#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Christopher Raine 
## Date: March 10, 2009
## Description: GNU-make based build system
#############################################################################

# Settings specific to the PageDist code page distribution &
# instrumentation tool 

# Path to the page dist tool  
PAGE_DIST := $(MAKE_TOOLS_BINDIR)/pagedist

# Path to the driver size table 
DRIVER_SIZETABLE := $(MAKE_ROOT)/Tools/DriverFuncs.sizetable

# The default code page distribution strategy. Determines which
# strategy the page distribution tool uses to distribute functions
# onto pages. 
# Valid values are:
#   single  - every function is placed on it's own page 
#   naive   - linear fills pages with function 
#   bfs     - breadth first distribution 
#   sa      - simulated annealing distribution
PAGEDIST_DEFAULT_DISTRIBUTION_STRATEGY := bfs

# The default flags for the page dist tool. Current settings are: 
# - path to the driver size table 
# - alignment of functions defaults to 64 bytes
# - initial pagesize defaults to 1024 bytes (remove me!)
export PAGEDIST_FLAGS := \
	-CDriverSizeTable=$(DRIVER_SIZETABLE) \
	-CPage.InitialPageSize=0
	
#	-CFunctionAlignment=64 \	

# Enable more output when running in verbose mode  
ifneq ($(MKOPTION_VERBOSE),1)
 PAGEDIST_FLAGS += -CLog.Level:info 
endif

# If additional flags have been set, append them to page dist tool
ifdef OPTION_PS3_PAGEDIST_FLAGS
 PAGEDIST_FLAGS += $(OPTION_PS3_PAGEDIST_FLAGS)
 $(warning user specified flags for pagedist: $(OPTION_PS3_PAGEDIST_FLAGS))
endif

# Command Macro to Distribute functions onto pages 
SPUJOB_CODEPAGE_DISTRIBUTE = \
	$(PAGE_DIST) $(PAGEDIST_FLAGS) -S $(NM_SPU) -c 1 -f $2 -o $1 \
	$(foreach object,$3,-O $(object)) \
	-p $(if $4,$4,$(PAGEDIST_DEFAULT_DISTRIBUTION_STRATEGY)) \
	$(if $5,-CPage.MaxSize=$5,) \
	$(if $6,-CFuncDistFile=$6,)



# Arch/CryCG.mk
# vim:ts=8:sw=2


