#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# SNC specific settings (SN Systems compiler for PS3)

# Filename extension for compiled object files.
ifndef EXT_O
 EXT_O := o
endif

# Filename extension for precompiled header files.
ifndef EXT_PCH
 EXT_PCH := h.gch
endif

# Filename extension for linker map files.
ifndef EXT_MAP
 EXT_MAP := map
endif

# Add -fPIC for shared modules.  However, on PS3 PPU, -fPIC may _not_ be used.
ifeq ($(OPTION_MODULE_LINKMODE),shared)
 ifneq ($(ARCH),PS3-cell)
  ARCH_CFLAGS += -fPIC
 endif
endif

# Filename extension for generated dependency files.
ifndef EXT_D
 EXT_D := d
endif
ifdef EXT_D_TMP
 ext_d := $(EXT_D_TMP)
else
 ext_d := $(EXT_D)
endif

# Support for ccache and distcc.
ifeq ($(MKOPTION_CCACHE),1)
 CCACHE ?= ccache
 ifeq ($(MKOPTION_DISTCC),1)
  # Note: The CCACHE_PREFIX environment variable (typically used to invoke
  # 'distcc' from 'ccache') causes problems with the compilers from the Cell
  # SDK, so we're simply embedding the 'distcc' call into the 'ccache' call.
  DISTCC ?= distcc
  CCACHE_PREFIX := $(DISTCC)
  export CCACHE_PREFIX
  CPREFIX := $(CCACHE)
 else
  CPREFIX := $(CCACHE)
 endif
else
 ifeq ($(MKOPTION_DISTCC),1)
  DISTCC ?= distcc
  CPREFIX := $(DISTCC)
 endif
 ifeq ($(MKOPTION_INCREDIBUILD),1)
  CPREFIX := $(PERL) '$(MAKE_ROOT)/Tools/incredibuild.pl' '$(INCREDIBAT)' 'size'
 endif
endif
CPREFIX ?=
ifeq ($(MKOPTION_DISTRIBUTED),1)
 # For distributed builds, we must rely on the compiler being in the
 # executable search path of the machine running the compiler.
 CPREFIX_CXX := $(CPREFIX) $(notdir $(CXX))
 CPREFIX_CC := $(CPREFIX) $(notdir $(CC))
else
 CPREFIX_CXX := $(CPREFIX) $(CXX)
 CPREFIX_CC := $(CPREFIX) $(CC)
endif

ifneq ($(MKOPTION_NOPCH),1)
 CXXPCHFLAGS = -include $(PROJECT_BUILD)/$(PROJECT_SOURCE_PCH)
 CPCHFLAGS =
 gccpch_flags =
 ifeq ($(MKOPTION_DISTCC),1)
  export DISTCC_PCH = 1
  export DISTCC_PCH_PROXY = 1
  gccpch_flags += -dD
 endif
else
 CXXPCHFLAGS =
 CPCHFLAGS =
 gccpch_flags =
endif

# Compile functions.
COMPILE_CXX = \
	$(CPREFIX_CXX) \
	  $(4) $(CFLAGS) $(CXXFLAGS) $(CPPFLAGS) \
	  '-Xdepmode=1' -Xdiag=1\
	  -MMD \
	  -Xmserrors=1\
	  -Xwchart=short\
	  -c '$(2)' -o '$(3)'
COMPILE_C = \
	$(CPREFIX_CC) \
	  $(4) $(CFLAGS) $(CPPFLAGS) \
	  '-Xdepmode=1' -Xdiag=1\
	  -Xmserrors=1\
	  -Xwchart=short\
	  -MMD \
	  -c '$(2)' -o '$(3)'
COMPILE_PCH = \
	$(CPREFIX_CXX) \
	  $(gccpch_flags) \
	  -w $(4) $(CFLAGS) $(CXXFLAGS) $(CPPFLAGS) \
	  '-Xdepmode=1' -Xdiag=1\
	  -Xwchart=short\
	  -Xmserrors=1\
	  -MMD \
	  -c '$(2)' -o '$(3)'

# 'module' projects.
LINK_MODULE_NAME_shared = $(addsuffix .so,$(1))
LINK_MODULE_NAME_static = $(addsuffix .o,$(1))
ifeq ($(OPTION_MODULE_LINKMODE),shared)
 # When linking a module to a shared object, we'll include the project
 # specific libraries but skip the rest.  Everyting in $(LDLIBS) will be
 # linked to the final program executable, so there's no need to add this
 # here.
 COMPILE_MODULE_NAME :=
 COMPILE_MODULE :=
 LINK_MODULE_NAME = $(LINK_MODULE_NAME_shared)
 LINK_MODULE = $(CXX) $(PROJECT_LDFLAGS) -shared $(LDSFLAGS) -o $(1) $(2) \
	$(PROJECT_LDLIBS)
endif # OPTION_MODULE_LINKMODE == shared
ifeq ($(OPTION_MODULE_LINKMODE),static)
 # Static linking using 'ld -r'.
 COMPILE_MODULE_NAME :=
 COMPILE_MODULE :=
 LINK_MODULE_NAME = $(LINK_MODULE_NAME_static)
 # Note that we don't add libraries to the invocation when linking a module
 # statically.
 LINK_MODULE = $(LD) -r $(LDRFLAGS) $(PROJECT_LDFLAGS) -o '$(1)' $(2)
endif # OPTION_MODULE_LINKMODE == static
ifndef LINK_MODULE
 $(error Unrecognized module link mode '$(OPTION_MODULE_LINKMODE)')
endif

# 'program' projects.
COMPILE_PROGRAM_NAME :=
COMPILE_PROGRAM :=
LINK_PROGRAM_NAME = $(1)
ifneq ($(OPTION_PS3_EXEC_NAME),)
  MAP_PROGRAM_NAME = $(output_dir)/$(OPTION_PS3_EXEC_NAME)$(output_suffix).$(EXT_MAP)
else
  MAP_PROGRAM_NAME = $(1).$(EXT_MAP)
endif

ifeq ($(OPTION_LD_MAPFILE),1)
 LINK_PROGRAM = $(CXX) $(LDFLAGS) -o '$(1)' \
	'-Map $(MAP_PROGRAM_NAME).$(EXT_MAP)' $(2) $(LDLIBS)
else
 LINK_PROGRAM = $(CXX) $(LDFLAGS) -o '$(1)' $(2) $(LDLIBS)
endif

# User specific code enabled via USER_$(USERNAME).
ifneq ($(OPTION_USER),)
 ARCH_CPPFLAGS += -DUSER_$(shell echo -n '$(OPTION_USER)' |tr a-z A-Z)
endif

# Handle build options.
ifeq ($(OPTION_DEBUG),1)
 ARCH_CFLAGS += -g
 ARCH_LDFLAGS += -g
 ARCH_LDRFLAGS += -g
endif # OPTION_DEBUG

ifneq ($(OPTION_DEBUG),1)
  ifneq ($(OPTION_NODEBUGSYM),1)
   ARCH_CFLAGS += -g
  endif
endif # !OPTION_DEBUG

ifeq ($(OPTION_RELEASE),1)
 ARCH_XFLAGS += -O3
endif

# Indicate that the compiler is not GCC.
COMPILER_IS_GCC := 0

#avoid invoking version.pl, update for each new gcc version
MKOPTION_PS3_GCC_VERSION := 4.1.1
MKOPTION_PS3_GCC_LIBDIR := $(CELL_SDK)/host-win32/ppu/lib/gcc/ppu-lv2
MKOPTION_PS3_GCC_LIBEXECDIR = $(CELL_SDK)/host-win32/ppu/libexec/gcc/ppu-lv2
GCC_VERSION := $(MKOPTION_PS3_GCC_VERSION)
GCC_LIBEXECDIR := $(MKOPTION_PS3_GCC_LIBEXECDIR)
GCC_LIBDIR := $(MKOPTION_PS3_GCC_LIBDIR)

# Arch/SNC.mk
# vim:ts=8:sw=8

