#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################


# Stage makefile for the 'build_sdk' stage.

OBJ_FILE_LIST := `find $(BUILD_ROOT)/CryEngine |grep "\.o" |grep -v "\.txt"`

OUTPUT_TARGET := $(CODE_ROOT)/PS3-Evaluation-SDK/Code
OUTPUT_TARGET_LIB_FILE := $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine3rdParty.a

$(OUTPUT_TARGET_LIB_FILE):
	
	@echo "Building PS3-Evaluation-SDK"
	 mkdir -p $(BUILD_ROOT)/3rdPartyLibs
	 mkdir -p $(OUTPUT_TARGET)/Game02/GameDll
	 mkdir -p $(OUTPUT_TARGET)/Game02/PS3Launcher
	 mkdir -p $(OUTPUT_TARGET)/CryEngine/CryCommon
	 mkdir -p $(OUTPUT_TARGET)/CryEngine/CryCommon/Console
	 mkdir -p $(OUTPUT_TARGET)/CryEngine/CryCommon/CryExtension
	 mkdir -p $(OUTPUT_TARGET)/CryEngine/CryCommon/CryExtension/Impl
	 mkdir -p $(OUTPUT_TARGET)/CryEngine/CryAction
	 mkdir -p $(OUTPUT_TARGET)/CryEngine/CryAction/DebrisMgr
	 mkdir -p $(OUTPUT_TARGET)/CryEngine/CryAction/Network
	 mkdir -p $(OUTPUT_TARGET)/SDKs/STLPORT
	 mkdir -p $(OUTPUT_TARGET)/SDKs/PS3
	 mkdir -p $(OUTPUT_TARGET)/Tools/Make
	 mkdir -p $(OUTPUT_TARGET)/Tools/PS3JobManager/lib/host-linux
	 mkdir -p $(OUTPUT_TARGET)/Tools/PS3JobManager/lib/host-win32
	 mkdir -p $(OUTPUT_TARGET)/Tools/PS3JobManager/PPU
	 mkdir -p $(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/Cache
	 mkdir -p $(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/CodePage
	 mkdir -p $(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/FuncHistTable
	 mkdir -p $(OUTPUT_TARGET)/Solutions
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryCommon
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryAction
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryAction/DebrisMgr
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryAction/DialogSystem
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryAction/Network
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryAction/TestSystem
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/Game02/GameDll
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/Game02/GameDll/Audio
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/ObjectFiles
	 mkdir -p $(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/Lib/PS3Launcher/spujob
	
	@echo "Copy Game Code and needed SDKs(will take some time)"
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/Game02/GameDll/*									$(OUTPUT_TARGET)/Game02/GameDll/
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/Game02/PS3Launcher/PS3Launcher.vc*				$(OUTPUT_TARGET)/Game02/PS3Launcher/	
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/SDKs/STLPORT/*									$(OUTPUT_TARGET)/SDKs/STLPORT/
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/SDKs/PS3/*										$(OUTPUT_TARGET)/SDKs/PS3/
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryCommon/*h							$(OUTPUT_TARGET)/CryEngine/CryCommon/
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryCommon/Console/*h					$(OUTPUT_TARGET)/CryEngine/CryCommon/Console/
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryCommon/CryExtension/*h				$(OUTPUT_TARGET)/CryEngine/CryCommon/CryExtension/
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryCommon/CryExtension/Impl/*h			$(OUTPUT_TARGET)/CryEngine/CryCommon/CryExtension/Impl/
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/Tools/Make/*										$(OUTPUT_TARGET)/Tools/Make/
	
	@echo "Copy PS3 Job Manager"			
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/host-linux/spumodgen		$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/host-linux/spumodgen
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/host-win32/spumodgen.exe	$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/host-win32/spumodgen.exe
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/libcryjobmanspu.a			$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/libcryjobmanspu.a
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/libDriverSPU.a				$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/libDriverSPU.a
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/libsn.a						$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/libsn.a
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/libsn.h						$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/libsn.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/libsntuner.a				$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/libsntuner.a
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/libsn_module.h				$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/libsn_module.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/libsn_spu.h					$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/libsn_spu.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/SPUDriver.elf				$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/SPUDriver.elf
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/SPUDriverAddr.txt			$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/SPUDriverAddr.txt
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/lib/spu_module.ld				$(OUTPUT_TARGET)/Tools/PS3JobManager/lib/spu_module.ld
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/PPU/JobManSPU.h					$(OUTPUT_TARGET)/Tools/PS3JobManager/PPU/JobManSPU.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/PPU/PPU.h						$(OUTPUT_TARGET)/Tools/PS3JobManager/PPU/PPU.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/PPU/SPUJobBase.h				$(OUTPUT_TARGET)/Tools/PS3JobManager/PPU/SPUJobBase.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/PPU/SPUMemAreaMan.h				$(OUTPUT_TARGET)/Tools/PS3JobManager/PPU/SPUMemAreaMan.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/Cache/CacheDefs_spu.h		$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/Cache/CacheDefs_spu.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/Cache/Cache_spu.h			$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/Cache/Cache_spu.h	
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/CodePage/SPUPageLayout.h	$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/CodePage/SPUPageLayout.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/CodePage/SPUPages.h			$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/CodePage/SPUPages.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/Elf.h						$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/Elf.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/FuncHistTable/SPUFuncPtr.h	$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/FuncHistTable/SPUFuncPtr.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/GenericSPUJob.h				$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/GenericSPUJob.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/JobStructs.h				$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/JobStructs.h	
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/LibSN_Module.h				$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/LibSN_Module.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/LibSN_SPU.h					$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/LibSN_SPU.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/Memory.h					$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/Memory.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/SPU.h						$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/SPU.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/SPUJob.h					$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/SPUJob.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/SPULoaderDefs.h				$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/SPULoaderDefs.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/SPULoaderDump.h				$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/SPULoaderDump.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/SPUMemManagerBase.h			$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/SPUMemManagerBase.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/SPUMultiThread.h			$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/SPUMultiThread.h
	$(BUILD_SILENT) cp $(CODE_ROOT)/Tools/PS3JobManager/SPU/SPUUtilities.h				$(OUTPUT_TARGET)/Tools/PS3JobManager/SPU/SPUUtilities.h

	@echo "Copy Needed CryAction Header"
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/ActionMapManager.h				$(OUTPUT_TARGET)/CryEngine/CryAction/ActionMapManager.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/CryAction.h						$(OUTPUT_TARGET)/CryEngine/CryAction/CryAction.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/DebrisMgr/DebrisMgr.h			$(OUTPUT_TARGET)/CryEngine/CryAction/DebrisMgr/DebrisMgr.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/IActionMapManager.h				$(OUTPUT_TARGET)/CryEngine/CryAction/IActionMapManager.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/IAnimatedCharacter.h				$(OUTPUT_TARGET)/CryEngine/CryAction/IAnimatedCharacter.h	
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/IInteractor.h					$(OUTPUT_TARGET)/CryEngine/CryAction/IInteractor.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/IItem.h							$(OUTPUT_TARGET)/CryEngine/CryAction/IItem.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/ILoadGame.h						$(OUTPUT_TARGET)/CryEngine/CryAction/ILoadGame.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/IMovementController.h			$(OUTPUT_TARGET)/CryEngine/CryAction/IMovementController.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/Inventory.h						$(OUTPUT_TARGET)/CryEngine/CryAction/Inventory.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/ISaveGame.h						$(OUTPUT_TARGET)/CryEngine/CryAction/ISaveGame.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/ItemParams.h						$(OUTPUT_TARGET)/CryEngine/CryAction/ItemParams.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/ItemSystem.h						$(OUTPUT_TARGET)/CryEngine/CryAction/ItemSystem.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/IWeapon.h						$(OUTPUT_TARGET)/CryEngine/CryAction/IWeapon.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/IWorldQuery.h					$(OUTPUT_TARGET)/CryEngine/CryAction/IWorldQuery.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/Network/NetActionSync.h			$(OUTPUT_TARGET)/CryEngine/CryAction/Network/NetActionSync.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/Network/VoiceListener.h			$(OUTPUT_TARGET)/CryEngine/CryAction/Network/VoiceListener.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/PersistantDebug.h				$(OUTPUT_TARGET)/CryEngine/CryAction/PersistantDebug.h
	$(BUILD_SILENT) cp -r $(CODE_ROOT)/CryEngine/CryAction/ReadabilitySound.h				$(OUTPUT_TARGET)/CryEngine/CryAction/ReadabilitySound.h

	@echo "Collecting all neeeded Object files(3rdParty and Launcher)"
	$(BUILD_SILENT) cd $(BUILD_ROOT)/3rdPartyLibs && \
	$(AR) x $(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmodex_SPURS.a && \
	$(AR) x $(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmod_event_net.a && \
	$(AR) x $(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmod_event.a && \
	$(AR) x $(CODE_ROOT)/SDKs/Speex/ps3/lib/libspeex.a && \
	$(AR) x $(CODE_ROOT)/SDKs/BigDigits/ps3/lib/libBigDigits.a && \
	$(AR) x $(CODE_ROOT)/CryEngine/CryFont/FreeType2/ps3/lib/libfreetype2.a && \
	$(AR) x $(CODE_ROOT)/CryEngine/CrySystem/zlib/ps3/lib/libzlib.a && \
	$(AR) x $(CODE_ROOT)/CryEngine/CryScriptSystem/ps3/lib/liblua.a && \
	$(AR) x $(CODE_ROOT)/CryEngine/CrySystem/XML/Expat/ps3/lib/libxmlexpat.a
	
	$(BUILD_SILENT) cp `find $(BUILD_ROOT)/Game02 |grep "\.o" |grep -v "\.txt |grep -v CryMtrace"`		$(BUILD_ROOT)/3rdPartyLibs				
								
	@echo "Copy all needed Object Files"								
	$(BUILD_SILENT) cp $(OBJ_FILE_LIST)									$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/ObjectFiles						
	$(BUILD_SILENT) cp $(BUILD_ROOT)/Game02/PS3Launcher/*.o				$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/
	
	@echo "Copy all needed devirtualization Header"	
	$(BUILD_SILENT) cp `ls $(BUILD_ROOT)/CryEngine/CryCommon/*h`				$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryCommon
	$(BUILD_SILENT) cp `ls $(BUILD_ROOT)/CryEngine/CryAction/*h`				$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryAction
	$(BUILD_SILENT) cp `ls $(BUILD_ROOT)/CryEngine/CryAction/DebrisMgr/*h`		$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryAction/DebrisMgr
	$(BUILD_SILENT) cp `ls $(BUILD_ROOT)/CryEngine/CryAction/Network/*h`		$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryAction/Network
	$(BUILD_SILENT) cp `ls $(BUILD_ROOT)/CryEngine/CryAction/TestSystem/*h`		$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/CryEngine/CryAction/TestSystem
	$(BUILD_SILENT) cp `ls $(BUILD_ROOT)/Game02/GameDll/*h`						$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/Game02/GameDll
	$(BUILD_SILENT) cp `ls $(BUILD_ROOT)/Game02/GameDll/Audio/*h`				$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/Game02/GameDll/Audio
		
	@echo "Copy generated SPU code"	
	$(BUILD_SILENT) cp $(BUILD_ROOT)/*.ld							$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/
	$(BUILD_SILENT) cp $(BUILD_ROOT)/Lib/PS3Launcher/spujob/*		$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/Lib/PS3Launcher/spujob/
	$(BUILD_SILENT) cp $(BUILD_ROOT)/Lib/*mk						$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/Lib/
	$(BUILD_SILENT) cp $(BUILD_ROOT)/Lib/PS3Launcher.elt			$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/Lib/PS3Launcher.elt
	$(BUILD_SILENT) cp $(BUILD_ROOT)/Lib/PS3Launcher.symlist		$(OUTPUT_TARGET)/$(PS3-SDK-FOLDER)/Lib/PS3Launcher.symlist

	@echo "Copy Solution and commen mk files"						
	$(BUILD_SILENT) cp $(CODE_ROOT)/Solutions/CryEngine.mk							$(OUTPUT_TARGET)/Solutions/CryEngine-EvalSDK.mk	
	$(BUILD_SILENT) cp $(CODE_ROOT)/Solutions/CryEngine_common.mk					$(OUTPUT_TARGET)/Solutions/CryEngine_common.mk
	$(BUILD_SILENT) cp $(CODE_ROOT)/Solutions/UserDebugSettings.vsprops				$(OUTPUT_TARGET)/Solutions/UserDebugSettings.vsprops
	$(BUILD_SILENT) cp $(CODE_ROOT)/Game02/PS3Launcher/Project.mk					$(OUTPUT_TARGET)/Game02/PS3Launcher/Project.mk
	$(BUILD_SILENT) cp $(CODE_ROOT)/Solutions/CryEngine-EvalSDK.vssscc				$(OUTPUT_TARGET)/Solutions/CryEngine-EvalSDK.vssscc
	$(BUILD_SILENT) cp $(CODE_ROOT)/Solutions/CryEngine-EvalSDK.sln					$(OUTPUT_TARGET)/Solutions/CryEngine-EvalSDK.sln	
	$(BUILD_SILENT) cp $(CODE_ROOT)/Solutions/Config_EvalSDK.mk									$(OUTPUT_TARGET)/../Config.mk
	$(BUILD_SILENT) cp -f $(CODE_ROOT)/Game02/GameDll/GameDll-PS3EvalSDK.vcproj					$(OUTPUT_TARGET)/Game02/GameDll/GameDll.vcproj
	$(BUILD_SILENT) cp -f $(CODE_ROOT)/Game02/PS3Launcher/PS3Launcher-EvalSDK.vcproj			$(OUTPUT_TARGET)/Game02/PS3Launcher/PS3Launcher.vcproj
	$(BUILD_SILENT) cp -f $(CODE_ROOT)/Game02/GameDll/GameDll-PS3EvalSDK.vcproj.vspscc			$(OUTPUT_TARGET)/Game02/GameDll/GameDll.vcproj.vspscc
	$(BUILD_SILENT) cp -f $(CODE_ROOT)/Game02/PS3Launcher/PS3Launcher-EvalSDK.vcproj.vspscc		$(OUTPUT_TARGET)/Game02/PS3Launcher/PS3Launcher.vcproj.vspscc


	@echo "Creating 3rdParty Code archive"	
	$(BUILD_SILENT) ppu-lv2-ar r $(OUTPUT_TARGET_LIB_FILE) $(BUILD_ROOT)/3rdPartyLibs/*
	
.PHONY: _prepare
_prepare:
	$(SILENT_NOP)
	
.PHONY: __command_build
__command_build: $(OUTPUT_TARGET_LIB_FILE)		
	$(SILENT_NOP)
	
# build_sdk.mk: __command_build TARGET=$(TARGET)

.PHONY: _command_default
_command_default: __command_build
	$(SILENT_NOP)
	
# build_sdk.mk: _command_default TARGET=$(TARGET)

.PHONY: _command_clean
_command_clean:	
	$(SILENT_NOP)
	
# build_sdk.mk: _command_clean TARGET=$(TARGET)

# Stage/build_sdk.mk
# vim:ts=8:sw=2

