#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Stage makefile for the 'compile' stage.

# This file is included only for the actual per-project make invocation
# (_exec_target_$(TARGET)).

# The 'compile' stage actually supports three types of build operations:
# - Compiling source files.
# - Linking source files to a module, which might be an SO style shared
#   library, a static library (.a), a relocatable object (.o, linking via
#   'ld -r') or a Windows style DLL.
# - Linking the modules to a final executable.  We'll assume there's a link
#   order dependency between the final executable and the modules it uses,
#   even if the modules are loaded dynamically at runtime.
#
# One common step is the extraction of the source file list from the VC
# project files.  The location of the VC project file (if any) is defined by
# the project makefile through the variable $(PROJECT_VCPROJ) (relative to the
# project code directory $(PROJECT_CODE)).

# NOTE
# If you're running into a make error of the form "missing 'endif'", then
# you're using a buggy version of GNU make (3.80 maybe?).  Use 3.81 or better.
# See http://lists.gnu.org/archive/html/help-make/2005-11/msg00016.html


# COMPILER_OUTPUT parses the output into msvc error paterns. ERROR_OUTPUT passes the -f option to make it fail
COMPILER_OUTPUT := \
	$(PERL) -I'$(MAKE_ROOT)/Tools' \
        $(MAKE_ROOT)/Tools/compiler_output.pl \
        -x -s -e $(MAKE_ROOT)/Stage/compile.error
ERROR_OUTPUT := \
	$(PERL) -I'$(MAKE_ROOT)/Tools' \
        $(MAKE_ROOT)/Tools/compiler_output.pl \
        -f -x -s -e $(MAKE_ROOT)/Stage/compile.error

ifneq ($(MKOPTION_SNC),1)
 ERROR_OUTPUT += -i $(MAKE_ROOT)/Stage/compile.ignore
 COMPILER_OUTPUT += -i $(MAKE_ROOT)/Stage/compile.ignore
endif

# Add compile stage specific build-wrapper options.
BUILDTOOL += \
	-i $(MAKE_ROOT)/Stage/compile.ignore \
	-e $(MAKE_ROOT)/Stage/compile.error
ifneq ($(HOST_SYSTEM),Linux)
 BUILDTOOL += -p $(PROJECT_CODE)
endif

include $(MAKE_ROOT)/Lib/prepare.mk

ifneq ($(strip $(PROJECT_VCPROJ)),)
 $(eval $(call prepare_compile,\
	$(PROJECT_CODE)/$(PROJECT_VCPROJ),PROJECT_,Files.mk))
else
 PROJECT_SOURCE_DIRS := .
endif

include $(MAKE_ROOT)/Lib/setfiles.mk

# Tag messages for the compile stage operations.
ifneq ($(MKOPTION_COMPACT),1)
 tag_c := C
 tag_cxx := C++
 tag_pch := C++/PCH
 tag_link := LINK
else
 tag_c :=
 tag_cxx :=
 tag_pch :=
 tag_link := Linking
endif

.PHONY: _prepare
_prepare: $(PREPARE_DEPS)
ifeq ($(FIRST_STAGE),compile)
	$(SILENT) mkdir -p "$(PROJECT_BUILD)"
else
	$(SILENT_NOP)
endif

# Set the compile and link flags.
include $(MAKE_ROOT)/Lib/setcflags.mk

# Convert a source file name into a compiled object file name.  Note that
# these functions are replicated in 'link.mk'.  Both version must be kept in
# sync.
compile_object_cpp = \
	$(subst /../,/,$(PROJECT_BUILD)/$(patsubst %.cpp,%.$(EXT_O),$(1)))
compile_object_c = \
	$(subst /../,/,$(PROJECT_BUILD)/$(patsubst %.c,%.$(EXT_O),$(1)))

# C++ compilation template for single-file compilation mode.
ifeq ($(MKOPTION_OPTIMIZE_SHELL),1)
define cppfile_template
-include $(PROJECT_BUILD)/$(patsubst %.cpp,%.d,$(1))
xflags_vn := PROJECT_XFLAGS_$(subst /,_,$(subst -,_,$(subst .,_,$(1))))
object := $(call compile_object_cpp,$(1))
$$(object): xflags := $$($$(xflags_vn))
$$(object): $(1) $(2)
	$(SILENT) mkdir -p "$$(dir $$@)"; \
	  echo $(tag_cxx) $($(TARGET)_CODE)/$(1); \
	  if [ -n "$$(xflags)" ]; then \
	    echo "  $(1): extra flags $$(xflags)"; \
	    ($$(call COMPILE_CXX,$(1),$$<,$$@, \
              $$(CPPFLAGS_DEVIRTUALIZE) $$(xflags)) \
              >$$@.txt 2>&1 || $(ERROR_OUTPUT) $$@.txt); \
	  fi; 
	  $(SILENT) if [ -z "$$(xflags)" ]; then \
	     ($$(call COMPILE_CXX,$(1),$$<,$$@, \
              $$(CPPFLAGS_DEVIRTUALIZE) $$(CXXPCHFLAGS) $$(XFLAGS)) \
              >$$@.txt 2>&1 || $(ERROR_OUTPUT) $$@.txt); \
	  fi
PROJECT_OBJECTS += $$(object)
endef
else
define cppfile_template
-include $(PROJECT_BUILD)/$(patsubst %.cpp,%.d,$(1))
xflags_vn := PROJECT_XFLAGS_$(subst /,_,$(subst -,_,$(subst .,_,$(1))))
object := $(call compile_object_cpp,$(1))
$$(object): xflags := $$($$(xflags_vn))
$$(object): $(1) $(2)
	$(SILENT) mkdir -p "$$(dir $$@)"
	$(BUILD_ECHO) $(tag_cxx) $($(TARGET)_CODE)/$(1)
	$(BUILD_SILENT) $(RM) $$@
	$(SILENT) if [ -n "$$(xflags)" ]; then \
	  echo "  $(1): extra flags $$(xflags)"; \
	  $(_BUILD) $$(call COMPILE_CXX,$(1),$$<,$$@,\
	    $$(CPPFLAGS_DEVIRTUALIZE) $$(xflags)); \
	fi; 
	$(SILENT) if [ -z "$$(xflags)" ]; then \
	    $(_BUILD) $$(call COMPILE_CXX,$(1),$$<,$$@,\
	    $$(CPPFLAGS_DEVIRTUALIZE) $$(CXXPCHFLAGS) $$(XFLAGS)); \
	fi
PROJECT_OBJECTS += $$(object)
endef
endif # MKOPTION_OPTIMIZE_SHELL

# C++/PCH compilation template for single-file compilation mode.
define pchfile_template
-include $(patsubst %.$(EXT_PCH),%.h.d,$(2))
xflags_vn := PROJECT_XFLAGS_$(subst /,_,$(subst -,_,$(subst .,_,$(1))))
$(2): xflags := $$($$(xflags_vn))
$(2): $(1) $(3)
	$(SILENT) mkdir -p "$$(dir $$@)"
	$(BUILD_ECHO) $(tag_pch) $($(TARGET)_CODE)/$(1)
	$(BUILD_SILENT) $(RM) $$@
	$(BUILD_SILENT) $(RM) '$$(dir $$@)/$$(notdir $$<)'
	$(SILENT) if [ -n "$$(xflags)" ]; then \
	  echo "  $(1): PCH extra flags $$(xflags)"; \
	  DISTCC_FALLBACK=0 \
	  $(_BUILD_PCH) $$(call COMPILE_PCH,$(1),$$<,$$@,\
	    $$(CPPFLAGS_DEVIRTUALIZE) $$(xflags_)); \
	fi;
	$(SILENT) if [ -z "$$(xflags)" ]; then \
	  DISTCC_FALLBACK=0 \
	  $(_BUILD_PCH) $$(call COMPILE_PCH,$(1),$$<,$$@,\
	    $$(CPPFLAGS_DEVIRTUALIZE) $$(XFLAGS)); \
	fi
endef

# C compilation template for single-file compilation mode.
ifeq ($(MKOPTION_OPTIMIZE_SHELL),1)
define cfile_template
-include $(PROJECT_BUILD)/$(patsubst %.c,%.d,$(1))
xflags_vn := PROJECT_XFLAGS_$(subst /,_,$(subst -,_,$(subst .,_,$(1))))
object := $(call compile_object_c,$(1))
$$(object): xflags := $$($$(xflags_vn))
$$(object): $(1)
	$(SILENT) mkdir -p "$$(dir $$@)"; \
	  echo $(tag_c) $($(TARGET)_CODE)/$(1); \
	  if [ -n "$$(xflags)" ]; then \
	    echo "  $(1): extra flags $$(xflags)"; \
	    ($$(call COMPILE_C,$(1),$$<,$$@,$$(xflags)) \
              >$$@.txt 2>&1 || $(ERROR_OUTPUT) $$@.txt); \
	  fi;
	  $(SILENT) if [ -z "$$(xflags)" ]; then \
	    ($$(call COMPILE_C,$(1),$$<,$$@,$$(XFLAGS)) \
              >$$@.txt 2>&1 || $(ERROR_OUTPUT) $$@.txt); \
	  fi
PROJECT_OBJECTS += $$(object)
endef
else
define cfile_template
-include $(PROJECT_BUILD)/$(patsubst %.c,%.d,$(1))
xflags_vn := PROJECT_XFLAGS_$(subst /,_,$(subst -,_,$(subst .,_,$(1))))
object := $(call compile_object_c,$(1))
$$(object): xflags := $$($$(xflags_vn))
$$(object): $(1)
	$(SILENT) mkdir -p "$$(dir $$@)"
	$(BUILD_ECHO) $(tag_c) $($(TARGET)_CODE)/$(1)
	$(BUILD_SILENT) $(RM) $$@
	$(SILENT) if [ -n "$$(xflags)" ]; then \
	  echo "  $(1): extra flags $$(xflags)"; \
	  $(_BUILD) $$(call COMPILE_C,$(1),$$<,$$@,$$(xflags)); \
	fi;
		$(SILENT) if [ -z "$$(xflags)" ]; then \
		$(_BUILD) $$(call COMPILE_C,$(1),$$<,$$@,$$(XFLAGS)); \
	fi
PROJECT_OBJECTS += $$(object)
endef
endif

COMPILE_CLEAN_$(TARGET) += \
	$(foreach cppfile,\
	  $(PROJECT_SOURCES_CPP),\
	  $(call compile_object_cpp,$(cppfile))) \
	$(foreach cfile,\
	  $(PROJECT_SOURCES_C),\
	  $(call compile_object_c,$(cfile)))

ifdef PROJECT_SOURCE_PCH
 project_pch := \
	$(PROJECT_BUILD)/$(patsubst %.h,%.$(EXT_PCH),$(PROJECT_SOURCE_PCH))
 COMPILE_CLEAN_$(TARGET) += $(project_pch)
else
 project_pch :=
endif
ifneq ($(MKOPTION_NOPCH),1)
 pchfile := $(project_pch)
 $(eval $(call pchfile_template,$(PROJECT_SOURCE_PCH),$(pchfile),))
else
 pchfile :=
endif

PROJECT_OBJECTS :=

# Single file compilation mode.
ifneq ($(strip $(PROJECT_SOURCES_CPP)),)
$(foreach cppfile,\
$(PROJECT_SOURCES_CPP),\
$(eval $(call cppfile_template,$(cppfile),$(pchfile))))
endif # PROJECT_SOURCES_CPP
ifneq ($(strip $(PROJECT_SOURCES_C)),)
$(foreach cfile,\
$(PROJECT_SOURCES_C),\
$(eval $(call cfile_template,$(cfile))))
endif # PROJECT_SOURCES_C

# Special feature for PS3 PRX linking.  If PROJECT_STUB_SOURCES_C and/or
# PROJECT_STUB_SOURCES_CPP is set, then only these are used in the final
# compile-module step.
ifeq ($(PROJECT_TYPE),module)
 PROJECT_STUB_OBJECTS =
PROJECT_STUB_OBJECTS += \
$(foreach cppfile,\
  $(PROJECT_STUB_SOURCES_CPP),\
  $(call compile_object_cpp,$(cppfile))) \
$(foreach cfile,\
  $(PROJECT_STUB_SOURCES_C),\
  $(call compile_object_c,$(cfile)))
endif

ifeq ($(PROJECT_TYPE),module)
 # Modules are compiled to re-linkable objects, shared objects or DLLs (if the
 # system supports it).  If the DLL system requires stub-libraries to resolve
 # inter-module dependencies, then the module is compiled into a stub library
 # and the final module linking is deferred to the 'link' stage.  A module
 # _always_ compiles to a single binary file in the $(BUILD_ROOT)/lib
 # directory.  The name of the module is derived from the project name as
 # define in the architecure specific function COMPLILE_MODULE_NAME.

 ifneq ($(COMPILE_MODULE),)
  PROJECT_OUTPUT := \
    $(TARGET_BUILD_ROOT)/Bin/$(call COMPILE_MODULE_NAME,$(TARGET))

# Module output rule.
ifeq ($(strip $(PROJECT_STUB_OBJECTS)),)
 project_compile_objects := $(PROJECT_OBJECTS)
else
 project_compile_objects := $(PROJECT_STUB_OBJECTS)
endif
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS)
	$(SILENT) mkdir -p "$(TARGET_BUILD_ROOT)/Bin"
ifneq ($(MKOPTION_COMPACT),1)	
	$(BUILD_ECHO) $(tag_link) $(call COMPILE_MODULE_NAME,$(TARGET))
else
	$(BUILD_ECHO) $(tag_link) $(TARGET)
endif	
	$(BUILD_SILENT) $(RM) $@
	$(call BUILD_MAKE_LDFILES,$(project_compile_objects),$@)
	$(BUILD_LINK) \
	  $(call COMPILE_MODULE,$@,\
	    $(call BUILD_LDFILES,$(project_compile_objects),$@))
ifdef PROJECT_POSTCOMPILE
	+$(PROJECT_POSTCOMPILE)
endif
# End of module output rule.

  COMPILE_CLEAN_$(TARGET) += \
	$(PROJECT_OUTPUT) \
	$(PROJECT_OUTPUT).$(EXT_LDFILES)

 else # else if COMPILE_MODULE == ''
  PROJECT_OUTPUT := $(TARGET_BUILD_ROOT)/Bin/$(TARGET).compiled
  COMPILE_CLEAN_$(TARGET) += $(PROJECT_OUTPUT)

# Module output rule.
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS)
ifeq ($(MKOPTION_OPTIMIZE_SHELL),1)
	$(SILENT) cd $(PROJECT_BUILD) \
          && $(COMPILER_OUTPUT) $(patsubst $(PROJECT_BUILD)/%,%.txt,$?)
endif
	$(SILENT) mkdir -p "$(TARGET_BUILD_ROOT)/Bin"
	$(SILENT) echo compiled >'$@'
# End of module output rule.

 endif # COMPILE_MODULE == ''
endif # PROJECT_TYPE == module

ifeq ($(PROJECT_TYPE),program)
 # A program is compiled to a single executable file.  Not all of the depended
 # on modules are linked (e.g. the renderer is loaded at runtime).  The list
 # of modules that should be linked to the executable is specified via
 # $(PROJECT_LINKMODULES) in the Project.mk file of the program.

 PROJECT_DEPMODULES ?= $(PROJECT_LINKMODULES)
 PROJECT_OBJECTS_DEP := $(PROJECT_OBJECTS)

 ifneq ($(strip $(PROJECT_STUB_OBJECTS)),)
  $(error PROJECT_STUB_OBJECTS set for PROJECT_TYPE=program)
 endif

 ifneq ($(COMPILE_PROGRAM),)
  ifneq ($(COMPILE_MODULE),)
   PROJECT_OBJECTS += \
	$(foreach module,$(PROJECT_LINKMODULES),\
	  $(BUILD_ROOT)/Bin/$(call COMPILE_MODULE_NAME,$(module)))
   PROJECT_OBJECTS_DEP += \
	$(foreach module,$(PROJECT_DEPMODULES),\\
	  $(BUILD_ROOT)/Bin/$(call COMPILE_MODULE_NAME,$(module)))
  endif # COMPILE_MODULE != ''

  PROJECT_OUTPUT := \
    $(TARGET_BUILD_ROOT)/Bin/$(call COMPILE_PROGRAM_NAME,$(TARGET))

# Program output rule.
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_DEP) $(PROJECT_DEPS_compile)
	$(SILENT) mkdir -p "$(TARGET_BUILD_ROOT)/Bin"
ifneq ($(MKOPTION_COMPACT),1)		
	$(BUILD_ECHO) $(tag_link) $(call COMPILE_PROGRAM_NAME,$(TARGET))
else	
	$(BUILD_ECHO) $(tag_link) $(TARGET)
endif	
	$(BUILD_SILENT) $(RM) $@
	$(call BUILD_MAKE_LDFILES,$(PROJECT_OBJECTS),$@)
	$(BUILD_LINK) \
	  $(call COMPILE_PROGRAM,$@,\
	    $(call BUILD_LDFILES,$(PROJECT_OBJECTS),$@))
ifdef PROJECT_POSTCOMPILE
	+$(PROJECT_POSTCOMPILE)
endif
# End of program output rule.

  COMPILE_CLEAN_$(TARGET) += \
	$(PROJECT_OUTPUT) \
	$(PROJECT_OUTPUT).$(EXT_LDFILES)

 else # else if COMPILE_PROGRAM == ''

  PROJECT_OUTPUT := $(TARGET_BUILD_ROOT)/Bin/$(TARGET).compiled
  COMPILE_CLEAN_$(TARGET) += $(PROJECT_OUTPUT)

# Program output rule.
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_DEP) $(PROJECT_DEPS_compile)
	$(SILENT) mkdir -p "$(TARGET_BUILD_ROOT)/Bin"
	$(SILENT) echo compiled >'$@'
# End of program output rule.

 endif # COMPILE_PROGRAM == ''

endif # PROJECT_TYPE == program

.PHONY: __command_compile
__command_compile: $(PROJECT_OUTPUT)
	$(SILENT_NOP)
# compile.mk: __command_compile TARGET=$(TARGET)

.PHONY: _command_default
_command_default: __command_compile
	$(SILENT_NOP)
# compile.mk: _command_default TARGET=$(TARGET)

.PHONY: _command_post
_command_post:
	$(SILENT_NOP)
# compile.mk: _command_post TARGET=$(TARGET)

.PHONY: _command_clean
_command_clean:
	$(BUILD_SILENT) $(RM) $(COMPILE_CLEAN_$(TARGET))
	$(SILENT_NOP)
# compile.mk: _command_clean TARGET=$(TARGET)

# Stage/compile.mk
# vim:ts=8:sw=2

