#############################################################################
## Crytek Source File
## Copyright (C) 2007, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Thu Jun 28, 2007
## Description: GNU-make based build system
#############################################################################

# Stage makefile for the 'link' stage.

BUILDTOOL += -i $(MAKE_ROOT)/Stage/compile.ignore
ifneq ($(HOST_SYSTEM),Linux)
 BUILDTOOL += -p $(PROJECT_CODE)
endif

include $(MAKE_ROOT)/Lib/prepare.mk

ifneq ($(strip $(PROJECT_VCPROJ)),)
 $(eval $(call prepare_compile,\
	$(PROJECT_CODE)/$(PROJECT_VCPROJ),PROJECT_,Files.mk))
else
 PROJECT_SOURCE_DIRS := .
endif

include $(MAKE_ROOT)/Lib/setfiles.mk

# Tag messages for the compile stage operations.
ifneq ($(MKOPTION_COMPACT),1)
 tag_c := C
 tag_cxx := C++
 tag_pch := C++/PCH
 tag_link := LINK
else
 tag_c :=
 tag_cxx :=
 tag_pch :=
 tag_link := Linking
endif

# Convert a source file name into a compiled object file name.  Note that
# these functions are replicated in 'compile.mk'.  Both version must be kept
# in sync.
link_object_cpp = \
	$(subst /../,/,$(PROJECT_BUILD)/$(patsubst %.cpp,%.$(EXT_O),$(1)))
link_object_c = \
	$(subst /../,/,$(PROJECT_BUILD)/$(patsubst %.c,%.$(EXT_O),$(1)))

# Note: We're redefining $(PROJECT_OBJECTS), overriding the $(PROJECT_OBJECTS)
# variable set by 'setfiles.mk' included above.  This is because we're
# building a dummy rule for these objects claiming that they are all up to
# data (see below).  $(PROJECT_OBJECTS_ADD) is handled after the dummy rule
# has been defined, because some of the object files in $(PROJECT_OBJECTS_ADD)
# may have explicit construction rules specified in the 'Project.mk'.
PROJECT_OBJECTS :=
PROJECT_OBJECTS += \
$(foreach cppfile,\
  $(PROJECT_SOURCES_CPP),\
  $(call link_object_cpp,$(cppfile))) \
$(foreach cfile,\
  $(PROJECT_SOURCES_C),\
  $(call link_object_c,$(cfile)))

PROJECT_DEPMODULES ?= $(PROJECT_LINKMODULES)

# In the link stage, we'll assume that all generated object files are up to
# date.  The rule below pevents 'make' from checking all object file time
# stamps against the corresponding source files.
$(PROJECT_OBJECTS):
	$(SILENT_NOP)
# link.mk: assume up-to-date: $(PROJECT_OBJECTS)

# Handle $(PROJECT_OBJECTS_ADD) after defining the dummy rule, see comment
# above.
ifdef PROJECT_OBJECTS_ADD
 PROJECT_OBJECTS += $(PROJECT_OBJECTS_ADD)
endif

.PHONY: _prepare
_prepare: $(PREPARE_DEPS)
ifeq ($(FIRST_STAGE),link)
	$(SILENT) mkdir -p "$(PROJECT_BUILD)"
else
	$(SILENT_NOP)
endif

# Set the compile and link flags.
include $(MAKE_ROOT)/Lib/setcflags.mk

PROJECT_DEPMODULES ?= $(PROJECT_LINKMODULES)
PROJECT_OBJECTS_DEP := $(PROJECT_OBJECTS)

ifdef ARCH_LIBDEPS
 PROJECT_OBJECTS_DEP += $(ARCH_LIBDEPS)
endif

ifeq ($(MKOPTION_FORCE_LINK),1)
.PHONY: _force_link
_force_link:

 PROJECT_OBJECTS_DEP += _force_link
endif

ifeq ($(PROJECT_TYPE),module)

 ifdef ARCH_LIBDEPS_module
  PROJECT_OBJECTS_DEP += $(ARCH_LIBDEPS_module)
 endif

 # Module may have link dependencies on some architecures.  Module link
 # dependencies are handled in architecure specific clauses below.

 ifeq ($(ARCH),PS3-cell)
  ifeq ($(OPTION_PS3_PRX),1)
   # Handle linker objects for PS3 PRX builds.  We'll add the stub libraries
   # to the objects if and only if the current module is a PRX and the
   # to-be-linked module was compiled as a PRX.
   ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
    define module_add_module
     ifeq ($$(OPTION_PS3_PRX_$(2)),1)
      $(1) += $(BUILD_ROOT)/Bin/$(call LINK_STUBLIB_NAME,$(2))
     endif
    endef
    $(foreach module,\
	$(PROJECT_LINKMODULES),\
	$(eval $(call module_add_module,PROJECT_OBJECTS,$(module))))
    $(foreach module,\
	$(PROJECT_DEPMODULES),\
	$(eval $(call module_add_module,PROJECT_OBJECTS_DEP,$(module))))
   endif # OPTION_PS3_PRX_$(TARGET) == 1
  endif # OPTION_PS3_PRX == 1
 endif # ARCH == PS3-cell

 ifneq ($(LINK_MODULE),)
  PROJECT_OUTPUT := \
    $(TARGET_BUILD_ROOT)/Bin/$(call LINK_MODULE_NAME,$(TARGET))

  # If there is only a single output file to link and $(OPTION_SKIPLINK) is
  # set, then the output file will be copied/symlinked instead of linking.
  project_output_skiplink := 0
  ifeq ($(OPTION_SKIPLINK),1)
   ifeq ($(words $(PROJECT_OBJECTS)),1)
    project_output_skiplink := 1
    ifeq ($(HOST_SYSTEM),Linux)
     skiplink := ln -s
    else
     skiplink := cp
    endif
    ifeq ($(MKOPTION_VERBOSE),1)
     skiplink += -v
    endif
   endif
  endif
  
  # If we're linking the final executable for file lists instead of linked
  # modules, then the we're not linking the output file - a dummy output file
  # is created instead (to fulfill the make dependencies).
  ifeq ($(MKOPTION_LDFILES),1)
   ifeq ($(MKOPTION_LDFILES_ALL),1)
    project_output_nolink := 1
    nolink := echo 'Not linking - MKOPTION_LDFILES_ALL == 1' >
   endif
  endif

# Output rule.
# Added MinGW support: The command line for the BUILD_MAKE_LDFILES is too long for Windows
# and so the list is split in 2 with 200 object files (which works for Windows) in the first part.
PROJECT_OBJECTS_LIST  := $(patsubst $(BUILD_STRIP_PREFIX)/%,%,$(PROJECT_OBJECTS))
PROJECT_OBJECTS_PART1 := $(wordlist 1, 50, $(PROJECT_OBJECTS_LIST))
PROJECT_OBJECTS_PART2 := $(wordlist 51, 100, $(PROJECT_OBJECTS_LIST))
PROJECT_OBJECTS_PART3 := $(wordlist 101, 150, $(PROJECT_OBJECTS_LIST))
PROJECT_OBJECTS_PART4 := $(wordlist 151, $(words $(PROJECT_OBJECTS_LIST)), $(PROJECT_OBJECTS_LIST))

$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_DEP) $(PROJECT_DEPS_link)
	$(SILENT) mkdir -p "$(BUILD_ROOT)/Bin"
ifneq ($(MKOPTION_COMPACT),1)	
	$(BUILD_ECHO) $(tag_link) $(call LINK_MODULE_NAME,$(TARGET))
else
	$(BUILD_ECHO) $(tag_link) $(TARGET)
endif
	$(SILENT) cd $(BUILD_STRIP_PREFIX) && $(RM) $(patsubst $(BUILD_STRIP_PREFIX)/%,%,$@)
	$(SILENT) $(call BUILD_MAKE_LDFILES,$(PROJECT_OBJECTS_PART1),$@)
ifneq (,$(strip $(PROJECT_OBJECTS_PART2)))
	$(SILENT) $(call BUILD_MAKE_LDFILES_APPEND,$(PROJECT_OBJECTS_PART2),$@)
endif
ifneq (,$(strip $(PROJECT_OBJECTS_PART3)))
	$(SILENT) $(call BUILD_MAKE_LDFILES_APPEND,$(PROJECT_OBJECTS_PART3),$@)
endif
ifneq (,$(strip $(PROJECT_OBJECTS_PART4)))
	$(SILENT) $(call BUILD_MAKE_LDFILES_APPEND,$(PROJECT_OBJECTS_PART4),$@)
endif
ifneq (,$(strip $(PROJECT_OBJECTS_PART5)))
	$(SILENT) $(call BUILD_MAKE_LDFILES_APPEND,$(PROJECT_OBJECTS_PART5),$@)
endif
ifeq ($(project_output_skiplink),1)
	$(BUILD_ECHO) $(tag_link) $(TARGET)
	$(SILENT) $(skiplink) $(PROJECT_OBJECTS) $@
else
ifeq ($(project_output_nolink),1)
	$(SILENT) $(nolink) $@
else
	$(BUILD_LINK) \
	  $(call LINK_MODULE,$@,\
	    $(call BUILD_LDFILES,$(PROJECT_OBJECTS),$@))
endif
endif
# End of output rule.

  LINK_CLEAN_$(TARGET) += \
	$(PROJECT_OUTPUT) \
	$(PROJECT_OUTPUT).$(EXT_LDFILES)

 else # else if LINK_MODULE == ''

  PROJECT_OUTPUT := $(TARGET_BUILD_ROOT)/Bin/$(TARGET).linked
# Output rule.
$(PROJECT_OUTPUT):
	$(SILENT) mkdir -p "$(BUILD_ROOT)/Bin"
	$(SILENT) echo linked >'$@'
# End of output rule.

  LINK_CLEAN_$(TARGET) += \
	$(PROJECT_OUTPUT) \
	$(PROJECT_OUTPUT).$(EXT_LDFILES)

 endif # skip_link != 1
endif # PROJECT_TYPE == module

ifeq ($(PROJECT_TYPE),program)
 ifneq ($(LINK_PROGRAM),)

  project_linkmodules_objects :=
  project_depmodules_objects :=
  ifneq ($(LINK_MODULE),)
   project_linkmodules_objects += \
	$(foreach module,\
	  $(PROJECT_LINKMODULES),\
	  $(BUILD_ROOT)/Bin/$(call LINK_MODULE_NAME,$(module)))
   project_depmodules_objects += \
	$(foreach module,\
	  $(PROJECT_DEPMODULES),\
	  $(BUILD_ROOT)/Bin/$(call LINK_MODULE_NAME,$(module)))
  endif # LINK_MODULE != ''

  ifdef ARCH_LIBDEPS_program
   PROJECT_OBJECTS_DEP += $(ARCH_LIBDEPS_program)
  endif

  ifeq ($(ARCH),PS3-cell)
   ifeq ($(OPTION_PS3_PRX),1)
    # On PS3, a mixed module setup is possible, i.e. some modules may be
    # shared and some may be static.  For the shared modules, the PRX stub
    # library resulting from the compile pass is linked.  PRX stub libraries
    # _must_ be linked _after_ all static objects to resolve link order
    # dependencies.
    project_linkmodules_objects_prxstub :=
    project_linkmodules_objects_static :=
    project_depmodules_objects_prxstub :=
    project_depmodules_objects_static :=
    define program_add_linkmodule
     ifeq ($$(OPTION_PS3_PRX_$(1)),1)
      project_linkmodules_objects_prxstub += \
	$(BUILD_ROOT)/Bin/$$(call LINK_STUBLIB_NAME,$(1))
     else
      project_linkmodules_objects_static += \
	$(BUILD_ROOT)/Bin/$$(call LINK_MODULE_NAME_static,$(1))
     endif
    endef
    define program_add_depmodule
     ifeq ($$(OPTION_PS3_PRX_$(1)),1)
      project_depmodules_objects_prxstub += \
	$(BUILD_ROOT)/Bin/$$(call LINK_STUBLIB_NAME,$(1))
     else
      # If it is not a PRX, then it must be added to dep list _and_ to the
      # link list.
      project_depmodules_objects_static += \
	$(BUILD_ROOT)/Bin/$$(call LINK_MODULE_NAME_static,$(1))
      project_linkmodules_objects_static += \
	$(BUILD_ROOT)/Bin/$$(call LINK_MODULE_NAME_static,$(1))
     endif
    endef
    $(foreach module,\
	$(PROJECT_LINKMODULES),\
	$(eval $(call program_add_linkmodule,$(module))))
    $(foreach module,\
	$(PROJECT_DEPMODULES),\
	$(eval $(call program_add_depmodule,$(module))))
    project_linkmodules_objects := \
	$(project_linkmodules_objects_static) \
	$(project_linkmodules_objects_prxstub)
    project_depmodules_objects := \
	$(project_depmodules_objects_static) \
	$(project_depmodules_objects_prxstub)
   endif # OPTION_PS3_PRX == 1
  endif # ARCH == PS3-cell

  PROJECT_OBJECTS += $(project_linkmodules_objects)
  PROJECT_OBJECTS_DEP += $(project_depmodules_objects)

  ifneq ($(LINK_DIRECT_SELF),1)
   PROJECT_OUTPUT := $(TARGET_BUILD_ROOT)/Bin/$(call LINK_PROGRAM_NAME,$(TARGET))
  else
   ifeq ($(OPTION_DEBUG),1)
    PROJECT_SUFF := _debug
   else
	  PROJECT_SUFF := 
   endif
   ifneq ($(OPTION_PS3_EXEC_NAME),)
    PROJECT_OUTPUT := $(output_dir)/$(call LINK_PROGRAM_NAME,$(OPTION_PS3_EXEC_NAME))$(PROJECT_SUFF).self
   else
    PROJECT_OUTPUT := $(output_dir)/$(call LINK_PROGRAM_NAME,$(TARGET))$(PROJECT_SUFF).self
   endif
  endif

  ifeq ($(COMPILER_IS_GCC),1)
   LINK_CLEAN_$(TARGET) += $(PROJECT_OUTPUT).$(EXT_MAP)
  endif

# Output rule.
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_DEP) $(PROJECT_DEPS_link)
	$(SILENT) mkdir -p "$(BUILD_ROOT)/Bin"
ifneq ($(MKOPTION_COMPACT),1)		
	$(BUILD_ECHO) $(tag_link) $(call LINK_PROGRAM_NAME,$(TARGET))
else	
	$(BUILD_ECHO) $(tag_link) $(TARGET)
endif	
	$(BUILD_SILENT) $(RM) $@
	$(call BUILD_MAKE_LDFILES,$(PROJECT_OBJECTS),$@)
	$(SILENT) cd $(BUILD_STRIP_PREFIX) && $(_BUILD_LINK) \
	  $(call LINK_PROGRAM,$@,\
	    $(call BUILD_LDFILES,$(PROJECT_OBJECTS),$@))
# End of output rule.

  LINK_CLEAN_$(TARGET) += \
	$(PROJECT_OUTPUT) $(PROJECT_OUTPUT).$(EXT_LDFILES)

 endif # LINK_PROGRAM != ''
endif # PROJECT_TYPE == program

ifeq ($(MKOPTION_PS3_MIXED_BUILD),1)
 mixed_output_dirs := \
   $(dir $(patsubst \
     $(TARGET_BUILD_ROOT)/%,$(MIXED_BUILD_ROOT)/%,$(PROJECT_OUTPUT)))
 ifneq ($(PROJECT_TYPE),program)     
 copy_mixed_output := \
   { \
     $(foreach output,$(PROJECT_OUTPUT) $(PROJECT_OUTPUT).$(EXT_LDFILES),\
       if [ -f '$(output)' ]; then \
         mixed_output='$(patsubst \
           $(TARGET_BUILD_ROOT)/%,$(MIXED_BUILD_ROOT)/%,$(output))'; \
         mkdir -p `dirname "$$mixed_output"`; \
         cp '$(output)' "$$mixed_output"; \
       else \
         :; \
       fi;) \
     :; \
   }
endif   
endif

.PHONY: __command_link
__command_link: $(PROJECT_OUTPUT)
ifeq ($(MKOPTION_PS3_MIXED_BUILD),1)
 ifneq ($(MIXED_BUILD),1)
	$(SILENT) $(copy_mixed_output)
 endif
endif
	$(SILENT_NOP)
# link.mk: __command_link TARGET=$(TARGET)

.PHONY: _command_default
_command_default: __command_link
ifdef PROJECT_POSTLINK
	+$(PROJECT_POSTLINK)
else
	$(SILENT_NOP)
endif # PROJECT_POSTLINK
# link.mk: _command_default TARGET=$(TARGET)

.PHONY: _command_post
_command_post:
ifdef PROJECT_POSTLINK
	+$(PROJECT_POSTLINK)
else
	$(SILENT_NOP)
# link.mk: _command_post TARGET=$(TARGET)
endif # PROJECT_POSTLINK

.PHONY: _command_clean
_command_clean:
	$(BUILD_SILENT) $(RM) $(LINK_CLEAN_$(TARGET))
	$(SILENT_NOP)
# link.mk: _command_clean TARGET=$(TARGET)

# Stage/compile.mk
# vim:ts=8:sw=2

