#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Stage makefile for the 'scan' stage.

# This file is included only for the actual per-project make invocation
# (_exec_target_$(TARGET)).

# The 'scan' stage supports the following build operations:
# - Scanning source files into translation unit CCG file.
# - Combining translation unit CCG files into index CCG file.  (Not
#   implemented yet.)
#
# One common step is the extraction of the source file list from the VC
# project files.  The location of the VC project file (if any) is defined by
# the project makefile through the variable $(PROJECT_VCPROJ) (relative to the
# project code directory $(PROJECT_CODE)).

# This stage should only be activated when the build process is not
# usign pregenerated scan files
ifneq ($(MKOPTION_USE_PREGEN_SPUFILES),0)
 $(error scan stage should only be activate\
	 when MKOPTION_USE_PREGEN_SPUFILES is 0)
endif 

# Add compile stage specific build-wrapper options.
BUILDTOOL += -i $(MAKE_ROOT)/Stage/scan.ignore
ifneq ($(HOST_SYSTEM),Linux)
 BUILDTOOL += -p $(PROJECT_CODE)
endif

include $(MAKE_ROOT)/Lib/prepare.mk

ifneq ($(strip $(PROJECT_VCPROJ)),)
 $(eval $(call prepare_compile,\
	$(PROJECT_CODE)/$(PROJECT_VCPROJ),PROJECT_,Files.mk))
else
 PROJECT_SOURCE_DIRS := .
endif

include $(MAKE_ROOT)/Lib/setfiles.mk

# For the scan phase, an explicit override for the per-project file lists.
# Note that this override may be empty, indicating that no files should be
# scanned.
ifeq ($(MKOPTION_PS3_SCANALL),1)
 ifdef PROJECT_SCAN_CPP
  PROJECT_SOURCES_CPP := $(PROJECT_SCAN_CPP)
 endif
 ifdef PROJECT_SCAN_C
  PROJECT_SOURCES_C := $(PROJECT_SCAN_C)
 endif
else
 PROJECT_SOURCES_CPP := $(PROJECT_SCAN_CPP)
 PROJECT_SOURCES_C := $(PROJECT_SCAN_C)
endif

# Tag messages for the compile stage operations.
ifneq ($(MKOPTION_COMPACT),1)
 tag_c := SCAN/C
 tag_cxx := SCAN/C++
 tag_link := SCAN/INDEX
else
 tag_c := scan
 tag_cxx := scan
 tag_link :=
endif

.PHONY: _prepare
_prepare: $(PREPARE_DEPS)
ifeq ($(FIRST_STAGE),scan)
	$(SILENT) mkdir -p "$(PROJECT_BUILD)"
else
	$(SILENT_NOP)
endif

# Convert a source file name into a CCG file name.
scan_object_cpp = \
  $(subst /../,/,$(PROJECT_BUILD)/scan/$(patsubst %.cpp,%.$(EXT_CCG),$(1)))
scan_tmpfiles_cpp = \
  $(subst /../,/,$(PROJECT_BUILD)/scan/$(patsubst %.cpp,%.s,$(1)))
scan_object_c = \
  $(subst /../,/,$(PROJECT_BUILD)/scan/$(patsubst %.c,%.$(EXT_CCG),$(1)))
scan_tmpfiles_c = \
  $(subst /../,/,$(PROJECT_BUILD)/scan/$(patsubst %.c,%.s,$(1)))

# Set the compile and link flags.
include $(MAKE_ROOT)/Lib/setcflags.mk
FLAGS_SUFFIX := _SCAN
include $(MAKE_ROOT)/Lib/setcflags.mk
FLAGS_SUFFIX :=

define cppfile_template
-include $(PROJECT_BUILD)/scan/$(patsubst %.cpp,%.d,$(1))
xflags_vn := PROJECT_XFLAGS_SCAN_$(subst /,_,$(subst -,_,$(subst .,_,$(1))))
object_ccg := $(call scan_object_cpp,$(1))
$$(object_ccg): xflags := $$($$(xflags_vn))
$$(object_ccg): $(1)
	$(SILENT) mkdir -p "$$(dir $$@)"
	$(BUILD_ECHO) $(tag_cxx) $($(TARGET)_CODE)/$(1)
	$(BUILD_SILENT) $(RM) $$@
	$(SILENT) if [ -n "$$(xflags)" ]; then \
	  echo "  $(1) (scan): extra flags $$(xflags)"; \
	  $(_BUILD) $$(call SCAN_CXX,$(1),$$<,$$@,\
	    $$(CPPFLAGS_DEVIRTUALIZE) $$(xflags)); \
	fi;
	$(SILENT) if [ -z "$$(xflags)" ]; then \
	  $(_BUILD) $$(call SCAN_CXX,$(1),$$<,$$@,\
	    $$(CPPFLAGS_DEVIRTUALIZE) $$(XFLAGS_SCAN)); \
	fi
PROJECT_OBJECTS_CCG += $$(object_ccg)
endef

define cfile_template
-include $(PROJECT_BUILD)/scan/$(patsubst %.c,%.d,$(1))
xflags_vn := PROJECT_XFLAGS_SCAN_$(subst /,_,$(subst -,_,$(subst .,_,$(1))))
object_ccg := $(call scan_object_c,$(1))
$$(object_ccg): xflags := $$($$(xflags_vn))
$$(object_ccg): $(1)
	$(SILENT) mkdir -p "$$(dir $$@)"
	$(BUILD_ECHO) $(tag_c) $($(TARGET)_CODE)/$(1)
	$(BUILD_SILENT) $(RM) $$@
	$(SILENT) if [ -n "$$(xflags)" ]; then \
	  echo "  $(1) (scan): extra flags $$(xflags)"; \
	  $(_BUILD) $$(call SCAN_C,$(1),$$<,$$@,$$(xflags)); \
	fi;
	$(SILENT) if [ -z "$$(xflags)" ]; then \
	  $(_BUILD) $$(call SCAN_C,$(1),$$<,$$@,$$(XFLAGS_SCAN)); \
	fi
PROJECT_OBJECTS_CCG += $$(object_ccg)
endef

SCAN_CLEAN_$(TARGET) += \
	$(foreach cppfile,\
	  $(PROJECT_SOURCES_CPP),\
	  $(call scan_object_cpp,$(cppfile)) \
	  $(call scan_tmpfiles_cpp,$(cppfile))) \
	$(foreach cfile,\
	  $(PROJECT_SOURCES_C),\
	  $(call scan_object_c,$(cfile)) \
	  $(call scan_tmpfiles_c,$(cfile)))

PROJECT_OBJECTS_CCG :=

# Single file compilation mode.
ifneq ($(strip $(PROJECT_SOURCES_CPP)),)
$(foreach cppfile,\
$(PROJECT_SOURCES_CPP),\
$(eval $(call cppfile_template,$(cppfile))))
endif # PROJECT_SOURCES_CPP
ifneq ($(strip $(PROJECT_SOURCES_C)),)
$(foreach cfile,\
$(PROJECT_SOURCES_C),\
$(eval $(call cfile_template,$(cfile))))
endif # PROJECT_SOURCES_C

ifeq ($(PROJECT_TYPE),module)
 # Modules are linked to index files.  A module _always_ compiles to a single
 # index file in the $(BUILD_ROOT)/Lib directory.  The name of the index file
 # is derived from the project name as define in the architecure specific
 # function SCANINDEX_NAME.

 PROJECT_OUTPUT := $(TARGET_BUILD_ROOT)/Lib/$(call SCAN_MODULE_NAME,$(TARGET))

 SCAN_CLEAN_$(TARGET) += \
	$(addprefix $(BUILD_ROOT)/Lib/,$(call SCAN_MODULE_CLEAN,$(TARGET)))

# Module output rule.
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_CCG) $(PROJECT_DEPS_scan)
	$(SILENT) mkdir -p "$(TARGET_BUILD_ROOT)/Lib"
ifeq ($(MKOPTION_VERBOSE),1)
	$(BUILD_ECHO) $(tag_link) $(call SCAN_MODULE_NAME,$(TARGET))
endif
	$(BUILD_SILENT) $(RM) $@
	#$(if $^,$(BUILD_LINK) $(call SCANINDEX_MODULE,$@,$^),)
	$(call SCANINDEX_MODULE,$@,$^)
# End of module output rule.

endif # PROJECT_TYPE == module

ifeq ($(PROJECT_TYPE),program)

 PROJECT_DEPMODULES ?= $(PROJECT_LINKMODULES)
 PROJECT_OBJECTS_DEP := $(PROJECT_OBJECTS_CCG)
 PROJECT_OBJECTS_LINK := $(PROJECT_OBJECTS_CCG)

 PROJECT_OBJECTS_LINK += \
	$(foreach module,$(PROJECT_LINKMODULES),\
	  $(BUILD_ROOT)/Lib/$(call SCAN_MODULE_NAME,$(module)))
 PROJECT_OBJECTS_DEP += \
	$(foreach module,$(PROJECT_DEPMODULES),\
	  $(BUILD_ROOT)/Lib/$(call SCAN_MODULE_NAME,$(module)))

 PROJECT_OUTPUT := \
   $(TARGET_BUILD_ROOT)/Lib/$(call SCAN_PROGRAM_NAME,$(TARGET))

 SCAN_CLEAN_$(TARGET) += \
	$(addprefix $(BUILD_ROOT)/Lib/,$(call SCAN_PROGRAM_CLEAN,$(TARGET)))

# Program output rule.
export PS3_ELEMENT_FILE := $(patsubst %.code,%.elt,$(PROJECT_OUTPUT))

$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_DEP) $(PROJECT_DEPS_scan)
	$(SILENT) mkdir -p "$(TARGET_BUILD_ROOT)/Lib"
ifeq ($(MKOPTION_VERBOSE),1)
	$(BUILD_ECHO) $(tag_link) $(call SCAN_PROGRAM_NAME,$(TARGET))
endif
	$(BUILD_SILENT) $(RM) $@
	$(BUILD_LINK) $(call SCANINDEX_PROGRAM,$@,$(PROJECT_OBJECTS_LINK))
# End of program output rule.

endif # PROJECT_TYPE == program

ifeq ($(MKOPTION_PS3_MIXED_BUILD),1)
 mixed_output_dirs := \
   $(dir $(patsubst \
     $(TARGET_BUILD_ROOT)/%,$(MIXED_BUILD_ROOT)/%,$(PROJECT_OUTPUT)))
 copy_mixed_output := \
   { \
     $(foreach output,$(PROJECT_OUTPUT),\
       if [ -f '$(output)' ]; then \
         mixed_output='$(patsubst \
           $(TARGET_BUILD_ROOT)/%,$(MIXED_BUILD_ROOT)/%,$(output))'; \
         mkdir -p `dirname "$$mixed_output"`; \
         cp '$(output)' "$$mixed_output"; \
       else \
         :; \
       fi;) \
     :; \
   }
endif

ifdef PROJECT_POSTSCAN
 _do_postscan := 1
else
 _do_postscan := 0
endif
ifeq ($(OPTION_PS3_SKIP_POSTSCAN),1)
 _do_postscan := 0
endif

.PHONY: __command_scan
__command_scan: $(PROJECT_OUTPUT)
ifeq ($(MKOPTION_PS3_MIXED_BUILD),1)
 ifneq ($(MIXED_BUILD),1)
	$(SILENT) $(copy_mixed_output)
 endif
endif
	$(SILENT_NOP)
# scan.mk: __command_scan TARGET=$(TARGET)

.PHONY: _command_default
_command_default: __command_scan
ifeq ($(_do_postscan),1)
	+$(PROJECT_POSTSCAN)
else
	$(SILENT_NOP)
endif
# scan.mk: _command_default TARGET=$(TARGET)

.PHONY: _command_post
_command_post:
ifeq ($(_do_postscan),1)
	+$(PROJECT_POSTSCAN)
else
	$(SILENT_NOP)
endif
# scan.mk: _command_post TARGET=$(TARGET)

.PHONY: _command_clean
_command_clean:
	$(BUILD_SILENT) $(RM) $(SCAN_CLEAN_$(TARGET))
	$(SILENT_NOP)
# scan.mk: _command_clean TARGET=$(TARGET)

# Stage/compile.mk
# vim:ts=8:sw=2

