#############################################################################
## Crytek Source File
## Copyright (C) 2009, Crytek Studios
##
## Creator: Chris Raine 
## Date: Okt 19, 2009
## Description: GNU-make based build system
#############################################################################

# Stage makefile for the 'scan_zip' stage.

# This stage should only be activated when the build process is using pregenerated 
# scan files 
ifneq ($(MKOPTION_USE_PREGEN_SPUFILES),1)
 $(error precompiled scan stage should only be activated\
	 when MKOPTION_USE_PREGEN_SPUFILES is 1)
endif 

.PHONY: _prepare
_prepare: $(PREPARE_DEPS) 
ifeq ($(FIRST_STAGE),scan_zip)
	$(SILENT) mkdir -p "$(PROJECT_BUILD)"
else
	$(SILENT_NOP)
endif

$(BUILD_ROOT)/extracted: $(MKOPTION_PREGEN_ARCHIVE)
	$(BUILD_ECHO) extracting files in $<
	mkdir -p $(dir $@)
	$(SILENT) if [ "$(MKOPTION_VERBOSE)" -eq "1" ]; then \
		tar -xzf - -C $(BUILD_ROOT) < '$<'; \
	else \
		tar -xvzf - -C $(BUILD_ROOT) < '$<'; \
	fi
	@touch $@ -r $<


.PHONY: _command_default
_command_default: $(BUILD_ROOT)/extracted
	$(SILENT_NOP)
# scan.mk: _command_default TARGET=$(TARGET)

.PHONY: _command_post
_command_post:
	$(SILENT_NOP)
# scan.mk: _command_post TARGET=$(TARGET)

.PHONY: _command_clean
_command_clean:
	$(BUILD_SILENT) $(RM) $(SCAN_CLEAN_$(TARGET))
	$(BUILD_SILENT) $(RM) $(BUILD_ROOT)/extracted
	$(SILENT_NOP)

# scan.mk: _command_clean TARGET=$(TARGET)

# Stage/compile.mk
# vim:ts=8:sw=2


