#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

PROJECT_TYPE := maketools

PROJECT_OUTPUT := maketools

.PHONY: maketools
maketools: devirtualize

# De-virtualization support.

DEVIRT = $(MAKE_TOOLS_BINDIR)/devirt

DEVIRT_CPPFLAGS = $(CPPFLAGS) -I $(CODE_ROOT)/CryEngine/CryCommon \
		  -I$(CODE_ROOT) -DDEVIRT_GEN_MANGLE_NAMES

DEVIRT_OPTIONS = $(strip -m "$(DEVIRT_CACHE_DIR)" -o "$(BUILD_ROOT)" \
		 $(foreach impl,$(UNIQUE_IMPL_LIST), -c "$(impl)") \
		 -B $(UNIQUE_IFACE_BASE_DIR) -R $(UNIQUE_IFACE_CODE_ROOT) \
		 $(foreach iface,$(UNIQUE_GAME_IFACE_LIST), -g "$(iface)") \
		 $(foreach impl,$(UNIQUE_GAME_IMPL_LIST), -k "$(impl)") \
		 $(foreach dir,$(UNIQUE_IFACE_DIR), -j "$(dir)") \
		 $(foreach iface,$(UNIQUE_IFACE_LIST), -i "$(iface)") \
		 -C \'$(_BUILD) $(CXX) $(CFLAGS) $(CXXFLAGS) \
		 $(DEVIRT_CPPFLAGS) -w -S\' )
DEVIRT_OPTIONS_PART1 = $(wordlist 1, 100, $(DEVIRT_OPTIONS))
DEVIRT_OPTIONS_PART2 = $(wordlist 101, $(words $(DEVIRT_OPTIONS)), $(DEVIRT_OPTIONS))

DEVIRT_OPTIONS_FILE = $(BUILD_ROOT)/devirt_options

run_devirtualize := 0;

# dont run the devirtualizer if building with the eval-SDK(but keep devirtualizer enabled since the SDK was build with it)
ifneq ($(BUILD_WITH_PS3_SDK),1)
	ifeq ($(OPTION_DEVIRTUALIZE),1)
	  ifeq ($(STAGE),scan)
		run_devirtualize := 1
	  else
		ifeq ($(STAGE),compile)
		  run_devirtualize := 1
		endif
	  endif
	else
	  ifeq ($(STAGE),scan)
		run_no_devirtualize := 1
	  else
		ifeq ($(STAGE),compile)
		  run_no_devirtualize := 1
		endif
	  endif
	endif
endif

.PHONY: devirtualize
ifeq ($(run_devirtualize),1)
devirtualize:
	@echo "[$(STAGE)] Devirtualizing..."
	$(SILENT) rm -f $(DEVIRT_CACHE_DIR)/$(DEVIRT_VIRTUAL_MAPFILE)
	$(SILENT) rm -f $(DEVIRT_OPTIONS_FILE)
	$(SILENT) echo -n $(DEVIRT_OPTIONS_PART1) > $(DEVIRT_OPTIONS_FILE)
	$(SILENT) echo -n ' ' >> $(DEVIRT_OPTIONS_FILE)
	$(SILENT) echo $(DEVIRT_OPTIONS_PART2) >> $(DEVIRT_OPTIONS_FILE)
	$(SILENT) cd $(CODE_ROOT) && $(_BUILD) $(DEVIRT) $(DEVIRT_OPTIONS_FILE)
else
devirtualize: no_devirtualize
	$(SILENT_NOP)
endif

# Devirtualization sanity check: 
# If the $(DEVIRT_CACHE_DIR) exists and devirtualization is turned
# off then the $(DEVIRT_CACHE_DIR) is removed and a full rebuild is
# enforced. This is done to prevent dependency problems when
# accidentally building against a previously devirtualized build
# directory.
.PHONY: no_devirtualize
ifeq ($(run_no_devirtualize),1)
no_devirtualize:
	if [ -d $(DEVIRT_CACHE_DIR) ]; then \
		echo 'INFO: previous build contained devirtialization'; \
		echo 'INFO: performing automatic full rebuild'; \
		rm -rf $(DEVIRT_CACHE_DIR); \
		rm -rf $(BUILD_ROOT); \
	fi 
else
no_devirtualize:
	$(SILENT_NOP)
endif



# vim:ts=8:sw=8

