#!/usr/bin/perl
#
# Simple script for embedding binary data into a C file.

if ($#ARGV != 1)
{
	print STDERR "usage: $0 (symbol-name) (binary-file) >(output-file)\n";
	exit 1;
}

my $symbol_name = $ARGV[0];
my $binary_file = $ARGV[1];

open(IN, '<', $binary_file) or die "can not open '$binary_file': $!";
my $buffer = '';

print "\n__attribute__ ((aligned(128))) unsigned char ${symbol_name}[] = {\n";

while (not eof IN)
{
	my $nread = read IN, $buffer, 32;
	defined $nread or die "read error: $!";
	print "  ";
	for (my $i = 0; $i < $nread; ++$i)
	{
		print sprintf '0x%02x, ', ord(substr $buffer, $i, 1);
	}
	print "\n";
}
print "  \n};\n\n";
close IN;
exit 0;

