#!/bin/bash
################################################################################
## Crytek Source File
## Copyright (C) 2009, Crytek Studios
##
## Creator: Christopher Raine
## Date: Oktober 19, 2009
## Description: GNU-make based build system
################################################################################

# Shell script to build the tar-file containing the required 
# files to build ps3 sdk with prescanned code. 

MAKE_COMMAND=""
MAKE=make
MAKE_OPTIONS=""
TARGET=PS3Launcher
REBUILD=0
OUTPUT=scan_files.tar
BUILD_LOG=""
CONFIG=profile
export DISTCC_HOSTS="192.168.14.132/8 192.168.14.133/8 192.168.0.240/8 192.168.222.221/8 192.168.14.131/8 192.168.101.10/8 localhost/1"

# Print the usage of this script to stdout 
function usage()
{
    SCRIPT_NAME=`basename $0`
    cat <<EOF
usage: 
	$SCRIPT_NAME [-r] [-v] [--target=build-target] [--output=output-tar]
Builds the required tar file for distributing precompiled spu code with the make system 
	-v|--verbose    enable verbose operation (default off)
	-r|--rebuild	force a rebuild before building the options (default off)
	-c|--config     the configuration (default 'profile')
	--target=name   The name of the build target to be built (default 'PS3Launcher')
	--ouput=file    The path to the output file (default scan_files.tar.gz)
EOF
}

# Setup the build environment for windows 
function setup_windows()
{
    if [ -z "$DEPOT_MAIN" ]; then
	echo ERROR: DEPOT_MAIN environment variable not set
	exit 1;
    fi
    if [ -z "$CELL_SDK" ]; then
	echo ERROR: CELL_SDK environment variable not set
	exit 1;
    fi
    local CYGWIN_DIR=$DEPOT_MAIN/Code/Tools/Make/Tools/host-win32/cygwin
    local MINGW_DIR=$DEPOT_MAIN/Code/Tools/Make/Tools/host-win32/mingw
    local MSYS_DIR=$DEPOT_MAIN/Code/Tools/Make/Tools/host-win32/msys/1.0
    local CELL_HOSTDIR=$DEPOT_MAIN/host-win32
    export PATH=$CELL_HOSTDIR/bin:$CELL_HOSTDIR/ppu/bin:$CELL_HOSTDIR/spu/bin:$PATH
    export PATH=$MSYS_DIR/bin:$MSYS_DIR/local/bin:$MINGW_DIR:$CYGWIN_DIR/bin:$PATH
    export MAKE=mingw32-make
    export SHELL=sh
    export BUILD_DIR=./BinTemp/PS3/PS3-cell-$CONFIG
    MAKE_OPTIONS="MAKE_SYSTEM=MinGW -f $DEPOT_MAIN/Code/Tools/Make/Default.mk"
}

# Setup the build environment for windows 
function setup_linux()
{
    echo not implemented yet!
    return 1;
}

# Rebuild the engine 
function rebuild()
{
    if [ "$REBUILD" -ne "0" ]; then 
	echo performing make clean 
	$MAKE $MAKE_OPTIONS TARGET=$TARGET clean 2>&1 $BUILD_LOG;
	if [ "$?" -ne "0"  ]; then
	    echo 'compilation failed'; 
	    exit 1;

	    fi
    fi
    echo building the sdk with "$MAKE" "$MAKE_OPTIONS" "TARGET=$TARGET" 
    $MAKE $MAKE_OPTIONS TARGET=$TARGET 2>&1 $BUILD_LOG;
    if [ "$?" -ne "0"  ]; then
	echo 'compilation failed'; 
	exit 1;
    fi
}

# Gather the generated files from the list 
function gather()
{
    if [ -e "$OUTPUT" ]; then     
	echo removing $OUTPUT;
	rm -f $OUTPUT; 
    fi
    touch "$BUILD_DIR"/extracted
    (cd "$BUILD_DIR" && echo extracted && \
	find . -iname "*.ccg"  -o -iname "*.ccgindex" \
	-o -iname "*.elt" -o -iname "*.symlist" \
	-o -iname "SPUJobs*.mk" -o \( -path "*Lib*spujob*" -a \( \
	-iname "*.fnc" -o -iname "*.h" -o -iname "*.cpp" \
	-o -iname "*.prf" -o -iname "*.txt" -o -iname "*.d" \
	-o -iname "*.page*" -o -iname "*.flow" -o -iname "*.u" \) \) ) \
	| xargs tar -uvf "$OUTPUT" -C "$BUILD_DIR";
    gzip -9 -f "$OUTPUT"
}


# Determine the host system 
case `uname -s` in
    MINGW32_NT-*) 
	setup_windows;
	if [ "$?" -ne "0" ]; then 
	    echo error setting up build environment;
	fi;; 
    Linux)
	setup_linux;
	if [ "$?" -ne "0" ]; then 
	    echo error setting up build environment;
	fi;; 
    *)
	echo unknown host system; 
	exit 1;;
esac


# Parse the command line
for arg in "$*"
do 
    case "$arg" in 
	-v|--verbose) VERBOSE=1;;
	-r|--rebuild) REBUILD=1;;
	--output=*) OUTPUT="$1";;
	--target=*) TARGET="$1";;
	--config=*) CONFIG="$1";;
	--help) usage; exit 0;;
	*) :;;
    esac
done

# perform a full rebuild of the engine 
rebuild 

# gather the the files together 
gather 


