/* PPU builtin extern declarations for CodeMirror */ 
#ifndef __PPU_BUILTINS__
#define __PPU_BUILTINS__

// Prevent Codemirror from entering headers that it does not understand
// The context of the headers <vec_types.h> and <altivec.h> is presented here
// in an equivalent portable manner for codemirror. 
#define _VEC_TYPES_H_	1
#define _ALTIVEC_H

#ifndef offsetof
# define offsetof(t, memb) ((size_t)__INTADDR__(&(((t *)0)->memb)))
#endif 

// Define the qword builtin type type 
typedef signed char __attribute__ ((vector_size (16), aligned (16))) qword;


#undef vector
#define vector __attribute__ ((vector_size (16)))
#undef __vector
#define __vector __attribute__ ((vector_size (16), aligned (16)))

#undef vec_uchar16
typedef unsigned char vec_uchar16 __vector;

#undef vec_char16
typedef signed char vec_char16 __vector;

#undef vec_ushort8
typedef unsigned short vec_ushort8 __vector;

#undef vec_short8
typedef short vec_short8 __vector;

#undef vec_uint4
typedef unsigned int vec_uint4 __vector;

#undef vec_int4
typedef int vec_int4 __vector;

#undef vec_ullong2
typedef unsigned long long vec_ullong2 __vector;

#undef vec_llong2
typedef long long vec_llong2 __vector;

#undef vec_float4
typedef float vec_float4 __vector;

#undef vec_double2
typedef double vec_double2 __vector;

#undef vec_bchar16
typedef unsigned char vec_bchar16 __vector;

#undef vec_bshort8
typedef unsigned short vec_bshort8 __vector;

#undef vec_bint4
typedef unsigned int vec_bint4 __vector;

#undef vec_pixel8
typedef unsigned short vec_pixel8 __vector;

#undef vector
#undef __vector

// Builtins from the gcc compiler 
// Note: most signatures have been guessed!
#if defined __cplusplus__
extern "C" { 
#endif 
  vec_char16 __builtin_vec_abs (vec_char16);
  vec_short8 __builtin_vec_abs (vec_short8);
  vec_int4 __builtin_vec_abs (vec_int4);
  vec_float4 __builtin_vec_abs (vec_float4);
     
  vec_char16 __builtin_vec_abss (vec_char16);
  vec_short8 __builtin_vec_abss (vec_short8);
  vec_int4 __builtin_vec_abss (vec_int4);
     
  vec_char16 __builtin_vec_add (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_add (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_add (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_add (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_add (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_add (vec_uchar16, vec_uchar16);
  vec_short8 __builtin_vec_add (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_add (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_add (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_add (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_add (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_add (vec_ushort8, vec_ushort8);
  vec_int4 __builtin_vec_add (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_add (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_add (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_add (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_add (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_add (vec_uint4, vec_uint4);
  vec_float4 __builtin_vec_add (vec_float4, vec_float4);

  vec_float4 __builtin_vec_vaddfp (vec_float4, vec_float4);
     
  vec_int4 __builtin_vec_vadduwm (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_vadduwm (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_vadduwm (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_vadduwm (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_vadduwm (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_vadduwm (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vadduhm (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_vadduhm (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_vadduhm (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_vadduhm (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_vadduhm (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_vadduhm (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vaddubm (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_vaddubm (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_vaddubm (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_vaddubm (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_vaddubm (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_vaddubm (vec_uchar16, vec_uchar16);
     
  vec_uint4 __builtin_vec_addc (vec_uint4, vec_uint4);
     
  vec_uchar16 __builtin_vec_adds (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_adds (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_adds (vec_uchar16, vec_uchar16);
  vec_char16 __builtin_vec_adds (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_adds (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_adds (vec_char16, vec_char16);
  vec_ushort8 __builtin_vec_adds (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_adds (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_adds (vec_ushort8, vec_ushort8);
  vec_short8 __builtin_vec_adds (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_adds (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_adds (vec_short8, vec_short8);
  vec_uint4 __builtin_vec_adds (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_adds (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_adds (vec_uint4, vec_uint4);
  vec_int4 __builtin_vec_adds (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_adds (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_adds (vec_int4, vec_int4);
     
  vec_int4 __builtin_vec_vaddsws (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_vaddsws (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_vaddsws (vec_int4, vec_int4);
     
  vec_uint4 __builtin_vec_vadduws (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_vadduws (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_vadduws (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vaddshs (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_vaddshs (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_vaddshs (vec_short8, vec_short8);
     
  vec_ushort8 __builtin_vec_vadduhs (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_vadduhs (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_vadduhs (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vaddsbs (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_vaddsbs (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_vaddsbs (vec_char16, vec_char16);
     
  vec_uchar16 __builtin_vec_vaddubs (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_vaddubs (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_vaddubs (vec_uchar16, vec_uchar16);
     
  vec_float4 __builtin_vec_and (vec_float4, vec_float4);
  vec_float4 __builtin_vec_and (vec_float4, vec_bint4);
  vec_float4 __builtin_vec_and (vec_bint4, vec_float4);
  vec_bint4 __builtin_vec_and (vec_bint4, vec_bint4);
  vec_int4 __builtin_vec_and (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_and (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_and (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_and (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_and (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_and (vec_uint4, vec_uint4);
  vec_bshort8 __builtin_vec_and (vec_bshort8, vec_bshort8);
  vec_short8 __builtin_vec_and (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_and (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_and (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_and (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_and (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_and (vec_ushort8, vec_ushort8);
  vec_char16 __builtin_vec_and (vec_bchar16, vec_char16);
  vec_bchar16 __builtin_vec_and (vec_bchar16, vec_bchar16);
  vec_char16 __builtin_vec_and (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_and (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_and (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_and (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_and (vec_uchar16, vec_uchar16);
     
  vec_float4 __builtin_vec_andc (vec_float4, vec_float4);
  vec_float4 __builtin_vec_andc (vec_float4, vec_bint4);
  vec_float4 __builtin_vec_andc (vec_bint4, vec_float4);
  vec_bint4 __builtin_vec_andc (vec_bint4, vec_bint4);
  vec_int4 __builtin_vec_andc (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_andc (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_andc (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_andc (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_andc (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_andc (vec_uint4, vec_uint4);
  vec_bshort8 __builtin_vec_andc (vec_bshort8, vec_bshort8);
  vec_short8 __builtin_vec_andc (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_andc (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_andc (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_andc (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_andc (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_andc (vec_ushort8, vec_ushort8);
  vec_char16 __builtin_vec_andc (vec_bchar16, vec_char16);
  vec_bchar16 __builtin_vec_andc (vec_bchar16, vec_bchar16);
  vec_char16 __builtin_vec_andc (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_andc (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_andc (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_andc (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_andc (vec_uchar16, vec_uchar16);
     
  vec_uchar16 __builtin_vec_avg (vec_uchar16, vec_uchar16);
  vec_char16 __builtin_vec_avg (vec_char16, vec_char16);
  vec_ushort8 __builtin_vec_avg (vec_ushort8, vec_ushort8);
  vec_short8 __builtin_vec_avg (vec_short8, vec_short8);
  vec_uint4 __builtin_vec_avg (vec_uint4, vec_uint4);
  vec_int4 __builtin_vec_avg (vec_int4, vec_int4);
     
  vec_int4 __builtin_vec_vavgsw (vec_int4, vec_int4);
     
  vec_uint4 __builtin_vec_vavguw (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vavgsh (vec_short8, vec_short8);
     
  vec_ushort8 __builtin_vec_vavguh (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vavgsb (vec_char16, vec_char16);
     
  vec_uchar16 __builtin_vec_vavgub (vec_uchar16, vec_uchar16);
     
  vec_float4 __builtin_vec_ceil (vec_float4); 
  vec_int4 __builtin_vec_cmpb (vec_float4, vec_float4);
     
  vec_bchar16 __builtin_vec_cmpeq (vec_char16, vec_char16);
  vec_bchar16 __builtin_vec_cmpeq (vec_uchar16, vec_uchar16);
  vec_bshort8 __builtin_vec_cmpeq (vec_short8, vec_short8);
  vec_bshort8 __builtin_vec_cmpeq (vec_ushort8, vec_ushort8);
  vec_bint4 __builtin_vec_cmpeq (vec_int4, vec_int4);
  vec_bint4 __builtin_vec_cmpeq (vec_uint4, vec_uint4);
  vec_bint4 __builtin_vec_cmpeq (vec_float4, vec_float4);
     
  vec_bint4 __builtin_vec_vcmpeqfp (vec_float4, vec_float4);
     
  vec_bint4 __builtin_vec_vcmpequw (vec_int4, vec_int4);
  vec_bint4 __builtin_vec_vcmpequw (vec_uint4, vec_uint4);
     
  vec_bshort8 __builtin_vec_vcmpequh (vec_short8, vec_short8);
  vec_bshort8 __builtin_vec_vcmpequh (vec_ushort8, vec_ushort8);
     
  vec_bchar16 __builtin_vec_vcmpequb (vec_char16, vec_char16);
  vec_bchar16 __builtin_vec_vcmpequb (vec_uchar16, vec_uchar16);
     
  vec_bint4 __builtin_vec_cmpge (vec_float4, vec_float4);
     
  vec_bchar16 __builtin_vec_cmpgt (vec_uchar16, vec_uchar16);
  vec_bchar16 __builtin_vec_cmpgt (vec_char16, vec_char16);
  vec_bshort8 __builtin_vec_cmpgt (vec_ushort8, vec_ushort8);
  vec_bshort8 __builtin_vec_cmpgt (vec_short8, vec_short8);
  vec_bint4 __builtin_vec_cmpgt (vec_uint4, vec_uint4);
  vec_bint4 __builtin_vec_cmpgt (vec_int4, vec_int4);
  vec_bint4 __builtin_vec_cmpgt (vec_float4, vec_float4);
     
  vec_bint4 __builtin_vec_vcmpgtfp (vec_float4, vec_float4);
     
  vec_bint4 __builtin_vec_vcmpgtsw (vec_int4, vec_int4);
     
  vec_bint4 __builtin_vec_vcmpgtuw (vec_uint4, vec_uint4);
     
  vec_bshort8 __builtin_vec_vcmpgtsh (vec_short8, vec_short8);
     
  vec_bshort8 __builtin_vec_vcmpgtuh (vec_ushort8, vec_ushort8);
     
  vec_bchar16 __builtin_vec_vcmpgtsb (vec_char16, vec_char16);
     
  vec_bchar16 __builtin_vec_vcmpgtub (vec_uchar16, vec_uchar16);
     
  vec_bint4 __builtin_vec_cmple (vec_float4, vec_float4);
     
  vec_bchar16 __builtin_vec_cmplt (vec_uchar16, vec_uchar16);
  vec_bchar16 __builtin_vec_cmplt (vec_char16, vec_char16);
  vec_bshort8 __builtin_vec_cmplt (vec_ushort8, vec_ushort8);
  vec_bshort8 __builtin_vec_cmplt (vec_short8, vec_short8);
  vec_bint4 __builtin_vec_cmplt (vec_uint4, vec_uint4);
  vec_bint4 __builtin_vec_cmplt (vec_int4, vec_int4);
  vec_bint4 __builtin_vec_cmplt (vec_float4, vec_float4);
     
  vec_float4 __builtin_vec_ctf (vec_uint4, const int);
  vec_float4 __builtin_vec_ctf (vec_int4, const int);
     
  vec_float4 __builtin_vec_vcfsx (vec_int4, const int);
     
  vec_float4 __builtin_vec_vcfux (vec_uint4, const int);
     
  vec_int4 __builtin_vec_cts (vec_float4, const int);
     
  vec_uint4 __builtin_vec_ctu (vec_float4, const int);
     
  void __builtin_vec_dss (const int);
     
  void __builtin_vec_dssall (void);
     
  void __builtin_vec_dst (const vec_uchar16 *, int, const int);
  void __builtin_vec_dst (const vec_char16 *, int, const int);
  void __builtin_vec_dst (const vec_bchar16 *, int, const int);
  void __builtin_vec_dst (const vec_ushort8 *, int, const int);
  void __builtin_vec_dst (const vec_short8 *, int, const int);
  void __builtin_vec_dst (const vec_bshort8 *, int, const int);
  void __builtin_vec_dst (const vec_pixel8 *, int, const int);
  void __builtin_vec_dst (const vec_uint4 *, int, const int);
  void __builtin_vec_dst (const vec_int4 *, int, const int);
  void __builtin_vec_dst (const vec_bint4 *, int, const int);
  void __builtin_vec_dst (const vec_float4 *, int, const int);
  void __builtin_vec_dst (const unsigned char *, int, const int);
  void __builtin_vec_dst (const signed char *, int, const int);
  void __builtin_vec_dst (const unsigned short *, int, const int);
  void __builtin_vec_dst (const short *, int, const int);
  void __builtin_vec_dst (const unsigned int *, int, const int);
  void __builtin_vec_dst (const int *, int, const int);
  void __builtin_vec_dst (const unsigned long *, int, const int);
  void __builtin_vec_dst (const long *, int, const int);
  void __builtin_vec_dst (const float *, int, const int);
     
  void __builtin_vec_dstst (const vec_uchar16 *, int, const int);
  void __builtin_vec_dstst (const vec_char16 *, int, const int);
  void __builtin_vec_dstst (const vec_bchar16 *, int, const int);
  void __builtin_vec_dstst (const vec_ushort8 *, int, const int);
  void __builtin_vec_dstst (const vec_short8 *, int, const int);
  void __builtin_vec_dstst (const vec_bshort8 *, int, const int);
  void __builtin_vec_dstst (const vec_pixel8 *, int, const int);
  void __builtin_vec_dstst (const vec_uint4 *, int, const int);
  void __builtin_vec_dstst (const vec_int4 *, int, const int);
  void __builtin_vec_dstst (const vec_bint4 *, int, const int);
  void __builtin_vec_dstst (const vec_float4 *, int, const int);
  void __builtin_vec_dstst (const unsigned char *, int, const int);
  void __builtin_vec_dstst (const signed char *, int, const int);
  void __builtin_vec_dstst (const unsigned short *, int, const int);
  void __builtin_vec_dstst (const short *, int, const int);
  void __builtin_vec_dstst (const unsigned int *, int, const int);
  void __builtin_vec_dstst (const int *, int, const int);
  void __builtin_vec_dstst (const unsigned long *, int, const int);
  void __builtin_vec_dstst (const long *, int, const int);
  void __builtin_vec_dstst (const float *, int, const int);
     
  void __builtin_vec_dststt (const vec_uchar16 *, int, const int);
  void __builtin_vec_dststt (const vec_char16 *, int, const int);
  void __builtin_vec_dststt (const vec_bchar16 *, int, const int);
  void __builtin_vec_dststt (const vec_ushort8 *, int, const int);
  void __builtin_vec_dststt (const vec_short8 *, int, const int);
  void __builtin_vec_dststt (const vec_bshort8 *, int, const int);
  void __builtin_vec_dststt (const vec_pixel8 *, int, const int);
  void __builtin_vec_dststt (const vec_uint4 *, int, const int);
  void __builtin_vec_dststt (const vec_int4 *, int, const int);
  void __builtin_vec_dststt (const vec_bint4 *, int, const int);
  void __builtin_vec_dststt (const vec_float4 *, int, const int);
  void __builtin_vec_dststt (const unsigned char *, int, const int);
  void __builtin_vec_dststt (const signed char *, int, const int);
  void __builtin_vec_dststt (const unsigned short *, int, const int);
  void __builtin_vec_dststt (const short *, int, const int);
  void __builtin_vec_dststt (const unsigned int *, int, const int);
  void __builtin_vec_dststt (const int *, int, const int);
  void __builtin_vec_dststt (const unsigned long *, int, const int);
  void __builtin_vec_dststt (const long *, int, const int);
  void __builtin_vec_dststt (const float *, int, const int);
     
  void __builtin_vec_dstt (const vec_uchar16 *, int, const int);
  void __builtin_vec_dstt (const vec_char16 *, int, const int);
  void __builtin_vec_dstt (const vec_bchar16 *, int, const int);
  void __builtin_vec_dstt (const vec_ushort8 *, int, const int);
  void __builtin_vec_dstt (const vec_short8 *, int, const int);
  void __builtin_vec_dstt (const vec_bshort8 *, int, const int);
  void __builtin_vec_dstt (const vec_pixel8 *, int, const int);
  void __builtin_vec_dstt (const vec_uint4 *, int, const int);
  void __builtin_vec_dstt (const vec_int4 *, int, const int);
  void __builtin_vec_dstt (const vec_bint4 *, int, const int);
  void __builtin_vec_dstt (const vec_float4 *, int, const int);
  void __builtin_vec_dstt (const unsigned char *, int, const int);
  void __builtin_vec_dstt (const signed char *, int, const int);
  void __builtin_vec_dstt (const unsigned short *, int, const int);
  void __builtin_vec_dstt (const short *, int, const int);
  void __builtin_vec_dstt (const unsigned int *, int, const int);
  void __builtin_vec_dstt (const int *, int, const int);
  void __builtin_vec_dstt (const unsigned long *, int, const int);
  void __builtin_vec_dstt (const long *, int, const int);
  void __builtin_vec_dstt (const float *, int, const int);
     
  vec_float4 __builtin_vec_expte (vec_float4);
     
  vec_float4 __builtin_vec_floor (vec_float4);
     
  vec_float4 __builtin_vec_ld (int, const vec_float4 *);
  vec_float4 __builtin_vec_ld (int, const float *);
  vec_bint4 __builtin_vec_ld (int, const vec_bint4 *);
  vec_int4 __builtin_vec_ld (int, const vec_int4 *);
  vec_int4 __builtin_vec_ld (int, const int *);
  vec_int4 __builtin_vec_ld (int, const long *);
  vec_uint4 __builtin_vec_ld (int, const vec_uint4 *);
  vec_uint4 __builtin_vec_ld (int, const unsigned int *);
  vec_uint4 __builtin_vec_ld (int, const unsigned long *);
  vec_bshort8 __builtin_vec_ld (int, const vec_bshort8 *);
  vec_pixel8 __builtin_vec_ld (int, const vec_pixel8 *);
  vec_short8 __builtin_vec_ld (int, const vec_short8 *);
  vec_short8 __builtin_vec_ld (int, const short *);
  vec_ushort8 __builtin_vec_ld (int, const vec_ushort8 *);
  vec_ushort8 __builtin_vec_ld (int, const unsigned short *);
  vec_bchar16 __builtin_vec_ld (int, const vec_bchar16 *);
  vec_char16 __builtin_vec_ld (int, const vec_char16 *);
  vec_char16 __builtin_vec_ld (int, const signed char *);
  vec_uchar16 __builtin_vec_ld (int, const vec_uchar16 *);
  vec_uchar16 __builtin_vec_ld (int, const unsigned char *);
     
  vec_char16 __builtin_vec_lde (int, const signed char *);
  vec_uchar16 __builtin_vec_lde (int, const unsigned char *);
  vec_short8 __builtin_vec_lde (int, const short *);
  vec_ushort8 __builtin_vec_lde (int, const unsigned short *);
  vec_float4 __builtin_vec_lde (int, const float *);
  vec_int4 __builtin_vec_lde (int, const int *);
  vec_uint4 __builtin_vec_lde (int, const unsigned int *);
  vec_int4 __builtin_vec_lde (int, const long *);
  vec_uint4 __builtin_vec_lde (int, const unsigned long *);
     
  vec_float4 __builtin_vec_lvewx (int, float *);
  vec_int4 __builtin_vec_lvewx (int, int *);
  vec_uint4 __builtin_vec_lvewx (int, unsigned int *);
  vec_int4 __builtin_vec_lvewx (int, long *);
  vec_uint4 __builtin_vec_lvewx (int, unsigned long *);
     
  vec_short8 __builtin_vec_lvehx (int, short *);
  vec_ushort8 __builtin_vec_lvehx (int, unsigned short *);
     
  vec_char16 __builtin_vec_lvebx (int, char *);
  vec_uchar16 __builtin_vec_lvebx (int, unsigned char *);
     
  vec_float4 __builtin_vec_ldl (int, const vec_float4 *);
  vec_float4 __builtin_vec_ldl (int, const float *);
  vec_bint4 __builtin_vec_ldl (int, const vec_bint4 *);
  vec_int4 __builtin_vec_ldl (int, const vec_int4 *);
  vec_int4 __builtin_vec_ldl (int, const int *);
  vec_int4 __builtin_vec_ldl (int, const long *);
  vec_uint4 __builtin_vec_ldl (int, const vec_uint4 *);
  vec_uint4 __builtin_vec_ldl (int, const unsigned int *);
  vec_uint4 __builtin_vec_ldl (int, const unsigned long *);
  vec_bshort8 __builtin_vec_ldl (int, const vec_bshort8 *);
  vec_pixel8 __builtin_vec_ldl (int, const vec_pixel8 *);
  vec_short8 __builtin_vec_ldl (int, const vec_short8 *);
  vec_short8 __builtin_vec_ldl (int, const short *);
  vec_ushort8 __builtin_vec_ldl (int, const vec_ushort8 *);
  vec_ushort8 __builtin_vec_ldl (int, const unsigned short *);
  vec_bchar16 __builtin_vec_ldl (int, const vec_bchar16 *);
  vec_char16 __builtin_vec_ldl (int, const vec_char16 *);
  vec_char16 __builtin_vec_ldl (int, const signed char *);
  vec_uchar16 __builtin_vec_ldl (int, const vec_uchar16 *);
  vec_uchar16 __builtin_vec_ldl (int, const unsigned char *);
     
  vec_float4 __builtin_vec_loge (vec_float4);
     
  vec_uchar16 __builtin_vec_lvsl (int, const volatile unsigned char *);
  vec_uchar16 __builtin_vec_lvsl (int, const volatile signed char *);
  vec_uchar16 __builtin_vec_lvsl (int, const volatile unsigned short *);
  vec_uchar16 __builtin_vec_lvsl (int, const volatile short *);
  vec_uchar16 __builtin_vec_lvsl (int, const volatile unsigned int *);
  vec_uchar16 __builtin_vec_lvsl (int, const volatile int *);
  vec_uchar16 __builtin_vec_lvsl (int, const volatile unsigned long *);
  vec_uchar16 __builtin_vec_lvsl (int, const volatile long *);
  vec_uchar16 __builtin_vec_lvsl (int, const volatile float *);
     
  vec_uchar16 __builtin_vec_lvsr (int, const volatile unsigned char *);
  vec_uchar16 __builtin_vec_lvsr (int, const volatile signed char *);
  vec_uchar16 __builtin_vec_lvsr (int, const volatile unsigned short *);
  vec_uchar16 __builtin_vec_lvsr (int, const volatile short *);
  vec_uchar16 __builtin_vec_lvsr (int, const volatile unsigned int *);
  vec_uchar16 __builtin_vec_lvsr (int, const volatile int *);
  vec_uchar16 __builtin_vec_lvsr (int, const volatile unsigned long *);
  vec_uchar16 __builtin_vec_lvsr (int, const volatile long *);
  vec_uchar16 __builtin_vec_lvsr (int, const volatile float *);
     
  vec_float4 __builtin_vec_madd (vec_float4, vec_float4, vec_float4);
     
  vec_short8 __builtin_vec_madds (vec_short8, vec_short8, vec_short8);
     
  vec_uchar16 __builtin_vec_max (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_max (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_max (vec_uchar16, vec_uchar16);
  vec_char16 __builtin_vec_max (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_max (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_max (vec_char16, vec_char16);
  vec_ushort8 __builtin_vec_max (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_max (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_max (vec_ushort8, vec_ushort8);
  vec_short8 __builtin_vec_max (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_max (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_max (vec_short8, vec_short8);
  vec_uint4 __builtin_vec_max (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_max (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_max (vec_uint4, vec_uint4);
  vec_int4 __builtin_vec_max (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_max (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_max (vec_int4, vec_int4);
  vec_float4 __builtin_vec_max (vec_float4, vec_float4);
  vec_float4 __builtin_vec_vmaxfp (vec_float4, vec_float4);
     
  vec_int4 __builtin_vec_vmaxsw (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_vmaxsw (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_vmaxsw (vec_int4, vec_int4);
     
  vec_uint4 __builtin_vec_vmaxuw (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_vmaxuw (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_vmaxuw (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vmaxsh (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_vmaxsh (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_vmaxsh (vec_short8, vec_short8);
     
  vec_ushort8 __builtin_vec_vmaxuh (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_vmaxuh (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_vmaxuh (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vmaxsb (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_vmaxsb (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_vmaxsb (vec_char16, vec_char16);
     
  vec_uchar16 __builtin_vec_vmaxub (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_vmaxub (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_vmaxub (vec_uchar16, vec_uchar16);
     
  vec_bchar16 __builtin_vec_mergeh (vec_bchar16, vec_bchar16);
  vec_char16 __builtin_vec_mergeh (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_mergeh (vec_uchar16, vec_uchar16);
  vec_bshort8 __builtin_vec_mergeh (vec_bshort8, vec_bshort8);
  vec_pixel8 __builtin_vec_mergeh (vec_pixel8, vec_pixel8);
  vec_short8 __builtin_vec_mergeh (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_mergeh (vec_ushort8, vec_ushort8);
  vec_float4 __builtin_vec_mergeh (vec_float4, vec_float4);
  vec_bint4 __builtin_vec_mergeh (vec_bint4, vec_bint4);
  vec_int4 __builtin_vec_mergeh (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_mergeh (vec_uint4, vec_uint4);
     
  vec_float4 __builtin_vec_vmrghw (vec_float4, vec_float4);
  vec_bint4 __builtin_vec_vmrghw (vec_bint4, vec_bint4);
  vec_int4 __builtin_vec_vmrghw (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_vmrghw (vec_uint4, vec_uint4);
     
  vec_bshort8 __builtin_vec_vmrghh (vec_bshort8, vec_bshort8);
  vec_short8 __builtin_vec_vmrghh (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_vmrghh (vec_ushort8, vec_ushort8);
  vec_pixel8 __builtin_vec_vmrghh (vec_pixel8, vec_pixel8);
     
  vec_bchar16 __builtin_vec_vmrghb (vec_bchar16, vec_bchar16);
  vec_char16 __builtin_vec_vmrghb (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_vmrghb (vec_uchar16, vec_uchar16);
     
  vec_bchar16 __builtin_vec_mergel (vec_bchar16, vec_bchar16);
  vec_char16 __builtin_vec_mergel (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_mergel (vec_uchar16, vec_uchar16);
  vec_bshort8 __builtin_vec_mergel (vec_bshort8, vec_bshort8);
  vec_pixel8 __builtin_vec_mergel (vec_pixel8, vec_pixel8);
  vec_short8 __builtin_vec_mergel (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_mergel (vec_ushort8, vec_ushort8);
  vec_float4 __builtin_vec_mergel (vec_float4, vec_float4);
  vec_bint4 __builtin_vec_mergel (vec_bint4, vec_bint4);
  vec_int4 __builtin_vec_mergel (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_mergel (vec_uint4, vec_uint4);
     
  vec_float4 __builtin_vec_vmrglw (vec_float4, vec_float4);
  vec_int4 __builtin_vec_vmrglw (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_vmrglw (vec_uint4, vec_uint4);
  vec_bint4 __builtin_vec_vmrglw (vec_bint4, vec_bint4);
     
  vec_bshort8 __builtin_vec_vmrglh (vec_bshort8, vec_bshort8);
  vec_short8 __builtin_vec_vmrglh (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_vmrglh (vec_ushort8, vec_ushort8);
  vec_pixel8 __builtin_vec_vmrglh (vec_pixel8, vec_pixel8);
     
  vec_bchar16 __builtin_vec_vmrglb (vec_bchar16, vec_bchar16);
  vec_char16 __builtin_vec_vmrglb (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_vmrglb (vec_uchar16, vec_uchar16);
     
  vec_ushort8 __builtin_vec_mfvscr (void);
     
  vec_uchar16 __builtin_vec_min (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_min (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_min (vec_uchar16, vec_uchar16);
  vec_char16 __builtin_vec_min (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_min (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_min (vec_char16, vec_char16);
  vec_ushort8 __builtin_vec_min (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_min (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_min (vec_ushort8, vec_ushort8);
  vec_short8 __builtin_vec_min (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_min (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_min (vec_short8, vec_short8);
  vec_uint4 __builtin_vec_min (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_min (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_min (vec_uint4, vec_uint4);
  vec_int4 __builtin_vec_min (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_min (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_min (vec_int4, vec_int4);
  vec_float4 __builtin_vec_min (vec_float4, vec_float4);
     
  vec_float4 __builtin_vec_vminfp (vec_float4, vec_float4);
     
  vec_int4 __builtin_vec_vminsw (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_vminsw (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_vminsw (vec_int4, vec_int4);
     
  vec_uint4 __builtin_vec_vminuw (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_vminuw (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_vminuw (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vminsh (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_vminsh (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_vminsh (vec_short8, vec_short8);
     
  vec_ushort8 __builtin_vec_vminuh (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_vminuh (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_vminuh (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vminsb (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_vminsb (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_vminsb (vec_char16, vec_char16);
     
  vec_uchar16 __builtin_vec_vminub (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_vminub (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_vminub (vec_uchar16, vec_uchar16);
     
  vec_short8 __builtin_vec_mladd (vec_short8, vec_short8, vec_short8);
  vec_short8 __builtin_vec_mladd (vec_short8, vec_ushort8, vec_ushort8);
  vec_short8 __builtin_vec_mladd (vec_ushort8, vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_mladd (vec_ushort8, vec_ushort8, vec_ushort8);
     
  vec_short8 __builtin_vec_mradds (vec_short8, vec_short8, vec_short8);
     
  vec_uint4 __builtin_vec_msum (vec_uchar16, vec_uchar16, vec_uint4);
  vec_int4 __builtin_vec_msum (vec_char16, vec_uchar16, vec_int4);
  vec_uint4 __builtin_vec_msum (vec_ushort8, vec_ushort8, vec_uint4);
  vec_int4 __builtin_vec_msum (vec_short8, vec_short8, vec_int4);
     
  vec_int4 __builtin_vec_vmsumshm (vec_short8, vec_short8, vec_int4);
  vec_uint4 __builtin_vec_vmsumuhm (vec_ushort8, vec_ushort8, vec_uint4);
  vec_int4 __builtin_vec_vmsummbm (vec_char16, vec_uchar16, vec_int4);
     
  vec_uint4 __builtin_vec_vmsumubm (vec_uchar16, vec_uchar16, vec_uint4);
     
  vec_uint4 __builtin_vec_msums (vec_ushort8, vec_ushort8, vec_uint4);
  vec_int4 __builtin_vec_msums (vec_short8, vec_short8, vec_int4);
     
  vec_int4 __builtin_vec_vmsumshs (vec_short8, vec_short8, vec_int4);
     
  vec_uint4 __builtin_vec_vmsumuhs (vec_ushort8, vec_ushort8, vec_uint4);
     
  void __builtin_vec_mtvscr (vec_int4);
  void __builtin_vec_mtvscr (vec_uint4);
  void __builtin_vec_mtvscr (vec_bint4);
  void __builtin_vec_mtvscr (vec_short8);
  void __builtin_vec_mtvscr (vec_ushort8);
  void __builtin_vec_mtvscr (vec_bshort8);
  void __builtin_vec_mtvscr (vec_pixel8);
  void __builtin_vec_mtvscr (vec_char16);
  void __builtin_vec_mtvscr (vec_uchar16);
  void __builtin_vec_mtvscr (vec_bchar16);
     
  vec_ushort8 __builtin_vec_mule (vec_uchar16, vec_uchar16);
  vec_short8 __builtin_vec_mule (vec_char16, vec_char16);
  vec_uint4 __builtin_vec_mule (vec_ushort8, vec_ushort8);
  vec_int4 __builtin_vec_mule (vec_short8, vec_short8);
     
  vec_int4 __builtin_vec_vmulesh (vec_short8, vec_short8);
     
  vec_uint4 __builtin_vec_vmuleuh (vec_ushort8, vec_ushort8);
     
  vec_short8 __builtin_vec_vmulesb (vec_char16, vec_char16);
     
  vec_ushort8 __builtin_vec_vmuleub (vec_uchar16, vec_uchar16);
     
  vec_ushort8 __builtin_vec_mulo (vec_uchar16, vec_uchar16);
  vec_short8 __builtin_vec_mulo (vec_char16, vec_char16);
  vec_uint4 __builtin_vec_mulo (vec_ushort8, vec_ushort8);
  vec_int4 __builtin_vec_mulo (vec_short8, vec_short8);
     
  vec_int4 __builtin_vec_vmulosh (vec_short8, vec_short8);
     
  vec_uint4 __builtin_vec_vmulouh (vec_ushort8, vec_ushort8);
     
  vec_short8 __builtin_vec_vmulosb (vec_char16, vec_char16);
     
  vec_ushort8 __builtin_vec_vmuloub (vec_uchar16, vec_uchar16);
     
  vec_float4 __builtin_vec_nmsub (vec_float4, vec_float4, vec_float4);
     
  vec_float4 __builtin_vec_nor (vec_float4, vec_float4);
  vec_int4 __builtin_vec_nor (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_nor (vec_uint4, vec_uint4);
  vec_bint4 __builtin_vec_nor (vec_bint4, vec_bint4);
  vec_short8 __builtin_vec_nor (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_nor (vec_ushort8, vec_ushort8);
  vec_bshort8 __builtin_vec_nor (vec_bshort8, vec_bshort8);
  vec_char16 __builtin_vec_nor (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_nor (vec_uchar16, vec_uchar16);
  vec_bchar16 __builtin_vec_nor (vec_bchar16, vec_bchar16);
     
  vec_float4 __builtin_vec_or (vec_float4, vec_float4);
  vec_float4 __builtin_vec_or (vec_float4, vec_bint4);
  vec_float4 __builtin_vec_or (vec_bint4, vec_float4);
  vec_bint4 __builtin_vec_or (vec_bint4, vec_bint4);
  vec_int4 __builtin_vec_or (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_or (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_or (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_or (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_or (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_or (vec_uint4, vec_uint4);
  vec_bshort8 __builtin_vec_or (vec_bshort8, vec_bshort8);
  vec_short8 __builtin_vec_or (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_or (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_or (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_or (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_or (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_or (vec_ushort8, vec_ushort8);
  vec_char16 __builtin_vec_or (vec_bchar16, vec_char16);
  vec_bchar16 __builtin_vec_or (vec_bchar16, vec_bchar16);
  vec_char16 __builtin_vec_or (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_or (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_or (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_or (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_or (vec_uchar16, vec_uchar16);
     
  vec_char16 __builtin_vec_pack (vec_short8, vec_short8);
  vec_uchar16 __builtin_vec_pack (vec_ushort8, vec_ushort8);
  vec_bchar16 __builtin_vec_pack (vec_bshort8, vec_bshort8);
  vec_short8 __builtin_vec_pack (vec_int4, vec_int4);
  vec_ushort8 __builtin_vec_pack (vec_uint4, vec_uint4);
  vec_bshort8 __builtin_vec_pack (vec_bint4, vec_bint4);
     
  vec_bshort8 __builtin_vec_vpkuwum (vec_bint4, vec_bint4);
  vec_short8 __builtin_vec_vpkuwum (vec_int4, vec_int4);
  vec_ushort8 __builtin_vec_vpkuwum (vec_uint4, vec_uint4);
     
  vec_bchar16 __builtin_vec_vpkuhum (vec_bshort8, vec_bshort8);
  vec_char16 __builtin_vec_vpkuhum (vec_short8, vec_short8);
  vec_uchar16 __builtin_vec_vpkuhum (vec_ushort8, vec_ushort8);
     
  vec_pixel8 __builtin_vec_packpx (vec_uint4, vec_uint4);
     
  vec_uchar16 __builtin_vec_packs (vec_ushort8, vec_ushort8);
  vec_char16 __builtin_vec_packs (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_packs (vec_uint4, vec_uint4);
  vec_short8 __builtin_vec_packs (vec_int4, vec_int4);
     
  vec_short8 __builtin_vec_vpkswss (vec_int4, vec_int4);
     
  vec_ushort8 __builtin_vec_vpkuwus (vec_uint4, vec_uint4);
     
  vec_char16 __builtin_vec_vpkshss (vec_short8, vec_short8);
     
  vec_uchar16 __builtin_vec_vpkuhus (vec_ushort8, vec_ushort8);
     
  vec_uchar16 __builtin_vec_packsu (vec_ushort8, vec_ushort8);
  vec_uchar16 __builtin_vec_packsu (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_packsu (vec_uint4, vec_uint4);
  vec_ushort8 __builtin_vec_packsu (vec_int4, vec_int4);
     
  vec_ushort8 __builtin_vec_vpkswus (vec_int4, vec_int4);
     
  vec_uchar16 __builtin_vec_vpkshus (vec_short8, vec_short8);
     
  vec_float4 __builtin_vec_perm (vec_float4, vec_float4, vec_uchar16);
  vec_int4 __builtin_vec_perm (vec_int4, vec_int4, vec_uchar16);
  vec_uint4 __builtin_vec_perm (vec_uint4, vec_uint4, vec_uchar16);
  vec_bint4 __builtin_vec_perm (vec_bint4, vec_bint4, vec_uchar16);
  vec_short8 __builtin_vec_perm (vec_short8, vec_short8, vec_uchar16);
  vec_ushort8 __builtin_vec_perm (vec_ushort8, vec_ushort8, vec_uchar16);
  vec_bshort8 __builtin_vec_perm (vec_bshort8, vec_bshort8, vec_uchar16);
  vec_pixel8 __builtin_vec_perm (vec_pixel8, vec_pixel8, vec_uchar16);
  vec_char16 __builtin_vec_perm (vec_char16, vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_perm (vec_uchar16, vec_uchar16, vec_uchar16);
  vec_bchar16 __builtin_vec_perm (vec_bchar16, vec_bchar16, vec_uchar16);
  vec_bchar16 __builtin_vec_perm (qword, qword, qword);
     
  vec_float4 __builtin_vec_re (vec_float4);
     
  vec_char16 __builtin_vec_rl (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_rl (vec_uchar16, vec_uchar16);
  vec_short8 __builtin_vec_rl (vec_short8, vec_ushort8);
  vec_ushort8 __builtin_vec_rl (vec_ushort8, vec_ushort8);
  vec_int4 __builtin_vec_rl (vec_int4, vec_uint4);
  vec_uint4 __builtin_vec_rl (vec_uint4, vec_uint4);
     
  vec_int4 __builtin_vec_vrlw (vec_int4, vec_uint4);
  vec_uint4 __builtin_vec_vrlw (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vrlh (vec_short8, vec_ushort8);
  vec_ushort8 __builtin_vec_vrlh (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vrlb (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_vrlb (vec_uchar16, vec_uchar16);
     
  vec_float4 __builtin_vec_round (vec_float4);
     
  vec_float4 __builtin_vec_rsqrte (vec_float4);
     
  vec_float4 __builtin_vec_sel (vec_float4, vec_float4, vec_bint4);
  vec_float4 __builtin_vec_sel (vec_float4, vec_float4, vec_uint4);
  vec_int4 __builtin_vec_sel (vec_int4, vec_int4, vec_bint4);
  vec_int4 __builtin_vec_sel (vec_int4, vec_int4, vec_uint4);
  vec_uint4 __builtin_vec_sel (vec_uint4, vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_sel (vec_uint4, vec_uint4, vec_uint4);
  vec_bint4 __builtin_vec_sel (vec_bint4, vec_bint4, vec_bint4);
  vec_bint4 __builtin_vec_sel (vec_bint4, vec_bint4, vec_uint4);
  vec_short8 __builtin_vec_sel (vec_short8, vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_sel (vec_short8, vec_short8, vec_ushort8);
  vec_ushort8 __builtin_vec_sel (vec_ushort8, vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_sel (vec_ushort8, vec_ushort8, vec_ushort8);
  vec_bshort8 __builtin_vec_sel (vec_bshort8, vec_bshort8, vec_bshort8);
  vec_bshort8 __builtin_vec_sel (vec_bshort8, vec_bshort8, vec_ushort8);
  vec_char16 __builtin_vec_sel (vec_char16, vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_sel (vec_char16, vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_sel (vec_uchar16, vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_sel (vec_uchar16, vec_uchar16, vec_uchar16);
  vec_bchar16 __builtin_vec_sel (vec_bchar16, vec_bchar16, vec_bchar16);
  vec_bchar16 __builtin_vec_sel (vec_bchar16, vec_bchar16, vec_uchar16);
     
  vec_char16 __builtin_vec_sl (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_sl (vec_uchar16, vec_uchar16);
  vec_short8 __builtin_vec_sl (vec_short8, vec_ushort8);
  vec_ushort8 __builtin_vec_sl (vec_ushort8, vec_ushort8);
  vec_int4 __builtin_vec_sl (vec_int4, vec_uint4);
  vec_uint4 __builtin_vec_sl (vec_uint4, vec_uint4);
     
  vec_int4 __builtin_vec_vslw (vec_int4, vec_uint4);
  vec_uint4 __builtin_vec_vslw (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vslh (vec_short8, vec_ushort8);
  vec_ushort8 __builtin_vec_vslh (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vslb (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_vslb (vec_uchar16, vec_uchar16);
     
  vec_float4 __builtin_vec_sld (vec_float4, vec_float4, const int);
  vec_int4 __builtin_vec_sld (vec_int4, vec_int4, const int);
  vec_uint4 __builtin_vec_sld (vec_uint4, vec_uint4, const int);
  vec_bint4 __builtin_vec_sld (vec_bint4, vec_bint4, const int);
  vec_short8 __builtin_vec_sld (vec_short8, vec_short8, const int);
  vec_ushort8 __builtin_vec_sld (vec_ushort8, vec_ushort8, const int);
  vec_bshort8 __builtin_vec_sld (vec_bshort8, vec_bshort8, const int);
  vec_pixel8 __builtin_vec_sld (vec_pixel8, vec_pixel8, const int);
  vec_char16 __builtin_vec_sld (vec_char16, vec_char16, const int);
  vec_uchar16 __builtin_vec_sld (vec_uchar16, vec_uchar16, const int);
  vec_bchar16 __builtin_vec_sld (vec_bchar16, vec_bchar16, const int);
     
  vec_int4 __builtin_vec_sll (vec_int4, vec_uint4);
  vec_int4 __builtin_vec_sll (vec_int4, vec_ushort8);
  vec_int4 __builtin_vec_sll (vec_int4, vec_uchar16);
  vec_uint4 __builtin_vec_sll (vec_uint4, vec_uint4);
  vec_uint4 __builtin_vec_sll (vec_uint4, vec_ushort8);
  vec_uint4 __builtin_vec_sll (vec_uint4, vec_uchar16);
  vec_bint4 __builtin_vec_sll (vec_bint4, vec_uint4);
  vec_bint4 __builtin_vec_sll (vec_bint4, vec_ushort8);
  vec_bint4 __builtin_vec_sll (vec_bint4, vec_uchar16);
  vec_short8 __builtin_vec_sll (vec_short8, vec_uint4);
  vec_short8 __builtin_vec_sll (vec_short8, vec_ushort8);
  vec_short8 __builtin_vec_sll (vec_short8, vec_uchar16);
  vec_ushort8 __builtin_vec_sll (vec_ushort8, vec_uint4);
  vec_ushort8 __builtin_vec_sll (vec_ushort8, vec_ushort8);
  vec_ushort8 __builtin_vec_sll (vec_ushort8, vec_uchar16);
  vec_bshort8 __builtin_vec_sll (vec_bshort8, vec_uint4);
  vec_bshort8 __builtin_vec_sll (vec_bshort8, vec_ushort8);
  vec_bshort8 __builtin_vec_sll (vec_bshort8, vec_uchar16);
  vec_pixel8 __builtin_vec_sll (vec_pixel8, vec_uint4);
  vec_pixel8 __builtin_vec_sll (vec_pixel8, vec_ushort8);
  vec_pixel8 __builtin_vec_sll (vec_pixel8, vec_uchar16);
  vec_char16 __builtin_vec_sll (vec_char16, vec_uint4);
  vec_char16 __builtin_vec_sll (vec_char16, vec_ushort8);
  vec_char16 __builtin_vec_sll (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_sll (vec_uchar16, vec_uint4);
  vec_uchar16 __builtin_vec_sll (vec_uchar16, vec_ushort8);
  vec_uchar16 __builtin_vec_sll (vec_uchar16, vec_uchar16);
  vec_bchar16 __builtin_vec_sll (vec_bchar16, vec_uint4);
  vec_bchar16 __builtin_vec_sll (vec_bchar16, vec_ushort8);
  vec_bchar16 __builtin_vec_sll (vec_bchar16, vec_uchar16);
     
  vec_float4 __builtin_vec_slo (vec_float4, vec_char16);
  vec_float4 __builtin_vec_slo (vec_float4, vec_uchar16);
  vec_int4 __builtin_vec_slo (vec_int4, vec_char16);
  vec_int4 __builtin_vec_slo (vec_int4, vec_uchar16);
  vec_uint4 __builtin_vec_slo (vec_uint4, vec_char16);
  vec_uint4 __builtin_vec_slo (vec_uint4, vec_uchar16);
  vec_short8 __builtin_vec_slo (vec_short8, vec_char16);
  vec_short8 __builtin_vec_slo (vec_short8, vec_uchar16);
  vec_ushort8 __builtin_vec_slo (vec_ushort8, vec_char16);
  vec_ushort8 __builtin_vec_slo (vec_ushort8, vec_uchar16);
  vec_pixel8 __builtin_vec_slo (vec_pixel8, vec_char16);
  vec_pixel8 __builtin_vec_slo (vec_pixel8, vec_uchar16);
  vec_char16 __builtin_vec_slo (vec_char16, vec_char16);
  vec_char16 __builtin_vec_slo (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_slo (vec_uchar16, vec_char16);
  vec_uchar16 __builtin_vec_slo (vec_uchar16, vec_uchar16);
     
  vec_char16 __builtin_vec_splat (vec_char16, const int);
  vec_uchar16 __builtin_vec_splat (vec_uchar16, const int);
  vec_bchar16 __builtin_vec_splat (vec_bchar16, const int);
  vec_short8 __builtin_vec_splat (vec_short8, const int);
  vec_ushort8 __builtin_vec_splat (vec_ushort8, const int);
  vec_bshort8 __builtin_vec_splat (vec_bshort8, const int);
  vec_pixel8 __builtin_vec_splat (vec_pixel8, const int);
  vec_float4 __builtin_vec_splat (vec_float4, const int);
  vec_int4 __builtin_vec_splat (vec_int4, const int);
  vec_uint4 __builtin_vec_splat (vec_uint4, const int);
  vec_bint4 __builtin_vec_splat (vec_bint4, const int);
     
  vec_float4 __builtin_vec_vspltw (vec_float4, const int);
  vec_int4 __builtin_vec_vspltw (vec_int4, const int);
  vec_uint4 __builtin_vec_vspltw (vec_uint4, const int);
  vec_bint4 __builtin_vec_vspltw (vec_bint4, const int);
     
  vec_bshort8 __builtin_vec_vsplth (vec_bshort8, const int);
  vec_short8 __builtin_vec_vsplth (vec_short8, const int);
  vec_ushort8 __builtin_vec_vsplth (vec_ushort8, const int);
  vec_pixel8 __builtin_vec_vsplth (vec_pixel8, const int);
     
  vec_char16 __builtin_vec_vspltb (vec_char16, const int);
  vec_uchar16 __builtin_vec_vspltb (vec_uchar16, const int);
  vec_bchar16 __builtin_vec_vspltb (vec_bchar16, const int);
     
  vec_uchar16 __builtin_altivec_vspltisb(const int);
  vec_ushort8 __builtin_altivec_vspltish(const int);
  vec_uint4 __builtin_altivec_vspltisw(const int);
     
  vec_char16 __builtin_vec_sr (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_sr (vec_uchar16, vec_uchar16);
  vec_short8 __builtin_vec_sr (vec_short8, vec_ushort8);
  vec_ushort8 __builtin_vec_sr (vec_ushort8, vec_ushort8);
  vec_int4 __builtin_vec_sr (vec_int4, vec_uint4);
  vec_uint4 __builtin_vec_sr (vec_uint4, vec_uint4);
     
  vec_int4 __builtin_vec_vsrw (vec_int4, vec_uint4);
  vec_uint4 __builtin_vec_vsrw (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vsrh (vec_short8, vec_ushort8);
  vec_ushort8 __builtin_vec_vsrh (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vsrb (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_vsrb (vec_uchar16, vec_uchar16);
     
  vec_char16 __builtin_vec_sra (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_sra (vec_uchar16, vec_uchar16);
  vec_short8 __builtin_vec_sra (vec_short8, vec_ushort8);
  vec_ushort8 __builtin_vec_sra (vec_ushort8, vec_ushort8);
  vec_int4 __builtin_vec_sra (vec_int4, vec_uint4);
  vec_uint4 __builtin_vec_sra (vec_uint4, vec_uint4);
     
  vec_int4 __builtin_vec_vsraw (vec_int4, vec_uint4);
  vec_uint4 __builtin_vec_vsraw (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vsrah (vec_short8, vec_ushort8);
  vec_ushort8 __builtin_vec_vsrah (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vsrab (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_vsrab (vec_uchar16, vec_uchar16);
     
  vec_int4 __builtin_vec_srl (vec_int4, vec_uint4);
  vec_int4 __builtin_vec_srl (vec_int4, vec_ushort8);
  vec_int4 __builtin_vec_srl (vec_int4, vec_uchar16);
  vec_uint4 __builtin_vec_srl (vec_uint4, vec_uint4);
  vec_uint4 __builtin_vec_srl (vec_uint4, vec_ushort8);
  vec_uint4 __builtin_vec_srl (vec_uint4, vec_uchar16);
  vec_bint4 __builtin_vec_srl (vec_bint4, vec_uint4);
  vec_bint4 __builtin_vec_srl (vec_bint4, vec_ushort8);
  vec_bint4 __builtin_vec_srl (vec_bint4, vec_uchar16);
  vec_short8 __builtin_vec_srl (vec_short8, vec_uint4);
  vec_short8 __builtin_vec_srl (vec_short8, vec_ushort8);
  vec_short8 __builtin_vec_srl (vec_short8, vec_uchar16);
  vec_ushort8 __builtin_vec_srl (vec_ushort8, vec_uint4);
  vec_ushort8 __builtin_vec_srl (vec_ushort8, vec_ushort8);
  vec_ushort8 __builtin_vec_srl (vec_ushort8, vec_uchar16);
  vec_bshort8 __builtin_vec_srl (vec_bshort8, vec_uint4);
  vec_bshort8 __builtin_vec_srl (vec_bshort8, vec_ushort8);
  vec_bshort8 __builtin_vec_srl (vec_bshort8, vec_uchar16);
  vec_pixel8 __builtin_vec_srl (vec_pixel8, vec_uint4);
  vec_pixel8 __builtin_vec_srl (vec_pixel8, vec_ushort8);
  vec_pixel8 __builtin_vec_srl (vec_pixel8, vec_uchar16);
  vec_char16 __builtin_vec_srl (vec_char16, vec_uint4);
  vec_char16 __builtin_vec_srl (vec_char16, vec_ushort8);
  vec_char16 __builtin_vec_srl (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_srl (vec_uchar16, vec_uint4);
  vec_uchar16 __builtin_vec_srl (vec_uchar16, vec_ushort8);
  vec_uchar16 __builtin_vec_srl (vec_uchar16, vec_uchar16);
  vec_bchar16 __builtin_vec_srl (vec_bchar16, vec_uint4);
  vec_bchar16 __builtin_vec_srl (vec_bchar16, vec_ushort8);
  vec_bchar16 __builtin_vec_srl (vec_bchar16, vec_uchar16);
     
  vec_float4 __builtin_vec_sro (vec_float4, vec_char16);
  vec_float4 __builtin_vec_sro (vec_float4, vec_uchar16);
  vec_int4 __builtin_vec_sro (vec_int4, vec_char16);
  vec_int4 __builtin_vec_sro (vec_int4, vec_uchar16);
  vec_uint4 __builtin_vec_sro (vec_uint4, vec_char16);
  vec_uint4 __builtin_vec_sro (vec_uint4, vec_uchar16);
  vec_short8 __builtin_vec_sro (vec_short8, vec_char16);
  vec_short8 __builtin_vec_sro (vec_short8, vec_uchar16);
  vec_ushort8 __builtin_vec_sro (vec_ushort8, vec_char16);
  vec_ushort8 __builtin_vec_sro (vec_ushort8, vec_uchar16);
  vec_pixel8 __builtin_vec_sro (vec_pixel8, vec_char16);
  vec_pixel8 __builtin_vec_sro (vec_pixel8, vec_uchar16);
  vec_char16 __builtin_vec_sro (vec_char16, vec_char16);
  vec_char16 __builtin_vec_sro (vec_char16, vec_uchar16);
  vec_uchar16 __builtin_vec_sro (vec_uchar16, vec_char16);
  vec_uchar16 __builtin_vec_sro (vec_uchar16, vec_uchar16);
     
  void __builtin_vec_st (vec_float4, int, vec_float4 *);
  void __builtin_vec_st (vec_float4, int, float *);
  void __builtin_vec_st (vec_int4, int, vec_int4 *);
  void __builtin_vec_st (vec_int4, int, int *);
  void __builtin_vec_st (vec_uint4, int, vec_uint4 *);
  void __builtin_vec_st (vec_uint4, int, unsigned int *);
  void __builtin_vec_st (vec_bint4, int, vec_bint4 *);
  void __builtin_vec_st (vec_bint4, int, unsigned int *);
  void __builtin_vec_st (vec_bint4, int, int *);
  void __builtin_vec_st (vec_short8, int, vec_short8 *);
  void __builtin_vec_st (vec_short8, int, short *);
  void __builtin_vec_st (vec_ushort8, int, vec_ushort8 *);
  void __builtin_vec_st (vec_ushort8, int, unsigned short *);
  void __builtin_vec_st (vec_bshort8, int, vec_bshort8 *);
  void __builtin_vec_st (vec_bshort8, int, unsigned short *);
  void __builtin_vec_st (vec_pixel8, int, vec_pixel8 *);
  void __builtin_vec_st (vec_pixel8, int, unsigned short *);
  void __builtin_vec_st (vec_pixel8, int, short *);
  void __builtin_vec_st (vec_bshort8, int, short *);
  void __builtin_vec_st (vec_char16, int, vec_char16 *);
  void __builtin_vec_st (vec_char16, int, signed char *);
  void __builtin_vec_st (vec_uchar16, int, vec_uchar16 *);
  void __builtin_vec_st (vec_uchar16, int, unsigned char *);
  void __builtin_vec_st (vec_bchar16, int, vec_bchar16 *);
  void __builtin_vec_st (vec_bchar16, int, unsigned char *);
  void __builtin_vec_st (vec_bchar16, int, signed char *);
     
  void __builtin_vec_ste (vec_char16, int, signed char *);
  void __builtin_vec_ste (vec_uchar16, int, unsigned char *);
  void __builtin_vec_ste (vec_bchar16, int, signed char *);
  void __builtin_vec_ste (vec_bchar16, int, unsigned char *);
  void __builtin_vec_ste (vec_short8, int, short *);
  void __builtin_vec_ste (vec_ushort8, int, unsigned short *);
  void __builtin_vec_ste (vec_bshort8, int, short *);
  void __builtin_vec_ste (vec_bshort8, int, unsigned short *);
  void __builtin_vec_ste (vec_pixel8, int, short *);
  void __builtin_vec_ste (vec_pixel8, int, unsigned short *);
  void __builtin_vec_ste (vec_float4, int, float *);
  void __builtin_vec_ste (vec_int4, int, int *);
  void __builtin_vec_ste (vec_uint4, int, unsigned int *);
  void __builtin_vec_ste (vec_bint4, int, int *);
  void __builtin_vec_ste (vec_bint4, int, unsigned int *);
     
  void __builtin_vec_stvewx (vec_float4, int, float *);
  void __builtin_vec_stvewx (vec_int4, int, int *);
  void __builtin_vec_stvewx (vec_uint4, int, unsigned int *);
  void __builtin_vec_stvewx (vec_bint4, int, int *);
  void __builtin_vec_stvewx (vec_bint4, int, unsigned int *);
     
  void __builtin_vec_stvehx (vec_short8, int, short *);
  void __builtin_vec_stvehx (vec_ushort8, int, unsigned short *);
  void __builtin_vec_stvehx (vec_bshort8, int, short *);
  void __builtin_vec_stvehx (vec_bshort8, int, unsigned short *);
  void __builtin_vec_stvehx (vec_pixel8, int, short *);
  void __builtin_vec_stvehx (vec_pixel8, int, unsigned short *);
     
  void __builtin_vec_stvebx (vec_char16, int, signed char *);
  void __builtin_vec_stvebx (vec_uchar16, int, unsigned char *);
  void __builtin_vec_stvebx (vec_bchar16, int, signed char *);
  void __builtin_vec_stvebx (vec_bchar16, int, unsigned char *);
     
  void __builtin_vec_stl (vec_float4, int, vec_float4 *);
  void __builtin_vec_stl (vec_float4, int, float *);
  void __builtin_vec_stl (vec_int4, int, vec_int4 *);
  void __builtin_vec_stl (vec_int4, int, int *);
  void __builtin_vec_stl (vec_uint4, int, vec_uint4 *);
  void __builtin_vec_stl (vec_uint4, int, unsigned int *);
  void __builtin_vec_stl (vec_bint4, int, vec_bint4 *);
  void __builtin_vec_stl (vec_bint4, int, unsigned int *);
  void __builtin_vec_stl (vec_bint4, int, int *);
  void __builtin_vec_stl (vec_short8, int, vec_short8 *);
  void __builtin_vec_stl (vec_short8, int, short *);
  void __builtin_vec_stl (vec_ushort8, int, vec_ushort8 *);
  void __builtin_vec_stl (vec_ushort8, int, unsigned short *);
  void __builtin_vec_stl (vec_bshort8, int, vec_bshort8 *);
  void __builtin_vec_stl (vec_bshort8, int, unsigned short *);
  void __builtin_vec_stl (vec_bshort8, int, short *);
  void __builtin_vec_stl (vec_pixel8, int, vec_pixel8 *);
  void __builtin_vec_stl (vec_pixel8, int, unsigned short *);
  void __builtin_vec_stl (vec_pixel8, int, short *);
  void __builtin_vec_stl (vec_char16, int, vec_char16 *);
  void __builtin_vec_stl (vec_char16, int, signed char *);
  void __builtin_vec_stl (vec_uchar16, int, vec_uchar16 *);
  void __builtin_vec_stl (vec_uchar16, int, unsigned char *);
  void __builtin_vec_stl (vec_bchar16, int, vec_bchar16 *);
  void __builtin_vec_stl (vec_bchar16, int, unsigned char *);
  void __builtin_vec_stl (vec_bchar16, int, signed char *);
     
  vec_char16 __builtin_vec_sub (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_sub (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_sub (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_sub (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_sub (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_sub (vec_uchar16, vec_uchar16);
  vec_short8 __builtin_vec_sub (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_sub (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_sub (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_sub (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_sub (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_sub (vec_ushort8, vec_ushort8);
  vec_int4 __builtin_vec_sub (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_sub (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_sub (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_sub (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_sub (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_sub (vec_uint4, vec_uint4);
  vec_float4 __builtin_vec_sub (vec_float4, vec_float4);
     
  vec_float4 __builtin_vec_vsubfp (vec_float4, vec_float4);
     
  vec_int4 __builtin_vec_vsubuwm (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_vsubuwm (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_vsubuwm (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_vsubuwm (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_vsubuwm (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_vsubuwm (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vsubuhm (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_vsubuhm (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_vsubuhm (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_vsubuhm (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_vsubuhm (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_vsubuhm (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vsububm (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_vsububm (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_vsububm (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_vsububm (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_vsububm (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_vsububm (vec_uchar16, vec_uchar16);
     
  vec_uint4 __builtin_vec_subc (vec_uint4, vec_uint4);
     
  vec_uchar16 __builtin_vec_subs (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_subs (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_subs (vec_uchar16, vec_uchar16);
  vec_char16 __builtin_vec_subs (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_subs (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_subs (vec_char16, vec_char16);
  vec_ushort8 __builtin_vec_subs (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_subs (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_subs (vec_ushort8, vec_ushort8);
  vec_short8 __builtin_vec_subs (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_subs (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_subs (vec_short8, vec_short8);
  vec_uint4 __builtin_vec_subs (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_subs (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_subs (vec_uint4, vec_uint4);
  vec_int4 __builtin_vec_subs (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_subs (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_subs (vec_int4, vec_int4);
     
  vec_int4 __builtin_vec_vsubsws (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_vsubsws (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_vsubsws (vec_int4, vec_int4);
     
  vec_uint4 __builtin_vec_vsubuws (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_vsubuws (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_vsubuws (vec_uint4, vec_uint4);
     
  vec_short8 __builtin_vec_vsubshs (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_vsubshs (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_vsubshs (vec_short8, vec_short8);
     
  vec_ushort8 __builtin_vec_vsubuhs (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_vsubuhs (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_vsubuhs (vec_ushort8, vec_ushort8);
     
  vec_char16 __builtin_vec_vsubsbs (vec_bchar16, vec_char16);
  vec_char16 __builtin_vec_vsubsbs (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_vsubsbs (vec_char16, vec_char16);
     
  vec_uchar16 __builtin_vec_vsububs (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_vsububs (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_vsububs (vec_uchar16, vec_uchar16);
     
  vec_uint4 __builtin_vec_sum4s (vec_uchar16, vec_uint4);
  vec_int4 __builtin_vec_sum4s (vec_char16, vec_int4);
  vec_int4 __builtin_vec_sum4s (vec_short8, vec_int4);
     
  vec_int4 __builtin_vec_vsum4shs (vec_short8, vec_int4);
     
  vec_int4 __builtin_vec_vsum4sbs (vec_char16, vec_int4);
     
  vec_uint4 __builtin_vec_vsum4ubs (vec_uchar16, vec_uint4);
     
  vec_int4 __builtin_vec_sum2s (vec_int4, vec_int4);
     
  vec_int4 __builtin_vec_sums (vec_int4, vec_int4);
     
  vec_float4 __builtin_vec_trunc (vec_float4);
     
  vec_short8 __builtin_vec_unpackh (vec_char16);
  vec_bshort8 __builtin_vec_unpackh (vec_bchar16);
  vec_int4 __builtin_vec_unpackh (vec_short8);
  vec_bint4 __builtin_vec_unpackh (vec_bshort8);
  vec_uint4 __builtin_vec_unpackh (vec_pixel8);
     
  vec_bint4 __builtin_vec_vupkhsh (vec_bshort8);
  vec_int4 __builtin_vec_vupkhsh (vec_short8);
     
  vec_uint4 __builtin_vec_vupkhpx (vec_pixel8);
     
  vec_bshort8 __builtin_vec_vupkhsb (vec_bchar16);
  vec_short8 __builtin_vec_vupkhsb (vec_char16);
     
  vec_short8 __builtin_vec_unpackl (vec_char16);
  vec_bshort8 __builtin_vec_unpackl (vec_bchar16);
  vec_uint4 __builtin_vec_unpackl (vec_pixel8);
  vec_int4 __builtin_vec_unpackl (vec_short8);
  vec_bint4 __builtin_vec_unpackl (vec_bshort8);
     
  vec_uint4 __builtin_vec_vupklpx (vec_pixel8);
     
  vec_bint4 __builtin_vec_vupklsh (vec_bshort8);
  vec_int4 __builtin_vec_vupklsh (vec_short8);
     
  vec_bshort8 __builtin_vec_vupklsb (vec_bchar16);
  vec_short8 __builtin_vec_vupklsb (vec_char16);
     
  vec_float4 __builtin_vec_xor (vec_float4, vec_float4);
  vec_float4 __builtin_vec_xor (vec_float4, vec_bint4);
  vec_float4 __builtin_vec_xor (vec_bint4, vec_float4);
  vec_bint4 __builtin_vec_xor (vec_bint4, vec_bint4);
  vec_int4 __builtin_vec_xor (vec_bint4, vec_int4);
  vec_int4 __builtin_vec_xor (vec_int4, vec_bint4);
  vec_int4 __builtin_vec_xor (vec_int4, vec_int4);
  vec_uint4 __builtin_vec_xor (vec_bint4, vec_uint4);
  vec_uint4 __builtin_vec_xor (vec_uint4, vec_bint4);
  vec_uint4 __builtin_vec_xor (vec_uint4, vec_uint4);
  vec_bshort8 __builtin_vec_xor (vec_bshort8, vec_bshort8);
  vec_short8 __builtin_vec_xor (vec_bshort8, vec_short8);
  vec_short8 __builtin_vec_xor (vec_short8, vec_bshort8);
  vec_short8 __builtin_vec_xor (vec_short8, vec_short8);
  vec_ushort8 __builtin_vec_xor (vec_bshort8, vec_ushort8);
  vec_ushort8 __builtin_vec_xor (vec_ushort8, vec_bshort8);
  vec_ushort8 __builtin_vec_xor (vec_ushort8, vec_ushort8);
  vec_char16 __builtin_vec_xor (vec_bchar16, vec_char16);
  vec_bchar16 __builtin_vec_xor (vec_bchar16, vec_bchar16);
  vec_char16 __builtin_vec_xor (vec_char16, vec_bchar16);
  vec_char16 __builtin_vec_xor (vec_char16, vec_char16);
  vec_uchar16 __builtin_vec_xor (vec_bchar16, vec_uchar16);
  vec_uchar16 __builtin_vec_xor (vec_uchar16, vec_bchar16);
  vec_uchar16 __builtin_vec_xor (vec_uchar16, vec_uchar16);


  // Check this bugger: 
  int __builtin_vec_vcmpgt_p(...);
  // The below functions are not actual builtins 
#if 0      
  int __builtin_vec_all_eq (vec_char16, vec_bchar16);
  int __builtin_vec_all_eq (vec_char16, vec_char16);
  int __builtin_vec_all_eq (vec_uchar16, vec_bchar16);
  int __builtin_vec_all_eq (vec_uchar16, vec_uchar16);
  int __builtin_vec_all_eq (vec_bchar16, vec_bchar16);
  int __builtin_vec_all_eq (vec_bchar16, vec_uchar16);
  int __builtin_vec_all_eq (vec_bchar16, vec_char16);
  int __builtin_vec_all_eq (vec_short8, vec_bshort8);
  int __builtin_vec_all_eq (vec_short8, vec_short8);
  int __builtin_vec_all_eq (vec_ushort8, vec_bshort8);
  int __builtin_vec_all_eq (vec_ushort8, vec_ushort8);
  int __builtin_vec_all_eq (vec_bshort8, vec_bshort8);
  int __builtin_vec_all_eq (vec_bshort8, vec_ushort8);
  int __builtin_vec_all_eq (vec_bshort8, vec_short8);
  int __builtin_vec_all_eq (vec_pixel8, vec_pixel8);
  int __builtin_vec_all_eq (vec_int4, vec_bint4);
  int __builtin_vec_all_eq (vec_int4, vec_int4);
  int __builtin_vec_all_eq (vec_uint4, vec_bint4);
  int __builtin_vec_all_eq (vec_uint4, vec_uint4);
  int __builtin_vec_all_eq (vec_bint4, vec_bint4);
  int __builtin_vec_all_eq (vec_bint4, vec_uint4);
  int __builtin_vec_all_eq (vec_bint4, vec_int4);
  int __builtin_vec_all_eq (vec_float4, vec_float4);
     
  int __builtin_vec_all_ge (vec_bchar16, vec_uchar16);
  int __builtin_vec_all_ge (vec_uchar16, vec_bchar16);
  int __builtin_vec_all_ge (vec_uchar16, vec_uchar16);
  int __builtin_vec_all_ge (vec_bchar16, vec_char16);
  int __builtin_vec_all_ge (vec_char16, vec_bchar16);
  int __builtin_vec_all_ge (vec_char16, vec_char16);
  int __builtin_vec_all_ge (vec_bshort8, vec_ushort8);
  int __builtin_vec_all_ge (vec_ushort8, vec_bshort8);
  int __builtin_vec_all_ge (vec_ushort8, vec_ushort8);
  int __builtin_vec_all_ge (vec_short8, vec_short8);
  int __builtin_vec_all_ge (vec_bshort8, vec_short8);
  int __builtin_vec_all_ge (vec_short8, vec_bshort8);
  int __builtin_vec_all_ge (vec_bint4, vec_uint4);
  int __builtin_vec_all_ge (vec_uint4, vec_bint4);
  int __builtin_vec_all_ge (vec_uint4, vec_uint4);
  int __builtin_vec_all_ge (vec_bint4, vec_int4);
  int __builtin_vec_all_ge (vec_int4, vec_bint4);
  int __builtin_vec_all_ge (vec_int4, vec_int4);
  int __builtin_vec_all_ge (vec_float4, vec_float4);
     
  int __builtin_vec_all_gt (vec_bchar16, vec_uchar16);
  int __builtin_vec_all_gt (vec_uchar16, vec_bchar16);
  int __builtin_vec_all_gt (vec_uchar16, vec_uchar16);
  int __builtin_vec_all_gt (vec_bchar16, vec_char16);
  int __builtin_vec_all_gt (vec_char16, vec_bchar16);
  int __builtin_vec_all_gt (vec_char16, vec_char16);
  int __builtin_vec_all_gt (vec_bshort8, vec_ushort8);
  int __builtin_vec_all_gt (vec_ushort8, vec_bshort8);
  int __builtin_vec_all_gt (vec_ushort8, vec_ushort8);
  int __builtin_vec_all_gt (vec_bshort8, vec_short8);
  int __builtin_vec_all_gt (vec_short8, vec_bshort8);
  int __builtin_vec_all_gt (vec_short8, vec_short8);
  int __builtin_vec_all_gt (vec_bint4, vec_uint4);
  int __builtin_vec_all_gt (vec_uint4, vec_bint4);
  int __builtin_vec_all_gt (vec_uint4, vec_uint4);
  int __builtin_vec_all_gt (vec_bint4, vec_int4);
  int __builtin_vec_all_gt (vec_int4, vec_bint4);
  int __builtin_vec_all_gt (vec_int4, vec_int4);
  int __builtin_vec_all_gt (vec_float4, vec_float4);
     
  int __builtin_vec_all_in (vec_float4, vec_float4);
     
  int __builtin_vec_all_le (vec_bchar16, vec_uchar16);
  int __builtin_vec_all_le (vec_uchar16, vec_bchar16);
  int __builtin_vec_all_le (vec_uchar16, vec_uchar16);
  int __builtin_vec_all_le (vec_bchar16, vec_char16);
  int __builtin_vec_all_le (vec_char16, vec_bchar16);
  int __builtin_vec_all_le (vec_char16, vec_char16);
  int __builtin_vec_all_le (vec_bshort8, vec_ushort8);
  int __builtin_vec_all_le (vec_ushort8, vec_bshort8);
  int __builtin_vec_all_le (vec_ushort8, vec_ushort8);
  int __builtin_vec_all_le (vec_bshort8, vec_short8);
  int __builtin_vec_all_le (vec_short8, vec_bshort8);
  int __builtin_vec_all_le (vec_short8, vec_short8);
  int __builtin_vec_all_le (vec_bint4, vec_uint4);
  int __builtin_vec_all_le (vec_uint4, vec_bint4);
  int __builtin_vec_all_le (vec_uint4, vec_uint4);
  int __builtin_vec_all_le (vec_bint4, vec_int4);
  int __builtin_vec_all_le (vec_int4, vec_bint4);
  int __builtin_vec_all_le (vec_int4, vec_int4);
  int __builtin_vec_all_le (vec_float4, vec_float4);
     
  int __builtin_vec_all_lt (vec_bchar16, vec_uchar16);
  int __builtin_vec_all_lt (vec_uchar16, vec_bchar16);
  int __builtin_vec_all_lt (vec_uchar16, vec_uchar16);
  int __builtin_vec_all_lt (vec_bchar16, vec_char16);
  int __builtin_vec_all_lt (vec_char16, vec_bchar16);
  int __builtin_vec_all_lt (vec_char16, vec_char16);
  int __builtin_vec_all_lt (vec_bshort8, vec_ushort8);
  int __builtin_vec_all_lt (vec_ushort8, vec_bshort8);
  int __builtin_vec_all_lt (vec_ushort8, vec_ushort8);
  int __builtin_vec_all_lt (vec_bshort8, vec_short8);
  int __builtin_vec_all_lt (vec_short8, vec_bshort8);
  int __builtin_vec_all_lt (vec_short8, vec_short8);
  int __builtin_vec_all_lt (vec_bint4, vec_uint4);
  int __builtin_vec_all_lt (vec_uint4, vec_bint4);
  int __builtin_vec_all_lt (vec_uint4, vec_uint4);
  int __builtin_vec_all_lt (vec_bint4, vec_int4);
  int __builtin_vec_all_lt (vec_int4, vec_bint4);
  int __builtin_vec_all_lt (vec_int4, vec_int4);
  int __builtin_vec_all_lt (vec_float4, vec_float4);
     
  int __builtin_vec_all_nan (vec_float4);
     
  int __builtin_vec_all_ne (vec_char16, vec_bchar16);
  int __builtin_vec_all_ne (vec_char16, vec_char16);
  int __builtin_vec_all_ne (vec_uchar16, vec_bchar16);
  int __builtin_vec_all_ne (vec_uchar16, vec_uchar16);
  int __builtin_vec_all_ne (vec_bchar16, vec_bchar16);
  int __builtin_vec_all_ne (vec_bchar16, vec_uchar16);
  int __builtin_vec_all_ne (vec_bchar16, vec_char16);
  int __builtin_vec_all_ne (vec_short8, vec_bshort8);
  int __builtin_vec_all_ne (vec_short8, vec_short8);
  int __builtin_vec_all_ne (vec_ushort8, vec_bshort8);
  int __builtin_vec_all_ne (vec_ushort8, vec_ushort8);
  int __builtin_vec_all_ne (vec_bshort8, vec_bshort8);
  int __builtin_vec_all_ne (vec_bshort8, vec_ushort8);
  int __builtin_vec_all_ne (vec_bshort8, vec_short8);
  int __builtin_vec_all_ne (vec_pixel8, vec_pixel8);
  int __builtin_vec_all_ne (vec_int4, vec_bint4);
  int __builtin_vec_all_ne (vec_int4, vec_int4);
  int __builtin_vec_all_ne (vec_uint4, vec_bint4);
  int __builtin_vec_all_ne (vec_uint4, vec_uint4);
  int __builtin_vec_all_ne (vec_bint4, vec_bint4);
  int __builtin_vec_all_ne (vec_bint4, vec_uint4);
  int __builtin_vec_all_ne (vec_bint4, vec_int4);
  int __builtin_vec_all_ne (vec_float4, vec_float4);
     
  int __builtin_vec_all_nge (vec_float4, vec_float4);
     
  int __builtin_vec_all_ngt (vec_float4, vec_float4);
     
  int __builtin_vec_all_nle (vec_float4, vec_float4);
     
  int __builtin_vec_all_nlt (vec_float4, vec_float4);
     
  int __builtin_vec_all_numeric (vec_float4);
     
  int __builtin_vec_any_eq (vec_char16, vec_bchar16);
  int __builtin_vec_any_eq (vec_char16, vec_char16);
  int __builtin_vec_any_eq (vec_uchar16, vec_bchar16);
  int __builtin_vec_any_eq (vec_uchar16, vec_uchar16);
  int __builtin_vec_any_eq (vec_bchar16, vec_bchar16);
  int __builtin_vec_any_eq (vec_bchar16, vec_uchar16);
  int __builtin_vec_any_eq (vec_bchar16, vec_char16);
  int __builtin_vec_any_eq (vec_short8, vec_bshort8);
  int __builtin_vec_any_eq (vec_short8, vec_short8);
  int __builtin_vec_any_eq (vec_ushort8, vec_bshort8);
  int __builtin_vec_any_eq (vec_ushort8, vec_ushort8);
  int __builtin_vec_any_eq (vec_bshort8, vec_bshort8);
  int __builtin_vec_any_eq (vec_bshort8, vec_ushort8);
  int __builtin_vec_any_eq (vec_bshort8, vec_short8);
  int __builtin_vec_any_eq (vec_pixel8, vec_pixel8);
  int __builtin_vec_any_eq (vec_int4, vec_bint4);
  int __builtin_vec_any_eq (vec_int4, vec_int4);
  int __builtin_vec_any_eq (vec_uint4, vec_bint4);
  int __builtin_vec_any_eq (vec_uint4, vec_uint4);
  int __builtin_vec_any_eq (vec_bint4, vec_bint4);
  int __builtin_vec_any_eq (vec_bint4, vec_uint4);
  int __builtin_vec_any_eq (vec_bint4, vec_int4);
  int __builtin_vec_any_eq (vec_float4, vec_float4);
     
  int __builtin_vec_any_ge (vec_char16, vec_bchar16);
  int __builtin_vec_any_ge (vec_uchar16, vec_bchar16);
  int __builtin_vec_any_ge (vec_uchar16, vec_uchar16);
  int __builtin_vec_any_ge (vec_char16, vec_char16);
  int __builtin_vec_any_ge (vec_bchar16, vec_uchar16);
  int __builtin_vec_any_ge (vec_bchar16, vec_char16);
  int __builtin_vec_any_ge (vec_ushort8, vec_bshort8);
  int __builtin_vec_any_ge (vec_ushort8, vec_ushort8);
  int __builtin_vec_any_ge (vec_short8, vec_short8);
  int __builtin_vec_any_ge (vec_short8, vec_bshort8);
  int __builtin_vec_any_ge (vec_bshort8, vec_ushort8);
  int __builtin_vec_any_ge (vec_bshort8, vec_short8);
  int __builtin_vec_any_ge (vec_int4, vec_bint4);
  int __builtin_vec_any_ge (vec_uint4, vec_bint4);
  int __builtin_vec_any_ge (vec_uint4, vec_uint4);
  int __builtin_vec_any_ge (vec_int4, vec_int4);
  int __builtin_vec_any_ge (vec_bint4, vec_uint4);
  int __builtin_vec_any_ge (vec_bint4, vec_int4);
  int __builtin_vec_any_ge (vec_float4, vec_float4);
     
  int __builtin_vec_any_gt (vec_bchar16, vec_uchar16);
  int __builtin_vec_any_gt (vec_uchar16, vec_bchar16);
  int __builtin_vec_any_gt (vec_uchar16, vec_uchar16);
  int __builtin_vec_any_gt (vec_bchar16, vec_char16);
  int __builtin_vec_any_gt (vec_char16, vec_bchar16);
  int __builtin_vec_any_gt (vec_char16, vec_char16);
  int __builtin_vec_any_gt (vec_bshort8, vec_ushort8);
  int __builtin_vec_any_gt (vec_ushort8, vec_bshort8);
  int __builtin_vec_any_gt (vec_ushort8, vec_ushort8);
  int __builtin_vec_any_gt (vec_bshort8, vec_short8);
  int __builtin_vec_any_gt (vec_short8, vec_bshort8);
  int __builtin_vec_any_gt (vec_short8, vec_short8);
  int __builtin_vec_any_gt (vec_bint4, vec_uint4);
  int __builtin_vec_any_gt (vec_uint4, vec_bint4);
  int __builtin_vec_any_gt (vec_uint4, vec_uint4);
  int __builtin_vec_any_gt (vec_bint4, vec_int4);
  int __builtin_vec_any_gt (vec_int4, vec_bint4);
  int __builtin_vec_any_gt (vec_int4, vec_int4);
  int __builtin_vec_any_gt (vec_float4, vec_float4);
     
  int __builtin_vec_any_le (vec_bchar16, vec_uchar16);
  int __builtin_vec_any_le (vec_uchar16, vec_bchar16);
  int __builtin_vec_any_le (vec_uchar16, vec_uchar16);
  int __builtin_vec_any_le (vec_bchar16, vec_char16);
  int __builtin_vec_any_le (vec_char16, vec_bchar16);
  int __builtin_vec_any_le (vec_char16, vec_char16);
  int __builtin_vec_any_le (vec_bshort8, vec_ushort8);
  int __builtin_vec_any_le (vec_ushort8, vec_bshort8);
  int __builtin_vec_any_le (vec_ushort8, vec_ushort8);
  int __builtin_vec_any_le (vec_bshort8, vec_short8);
  int __builtin_vec_any_le (vec_short8, vec_bshort8);
  int __builtin_vec_any_le (vec_short8, vec_short8);
  int __builtin_vec_any_le (vec_bint4, vec_uint4);
  int __builtin_vec_any_le (vec_uint4, vec_bint4);
  int __builtin_vec_any_le (vec_uint4, vec_uint4);
  int __builtin_vec_any_le (vec_bint4, vec_int4);
  int __builtin_vec_any_le (vec_int4, vec_bint4);
  int __builtin_vec_any_le (vec_int4, vec_int4);
  int __builtin_vec_any_le (vec_float4, vec_float4);
     
  int __builtin_vec_any_lt (vec_bchar16, vec_uchar16);
  int __builtin_vec_any_lt (vec_uchar16, vec_bchar16);
  int __builtin_vec_any_lt (vec_uchar16, vec_uchar16);
  int __builtin_vec_any_lt (vec_bchar16, vec_char16);
  int __builtin_vec_any_lt (vec_char16, vec_bchar16);
  int __builtin_vec_any_lt (vec_char16, vec_char16);
  int __builtin_vec_any_lt (vec_bshort8, vec_ushort8);
  int __builtin_vec_any_lt (vec_ushort8, vec_bshort8);
  int __builtin_vec_any_lt (vec_ushort8, vec_ushort8);
  int __builtin_vec_any_lt (vec_bshort8, vec_short8);
  int __builtin_vec_any_lt (vec_short8, vec_bshort8);
  int __builtin_vec_any_lt (vec_short8, vec_short8);
  int __builtin_vec_any_lt (vec_bint4, vec_uint4);
  int __builtin_vec_any_lt (vec_uint4, vec_bint4);
  int __builtin_vec_any_lt (vec_uint4, vec_uint4);
  int __builtin_vec_any_lt (vec_bint4, vec_int4);
  int __builtin_vec_any_lt (vec_int4, vec_bint4);
  int __builtin_vec_any_lt (vec_int4, vec_int4);
  int __builtin_vec_any_lt (vec_float4, vec_float4);
     
  int __builtin_vec_any_nan (vec_float4);
     
  int __builtin_vec_any_ne (vec_char16, vec_bchar16);
  int __builtin_vec_any_ne (vec_char16, vec_char16);
  int __builtin_vec_any_ne (vec_uchar16, vec_bchar16);
  int __builtin_vec_any_ne (vec_uchar16, vec_uchar16);
  int __builtin_vec_any_ne (vec_bchar16, vec_bchar16);
  int __builtin_vec_any_ne (vec_bchar16, vec_uchar16);
  int __builtin_vec_any_ne (vec_bchar16, vec_char16);
  int __builtin_vec_any_ne (vec_short8, vec_bshort8);
  int __builtin_vec_any_ne (vec_short8, vec_short8);
  int __builtin_vec_any_ne (vec_ushort8, vec_bshort8);
  int __builtin_vec_any_ne (vec_ushort8, vec_ushort8);
  int __builtin_vec_any_ne (vec_bshort8, vec_bshort8);
  int __builtin_vec_any_ne (vec_bshort8, vec_ushort8);
  int __builtin_vec_any_ne (vec_bshort8, vec_short8);
  int __builtin_vec_any_ne (vec_pixel8, vec_pixel8);
  int __builtin_vec_any_ne (vec_int4, vec_bint4);
  int __builtin_vec_any_ne (vec_int4, vec_int4);
  int __builtin_vec_any_ne (vec_uint4, vec_bint4);
  int __builtin_vec_any_ne (vec_uint4, vec_uint4);
  int __builtin_vec_any_ne (vec_bint4, vec_bint4);
  int __builtin_vec_any_ne (vec_bint4, vec_uint4);
  int __builtin_vec_any_ne (vec_bint4, vec_int4);
  int __builtin_vec_any_ne (vec_float4, vec_float4);
     
  int __builtin_vec_any_nge (vec_float4, vec_float4);
     
  int __builtin_vec_any_ngt (vec_float4, vec_float4);
     
  int __builtin_vec_any_nle (vec_float4, vec_float4);
     
  int __builtin_vec_any_nlt (vec_float4, vec_float4);
     
  int __builtin_vec_any_numeric (vec_float4);
     
  int __builtin_vec_any_out (vec_float4, vec_float4);
#endif 

#if defined __cplusplus__
}; 
#endif 

#if !defined(__VEC__) || !defined(__ALTIVEC__)
#error Use the "-maltivec" flag to enable PowerPC AltiVec support
#endif

#ifdef _ARCH_PPC64
#define OFFSET_T long
#else
#define OFFSET_T int
#endif

/* Condition register codes for AltiVec predicates. */
#define __CR6_EQ		0
#define __CR6_EQ_REV		1
#define __CR6_LT		2
#define __CR6_LT_REV		3

/* Synonyms.  */
#define vec_vaddcuw vec_addc
#define vec_vand vec_and
#define vec_vandc vec_andc
#define vec_vrfip vec_ceil
#define vec_vcmpbfp vec_cmpb
#define vec_vcmpgefp vec_cmpge
#define vec_vctsxs vec_cts
#define vec_vctuxs vec_ctu
#define vec_vexptefp vec_expte
#define vec_vrfim vec_floor
#define vec_lvx vec_ld
#define vec_lvxl vec_ldl
#define vec_vlogefp vec_loge
#define vec_vmaddfp vec_madd
#define vec_vmhaddshs vec_madds
#define vec_vmladduhm vec_mladd
#define vec_vmhraddshs vec_mradds
#define vec_vnmsubfp vec_nmsub
#define vec_vnor vec_nor
#define vec_vor vec_or
#define vec_vpkpx vec_packpx
#define vec_vperm vec_perm
#define vec_vrefp vec_re
#define vec_vrfin vec_round
#define vec_vrsqrtefp vec_rsqrte
#define vec_vsel vec_sel
#define vec_vsldoi vec_sld
#define vec_vsl vec_sll
#define vec_vslo vec_slo
#define vec_vspltisb vec_splat_s8
#define vec_vspltish vec_splat_s16
#define vec_vspltisw vec_splat_s32
#define vec_vsr vec_srl
#define vec_vsro vec_sro
#define vec_stvx vec_st
#define vec_stvxl vec_stl
#define vec_vsubcuw vec_subc
#define vec_vsum2sws vec_sum2s
#define vec_vsumsws vec_sums
#define vec_vrfiz vec_trunc
#define vec_vxor vec_xor

/* Functions that are resolved by the backend to one of the
   typed builtins.  */
#define vec_vaddfp __builtin_vec_vaddfp
#define vec_addc __builtin_vec_addc
#define vec_vaddsws __builtin_vec_vaddsws
#define vec_vaddshs __builtin_vec_vaddshs
#define vec_vaddsbs __builtin_vec_vaddsbs
#define vec_vavgsw __builtin_vec_vavgsw
#define vec_vavguw __builtin_vec_vavguw
#define vec_vavgsh __builtin_vec_vavgsh
#define vec_vavguh __builtin_vec_vavguh
#define vec_vavgsb __builtin_vec_vavgsb
#define vec_vavgub __builtin_vec_vavgub
#define vec_ceil __builtin_vec_ceil
#define vec_cmpb __builtin_vec_cmpb
#define vec_vcmpeqfp __builtin_vec_vcmpeqfp
#define vec_cmpge __builtin_vec_cmpge
#define vec_vcmpgtfp __builtin_vec_vcmpgtfp
#define vec_vcmpgtsw __builtin_vec_vcmpgtsw
#define vec_vcmpgtuw __builtin_vec_vcmpgtuw
#define vec_vcmpgtsh __builtin_vec_vcmpgtsh
#define vec_vcmpgtuh __builtin_vec_vcmpgtuh
#define vec_vcmpgtsb __builtin_vec_vcmpgtsb
#define vec_vcmpgtub __builtin_vec_vcmpgtub
#define vec_vcfsx __builtin_vec_vcfsx
#define vec_vcfux __builtin_vec_vcfux
#define vec_cts __builtin_vec_cts
#define vec_ctu __builtin_vec_ctu
#define vec_expte __builtin_vec_expte
#define vec_floor __builtin_vec_floor
#define vec_loge __builtin_vec_loge
#define vec_madd __builtin_vec_madd
#define vec_madds __builtin_vec_madds
#define vec_mtvscr __builtin_vec_mtvscr
#define vec_vmaxfp __builtin_vec_vmaxfp
#define vec_vmaxsw __builtin_vec_vmaxsw
#define vec_vmaxsh __builtin_vec_vmaxsh
#define vec_vmaxsb __builtin_vec_vmaxsb
#define vec_vminfp __builtin_vec_vminfp
#define vec_vminsw __builtin_vec_vminsw
#define vec_vminsh __builtin_vec_vminsh
#define vec_vminsb __builtin_vec_vminsb
#define vec_mradds __builtin_vec_mradds
#define vec_vmsumshm __builtin_vec_vmsumshm
#define vec_vmsumuhm __builtin_vec_vmsumuhm
#define vec_vmsummbm __builtin_vec_vmsummbm
#define vec_vmsumubm __builtin_vec_vmsumubm
#define vec_vmsumshs __builtin_vec_vmsumshs
#define vec_vmsumuhs __builtin_vec_vmsumuhs
#define vec_vmulesb __builtin_vec_vmulesb
#define vec_vmulesh __builtin_vec_vmulesh
#define vec_vmuleuh __builtin_vec_vmuleuh
#define vec_vmuleub __builtin_vec_vmuleub
#define vec_vmulosh __builtin_vec_vmulosh
#define vec_vmulouh __builtin_vec_vmulouh
#define vec_vmulosb __builtin_vec_vmulosb
#define vec_vmuloub __builtin_vec_vmuloub
#define vec_nmsub __builtin_vec_nmsub
#define vec_packpx __builtin_vec_packpx
#define vec_vpkswss __builtin_vec_vpkswss
#define vec_vpkuwus __builtin_vec_vpkuwus
#define vec_vpkshss __builtin_vec_vpkshss
#define vec_vpkuhus __builtin_vec_vpkuhus
#define vec_vpkswus __builtin_vec_vpkswus
#define vec_vpkshus __builtin_vec_vpkshus
#define vec_re __builtin_vec_re
#define vec_round __builtin_vec_round
#define vec_rsqrte __builtin_vec_rsqrte
#define vec_vsubfp __builtin_vec_vsubfp
#define vec_subc __builtin_vec_subc
#define vec_vsubsws __builtin_vec_vsubsws
#define vec_vsubshs __builtin_vec_vsubshs
#define vec_vsubsbs __builtin_vec_vsubsbs
#define vec_sum4s __builtin_vec_sum4s
#define vec_vsum4shs __builtin_vec_vsum4shs
#define vec_vsum4sbs __builtin_vec_vsum4sbs
#define vec_vsum4ubs __builtin_vec_vsum4ubs
#define vec_sum2s __builtin_vec_sum2s
#define vec_sums __builtin_vec_sums
#define vec_trunc __builtin_vec_trunc
#define vec_vupkhpx __builtin_vec_vupkhpx
#define vec_vupkhsh __builtin_vec_vupkhsh
#define vec_vupkhsb __builtin_vec_vupkhsb
#define vec_vupklpx __builtin_vec_vupklpx
#define vec_vupklsh __builtin_vec_vupklsh
#define vec_vupklsb __builtin_vec_vupklsb
#define vec_abs __builtin_vec_abs
#define vec_abss __builtin_vec_abss
#define vec_add __builtin_vec_add
#define vec_adds __builtin_vec_adds
#define vec_and __builtin_vec_and
#define vec_andc __builtin_vec_andc
#define vec_avg __builtin_vec_avg
#define vec_cmpeq __builtin_vec_cmpeq
#define vec_cmpgt __builtin_vec_cmpgt
#define vec_ctf __builtin_vec_ctf
#define vec_dst __builtin_vec_dst
#define vec_dstst __builtin_vec_dstst
#define vec_dststt __builtin_vec_dststt
#define vec_dstt __builtin_vec_dstt
#define vec_ld __builtin_vec_ld
#define vec_lde __builtin_vec_lde
#define vec_ldl __builtin_vec_ldl
#define vec_lvebx __builtin_vec_lvebx
#define vec_lvehx __builtin_vec_lvehx
#define vec_lvewx __builtin_vec_lvewx
/* CELL LOCAL Begin */
#define vec_lvlx __builtin_vec_lvlx
#define vec_lvlxl __builtin_vec_lvlxl
#define vec_lvrx __builtin_vec_lvrx
#define vec_lvrxl __builtin_vec_lvrxl
/* CELL LOCAL End */
#define vec_lvsl __builtin_vec_lvsl
#define vec_lvsr __builtin_vec_lvsr
#define vec_max __builtin_vec_max
#define vec_mergeh __builtin_vec_mergeh
#define vec_mergel __builtin_vec_mergel
#define vec_min __builtin_vec_min
#define vec_mladd __builtin_vec_mladd
#define vec_msum __builtin_vec_msum
#define vec_msums __builtin_vec_msums
#define vec_mule __builtin_vec_mule
#define vec_mulo __builtin_vec_mulo
#define vec_nor __builtin_vec_nor
#define vec_or __builtin_vec_or
#define vec_pack __builtin_vec_pack
#define vec_packs __builtin_vec_packs
#define vec_packsu __builtin_vec_packsu
#define vec_perm __builtin_vec_perm
#define vec_rl __builtin_vec_rl
#define vec_sel __builtin_vec_sel
#define vec_sl __builtin_vec_sl
#define vec_sld __builtin_vec_sld
#define vec_sll __builtin_vec_sll
#define vec_slo __builtin_vec_slo
#define vec_splat __builtin_vec_splat
#define vec_sr __builtin_vec_sr
#define vec_sra __builtin_vec_sra
#define vec_srl __builtin_vec_srl
#define vec_sro __builtin_vec_sro
#define vec_st __builtin_vec_st
#define vec_ste __builtin_vec_ste
#define vec_stl __builtin_vec_stl
#define vec_stvebx __builtin_vec_stvebx
#define vec_stvehx __builtin_vec_stvehx
#define vec_stvewx __builtin_vec_stvewx
/* CELL LOCAL Begin */
#define vec_stvlx __builtin_vec_stvlx
#define vec_stvlxl __builtin_vec_stvlxl
#define vec_stvrx __builtin_vec_stvrx
#define vec_stvrxl __builtin_vec_stvrxl
/* CELL LOCAL End */
#define vec_sub __builtin_vec_sub
#define vec_subs __builtin_vec_subs
#define vec_sum __builtin_vec_sum
#define vec_unpackh __builtin_vec_unpackh
#define vec_unpackl __builtin_vec_unpackl
#define vec_vaddubm __builtin_vec_vaddubm
#define vec_vaddubs __builtin_vec_vaddubs
#define vec_vadduhm __builtin_vec_vadduhm
#define vec_vadduhs __builtin_vec_vadduhs
#define vec_vadduwm __builtin_vec_vadduwm
#define vec_vadduws __builtin_vec_vadduws
#define vec_vcmpequb __builtin_vec_vcmpequb
#define vec_vcmpequh __builtin_vec_vcmpequh
#define vec_vcmpequw __builtin_vec_vcmpequw
#define vec_vmaxub __builtin_vec_vmaxub
#define vec_vmaxuh __builtin_vec_vmaxuh
#define vec_vmaxuw __builtin_vec_vmaxuw
#define vec_vminub __builtin_vec_vminub
#define vec_vminuh __builtin_vec_vminuh
#define vec_vminuw __builtin_vec_vminuw
#define vec_vmrghb __builtin_vec_vmrghb
#define vec_vmrghh __builtin_vec_vmrghh
#define vec_vmrghw __builtin_vec_vmrghw
#define vec_vmrglb __builtin_vec_vmrglb
#define vec_vmrglh __builtin_vec_vmrglh
#define vec_vmrglw __builtin_vec_vmrglw
#define vec_vpkuhum __builtin_vec_vpkuhum
#define vec_vpkuwum __builtin_vec_vpkuwum
#define vec_vrlb __builtin_vec_vrlb
#define vec_vrlh __builtin_vec_vrlh
#define vec_vrlw __builtin_vec_vrlw
#define vec_vslb __builtin_vec_vslb
#define vec_vslh __builtin_vec_vslh
#define vec_vslw __builtin_vec_vslw
#define vec_vspltb __builtin_vec_vspltb
#define vec_vsplth __builtin_vec_vsplth
#define vec_vspltw __builtin_vec_vspltw
#define vec_vsrab __builtin_vec_vsrab
#define vec_vsrah __builtin_vec_vsrah
#define vec_vsraw __builtin_vec_vsraw
#define vec_vsrb __builtin_vec_vsrb
#define vec_vsrh __builtin_vec_vsrh
#define vec_vsrw __builtin_vec_vsrw
#define vec_vsububs __builtin_vec_vsububs
#define vec_vsububm __builtin_vec_vsububm
#define vec_vsubuhm __builtin_vec_vsubuhm
#define vec_vsubuhs __builtin_vec_vsubuhs
#define vec_vsubuwm __builtin_vec_vsubuwm
#define vec_vsubuws __builtin_vec_vsubuws
#define vec_xor __builtin_vec_xor

#define vec_extract __builtin_vec_extract
#define vec_insert __builtin_vec_insert
#define vec_splats __builtin_vec_splats
#define vec_promote __builtin_vec_promote

/* Predicates.
   For C++, we use templates in order to allow non-parenthesized arguments.
   For C, instead, we use macros since non-parenthesized arguments were
   not allowed even in older GCC implementation of AltiVec.

   In the future, we may add more magic to the back-end, so that no
   one- or two-argument macros are used.  */

#ifdef __cplusplus__
#define __altivec_unary_pred(NAME, CALL) \
template <class T> int NAME (T a1) { return CALL; }

#define __altivec_scalar_pred(NAME, CALL) \
template <class T, class U> int NAME (T a1, U a2) { return CALL; }

/* Given the vec_step of a type, return the corresponding bool type.  */
template <int STEP> class __altivec_bool_ret { };
template <> class __altivec_bool_ret <4> {
  typedef __vector __bool int __ret;
};
template <> class __altivec_bool_ret <8> {
  typedef __vector __bool short __ret;
};
template <> class __altivec_bool_ret <16> {
  typedef __vector __bool char __ret;
};

/* Be very liberal in the pairs we accept.  Mistakes such as passing
   a `vector char' and `vector short' will be caught by the middle-end,
   while any attempt to detect them here would produce hard to understand
   error messages involving the implementation details of AltiVec.  */
#define __altivec_binary_pred(NAME, CALL) \
template <class T, class U> \
typename __altivec_bool_ret <vec_step (T)>::__ret \
NAME (T a1, U a2) \
{ \
  return CALL; \
}

__altivec_binary_pred(vec_cmplt,
  __builtin_vec_cmpgt (a2, a1))
__altivec_binary_pred(vec_cmple,
  __builtin_altivec_cmpge (a2, a1))

__altivec_scalar_pred(vec_all_in,
  __builtin_altivec_vcmpbfp_p (__CR6_EQ, a1, a2))
__altivec_scalar_pred(vec_any_out,
  __builtin_altivec_vcmpbfp_p (__CR6_EQ_REV, a1, a2))

__altivec_unary_pred(vec_all_nan,
  __builtin_altivec_vcmpeqfp_p (__CR6_EQ, a1, a1))
__altivec_unary_pred(vec_any_nan,
  __builtin_altivec_vcmpeqfp_p (__CR6_LT_REV, a1, a1))

__altivec_unary_pred(vec_all_numeric,
  __builtin_altivec_vcmpeqfp_p (__CR6_LT, a1, a1))
__altivec_unary_pred(vec_any_numeric,
  __builtin_altivec_vcmpeqfp_p (__CR6_EQ_REV, a1, a1))

__altivec_scalar_pred(vec_all_eq,
  __builtin_vec_vcmpeq_p (__CR6_LT, a1, a2))
__altivec_scalar_pred(vec_all_ne,
  __builtin_vec_vcmpeq_p (__CR6_EQ, a1, a2))
__altivec_scalar_pred(vec_any_eq,
  __builtin_vec_vcmpeq_p (__CR6_EQ_REV, a1, a2))
__altivec_scalar_pred(vec_any_ne,
  __builtin_vec_vcmpeq_p (__CR6_LT_REV, a1, a2))

__altivec_scalar_pred(vec_all_gt,
  __builtin_vec_vcmpgt_p (__CR6_LT, a1, a2))
__altivec_scalar_pred(vec_all_lt,
  __builtin_vec_vcmpgt_p (__CR6_LT, a2, a1))
__altivec_scalar_pred(vec_any_gt,
  __builtin_vec_vcmpgt_p (__CR6_EQ_REV, a1, a2))
__altivec_scalar_pred(vec_any_lt,
  __builtin_vec_vcmpgt_p (__CR6_EQ_REV, a2, a1))

__altivec_scalar_pred(vec_all_ngt,
  __builtin_altivec_vcmpgtfp_p (__CR6_EQ, a1, a2))
__altivec_scalar_pred(vec_all_nlt,
  __builtin_altivec_vcmpgtfp_p (__CR6_EQ, a2, a1))
__altivec_scalar_pred(vec_any_ngt,
  __builtin_altivec_vcmpgtfp_p (__CR6_LT_REV, a1, a2))
__altivec_scalar_pred(vec_any_nlt,
  __builtin_altivec_vcmpgtfp_p (__CR6_LT_REV, a2, a1))

/* __builtin_vec_vcmpge_p is vcmpgefp for floating-point vector types,
   while for integer types it is converted to __builtin_vec_vcmpgt_p,
   with inverted args and condition code.  */
__altivec_scalar_pred(vec_all_le,
  __builtin_vec_vcmpge_p (__CR6_LT, a2, a1))
__altivec_scalar_pred(vec_all_ge,
  __builtin_vec_vcmpge_p (__CR6_LT, a1, a2))
__altivec_scalar_pred(vec_any_le,
  __builtin_vec_vcmpge_p (__CR6_EQ_REV, a2, a1))
__altivec_scalar_pred(vec_any_ge,
  __builtin_vec_vcmpge_p (__CR6_EQ_REV, a1, a2))

__altivec_scalar_pred(vec_all_nge,
  __builtin_altivec_vcmpgefp_p (__CR6_EQ, a1, a2))
__altivec_scalar_pred(vec_all_nle,
  __builtin_altivec_vcmpgefp_p (__CR6_EQ, a2, a1))
__altivec_scalar_pred(vec_any_nge,
  __builtin_altivec_vcmpgefp_p (__CR6_LT_REV, a1, a2))
__altivec_scalar_pred(vec_any_nle,
  __builtin_altivec_vcmpgefp_p (__CR6_LT_REV, a2, a1))

#undef __altivec_scalar_pred
#undef __altivec_unary_pred
#undef __altivec_binary_pred
#else
#define vec_cmplt(a1, a2) __builtin_vec_cmpgt ((a2), (a1))
#define vec_cmple(a1, a2) (vec_bint4) __builtin_altivec_vcmpgefp ((a2), (a1))

#define vec_all_in(a1, a2) __builtin_altivec_vcmpbfp_p (__CR6_EQ, (a1), (a2))
#define vec_any_out(a1, a2) __builtin_altivec_vcmpbfp_p (__CR6_EQ_REV, (a1), (a2))

#define vec_all_nan(a1) __builtin_altivec_vcmpeqfp_p (__CR6_EQ, (a1), (a1))
#define vec_any_nan(a1) __builtin_altivec_vcmpeqfp_p (__CR6_LT_REV, (a1), (a1))

#define vec_all_numeric(a1) __builtin_altivec_vcmpeqfp_p (__CR6_LT, (a1), (a1))
#define vec_any_numeric(a1) __builtin_altivec_vcmpeqfp_p (__CR6_EQ_REV, (a1), (a1))

#define vec_all_eq(a1, a2) __builtin_vec_vcmpeq_p (__CR6_LT, (a1), (a2))
#define vec_all_ne(a1, a2) __builtin_vec_vcmpeq_p (__CR6_EQ, (a1), (a2))
#define vec_any_eq(a1, a2) __builtin_vec_vcmpeq_p (__CR6_EQ_REV, (a1), (a2))
#define vec_any_ne(a1, a2) __builtin_vec_vcmpeq_p (__CR6_LT_REV, (a1), (a2))

#define vec_all_gt(a1, a2) __builtin_vec_vcmpgt_p (__CR6_LT, (a1), (a2))
#define vec_all_lt(a1, a2) __builtin_vec_vcmpgt_p (__CR6_LT, (a2), (a1))
#define vec_any_gt(a1, a2) __builtin_vec_vcmpgt_p (__CR6_EQ_REV, (a1), (a2))
#define vec_any_lt(a1, a2) __builtin_vec_vcmpgt_p (__CR6_EQ_REV, (a2), (a1))

#define vec_all_ngt(a1, a2) __builtin_altivec_vcmpgtfp_p (__CR6_EQ, (a1), (a2))
#define vec_all_nlt(a1, a2) __builtin_altivec_vcmpgtfp_p (__CR6_EQ, (a2), (a1))
#define vec_any_ngt(a1, a2) __builtin_altivec_vcmpgtfp_p (__CR6_LT_REV, (a1), (a2))
#define vec_any_nlt(a1, a2) __builtin_altivec_vcmpgtfp_p (__CR6_LT_REV, (a2), (a1))

/* __builtin_vec_vcmpge_p is vcmpgefp for floating-point vector types,
   while for integer types it is converted to __builtin_vec_vcmpgt_p,
   with inverted args and condition code.  */
#define vec_all_le(a1, a2) __builtin_vec_vcmpge_p (__CR6_LT, (a2), (a1))
#define vec_all_ge(a1, a2) __builtin_vec_vcmpge_p (__CR6_LT, (a1), (a2))
#define vec_any_le(a1, a2) __builtin_vec_vcmpge_p (__CR6_EQ_REV, (a2), (a1))
#define vec_any_ge(a1, a2) __builtin_vec_vcmpge_p (__CR6_EQ_REV, (a1), (a2))

#define vec_all_nge(a1, a2) __builtin_altivec_vcmpgefp_p (__CR6_EQ, (a1), (a2))
#define vec_all_nle(a1, a2) __builtin_altivec_vcmpgefp_p (__CR6_EQ, (a2), (a1))
#define vec_any_nge(a1, a2) __builtin_altivec_vcmpgefp_p (__CR6_LT_REV, (a1), (a2))
#define vec_any_nle(a1, a2) __builtin_altivec_vcmpgefp_p (__CR6_LT_REV, (a2), (a1))
#endif

/* These do not accept vectors, so they do not have a __builtin_vec_*
   counterpart.  */
#define vec_dss(x) __builtin_altivec_dss((x))
#define vec_dssall() __builtin_altivec_dssall ()
#define vec_mfvscr() ((vec_ushort8) __builtin_altivec_mfvscr ())
#define vec_splat_s8(x) __builtin_altivec_vspltisb ((x))
#define vec_splat_s16(x) __builtin_altivec_vspltish ((x))
#define vec_splat_s32(x) __builtin_altivec_vspltisw ((x))
#define vec_splat_u8(x) ((vec_uchar16) vec_splat_s8 ((x)))
#define vec_splat_u16(x) ((vec_ushort8) vec_splat_s16 ((x)))
#define vec_splat_u32(x) ((vec_uint4) vec_splat_s32 ((x)))

/* This also accepts a type for its parameter, so it is not enough
   to #define vec_step to __builtin_vec_step.  */
#define vec_step(x) __builtin_vec_step (* (__typeof__ (x) *) 0)



#endif
