#ifndef CRCYG_PREDEFS
#define CRCYG_PREDEFS

#if !defined(__CRYCG__)
# error "This file should only be used with the crycg frontend compiler!";
#endif

// The frontend compiler is tricked to believe that it is not a
// ppu frontent, but a spu-frontend
#undef __PPU__


////////////////////////////////////////////////////////////////////////////////
// Required standard types 
////////////////////////////////////////////////////////////////////////////////

// Note: This include statement resolves to target/common/include,
// which is (mostly) invariant of target architecture. 
#include <sys/sys_types.h>

#ifndef _INTPTR
# define _INTPTR	0	/* 0 => int, 1 => long, 2 => long long */
#endif /* _INTPTR */

typedef int64_t int_fast64_t;
typedef uint64_t uint_fast64_t;

#if !defined(__cplusplus) || defined(__STDC_LIMIT_MACROS)
#define INT8_MIN	(-0x7f - _C2)
#define INT16_MIN	(-0x7fff - _C2)
#define INT32_MIN	(-0x7fffffff - _C2)

#define INT8_MAX	0x7f
#define INT16_MAX	0x7fff
#define INT32_MAX	0x7fffffff
#define UINT8_MAX	0xff
#define UINT16_MAX	0xffff
#define UINT32_MAX	0xffffffff

#define INT_LEAST8_MIN		(-0x7f - _C2)
#define INT_LEAST16_MIN		(-0x7fff - _C2)
#define INT_LEAST32_MIN		(-0x7fffffff - _C2)

#define INT_LEAST8_MAX		0x7f
#define INT_LEAST16_MAX		0x7fff
#define INT_LEAST32_MAX		0x7fffffff
#define UINT_LEAST8_MAX		0xff
#define UINT_LEAST16_MAX	0xffff
#define UINT_LEAST32_MAX	0xffffffff

#define INT_FAST8_MIN		(-0x7fffffff - _C2)
#define INT_FAST16_MIN		(-0x7fffffff - _C2)
#define INT_FAST32_MIN		(-0x7fffffff - _C2)

#define INT_FAST8_MAX		0x7fffffff
#define INT_FAST16_MAX		0x7fffffff
#define INT_FAST32_MAX		0x7fffffff
#define UINT_FAST8_MAX		0xffffffff
#define UINT_FAST16_MAX		0xffffffff
#define UINT_FAST32_MAX		0xffffffff

#if _INTPTR == 0 && !_ILONG
#define INTPTR_MAX			0x7fff
#define INTPTR_MIN			(-INTPTR_MAX - _C2)
#define UINTPTR_MAX			0xffff

#elif _INTPTR == 0 && _ILONG
#define INTPTR_MAX			0x7fffffff
#define INTPTR_MIN			(-INTPTR_MAX - _C2)
#define UINTPTR_MAX			0xffffffff

#elif _INTPTR == 1
#define INTPTR_MAX			0x7fffffffffffffffL
#define INTPTR_MIN			(-INTPTR_MAX - _C2)
#define UINTPTR_MAX			0xffffffffffffffffUL

#else /* _INTPTR == 2 */
#define INTPTR_MIN			(-_LLONG_MAX - _C2)
#define INTPTR_MAX			_LLONG_MAX
#define UINTPTR_MAX			_ULLONG_MAX
#endif /* _INTPTR */
#endif /* !defined(__cplusplus) || defined(__STDC_LIMIT_MACROS) */

#if !defined(__cplusplus) || defined(__STDC_CONSTANT_MACROS)
#define INT8_C(x)	x
#define INT16_C(x)	x
#if _ILONG
 #define INT32_C(x)	x
#else
 #define INT32_C(x)	x ## L
#endif

#define UINT8_C(x)	x ## U
#define UINT16_C(x)	x ## U
#if _ILONG
 #define UINT32_C(x)	x ## U
#else
 #define UINT32_C(x)	x ## UL
#endif
#endif /* !defined(__cplusplus) || defined(__STDC_CONSTANT_MACROS) */

#if !defined(__cplusplus) || defined(__STDC_LIMIT_MACROS)
#if _ILONG
  #define SIG_ATOMIC_MIN	INT32_MIN
  #define SIG_ATOMIC_MAX	INT32_MAX
 #if _INTPTR == 0
  #define PTRDIFF_MIN		INT32_MIN
  #define PTRDIFF_MAX		INT32_MAX
  #define SIZE_MAX			UINT32_MAX
 #elif _INTPTR == 1
  #define PTRDIFF_MIN		INT64_MIN
  #define PTRDIFF_MAX		INT64_MAX
  #define SIZE_MAX			UINT64_MAX
#endif
#else /* _ILONG */
 #define PTRDIFF_MIN		INT16_MIN
 #define PTRDIFF_MAX		INT16_MAX
 #define SIG_ATOMIC_MIN	INT16_MIN
 #define SIG_ATOMIC_MAX	INT16_MAX
 #define SIZE_MAX			UINT16_MAX
#endif /* _ILONG */

#define WCHAR_MIN	_WCMIN
#define WCHAR_MAX	_WCMAX

#define WINT_MIN	_WIMIN
#define WINT_MAX	_WIMAX

#define INT64_MIN	(-0x7fffffffffffffffLL - _C2)
#define INT64_MAX	0x7fffffffffffffffLL
#define UINT64_MAX	0xffffffffffffffffULL

#define INT_LEAST64_MIN		(-0x7fffffffffffffffLL - _C2)
#define INT_LEAST64_MAX		0x7fffffffffffffffLL
#define UINT_LEAST64_MAX	0xffffffffffffffffULL

#define INT_FAST64_MIN		(-0x7fffffffffffffffLL - _C2)
#define INT_FAST64_MAX		0x7fffffffffffffffLL
#define UINT_FAST64_MAX		0xffffffffffffffffULL

#define INTMAX_MIN		(-0x7fffffffffffffffLL - _C2)
#define INTMAX_MAX		0x7fffffffffffffffLL
#define UINTMAX_MAX		0xffffffffffffffffULL
#endif /* !defined(__cplusplus) || defined(__STDC_LIMIT_MACROS) */

#if !defined(__cplusplus) || defined(__STDC_CONSTANT_MACROS)
 #define INT64_C(x)		x ## LL
 #define UINT64_C(x)		x ## ULL
 #define INTMAX_C(x)		INT64_C(x)
 #define UINTMAX_C(x)		UINT64_C(x)
#endif /* !defined(__cplusplus) || defined(__STDC_CONSTANT_MACROS) */


////////////////////////////////////////////////////////////////////////////////
// Float changes 
////////////////////////////////////////////////////////////////////////////////
#define _FLOAT

#define FLT_RADIX		2

#ifdef _FRND
  #define FLT_ROUNDS		_FRND
#else /* _FRND */
 #define FLT_ROUNDS		-1	/* indeterminable */
#endif /* _FRND */

#if _HAS_C9X
 #ifdef _FEVAL
  #define FLT_EVAL_METHOD	_FEVAL

 #else /* _FEVAL */
  #define FLT_EVAL_METHOD	-1	/* indeterminable */
 #endif /* _FEVAL */

 #if _DLONG == 0
  #define DECIMAL_DIG		17	/* 64-bit long double */

 #elif _DLONG == 1
  #define DECIMAL_DIG		21	/* 80-bit long double */

 #else /* 1 < _DLONG */
  #define DECIMAL_DIG		35	/* 128-bit SPARC long double */
 #endif /* _DLONG */
#endif /* _IS_C9X */

 #define FLT_EPSILON		0x8p-26f
 #define FLT_MAX		0x1.fffffep+128f
 #define FLT_MIN		0x8p-129f

 #define FLT_DIG			6	/* _CSTD _Flt._Ddig */
 #define FLT_MANT_DIG		24	/* _CSTD _Flt._Dmdig */
 #define FLT_MAX_10_EXP		38	/* _CSTD _Flt._Dmax10e */
 #define FLT_MAX_EXP		129	/* _CSTD _Flt._Dmaxe */
 #define FLT_MIN_10_EXP		-37	/* _CSTD _Flt._Dmin10e */
 #define FLT_MIN_EXP		-125	/* _CSTD _Flt._Dmine */

 #define DBL_EPSILON		0x8p-55
 #define DBL_MAX		0xf.ffffffffffff8p+1020
 #define DBL_MIN		0x8p-1025

 #define DBL_DIG			15 	/* _CSTD _Dbl._Ddig */
 #define DBL_MANT_DIG		53	/* _CSTD _Dbl._Dmdig */
 #define DBL_MAX_10_EXP		308	/* _CSTD _Dbl._Dmax10e */
 #define DBL_MAX_EXP		1024	/* _CSTD _Dbl._Dmaxe */
 #define DBL_MIN_10_EXP		-307	/* _CSTD _Dbl._Dmin10e */
 #define DBL_MIN_EXP		-1021	/* _CSTD _Dbl._Dmine */

 #define LDBL_EPSILON	0x8p-55L
 #define LDBL_MAX		0xf.ffffffffffff8p+1020L
 #define LDBL_MIN		0x8p-1025L

 #define LDBL_DIG		15	/* _CSTD _Ldbl._Ddig */
 #define LDBL_MANT_DIG		53	/* _CSTD _Ldbl._Dmdig */
 #define LDBL_MAX_10_EXP	308	/* _CSTD _Ldbl._Dmax10e */
 #define LDBL_MAX_EXP		1024	/* _CSTD _Ldbl._Dmaxe */
 #define LDBL_MIN_10_EXP	-307	/* _CSTD _Ldbl._Dmin10e */
 #define LDBL_MIN_EXP		-1021	/* _CSTD _Ldbl._Dmine */

////////////////////////////////////////////////////////////////////////////////
// Required typedefs from ppu/include/time.h 
////////////////////////////////////////////////////////////////////////////////
typedef int64_t clock_t;
typedef int64_t time_t;

////////////////////////////////////////////////////////////////////////////////
// Required typedefs/macros and other magic for spu intrinics
////////////////////////////////////////////////////////////////////////////////

// Prevent the frontend compiler from actually including anything from
// the system header file (which will generate a ton of error
// messages) by tricking the include guard that the file has already
// been parsed by the preprocessor
#define _SPU_INTERNALS_H
#define __SPU_INTRINSICS_H__
#define _SPU_INTRINSICS_GCC_H
#define __VEC_TYPES_H__

/*  The spu specific instruction macros, si_*(), correspond 1-1 with
 *  SPU instructions in the ISA.  The arguments are the same with the
 *  following exceptions:
 *   -  any instruction which both reads and writes rt will have an
 *      extra parameter in the macro.
 *   -  instructions which append zero to the immediate field assume
 *      the value given in a macro already has the zeroes appended.
 *   -  integer/float convert functions expect a value from 0 to 127,
 *      i.e., the bias is added by the compiler.
 *
 *  Parameters named 'imm' accept an integer literal.
 *  Parameters named 'r[abcdt]' accept a qword argument.
 *  Parameters named 'scalar' accept a scalar argument.
 */

#ifndef offsetof
#  define offsetof(t, memb) ((size_t)__INTADDR__(&(((t *)0)->memb)))
#endif 

#undef vector
#define vector __attribute__ ((vector_size (16)))


#undef __vector
#define __vector __attribute__ ((vector_size (16), aligned (16)))

#undef vec_uchar16
typedef unsigned char vec_uchar16 __vector;
#undef vec_char16
typedef signed char vec_char16 __vector;
#undef vec_ushort8
typedef unsigned short vec_ushort8 __vector;
#undef vec_short8
typedef short vec_short8 __vector;
#undef vec_uint4
typedef unsigned int vec_uint4 __vector;
#undef vec_int4
typedef int vec_int4 __vector;
#undef vec_ullong2
typedef unsigned long long vec_ullong2 __vector;
#undef vec_llong2
typedef long long vec_llong2 __vector;
#undef vec_float4
typedef float vec_float4 __vector;
#undef vec_double2
typedef double vec_double2 __vector;
#undef vec_bchar16
typedef unsigned char vec_bchar16 __vector;
#undef vec_bshort8
typedef unsigned short vec_bshort8 __vector;
#undef vec_bint4
typedef unsigned int vec_bint4 __vector;
#undef vec_pixel8
typedef unsigned short vec_pixel8 __vector;


/* SPU Channel Defines 
 */
#define SPU_RdEventStat		 0
#define SPU_WrEventMask		 1
#define SPU_WrEventAck		 2
#define SPU_RdSigNotify1	 3
#define SPU_RdSigNotify2	 4
#define SPU_WrDec		 7
#define SPU_RdDec		 8
#define SPU_RdEventStatMask	11
#define SPU_RdEventMask		11
#define SPU_RdMachStat		13
#define SPU_WrSRR0		14
#define SPU_RdSRR0		15
#define SPU_WrOutMbox		28 
#define SPU_RdInMbox		29 
#define SPU_WrOutIntrMbox	30 

/* MFC Channel Defines. 
 */
#define MFC_WrMSSyncReq		 9
#define MFC_RdTagMask		12
#define MFC_LSA			16 
#define MFC_EAH			17 
#define MFC_EAL			18 
#define MFC_Size		19 
#define MFC_TagID		20 
#define MFC_Cmd			21 
#define MFC_WrTagMask		22 
#define MFC_WrTagUpdate		23 
#define MFC_RdTagStat		24 
#define MFC_RdListStallStat	25 
#define MFC_WrListStallAck	26 
#define MFC_RdAtomicStat	27 

typedef signed char __attribute__ ((vector_size (16), aligned (16))) qword;

#undef ctor_inline
#define ctor_inline __inline__

#if defined __CRYCG__

#undef inline
#define inline __attribute__ ((crycg_attr ("inline"))) __inline__

#if defined __cplusplus
extern "C" {
#endif
  vec_float4 __builtin_spu_roundtf(vec_double2);

  vec_float4 __builtin_spu_convtf(vec_int4, int);
  vec_float4 __builtin_spu_convtf_0(vec_uint4, int);
  vec_float4 __builtin_spu_convtf_1(vec_int4, int);

  vec_int4 __builtin_spu_convts(vec_float4, int);
  vec_uint4 __builtin_spu_convtu(vec_float4, int);

  vec_uint4 __builtin_spu_cmpabsgt(vec_float4, vec_float4);
  vec_uint4 __builtin_spu_cmpabseq(vec_float4, vec_float4);

	vec_uchar16 __builtin_spu_avg(vec_uchar16, vec_uchar16);

  vec_short8 __builtin_spu_extend_0(vec_char16);
  vec_int4 __builtin_spu_extend_1(vec_short8);
  vec_llong2 __builtin_spu_extend_2(vec_int4);
  vec_double2 __builtin_spu_extend_3(vec_float4);

  vec_uint4 __builtin_spu_add_0(vec_uint4, vec_uint4);
  vec_int4 __builtin_spu_add_1(vec_int4, vec_int4);
  vec_ushort8 __builtin_spu_add_2(vec_ushort8, vec_ushort8);
  vec_short8 __builtin_spu_add_3(vec_short8, vec_short8);
  vec_float4 __builtin_spu_add_4(vec_float4, vec_float4);
  vec_double2 __builtin_spu_add_5(vec_double2, vec_double2);
  vec_ushort8 __builtin_spu_add_6(vec_ushort8, unsigned short int);
  vec_short8 __builtin_spu_add_7(vec_short8, short int);
  vec_uint4 __builtin_spu_add_8(vec_uint4, unsigned int);
  vec_int4 __builtin_spu_add_9(vec_int4, int);

  vec_int4 __builtin_spu_addx_0(vec_int4, vec_int4, vec_int4);
  vec_uint4 __builtin_spu_addx_1(vec_uint4, vec_uint4, vec_uint4);

  vec_int4 __builtin_spu_genc_0(vec_int4, vec_int4);
  vec_uint4 __builtin_spu_genc_1(vec_uint4, vec_uint4);

  vec_int4 __builtin_spu_gencx_0(vec_int4, vec_int4, vec_int4);
  vec_uint4 __builtin_spu_gencx_1(vec_uint4, vec_uint4, vec_uint4);

  vec_int4 __builtin_spu_madd_0(vec_short8, vec_short8, vec_int4);
  vec_float4 __builtin_spu_madd_1(vec_float4, vec_float4, vec_float4);
  vec_double2 __builtin_spu_madd_2(vec_double2, vec_double2, vec_double2);

  vec_float4 __builtin_spu_msub_0(vec_float4, vec_float4, vec_float4);
  vec_double2 __builtin_spu_msub_1(vec_double2, vec_double2, vec_double2);

  vec_uint4 __builtin_spu_mhhadd_0(vec_ushort8, vec_ushort8, vec_uint4);
  vec_int4 __builtin_spu_mhhadd_1(vec_short8, vec_short8, vec_int4);

  vec_uint4 __builtin_spu_mule_0(vec_ushort8, vec_ushort8);
  vec_int4 __builtin_spu_mule_1(vec_short8, vec_short8);

  vec_float4 __builtin_spu_mul_0(vec_float4, vec_float4);
  vec_double2 __builtin_spu_mul_1(vec_double2, vec_double2);

  vec_int4 __builtin_spu_mulo_0(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_mulo_1(vec_ushort8, vec_ushort8);
  vec_int4 __builtin_spu_mulo_2(vec_short8, short int);
  vec_uint4 __builtin_spu_mulo_3(vec_ushort8, unsigned short int);

  vec_float4 __builtin_spu_nmsub_0(vec_float4, vec_float4, vec_float4);
  vec_double2 __builtin_spu_nmsub_1(vec_double2, vec_double2, vec_double2);

  vec_ushort8 __builtin_spu_sub_0(vec_ushort8, vec_ushort8);
  vec_short8 __builtin_spu_sub_1(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_sub_2(vec_uint4, vec_uint4);
  vec_int4 __builtin_spu_sub_3(vec_int4, vec_int4);
  vec_float4 __builtin_spu_sub_4(vec_float4, vec_float4);
  vec_double2 __builtin_spu_sub_5(vec_double2, vec_double2);
  vec_ushort8 __builtin_spu_sub_6(short unsigned int, vec_ushort8);
  vec_short8 __builtin_spu_sub_7(short int, vec_short8);
  vec_uint4 __builtin_spu_sub_8(unsigned int, vec_uint4);
  vec_int4 __builtin_spu_sub_9(int, vec_int4);

  vec_uint4 __builtin_spu_subx_0(vec_uint4, vec_uint4, vec_uint4);
  vec_int4 __builtin_spu_subx_1(vec_int4, vec_int4, vec_int4);

  vec_uint4 __builtin_spu_genb_0(vec_uint4, vec_uint4);
  vec_int4 __builtin_spu_genb_1(vec_int4, vec_int4);

  vec_uint4 __builtin_spu_genbx_0(vec_uint4, vec_uint4, vec_uint4);
  vec_int4 __builtin_spu_genbx_1(vec_int4, vec_int4, vec_int4);

  vec_uchar16 __builtin_spu_cmpeq_0(vec_uchar16, vec_uchar16);
  vec_uchar16 __builtin_spu_cmpeq_1(vec_char16, vec_char16);
  vec_ushort8 __builtin_spu_cmpeq_2(vec_ushort8, vec_ushort8);
  vec_ushort8 __builtin_spu_cmpeq_3(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_cmpeq_4(vec_uint4, vec_uint4);
  vec_uint4 __builtin_spu_cmpeq_5(vec_int4, vec_int4);
  vec_uint4 __builtin_spu_cmpeq_6(vec_float4, vec_float4);
  vec_uchar16 __builtin_spu_cmpeq_7(vec_uchar16, unsigned char);
  vec_uchar16 __builtin_spu_cmpeq_8(vec_char16, signed char);
  vec_ushort8 __builtin_spu_cmpeq_9(vec_ushort8, short unsigned int);
  vec_ushort8 __builtin_spu_cmpeq_10(vec_short8, short int);
  vec_uint4 __builtin_spu_cmpeq_11(vec_uint4, unsigned int);
  vec_uint4 __builtin_spu_cmpeq_12(vec_int4, int);

  vec_uchar16 __builtin_spu_cmpgt_0(vec_uchar16, vec_uchar16);
  vec_uchar16 __builtin_spu_cmpgt_1(vec_char16, vec_char16);
  vec_ushort8 __builtin_spu_cmpgt_2(vec_ushort8, vec_ushort8);
  vec_ushort8 __builtin_spu_cmpgt_3(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_cmpgt_4(vec_uint4, vec_uint4);
  vec_uint4 __builtin_spu_cmpgt_5(vec_int4, vec_int4);
  vec_uint4 __builtin_spu_cmpgt_6(vec_float4, vec_float4);
  vec_uchar16 __builtin_spu_cmpgt_7(vec_uchar16, unsigned char);
  vec_uchar16 __builtin_spu_cmpgt_8(vec_char16, signed char);
  vec_ushort8 __builtin_spu_cmpgt_9(vec_ushort8, short unsigned int);
  vec_ushort8 __builtin_spu_cmpgt_10(vec_short8, short int);
  vec_uint4 __builtin_spu_cmpgt_11(vec_int4, int);
  vec_uint4 __builtin_spu_cmpgt_12(vec_uint4, unsigned int);

  void __builtin_spu_hcmpeq_0(int, int);
  void __builtin_spu_hcmpeq_1(unsigned int, unsigned int);

  void __builtin_spu_hcmpgt_0(int, int);
  void __builtin_spu_hcmpgt_1(unsigned int, unsigned int);

  vec_uchar16 __builtin_spu_cntb_0(vec_char16);
  vec_uchar16 __builtin_spu_cntb_1(vec_uchar16);

  vec_uint4 __builtin_spu_cntlz_0(vec_int4);
  vec_uint4 __builtin_spu_cntlz_1(vec_uint4);
  vec_uint4 __builtin_spu_cntlz_2(vec_float4);

  vec_uint4 __builtin_spu_gather_0(vec_int4);
  vec_uint4 __builtin_spu_gather_1(vec_uint4);
  vec_uint4 __builtin_spu_gather_2(vec_short8);
  vec_uint4 __builtin_spu_gather_3(vec_ushort8);
  vec_uint4 __builtin_spu_gather_4(vec_char16);
  vec_uint4 __builtin_spu_gather_5(vec_uchar16);
  vec_uint4 __builtin_spu_gather_6(vec_float4);

  vec_uchar16 __builtin_spu_maskb_0(short unsigned int);
  vec_uchar16 __builtin_spu_maskb_1(short int);
  vec_uchar16 __builtin_spu_maskb_2(unsigned int);
  vec_uchar16 __builtin_spu_maskb_3(int);
  vec_ushort8 __builtin_spu_maskh_0(unsigned char);
  vec_ushort8 __builtin_spu_maskh_1(signed char);
  vec_ushort8 __builtin_spu_maskh_2(short unsigned int);
  vec_ushort8 __builtin_spu_maskh_3(short int);
  vec_ushort8 __builtin_spu_maskh_4(unsigned int);
  vec_ushort8 __builtin_spu_maskh_5(int);

  vec_uint4 __builtin_spu_maskw_0(unsigned char);
  vec_uint4 __builtin_spu_maskw_1(signed char);
  vec_uint4 __builtin_spu_maskw_2(short unsigned int);
  vec_uint4 __builtin_spu_maskw_3(short int);
  vec_uint4 __builtin_spu_maskw_4(unsigned int);
  vec_uint4 __builtin_spu_maskw_5(int);

  vec_llong2 __builtin_spu_sel_0(vec_llong2, vec_llong2, vec_ullong2);
  vec_ullong2 __builtin_spu_sel_1(vec_ullong2, vec_ullong2, vec_ullong2);
  vec_int4 __builtin_spu_sel_2(vec_int4, vec_int4, vec_uint4);
  vec_uint4 __builtin_spu_sel_3(vec_uint4, vec_uint4, vec_uint4);
  vec_short8 __builtin_spu_sel_4(vec_short8, vec_short8, vec_ushort8);
  vec_ushort8 __builtin_spu_sel_5(vec_ushort8, vec_ushort8, vec_ushort8);
  vec_char16 __builtin_spu_sel_6(vec_char16, vec_char16, vec_uchar16);
  vec_uchar16 __builtin_spu_sel_7(vec_uchar16, vec_uchar16, vec_uchar16);
  vec_float4 __builtin_spu_sel_8(vec_float4, vec_float4, vec_uint4);
  vec_double2 __builtin_spu_sel_9(vec_double2, vec_double2, vec_ullong2);

  vec_llong2 __builtin_spu_sel_0o(vec_llong2, vec_llong2, vec_uchar16);
  vec_ullong2 __builtin_spu_sel_1o(vec_ullong2, vec_ullong2, vec_uchar16);
  vec_int4 __builtin_spu_sel_2o(vec_int4, vec_int4, vec_uchar16);
  vec_uint4 __builtin_spu_sel_3o(vec_uint4, vec_uint4, vec_uchar16);
  vec_short8 __builtin_spu_sel_4o(vec_short8, vec_short8, vec_uchar16);
  vec_ushort8 __builtin_spu_sel_5o(vec_ushort8, vec_ushort8, vec_uchar16);
  vec_float4 __builtin_spu_sel_8o(vec_float4, vec_float4, vec_uchar16);
  vec_double2 __builtin_spu_sel_9o(vec_double2, vec_double2, vec_uchar16);

  vec_uchar16 __builtin_spu_shuffle_0(vec_uchar16, vec_uchar16, vec_uchar16);
  vec_char16 __builtin_spu_shuffle_1(vec_char16, vec_char16, vec_uchar16);
  vec_ushort8 __builtin_spu_shuffle_2(vec_ushort8, vec_ushort8, vec_uchar16);
  vec_short8 __builtin_spu_shuffle_3(vec_short8, vec_short8, vec_uchar16);
  vec_uint4 __builtin_spu_shuffle_4(vec_uint4, vec_uint4, vec_uchar16);
  vec_int4 __builtin_spu_shuffle_5(vec_int4, vec_int4, vec_uchar16);
  vec_ullong2 __builtin_spu_shuffle_6(vec_ullong2, vec_ullong2, vec_uchar16);
  vec_llong2 __builtin_spu_shuffle_7(vec_llong2, vec_llong2, vec_uchar16);
  vec_float4 __builtin_spu_shuffle_8(vec_float4, vec_float4, vec_uchar16);
  vec_double2 __builtin_spu_shuffle_9(vec_double2, vec_double2, vec_uchar16);

  vec_uchar16 __builtin_spu_and_0(vec_uchar16, vec_uchar16);
  vec_char16 __builtin_spu_and_1(vec_char16, vec_char16);
  vec_ushort8 __builtin_spu_and_2(vec_ushort8, vec_ushort8);
  vec_short8 __builtin_spu_and_3(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_and_4(vec_uint4, vec_uint4);
  vec_int4 __builtin_spu_and_5(vec_int4, vec_int4);
  vec_ullong2 __builtin_spu_and_6(vec_ullong2, vec_ullong2);
  vec_llong2 __builtin_spu_and_7(vec_llong2, vec_llong2);
  vec_float4 __builtin_spu_and_8(vec_float4, vec_float4);
  vec_double2 __builtin_spu_and_9(vec_double2, vec_double2);
  vec_uchar16 __builtin_spu_and_10(vec_uchar16, unsigned char);
  vec_char16 __builtin_spu_and_11(vec_char16, signed char);
  vec_ushort8 __builtin_spu_and_12(vec_ushort8, short unsigned int);
  vec_short8 __builtin_spu_and_13(vec_short8, short int);
  vec_uint4 __builtin_spu_and_14(vec_uint4, unsigned int);
  vec_int4 __builtin_spu_and_15(vec_int4, int);

  vec_llong2 __builtin_spu_andc_0(vec_llong2, vec_llong2);
  vec_ullong2 __builtin_spu_andc_1(vec_ullong2, vec_ullong2);
  vec_int4 __builtin_spu_andc_2(vec_int4, vec_int4);
  vec_uint4 __builtin_spu_andc_3(vec_uint4, vec_uint4);
  vec_short8 __builtin_spu_andc_4(vec_short8, vec_short8);
  vec_ushort8 __builtin_spu_andc_5(vec_ushort8, vec_ushort8);
  vec_char16 __builtin_spu_andc_6(vec_char16, vec_char16);
  vec_uchar16 __builtin_spu_andc_7(vec_uchar16, vec_uchar16);
  vec_float4 __builtin_spu_andc_8(vec_float4, vec_float4);
  vec_double2 __builtin_spu_andc_9(vec_double2, vec_double2);

  vec_llong2 __builtin_spu_eqv_0(vec_llong2, vec_llong2);
  vec_ullong2 __builtin_spu_eqv_1(vec_ullong2, vec_ullong2);
  vec_int4 __builtin_spu_eqv_2(vec_int4, vec_int4);
  vec_uint4 __builtin_spu_eqv_3(vec_uint4, vec_uint4);
  vec_short8 __builtin_spu_eqv_4(vec_short8, vec_short8);
  vec_ushort8 __builtin_spu_eqv_5(vec_ushort8, vec_ushort8);
  vec_char16 __builtin_spu_eqv_6(vec_char16, vec_char16);
  vec_uchar16 __builtin_spu_eqv_7(vec_uchar16, vec_uchar16);
  vec_float4 __builtin_spu_eqv_8(vec_float4, vec_float4);
  vec_double2 __builtin_spu_eqv_9(vec_double2, vec_double2);

  vec_llong2 __builtin_spu_nand_0(vec_llong2, vec_llong2);
  vec_ullong2 __builtin_spu_nand_1(vec_ullong2, vec_ullong2);
  vec_int4 __builtin_spu_nand_2(vec_int4, vec_int4);
  vec_uint4 __builtin_spu_nand_3(vec_uint4, vec_uint4);
  vec_short8 __builtin_spu_nand_4(vec_short8, vec_short8);
  vec_ushort8 __builtin_spu_nand_5(vec_ushort8, vec_ushort8);
  vec_char16 __builtin_spu_nand_6(vec_char16, vec_char16);
  vec_uchar16 __builtin_spu_nand_7(vec_uchar16, vec_uchar16);
  vec_float4 __builtin_spu_nand_8(vec_float4, vec_float4);
  vec_double2 __builtin_spu_nand_9(vec_double2, vec_double2);

  vec_llong2 __builtin_spu_nor_0(vec_llong2, vec_llong2);
  vec_ullong2 __builtin_spu_nor_1(vec_ullong2, vec_ullong2);
  vec_int4 __builtin_spu_nor_2(vec_int4, vec_int4);
  vec_uint4 __builtin_spu_nor_3(vec_uint4, vec_uint4);
  vec_short8 __builtin_spu_nor_4(vec_short8, vec_short8);
  vec_ushort8 __builtin_spu_nor_5(vec_ushort8, vec_ushort8);
  vec_char16 __builtin_spu_nor_6(vec_char16, vec_char16);
  vec_uchar16 __builtin_spu_nor_7(vec_uchar16, vec_uchar16);
  vec_float4 __builtin_spu_nor_8(vec_float4, vec_float4);
  vec_double2 __builtin_spu_nor_9(vec_double2, vec_double2);

  vec_uchar16 __builtin_spu_or_0(vec_uchar16, vec_uchar16);
  vec_char16 __builtin_spu_or_1(vec_char16, vec_char16);
  vec_ushort8 __builtin_spu_or_2(vec_ushort8, vec_ushort8);
  vec_short8 __builtin_spu_or_3(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_or_4(vec_uint4, vec_uint4);
  vec_int4 __builtin_spu_or_5(vec_int4, vec_int4);
  vec_ullong2 __builtin_spu_or_6(vec_ullong2, vec_ullong2);
  vec_llong2 __builtin_spu_or_7(vec_llong2, vec_llong2);
  vec_float4 __builtin_spu_or_8(vec_float4, vec_float4);
  vec_double2 __builtin_spu_or_9(vec_double2, vec_double2);
  vec_uchar16 __builtin_spu_or_10(vec_uchar16, unsigned char);
  vec_char16 __builtin_spu_or_11(vec_char16, signed char);
  vec_ushort8 __builtin_spu_or_12(vec_ushort8, short unsigned int);
  vec_short8 __builtin_spu_or_13(vec_short8, short int);
  vec_uint4 __builtin_spu_or_14(vec_uint4, unsigned int);
  vec_int4 __builtin_spu_or_15(vec_int4, int);

  vec_llong2 __builtin_spu_orc_0(vec_llong2, vec_llong2);
  vec_ullong2 __builtin_spu_orc_1(vec_ullong2, vec_ullong2);
  vec_int4 __builtin_spu_orc_2(vec_int4, vec_int4);
  vec_uint4 __builtin_spu_orc_3(vec_uint4, vec_uint4);
  vec_short8 __builtin_spu_orc_4(vec_short8, vec_short8);
  vec_ushort8 __builtin_spu_orc_5(vec_ushort8, vec_ushort8);
  vec_char16 __builtin_spu_orc_6(vec_char16, vec_char16);
  vec_uchar16 __builtin_spu_orc_7(vec_uchar16, vec_uchar16);
  vec_float4 __builtin_spu_orc_8(vec_float4, vec_float4);
  vec_double2 __builtin_spu_orc_9(vec_double2, vec_double2);

  vec_int4 __builtin_spu_orx_0(vec_int4);
  vec_uint4 __builtin_spu_orx_1(vec_uint4);
  vec_uchar16 __builtin_spu_xor_0(vec_uchar16, vec_uchar16);
  vec_char16 __builtin_spu_xor_1(vec_char16, vec_char16);
  vec_ushort8 __builtin_spu_xor_2(vec_ushort8, vec_ushort8);
  vec_short8 __builtin_spu_xor_3(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_xor_4(vec_uint4, vec_uint4);
  vec_int4 __builtin_spu_xor_5(vec_int4, vec_int4);
  vec_ullong2 __builtin_spu_xor_6(vec_ullong2, vec_ullong2);
  vec_llong2 __builtin_spu_xor_7(vec_llong2, vec_llong2);
  vec_float4 __builtin_spu_xor_8(vec_float4, vec_float4);
  vec_double2 __builtin_spu_xor_9(vec_double2, vec_double2);
  vec_uchar16 __builtin_spu_xor_10(vec_uchar16, unsigned char);
  vec_char16 __builtin_spu_xor_11(vec_char16, signed char);
  vec_ushort8 __builtin_spu_xor_12(vec_ushort8, short unsigned int);
  vec_short8 __builtin_spu_xor_13(vec_short8, short int);
  vec_uint4 __builtin_spu_xor_14(vec_uint4, unsigned int);
  vec_int4 __builtin_spu_xor_15(vec_int4, int);

  vec_ushort8 __builtin_spu_rl_0(vec_ushort8, vec_short8);
  vec_short8 __builtin_spu_rl_1(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_rl_2(vec_uint4, vec_int4);
  vec_int4 __builtin_spu_rl_3(vec_int4, vec_int4);
  vec_ushort8 __builtin_spu_rl_4(vec_ushort8, short int);
  vec_short8 __builtin_spu_rl_5(vec_short8, short int);
  vec_uint4 __builtin_spu_rl_6(vec_uint4, int);
  vec_int4 __builtin_spu_rl_7(vec_int4, int);

  vec_uchar16 __builtin_spu_rlqw_0(vec_uchar16, int);
  vec_char16 __builtin_spu_rlqw_1(vec_char16, int);
  vec_ushort8 __builtin_spu_rlqw_2(vec_ushort8, int);
  vec_short8 __builtin_spu_rlqw_3(vec_short8, int);
  vec_uint4 __builtin_spu_rlqw_4(vec_uint4, int);
  vec_int4 __builtin_spu_rlqw_5(vec_int4, int);
  vec_ullong2 __builtin_spu_rlqw_6(vec_ullong2, int);
  vec_llong2 __builtin_spu_rlqw_7(vec_llong2, int);
  vec_float4 __builtin_spu_rlqw_8(vec_float4, int);
  vec_double2 __builtin_spu_rlqw_9(vec_double2, int);

  vec_uchar16 __builtin_spu_rlqwbyte_0(vec_uchar16, int);
  vec_char16 __builtin_spu_rlqwbyte_1(vec_char16, int);
  vec_ushort8 __builtin_spu_rlqwbyte_2(vec_ushort8, int);
  vec_short8 __builtin_spu_rlqwbyte_3(vec_short8, int);
  vec_uint4 __builtin_spu_rlqwbyte_4(vec_uint4, int);
  vec_int4 __builtin_spu_rlqwbyte_5(vec_int4, int);
  vec_ullong2 __builtin_spu_rlqwbyte_6(vec_ullong2, int);
  vec_llong2 __builtin_spu_rlqwbyte_7(vec_llong2, int);
  vec_float4 __builtin_spu_rlqwbyte_8(vec_float4, int);
  vec_double2 __builtin_spu_rlqwbyte_9(vec_double2, int);

  vec_uchar16 __builtin_spu_rlqwbytebc_0(vec_uchar16, int);
  vec_char16 __builtin_spu_rlqwbytebc_1(vec_char16, int);
  vec_ushort8 __builtin_spu_rlqwbytebc_2(vec_ushort8, int);
  vec_short8 __builtin_spu_rlqwbytebc_3(vec_short8, int);
  vec_uint4 __builtin_spu_rlqwbytebc_4(vec_uint4, int);
  vec_int4 __builtin_spu_rlqwbytebc_5(vec_int4, int);
  vec_ullong2 __builtin_spu_rlqwbytebc_6(vec_ullong2, int);
  vec_llong2 __builtin_spu_rlqwbytebc_7(vec_llong2, int);
  vec_float4 __builtin_spu_rlqwbytebc_8(vec_float4, int);
  vec_double2 __builtin_spu_rlqwbytebc_9(vec_double2, int);

  vec_ushort8 __builtin_spu_rlmask_0(vec_ushort8, vec_short8);
  vec_short8 __builtin_spu_rlmask_1(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_rlmask_2(vec_uint4, vec_int4);
  vec_int4 __builtin_spu_rlmask_3(vec_int4, vec_int4);
  vec_ushort8 __builtin_spu_rlmask_4(vec_ushort8, int);
  vec_short8 __builtin_spu_rlmask_5(vec_short8, int);
  vec_uint4 __builtin_spu_rlmask_6(vec_uint4, int);
  vec_int4 __builtin_spu_rlmask_7(vec_int4, int);

  vec_ushort8 __builtin_spu_rlmaska_0(vec_ushort8, vec_short8);
  vec_short8 __builtin_spu_rlmaska_1(vec_short8, vec_short8);
  vec_uint4 __builtin_spu_rlmaska_2(vec_uint4, vec_int4);
  vec_int4 __builtin_spu_rlmaska_3(vec_int4, vec_int4);
  vec_ushort8 __builtin_spu_rlmaska_4(vec_ushort8, int);
  vec_short8 __builtin_spu_rlmaska_5(vec_short8, int);
  vec_uint4 __builtin_spu_rlmaska_6(vec_uint4, int);
  vec_int4 __builtin_spu_rlmaska_7(vec_int4, int);

  vec_uchar16 __builtin_spu_rlmaskqw_0(vec_uchar16, int);
  vec_char16 __builtin_spu_rlmaskqw_1(vec_char16, int);
  vec_ushort8 __builtin_spu_rlmaskqw_2(vec_ushort8, int);
  vec_short8 __builtin_spu_rlmaskqw_3(vec_short8, int);
  vec_uint4 __builtin_spu_rlmaskqw_4(vec_uint4, int);
  vec_int4 __builtin_spu_rlmaskqw_5(vec_int4, int);
  vec_ullong2 __builtin_spu_rlmaskqw_6(vec_ullong2, int);
  vec_llong2 __builtin_spu_rlmaskqw_7(vec_llong2, int);
  vec_float4 __builtin_spu_rlmaskqw_8(vec_float4, int);
  vec_double2 __builtin_spu_rlmaskqw_9(vec_double2, int);

  vec_uchar16 __builtin_spu_rlmaskqwbyte_0(vec_uchar16, int);
  vec_char16 __builtin_spu_rlmaskqwbyte_1(vec_char16, int);
  vec_ushort8 __builtin_spu_rlmaskqwbyte_2(vec_ushort8, int);
  vec_short8 __builtin_spu_rlmaskqwbyte_3(vec_short8, int);
  vec_uint4 __builtin_spu_rlmaskqwbyte_4(vec_uint4, int);
  vec_int4 __builtin_spu_rlmaskqwbyte_5(vec_int4, int);
  vec_ullong2 __builtin_spu_rlmaskqwbyte_6(vec_ullong2, int);
  vec_llong2 __builtin_spu_rlmaskqwbyte_7(vec_llong2, int);
  vec_float4 __builtin_spu_rlmaskqwbyte_8(vec_float4, int);
  vec_double2 __builtin_spu_rlmaskqwbyte_9(vec_double2, int);

  vec_uchar16 __builtin_spu_rlmaskqwbytebc_0(vec_uchar16, int);
  vec_char16 __builtin_spu_rlmaskqwbytebc_1(vec_char16, int);
  vec_ushort8 __builtin_spu_rlmaskqwbytebc_2(vec_ushort8, int);
  vec_short8 __builtin_spu_rlmaskqwbytebc_3(vec_short8, int);
  vec_uint4 __builtin_spu_rlmaskqwbytebc_4(vec_uint4, int);
  vec_int4 __builtin_spu_rlmaskqwbytebc_5(vec_int4, int);
  vec_ullong2 __builtin_spu_rlmaskqwbytebc_6(vec_ullong2, int);
  vec_llong2 __builtin_spu_rlmaskqwbytebc_7(vec_llong2, int);
  vec_float4 __builtin_spu_rlmaskqwbytebc_8(vec_float4, int);
  vec_double2 __builtin_spu_rlmaskqwbytebc_9(vec_double2, int);

  vec_ushort8 __builtin_spu_sl_0(vec_ushort8, vec_ushort8);
  vec_short8 __builtin_spu_sl_1(vec_short8, vec_ushort8);
  vec_uint4 __builtin_spu_sl_2(vec_uint4, vec_uint4);
  vec_int4 __builtin_spu_sl_3(vec_int4, vec_uint4);
  vec_ushort8 __builtin_spu_sl_4(vec_ushort8, unsigned int);
  vec_short8 __builtin_spu_sl_5(vec_short8, unsigned int);
  vec_uint4 __builtin_spu_sl_6(vec_uint4, unsigned int);
  vec_int4 __builtin_spu_sl_7(vec_int4, unsigned int);

  vec_llong2 __builtin_spu_slqw_0(vec_llong2, unsigned int);
  vec_ullong2 __builtin_spu_slqw_1(vec_ullong2, unsigned int);
  vec_int4 __builtin_spu_slqw_2(vec_int4, unsigned int);
  vec_uint4 __builtin_spu_slqw_3(vec_uint4, unsigned int);
  vec_short8 __builtin_spu_slqw_4(vec_short8, unsigned int);
  vec_ushort8 __builtin_spu_slqw_5(vec_ushort8, unsigned int);
  vec_char16 __builtin_spu_slqw_6(vec_char16, unsigned int);
  vec_uchar16 __builtin_spu_slqw_7(vec_uchar16, unsigned int);
  vec_float4 __builtin_spu_slqw_8(vec_float4, unsigned int);
  vec_double2 __builtin_spu_slqw_9(vec_double2, unsigned int);

  vec_llong2 __builtin_spu_slqwbyte_0(vec_llong2, unsigned int);
  vec_ullong2 __builtin_spu_slqwbyte_1(vec_ullong2, unsigned int);
  vec_int4 __builtin_spu_slqwbyte_2(vec_int4, unsigned int);
  vec_uint4 __builtin_spu_slqwbyte_3(vec_uint4, unsigned int);
  vec_short8 __builtin_spu_slqwbyte_4(vec_short8, unsigned int);
  vec_ushort8 __builtin_spu_slqwbyte_5(vec_ushort8, unsigned int);
  vec_char16 __builtin_spu_slqwbyte_6(vec_char16, unsigned int);
  vec_uchar16 __builtin_spu_slqwbyte_7(vec_uchar16, unsigned int);
  vec_float4 __builtin_spu_slqwbyte_8(vec_float4, unsigned int);
  vec_double2 __builtin_spu_slqwbyte_9(vec_double2, unsigned int);

  vec_llong2 __builtin_spu_slqwbytebc_0(vec_llong2, unsigned int);
  vec_ullong2 __builtin_spu_slqwbytebc_1(vec_ullong2, unsigned int);
  vec_int4 __builtin_spu_slqwbytebc_2(vec_int4, unsigned int);
  vec_uint4 __builtin_spu_slqwbytebc_3(vec_uint4, unsigned int);
  vec_short8 __builtin_spu_slqwbytebc_4(vec_short8, unsigned int);
  vec_ushort8 __builtin_spu_slqwbytebc_5(vec_ushort8, unsigned int);
  vec_char16 __builtin_spu_slqwbytebc_6(vec_char16, unsigned int);
  vec_uchar16 __builtin_spu_slqwbytebc_7(vec_uchar16, unsigned int);
  vec_float4 __builtin_spu_slqwbytebc_8(vec_float4, unsigned int);
  vec_double2 __builtin_spu_slqwbytebc_9(vec_double2, unsigned int);

  vec_uchar16 __builtin_spu_splats_0(unsigned char);
  vec_char16 __builtin_spu_splats_1(signed char);
  vec_ushort8 __builtin_spu_splats_2(short unsigned int);
  vec_short8 __builtin_spu_splats_3(short int);
  vec_uint4 __builtin_spu_splats_4(unsigned int);
  vec_int4 __builtin_spu_splats_5(int);
  vec_ullong2 __builtin_spu_splats_6(long long unsigned int);
  vec_llong2 __builtin_spu_splats_7(long long int);
  vec_float4 __builtin_spu_splats_8(float);
  vec_double2 __builtin_spu_splats_9(double);

  unsigned char __builtin_spu_extract_0(vec_uchar16, int);
  signed char __builtin_spu_extract_1(vec_char16, int);
  short unsigned int __builtin_spu_extract_2(vec_ushort8, int);
  short int __builtin_spu_extract_3(vec_short8, int);
  unsigned int __builtin_spu_extract_4(vec_uint4, int);
  int __builtin_spu_extract_5(vec_int4, int);
  long long unsigned int __builtin_spu_extract_6(vec_ullong2, int);
  long long int __builtin_spu_extract_7(vec_llong2, int);
  float __builtin_spu_extract_8(vec_float4, int);
  double __builtin_spu_extract_9(vec_double2, int);

  vec_uchar16 __builtin_spu_insert_0(unsigned char, vec_uchar16, int);
  vec_char16 __builtin_spu_insert_1(signed char, vec_char16, int);
  vec_ushort8 __builtin_spu_insert_2(short unsigned int, vec_ushort8, int);
  vec_short8 __builtin_spu_insert_3(short int, vec_short8, int);
  vec_uint4 __builtin_spu_insert_4(unsigned int, vec_uint4, int);
  vec_int4 __builtin_spu_insert_5(int, vec_int4, int);
  vec_ullong2 __builtin_spu_insert_6(long long unsigned int, vec_ullong2, int);
  vec_llong2 __builtin_spu_insert_7(long long int, vec_llong2, int);
  vec_float4 __builtin_spu_insert_8(float, vec_float4, int);
  vec_double2 __builtin_spu_insert_9(double, vec_double2, int);

  vec_uchar16 __builtin_spu_promote_0(unsigned char, int);
  vec_char16 __builtin_spu_promote_1(signed char, int);
  vec_ushort8 __builtin_spu_promote_2(short unsigned int, int);
  vec_short8 __builtin_spu_promote_3(short int, int);
  vec_uint4 __builtin_spu_promote_4(unsigned int, int);
  vec_int4 __builtin_spu_promote_5(int, int);
  vec_ullong2 __builtin_spu_promote_6(long long unsigned int, int);
  vec_llong2 __builtin_spu_promote_7(long long int, int);
  vec_float4 __builtin_spu_promote_8(float, int);
  vec_double2 __builtin_spu_promote_9(double, int);

#if 0
  qword __builtin_si_lqd(qword ra, qword imm);
  qword __builtin_si_lqx(qword ra, qword rb);
  qword __builtin_si_lqa(qword imm);
  qword __builtin_si_lqr(qword imm);
  qword __builtin_si_stqd(qword rt, qword ra, qword imm);
  qword __builtin_si_stqx(qword rt, qword ra, qword rb);
  qword __builtin_si_stqa(qword rt, qword imm);
  qword __builtin_si_stqr(qword rt, qword imm);
  qword __builtin_si_cbd(qword ra, qword imm);
  qword __builtin_si_cbx(qword ra, qword rb);
  qword __builtin_si_chd(qword ra, qword imm);
  qword __builtin_si_chx(qword ra, qword rb);
  qword __builtin_si_cwd(qword ra, qword imm);
  qword __builtin_si_cwx(qword ra, qword rb);
  qword __builtin_si_cdd(qword ra, qword imm);
  qword __builtin_si_cdx(qword ra, qword rb);
  qword __builtin_si_ilh(qword imm);
  qword __builtin_si_ilhu(qword imm);
  qword __builtin_si_il(qword imm);
  qword __builtin_si_ila(qword imm);
  qword __builtin_si_iohl(qword ra, qword imm);
  qword __builtin_si_fsmbi(qword imm);
  qword __builtin_si_ah(qword ra, qword rb);
  qword __builtin_si_ahi(qword ra, qword imm);
  qword __builtin_si_a(qword ra, qword rb);
  qword __builtin_si_ai(qword ra, qword imm);
  qword __builtin_si_addx(qword ra, qword rb, qword rt);
  qword __builtin_si_cg(qword ra, qword rb);
  qword __builtin_si_cgx(qword ra, qword rb, qword rt);
  qword __builtin_si_sfh(qword rb, qword ra);
  qword __builtin_si_sfhi(qword imm, qword ra);
  qword __builtin_si_sf(qword rb, qword ra);
  qword __builtin_si_sfi(qword imm, qword ra);
  qword __builtin_si_sfx(qword rb, qword ra, qword rt);
  qword __builtin_si_bg(qword rb, qword ra);
  qword __builtin_si_bgx(qword rb, qword ra, qword rt);
  qword __builtin_si_mpy(qword ra, qword rb);
  qword __builtin_si_mpyu(qword ra, qword rb);
  qword __builtin_si_mpyi(qword ra, qword imm);
  qword __builtin_si_mpyui(qword ra, qword imm);
  qword __builtin_si_mpya(qword ra, qword rb, qword rc);
  qword __builtin_si_mpyh(qword ra, qword rb);
  qword __builtin_si_mpys(qword ra, qword rb);
  qword __builtin_si_mpyhh(qword ra, qword rb);
  qword __builtin_si_mpyhhu(qword ra, qword rb);
  qword __builtin_si_mpyhha(qword ra, qword rb, qword rc);
  qword __builtin_si_mpyhhau(qword ra, qword rb, qword rc);
  qword __builtin_si_clz(qword ra);
  qword __builtin_si_cntb(qword ra);
  qword __builtin_si_fsmb(qword ra);
  qword __builtin_si_fsmh(qword ra);
  qword __builtin_si_fsm(qword ra);
  qword __builtin_si_gbb(qword ra);
  qword __builtin_si_gbh(qword ra);
  qword __builtin_si_gb(qword ra);
  qword __builtin_si_avgb(qword ra, qword rb);
  qword __builtin_si_absdb(qword ra, qword rb);
  qword __builtin_si_sumb(qword ra, qword rb);
  qword __builtin_si_xsbh(qword ra);
  qword __builtin_si_xshw(qword ra);
  qword __builtin_si_xswd(qword ra);
  qword __builtin_si_and(qword ra, qword rb);
  qword __builtin_si_andc(qword ra, qword rb);
  qword __builtin_si_andbi(qword ra, qword imm);
  qword __builtin_si_andhi(qword ra, qword imm);
  qword __builtin_si_andi(qword ra, qword imm);
  qword __builtin_si_or(qword ra, qword rb);
  qword __builtin_si_orc(qword ra, qword rb);
  qword __builtin_si_orbi(qword ra, qword imm);
  qword __builtin_si_orhi(qword ra, qword imm);
  qword __builtin_si_ori(qword ra, qword imm);
  qword __builtin_si_orx(qword ra);
  qword __builtin_si_xor(qword ra, qword rb);
  qword __builtin_si_xorbi(qword ra, qword imm);
  qword __builtin_si_xorhi(qword ra, qword imm);
  qword __builtin_si_xori(qword ra, qword imm);
  qword __builtin_si_nand(qword ra, qword rb);
  qword __builtin_si_nor(qword ra, qword rb);
  qword __builtin_si_eqv(qword ra, qword rb);
  qword __builtin_si_selb(qword ra, qword rb, qword rc);
  qword __builtin_si_shufb(qword ra, qword rb, qword rc);
  qword __builtin_si_shlh(qword ra, qword rb);
  qword __builtin_si_shlhi(qword ra, qword imm);
  qword __builtin_si_shl(qword ra, qword rb);
  qword __builtin_si_shli(qword ra, qword imm);
  qword __builtin_si_shlqbi(qword ra, qword rb);
  qword __builtin_si_shlqbii(qword ra, qword imm);
  qword __builtin_si_shlqby(qword ra, qword rb);
  qword __builtin_si_shlqbyi(qword ra, qword imm);
  qword __builtin_si_shlqbybi(qword ra, qword rb);
  qword __builtin_si_roth(qword ra, qword rb);
  qword __builtin_si_rothi(qword ra, qword imm);
  qword __builtin_si_rot(qword ra, qword rb);
  qword __builtin_si_roti(qword ra, qword imm);
  qword __builtin_si_rotqby(qword ra, qword rb);
  qword __builtin_si_rotqbyi(qword ra, qword imm);
  qword __builtin_si_rotqbybi(qword ra, qword rb);
  qword __builtin_si_rotqbi(qword ra, qword rb);
  qword __builtin_si_rotqbii(qword ra, qword imm);
  qword __builtin_si_rothm(qword ra, qword rb);
  qword __builtin_si_rothmi(qword ra, qword imm);
  qword __builtin_si_rotm(qword ra, qword rb);
  qword __builtin_si_rotmi(qword ra, qword imm);
  qword __builtin_si_rotqmby(qword ra, qword rb);
  qword __builtin_si_rotqmbyi(qword ra, qword imm);
  qword __builtin_si_rotqmbi(qword ra, qword rb);
  qword __builtin_si_rotqmbii(qword ra, qword imm);
  qword __builtin_si_rotqmbybi(qword ra, qword rb);
  qword __builtin_si_rotmah(qword ra, qword rb);
  qword __builtin_si_rotmahi(qword ra, qword imm);
  qword __builtin_si_rotma(qword ra, qword rb);
  qword __builtin_si_rotmai(qword ra, qword imm);
  qword __builtin_si_heq(qword ra, qword rb);
  qword __builtin_si_heqi(qword ra, qword imm);
  qword __builtin_si_hgt(qword ra, qword rb);
  qword __builtin_si_hgti(qword ra, qword imm);
  qword __builtin_si_hlgt(qword ra, qword rb);
  qword __builtin_si_hlgti(qword ra, qword imm);
  qword __builtin_si_ceqb(qword ra, qword rb);
  qword __builtin_si_ceqbi(qword ra, qword imm);
  qword __builtin_si_ceqh(qword ra, qword rb);
  qword __builtin_si_ceqhi(qword ra, qword imm);
  qword __builtin_si_ceq(qword ra, qword rb);
  qword __builtin_si_ceqi(qword ra, qword imm);
  qword __builtin_si_cgtb(qword ra, qword rb);
  qword __builtin_si_cgtbi(qword ra, qword imm);
  qword __builtin_si_cgth(qword ra, qword rb);
  qword __builtin_si_cgthi(qword ra, qword imm);
  qword __builtin_si_cgt(qword ra, qword rb);
  qword __builtin_si_cgti(qword ra, qword imm);
  qword __builtin_si_clgtb(qword ra, qword rb);
  qword __builtin_si_clgtbi(qword ra, qword imm);
  qword __builtin_si_clgth(qword ra, qword rb);
  qword __builtin_si_clgthi(qword ra, qword imm);
  qword __builtin_si_clgt(qword ra, qword rb);
  qword __builtin_si_clgti(qword ra, qword imm);
  qword __builtin_si_br(qword tgt, qword bl);
  qword __builtin_si_bra(qword tgt, qword bl);
  qword __builtin_si_brsl(qword tgt, qword bl);
  qword __builtin_si_brasl(qword tgt, qword bl);
  qword __builtin_si_bi(qword ra, qword bl);
  qword __builtin_si_bisled(qword ra, qword imm);
  qword __builtin_si_bisledd(qword ra, qword imm);
  qword __builtin_si_bislede(qword ra, qword imm);
  qword __builtin_si_bisl(qword ra, qword bl);
  qword __builtin_si_brnz(qword ra, qword tgt, qword bl);
  qword __builtin_si_brz(qword ra, qword tgt, qword bl);
  qword __builtin_si_brhnz(qword ra, qword tgt, qword bl);
  qword __builtin_si_brhz(qword ra, qword tgt, qword bl);
  qword __builtin_si_binz(qword ra, qword tgt, qword bl);
  qword __builtin_si_biz(qword ra, qword tgt, qword bl);
  qword __builtin_si_bihnz(qword ra, qword tgt, qword bl);
  qword __builtin_si_bihz(qword ra, qword tgt, qword bl);
  qword __builtin_si_hbr(qword bl, qword ra);
  qword __builtin_si_hbra(qword bl, qword tgt);
  qword __builtin_si_hbrr(qword bl, qword tgt);
  qword __builtin_si_fa(qword ra, qword rb);
  qword __builtin_si_dfa(qword ra, qword rb);
  qword __builtin_si_fs(qword ra, qword rb);
  qword __builtin_si_dfs(qword ra, qword rb);
  qword __builtin_si_fm(qword ra, qword rb);
  qword __builtin_si_dfm(qword ra, qword rb);
  qword __builtin_si_fma(qword ra, qword rb, qword rc);
  qword __builtin_si_dfma(qword ra, qword rb, qword rc);
  qword __builtin_si_dfnma(qword ra, qword rb, qword rc);
  qword __builtin_si_fnms(qword ra, qword rb, qword rc);
  qword __builtin_si_dfnms(qword ra, qword rb, qword rc);
  qword __builtin_si_fms(qword ra, qword rb, qword rc);
  qword __builtin_si_dfms(qword ra, qword rb, qword rc);
  qword __builtin_si_frest(qword ra);
  qword __builtin_si_frsqest(qword ra);
  qword __builtin_si_fi(qword ra, qword rb);
  qword __builtin_si_csflt(qword ra, qword imm);
  qword __builtin_si_cflts(qword ra, qword imm);
  qword __builtin_si_cuflt(qword ra, qword imm);
  qword __builtin_si_cfltu(qword ra, qword imm);
  qword __builtin_si_frds(qword ra);
  qword __builtin_si_fesd(qword ra);
  qword __builtin_si_fceq(qword ra, qword rb);
  qword __builtin_si_fcmeq(qword ra, qword rb);
  qword __builtin_si_fcgt(qword ra, qword rb);
  qword __builtin_si_fcmgt(qword ra, qword rb);
  qword __builtin_si_stop(qword imm);
  qword __builtin_si_stopd(qword ra, qword rb, qword rc);
  qword __builtin_si_lnop(qword );
  qword __builtin_si_nop(qword );
  qword __builtin_si_sync(qword );
  qword __builtin_si_syncc(qword );
  qword __builtin_si_dsync(qword );
  qword __builtin_si_mfspr(qword imm);
  qword __builtin_si_mtspr(qword imm, qword ra);
  qword __builtin_si_fscrrd(qword );
  qword __builtin_si_fscrwr(qword ra);
  qword __builtin_si_rdch(int imm);
  qword __builtin_si_rchcnt(int imm);
  qword __builtin_si_wrch(int imm, qword ra);
#else
  qword __builtin_si_lqd(qword ra, unsigned int imm);
  qword __builtin_si_lqx(qword ra, qword rb);
  qword __builtin_si_lqa(unsigned int imm);
  qword __builtin_si_lqr(unsigned int imm);
  void __builtin_si_stqd(qword a, qword b, unsigned int imm);
  void __builtin_si_stqx(qword rt, qword ra, qword rb);
  void __builtin_si_stqa(qword rt, unsigned int imm);
  void __builtin_si_stqr(qword rt, unsigned int imm);
  qword __builtin_si_cbd(qword ra, int imm);
  qword __builtin_si_cbx(qword ra, qword rb);
  qword __builtin_si_chd(qword ra, int imm);
  qword __builtin_si_chx(qword ra, qword rb);
  qword __builtin_si_cwd(qword ra, int imm);
  qword __builtin_si_cwx(qword ra, qword rb);
  qword __builtin_si_cdd(qword ra, int imm);
  qword __builtin_si_cdx(qword ra, qword rb);
  qword __builtin_si_ilh(signed short imm);
  qword __builtin_si_ilhu(signed short imm);
  qword __builtin_si_il(signed short imm);
  qword __builtin_si_ila(unsigned int imm);
  qword __builtin_si_iohl(qword ra, unsigned short imm);
  qword __builtin_si_fsmbi(int imm);
  qword __builtin_si_ah(qword ra, qword rb);
  qword __builtin_si_ahi(qword ra, short imm);
  qword __builtin_si_a(qword ra, qword rb);
  qword __builtin_si_ai(qword ra, int imm);
  qword __builtin_si_addx(qword ra, qword rb, qword rt);
  qword __builtin_si_cg(qword ra, qword rb);
  qword __builtin_si_cgx(qword ra, qword rb, qword rt);
  qword __builtin_si_sfh(qword rb, qword ra);
  qword __builtin_si_sfhi(qword imm, short ra);
  qword __builtin_si_sf(qword rb, qword ra);
  qword __builtin_si_sfi(qword imm, int ra);
  qword __builtin_si_sfx(qword rb, qword ra, qword rt);
  qword __builtin_si_bg(qword rb, qword ra);
  qword __builtin_si_bgx(qword rb, qword ra, qword rt);
  qword __builtin_si_mpy(qword ra, qword rb);
  qword __builtin_si_mpyu(qword ra, qword rb);
  qword __builtin_si_mpyi(qword ra, short imm);
  qword __builtin_si_mpyui(qword ra, unsigned short imm);
  qword __builtin_si_mpya(qword ra, qword rb, qword rc);
  qword __builtin_si_mpyh(qword ra, qword rb);
  qword __builtin_si_mpys(qword ra, qword rb);
  qword __builtin_si_mpyhh(qword ra, qword rb);
  qword __builtin_si_mpyhhu(qword ra, qword rb);
  qword __builtin_si_mpyhha(qword ra, qword rb, qword rc);
  qword __builtin_si_mpyhhau(qword ra, qword rb, qword rc);
  qword __builtin_si_clz(qword ra);
  qword __builtin_si_cntb(qword ra);
  qword __builtin_si_fsmb(qword ra);
  qword __builtin_si_fsmh(qword ra);
  qword __builtin_si_fsm(qword ra);
  qword __builtin_si_gbb(qword ra);
  qword __builtin_si_gbh(qword ra);
  qword __builtin_si_gb(qword ra);
  qword __builtin_si_avgb(vec_uchar16 ra, vec_uchar16 rb);
  qword __builtin_si_absdb(qword ra, qword rb);
  qword __builtin_si_sumb(qword ra, qword rb);
  qword __builtin_si_xsbh(qword ra);
  qword __builtin_si_xshw(qword ra);
  qword __builtin_si_xswd(qword ra);
  qword __builtin_si_and(qword ra, qword rb);
  qword __builtin_si_andc(vec_uchar16 ra, vec_uchar16 rb);
  qword __builtin_si_andbi(qword ra, signed char imm);
  qword __builtin_si_andhi(qword ra, signed short imm);
  qword __builtin_si_andi(qword ra, signed int imm);
  qword __builtin_si_or(qword ra, qword rb);
  qword __builtin_si_orc(qword ra, qword rb);
  qword __builtin_si_orbi(qword ra, unsigned char imm);
  qword __builtin_si_orhi(qword ra, unsigned short imm);
  qword __builtin_si_ori(qword ra, unsigned int imm);
  qword __builtin_si_orx(qword ra);
  qword __builtin_si_xor(qword ra, qword rb);
  qword __builtin_si_xorbi(qword ra, unsigned char imm);
  qword __builtin_si_xorhi(qword ra, unsigned short imm);
  qword __builtin_si_xori(qword ra, unsigned int imm);
  qword __builtin_si_nand(qword ra, qword rb);
  qword __builtin_si_nor(qword ra, qword rb);
  qword __builtin_si_eqv(qword ra, qword rb);
  qword __builtin_si_selb(qword ra, qword rb, qword rc);
  qword __builtin_si_shufb(qword ra, qword rb, qword rc);
  qword __builtin_si_shlh(qword ra, qword rb);
  qword __builtin_si_shlhi(qword ra, unsigned int imm);
  qword __builtin_si_shl(qword ra, qword rb);
  qword __builtin_si_shli(qword ra, unsigned int imm);
  qword __builtin_si_shlqbi(qword ra, qword rb);
  qword __builtin_si_shlqbii(qword ra, unsigned int imm);
  qword __builtin_si_shlqby(qword ra, qword rb);
  qword __builtin_si_shlqbyi(qword ra, unsigned int imm);
  qword __builtin_si_shlqbybi(qword ra, qword rb);
  qword __builtin_si_roth(qword ra, qword rb);
  qword __builtin_si_rothi(qword ra, int imm);
  qword __builtin_si_rot(qword ra, qword rb);
  qword __builtin_si_roti(qword ra, int imm);
  qword __builtin_si_rotqby(qword ra, qword rb);
  qword __builtin_si_rotqbyi(qword ra, int imm);
  qword __builtin_si_rotqbybi(qword ra, qword rb);
  qword __builtin_si_rotqbi(qword ra, qword rb);
  qword __builtin_si_rotqbii(qword ra, int imm);
  qword __builtin_si_rothm(qword ra, qword rb);
  qword __builtin_si_rothmi(qword ra, int imm);
  qword __builtin_si_rotm(qword ra, qword rb);
  qword __builtin_si_rotmi(qword ra, int imm);
  qword __builtin_si_rotqmby(qword ra, qword rb);
  qword __builtin_si_rotqmbyi(qword ra, int imm);
  qword __builtin_si_rotqmbi(qword ra, qword rb);
  qword __builtin_si_rotqmbii(qword ra, int imm);
  qword __builtin_si_rotqmbybi(qword ra, qword rb);
  qword __builtin_si_rotmah(qword ra, qword rb);
  qword __builtin_si_rotmahi(qword ra, int imm);
  qword __builtin_si_rotma(qword ra, qword rb);
  qword __builtin_si_rotmai(qword ra, int imm);
  void __builtin_si_heq(qword ra, qword rb);
  void __builtin_si_heqi(qword ra, unsigned int imm);
  void __builtin_si_hgt(qword ra, qword rb);
  void __builtin_si_hgti(qword ra, signed int imm);
  void __builtin_si_hlgt(qword ra, qword rb);
  void __builtin_si_hlgti(qword ra, unsigned int imm);
  qword __builtin_si_ceqb(qword ra, qword rb);
  qword __builtin_si_ceqbi(qword ra, signed char imm);
  qword __builtin_si_ceqh(qword ra, signed short rb);
  qword __builtin_si_ceqhi(qword ra, signed short imm);
  qword __builtin_si_ceq(qword ra, qword rb);
  qword __builtin_si_ceqi(qword ra, signed int imm);
  qword __builtin_si_cgtb(qword ra, qword rb);
  qword __builtin_si_cgtbi(qword ra, signed char imm);
  qword __builtin_si_cgth(qword ra, qword rb);
  qword __builtin_si_cgthi(qword ra, signed short imm);
  qword __builtin_si_cgt(qword ra, qword rb);
  qword __builtin_si_cgti(qword ra, signed int imm);
  qword __builtin_si_clgtb(qword ra, qword rb);
  qword __builtin_si_clgtbi(qword ra, unsigned char imm);
  qword __builtin_si_clgth(qword ra, qword rb);
  qword __builtin_si_clgthi(qword ra, unsigned short imm);
  qword __builtin_si_clgt(qword ra, qword rb);
  qword __builtin_si_clgti(qword ra, unsigned int imm);
  void __builtin_si_br(qword tgt, qword bl);
  void __builtin_si_bra(qword tgt, qword bl);
  void __builtin_si_brsl(qword tgt, qword bl);
  void __builtin_si_brasl(qword tgt, qword bl);
  void __builtin_si_bi(qword ra, qword bl);
  void __builtin_si_bisled(qword ra, int imm);
  void __builtin_si_bisledd(qword ra, int imm);
  void __builtin_si_bislede(qword ra, qword imm);
  void __builtin_si_bisl(qword ra, qword bl);
  void __builtin_si_brnz(qword ra, qword tgt, qword bl);
  void __builtin_si_brz(qword ra, qword tgt, qword bl);
  void __builtin_si_brhnz(qword ra, qword tgt, qword bl);
  void __builtin_si_brhz(qword ra, qword tgt, qword bl);
  void __builtin_si_binz(qword ra, qword tgt, qword bl);
  void __builtin_si_biz(qword ra, qword tgt, qword bl);
  void __builtin_si_bihnz(qword ra, qword tgt, qword bl);
  void __builtin_si_bihz(qword ra, qword tgt, qword bl);
  void __builtin_si_hbr(qword bl, qword ra);
  void __builtin_si_hbra(qword bl, qword tgt);
  void __builtin_si_hbrr(qword bl, qword tgt);
  qword __builtin_si_fa(qword ra, qword rb);
  qword __builtin_si_dfa(qword ra, qword rb);
  qword __builtin_si_fs(qword ra, qword rb);
  qword __builtin_si_dfs(qword ra, qword rb);
  qword __builtin_si_fm(qword ra, qword rb);
  qword __builtin_si_dfm(qword ra, qword rb);
  qword __builtin_si_fma(qword ra, qword rb, qword rc);
  qword __builtin_si_dfma(qword ra, qword rb, qword rc);
  qword __builtin_si_dfnma(qword ra, qword rb, qword rc);
  qword __builtin_si_fnms(qword ra, qword rb, qword rc);
  qword __builtin_si_dfnms(qword ra, qword rb, qword rc);
  qword __builtin_si_fms(qword ra, qword rb, qword rc);
  qword __builtin_si_dfms(qword ra, qword rb, qword rc);
  qword __builtin_si_frest(qword ra);
  qword __builtin_si_frsqest(qword ra);
  qword __builtin_si_fi(qword ra, qword rb);
  qword __builtin_si_csflt(qword ra, int imm);
  qword __builtin_si_cflts(qword ra, int imm);
  qword __builtin_si_cuflt(qword ra, int imm);
  qword __builtin_si_cfltu(qword ra, int imm);
  qword __builtin_si_frds(qword ra);
  qword __builtin_si_fesd(qword ra);
  qword __builtin_si_fceq(qword ra, qword rb);
  qword __builtin_si_fcmeq(qword ra, qword rb);
  qword __builtin_si_fcgt(qword ra, qword rb);
  qword __builtin_si_fcmgt(qword ra, qword rb);
  void __builtin_si_stop(int imm);
  void __builtin_si_stopd(qword ra, qword rb, qword rc);
  void __builtin_si_lnop(qword );
  void __builtin_si_nop(qword );
  void __builtin_si_sync(qword );
  void __builtin_si_syncc(qword );
  void __builtin_si_dsync();
  qword __builtin_si_mfspr(vec_uint4 imm);
  void __builtin_si_mtspr(qword imm, qword ra);
  qword __builtin_si_fscrrd(vec_uint4);
  void __builtin_si_fscrwr(qword ra);
  qword __builtin_si_rdch(int imm);
  qword __builtin_si_rchcnt(int imm);
  void __builtin_si_wrch(int imm, qword ra);
#endif

  qword __builtin_si_from_char(signed char scalar);
  qword __builtin_si_from_uchar(unsigned char scalar);
  qword __builtin_si_from_short(short int scalar);
  qword __builtin_si_from_ushort(unsigned short int scalar);
  qword __builtin_si_from_int(int scalar);
  qword __builtin_si_from_uint(unsigned int scalar);
  qword __builtin_si_from_long(long long int scalar);
  qword __builtin_si_from_ulong(unsigned long long int scalar);
  qword __builtin_si_from_float(float scalar);
  qword __builtin_si_from_double(double scalar);
  qword __builtin_si_from_ptr(volatile void *scalar);

  signed char __builtin_si_to_char(qword ra);
  unsigned char __builtin_si_to_uchar(qword ra);
  short int __builtin_si_to_short(qword ra);
  unsigned short int __builtin_si_to_ushort(qword ra);
  int __builtin_si_to_int(qword ra);
  unsigned int __builtin_si_to_uint(qword ra);
  long long int __builtin_si_to_long(qword ra);
  unsigned long long int __builtin_si_to_ulong(qword ra);
  float __builtin_si_to_float(qword ra);
  double __builtin_si_to_double(qword ra);
  volatile void *__builtin_si_to_ptr(qword ra);

#if defined __cplusplus
} // extern "C"
#endif
#endif

#if defined __CRYCG__
#define VEC_CHAR16_CONST1(SCALAR) \
	(__extension__ (vec_char16){ (SCALAR), (SCALAR), (SCALAR), (SCALAR), \
	 (SCALAR), (SCALAR), (SCALAR), (SCALAR), \
	 (SCALAR), (SCALAR), (SCALAR), (SCALAR), \
	 (SCALAR), (SCALAR), (SCALAR), (SCALAR) })
#define VEC_UCHAR16_CONST1(SCALAR) \
	(__extension__ (vec_uchar16){ (SCALAR), (SCALAR), (SCALAR), (SCALAR), \
	 (SCALAR), (SCALAR), (SCALAR), (SCALAR), \
	 (SCALAR), (SCALAR), (SCALAR), (SCALAR), \
	 (SCALAR), (SCALAR), (SCALAR), (SCALAR) })
#define VEC_SHORT8_CONST1(SCALAR) \
	(__extension__ (vec_short8){ (SCALAR), (SCALAR), (SCALAR), (SCALAR), \
	 (SCALAR), (SCALAR), (SCALAR), (SCALAR) })
#define VEC_USHORT8_CONST1(SCALAR) \
	(__extension__ (vec_ushort8){ (SCALAR), (SCALAR), (SCALAR), (SCALAR), \
	 (SCALAR), (SCALAR), (SCALAR), (SCALAR) })
#define VEC_INT4_CONST1(SCALAR) \
  (__extension__ (vec_int4){ (SCALAR), (SCALAR), (SCALAR), (SCALAR) })
#define VEC_UINT4_CONST1(SCALAR) \
  (__extension__ (vec_uint4){ (SCALAR), (SCALAR), (SCALAR), (SCALAR) })
#define VEC_FLOAT4_CONST1(SCALAR) \
  (__extension__ (vec_float4){ (SCALAR), (SCALAR), (SCALAR), (SCALAR) })
#else
#define VEC_CHAR16_CONST1(SCALAR) ((vec_char16)(SCALAR))
#define VEC_UCHAR16_CONST1(SCALAR) ((vec_uchar16)(SCALAR))
#define VEC_SHORT8_CONST1(SCALAR) ((vec_short8)(SCALAR))
#define VEC_USHORT8_CONST1(SCALAR) ((vec_ushort8)(SCALAR))
#define VEC_INT4_CONST1(SCALAR) ((vec_int4)(SCALAR))
#define VEC_UINT4_CONST1(SCALAR) ((vec_uint4)(SCALAR))
#define VEC_FLOAT4_CONST1(SCALAR) ((vec_float4)(SCALAR))
#endif

#define VEC_CHAR16(...) \
  (__extension__ (vec_char16){ __VA_ARGS__ })
#define VEC_UCHAR16(...) \
  (__extension__ (vec_uchar16){ __VA_ARGS__ })
#define VEC_SHORT8(...) \
	(__extension__ (vec_short8){ __VA_ARGS__ })
#define VEC_USHORT8(...) \
	(__extension__ (vec_ushort8){ __VA_ARGS__ })
#define VEC_INT4(S1, S2, S3, S4) \
  (__extension__ (vec_int4){ (S1), (S2), (S3), (S4) })
#define VEC_UINT4(S1, S2, S3, S4) \
  (__extension__ (vec_uint4){ (S1), (S2), (S3), (S4) })
#define VEC_FLOAT4(S1, S2, S3, S4) \
  (__extension__ (vec_float4){ (S1), (S2), (S3), (S4) })


#define si_lqd(ra,imm)       __builtin_si_lqd(ra,imm)
#define si_lqx(ra,rb)        __builtin_si_lqx(ra,rb)
#define si_lqa(imm)          __builtin_si_lqa(imm)
#define si_lqr(imm)          __builtin_si_lqr(imm)
#define si_stqd(rt,ra,imm)   __builtin_si_stqd(rt,ra,imm)
#define si_stqx(rt,ra,rb)    __builtin_si_stqx(rt,ra,rb)
#define si_stqa(rt,imm)      __builtin_si_stqa(rt,imm)
#define si_stqr(rt,imm)      __builtin_si_stqr(rt,imm)
#define si_cbd(ra,imm)       __builtin_si_cbd(ra,imm)
#define si_cbx(ra,rb)        __builtin_si_cbx(ra,rb)
#define si_chd(ra,imm)       __builtin_si_chd(ra,imm)
#define si_chx(ra,rb)        __builtin_si_chx(ra,rb)
#define si_cwd(ra,imm)       __builtin_si_cwd(ra,imm)
#define si_cwx(ra,rb)        __builtin_si_cwx(ra,rb)
#define si_cdd(ra,imm)       __builtin_si_cdd(ra,imm)
#define si_cdx(ra,rb)        __builtin_si_cdx(ra,rb)
#define si_ilh(imm)          __builtin_si_ilh(imm)
#define si_ilhu(imm)         __builtin_si_ilhu(imm)
#define si_il(imm)           __builtin_si_il(imm)
#define si_ila(imm)          __builtin_si_ila(imm)
#define si_iohl(ra,imm)      __builtin_si_iohl(ra,imm)
#define si_fsmbi(imm)        __builtin_si_fsmbi(imm)
#define si_ah(ra,rb)         __builtin_si_ah(ra,rb)
#define si_ahi(ra,imm)       __builtin_si_ahi(ra,imm)
#define si_a(ra,rb)          __builtin_si_a(ra,rb)
#define si_ai(ra,imm)        __builtin_si_ai(ra,imm)
#define si_addx(ra,rb,rt)    __builtin_si_addx(ra,rb,rt)
#define si_cg(ra,rb)         __builtin_si_cg(ra,rb)
#define si_cgx(ra,rb,rt)     __builtin_si_cgx(ra,rb,rt)
#define si_sfh(ra,rb)        __builtin_si_sfh(ra,rb)
#define si_sfhi(imm,ra)      __builtin_si_sfhi(imm,ra)
#define si_sf(ra,rb)         __builtin_si_sf(ra,rb)
#define si_sfi(ra,imm)       __builtin_si_sfi(ra,imm)
#define si_sfx(ra,rb,rt)     __builtin_si_sfx(ra,rb,rt)
#define si_bg(ra,rb)         __builtin_si_bg(ra,rb)
#define si_bgx(ra,rb,rt)     __builtin_si_bgx(ra,rb,rt)
#define si_mpy(ra,rb)        __builtin_si_mpy(ra,rb)
#define si_mpyu(ra,rb)       __builtin_si_mpyu(ra,rb)
#define si_mpyi(ra,imm)      __builtin_si_mpyi(ra,imm)
#define si_mpyui(ra,imm)     __builtin_si_mpyui(ra,imm)
#define si_mpya(ra,rb,rc)    __builtin_si_mpya(ra,rb,rc)
#define si_mpyh(ra,rb)       __builtin_si_mpyh(ra,rb)
#define si_mpys(ra,rb)       __builtin_si_mpys(ra,rb)
#define si_mpyhh(ra,rb)      __builtin_si_mpyhh(ra,rb)
#define si_mpyhhu(ra,rb)     __builtin_si_mpyhhu(ra,rb)
#define si_mpyhha(ra,rb,rc)  __builtin_si_mpyhha(ra,rb,rc)
#define si_mpyhhau(ra,rb,rc) __builtin_si_mpyhhau(ra,rb,rc)
#define si_clz(ra)           __builtin_si_clz(ra)
#define si_cntb(ra)          __builtin_si_cntb(ra)
#define si_fsmb(ra)          __builtin_si_fsmb(ra)
#define si_fsmh(ra)          __builtin_si_fsmh(ra)
#define si_fsm(ra)           __builtin_si_fsm(ra)
#define si_gbb(ra)           __builtin_si_gbb(ra)
#define si_gbh(ra)           __builtin_si_gbh(ra)
#define si_gb(ra)            __builtin_si_gb(ra)
#define si_avgb(ra,rb)       __builtin_si_avgb(ra,rb)
#define si_absdb(ra,rb)      __builtin_si_absdb(ra,rb)
#define si_sumb(ra,rb)       __builtin_si_sumb(ra,rb)
#define si_xsbh(ra)          __builtin_si_xsbh(ra)
#define si_xshw(ra)          __builtin_si_xshw(ra)
#define si_xswd(ra)          __builtin_si_xswd(ra)
#define si_and(ra,rb)        __builtin_si_and(ra,rb)
#define si_andc(ra,rb)       __builtin_si_andc(ra,rb)
#define si_andbi(ra,imm)     __builtin_si_andbi(ra,imm)
#define si_andhi(ra,imm)     __builtin_si_andhi(ra,imm)
#define si_andi(ra,imm)      __builtin_si_andi(ra,imm)
#define si_or(ra,rb)         __builtin_si_or(ra,rb)
#define si_orc(ra,rb)        __builtin_si_orc(ra,rb)
#define si_orbi(ra,imm)      __builtin_si_orbi(ra,imm)
#define si_orhi(ra,imm)      __builtin_si_orhi(ra,imm)
#define si_ori(ra,imm)       __builtin_si_ori(ra,imm)
#define si_orx(ra)           __builtin_si_orx(ra)
#define si_xor(ra,rb)        __builtin_si_xor(ra,rb)
#define si_xorbi(ra,imm)     __builtin_si_xorbi(ra,imm)
#define si_xorhi(ra,imm)     __builtin_si_xorhi(ra,imm)
#define si_xori(ra,imm)      __builtin_si_xori(ra,imm)
#define si_nand(ra,rb)       __builtin_si_nand(ra,rb)
#define si_nor(ra,rb)        __builtin_si_nor(ra,rb)
#define si_eqv(ra,rb)        __builtin_si_eqv(ra,rb)
#define si_selb(ra,rb,rc)    __builtin_si_selb(ra,rb,rc)
#define si_shufb(ra,rb,rc)   __builtin_si_shufb(ra,rb,rc)
#define si_shlh(ra,rb)       __builtin_si_shlh(ra,rb)
#define si_shlhi(ra,imm)     __builtin_si_shlhi(ra,imm)
#define si_shl(ra,rb)        __builtin_si_shl(ra,rb)
#define si_shli(ra,imm)      __builtin_si_shli(ra,imm)
#define si_shlqbi(ra,rb)     __builtin_si_shlqbi(ra,rb)
#define si_shlqbii(ra,imm)   __builtin_si_shlqbii(ra,imm)
#define si_shlqby(ra,rb)     __builtin_si_shlqby(ra,rb)
#define si_shlqbyi(ra,imm)   __builtin_si_shlqbyi(ra,imm)
#define si_shlqbybi(ra,rb)   __builtin_si_shlqbybi(ra,rb)
#define si_roth(ra,rb)       __builtin_si_roth(ra,rb)
#define si_rothi(ra,imm)     __builtin_si_rothi(ra,imm)
#define si_rot(ra,rb)        __builtin_si_rot(ra,rb)
#define si_roti(ra,imm)      __builtin_si_roti(ra,imm)
#define si_rotqby(ra,rb)     __builtin_si_rotqby(ra,rb)
#define si_rotqbyi(ra,imm)   __builtin_si_rotqbyi(ra,imm)
#define si_rotqbybi(ra,rb)   __builtin_si_rotqbybi(ra,rb)
#define si_rotqbi(ra,rb)     __builtin_si_rotqbi(ra,rb)
#define si_rotqbii(ra,imm)   __builtin_si_rotqbii(ra,imm)
#define si_rothm(ra,rb)      __builtin_si_rothm(ra,rb)
#define si_rothmi(ra,imm)    __builtin_si_rothmi(ra,imm)
#define si_rotm(ra,rb)       __builtin_si_rotm(ra,rb)
#define si_rotmi(ra,imm)     __builtin_si_rotmi(ra,imm)
#define si_rotqmby(ra,rb)    __builtin_si_rotqmby(ra,rb)
#define si_rotqmbyi(ra,imm)  __builtin_si_rotqmbyi(ra,imm)
#define si_rotqmbi(ra,rb)    __builtin_si_rotqmbi(ra,rb)
#define si_rotqmbii(ra,imm)  __builtin_si_rotqmbii(ra,imm)
#define si_rotqmbybi(ra,rb)  __builtin_si_rotqmbybi(ra,rb)
#define si_rotmah(ra,rb)     __builtin_si_rotmah(ra,rb)
#define si_rotmahi(ra,imm)   __builtin_si_rotmahi(ra,imm)
#define si_rotma(ra,rb)      __builtin_si_rotma(ra,rb)
#define si_rotmai(ra,imm)    __builtin_si_rotmai(ra,imm)
#define si_heq(ra,rb)        __builtin_si_heq(ra,rb)
#define si_heqi(ra,imm)      __builtin_si_heqi(ra,imm)
#define si_hgt(ra,rb)        __builtin_si_hgt(ra,rb)
#define si_hgti(ra,imm)      __builtin_si_hgti(ra,imm)
#define si_hlgt(ra,rb)       __builtin_si_hlgt(ra,rb)
#define si_hlgti(ra,imm)     __builtin_si_hlgti(ra,imm)
#define si_ceqb(ra,rb)       __builtin_si_ceqb(ra,rb)
#define si_ceqbi(ra,imm)     __builtin_si_ceqbi(ra,imm)
#define si_ceqh(ra,rb)       __builtin_si_ceqh(ra,rb)
#define si_ceqhi(ra,imm)     __builtin_si_ceqhi(ra,imm)
#define si_ceq(ra,rb)        __builtin_si_ceq(ra,rb)
#define si_ceqi(ra,imm)      __builtin_si_ceqi(ra,imm)
#define si_cgtb(ra,rb)       __builtin_si_cgtb(ra,rb)
#define si_cgtbi(ra,imm)     __builtin_si_cgtbi(ra,imm)
#define si_cgth(ra,rb)       __builtin_si_cgth(ra,rb)
#define si_cgthi(ra,imm)     __builtin_si_cgthi(ra,imm)
#define si_cgt(ra,rb)        __builtin_si_cgt(ra,rb)
#define si_cgti(ra,imm)      __builtin_si_cgti(ra,imm)
#define si_clgtb(ra,rb)      __builtin_si_clgtb(ra,rb)
#define si_clgtbi(ra,imm)    __builtin_si_clgtbi(ra,imm)
#define si_clgth(ra,rb)      __builtin_si_clgth(ra,rb)
#define si_clgthi(ra,imm)    __builtin_si_clgthi(ra,imm)
#define si_clgt(ra,rb)       __builtin_si_clgt(ra,rb)
#define si_clgti(ra,imm)     __builtin_si_clgti(ra,imm)
#define si_bisled(ra)        __builtin_si_bisled(ra,0)
#define si_bisledd(ra)       __builtin_si_bisledd(ra,0)
#define si_bislede(ra)       __builtin_si_bislede(ra,0)
#define si_fa(ra,rb)         __builtin_si_fa(ra,rb)
#define si_dfa(ra,rb)        __builtin_si_dfa(ra,rb)
#define si_fs(ra,rb)         __builtin_si_fs(ra,rb)
#define si_dfs(ra,rb)        __builtin_si_dfs(ra,rb)
#define si_fm(ra,rb)         __builtin_si_fm(ra,rb)
#define si_dfm(ra,rb)        __builtin_si_dfm(ra,rb)
#define si_fma(ra,rb,rc)     __builtin_si_fma(ra,rb,rc)
#define si_dfma(ra,rb,rc)    __builtin_si_dfma(ra,rb,rc)
#define si_dfnma(ra,rb,rc)   __builtin_si_dfnma(ra,rb,rc)
#define si_fnms(ra,rb,rc)    __builtin_si_fnms(ra,rb,rc)
#define si_dfnms(ra,rb,rc)   __builtin_si_dfnms(ra,rb,rc)
#define si_fms(ra,rb,rc)     __builtin_si_fms(ra,rb,rc)
#define si_dfms(ra,rb,rc)    __builtin_si_dfms(ra,rb,rc)
#define si_frest(ra)         __builtin_si_frest(ra)
#define si_frsqest(ra)       __builtin_si_frsqest(ra)
#define si_fi(ra,rb)         __builtin_si_fi(ra,rb)
#define si_csflt(ra,imm)     __builtin_si_csflt(ra,imm)
#define si_cflts(ra,imm)     __builtin_si_cflts(ra,imm)
#define si_cuflt(ra,imm)     __builtin_si_cuflt(ra,imm)
#define si_cfltu(ra,imm)     __builtin_si_cfltu(ra,imm)
#define si_frds(ra)          __builtin_si_frds(ra)
#define si_fesd(ra)          __builtin_si_fesd(ra)
#define si_fceq(ra,rb)       __builtin_si_fceq(ra,rb)
#define si_fcmeq(ra,rb)      __builtin_si_fcmeq(ra,rb)
#define si_fcgt(ra,rb)       __builtin_si_fcgt(ra,rb)
#define si_fcmgt(ra,rb)      __builtin_si_fcmgt(ra,rb)
#define si_stop(imm)         __builtin_si_stop(imm)
#define si_stopd(ra,rb,rc)   __builtin_si_stopd(ra,rb,rc)
#define si_lnop()            __builtin_si_lnop()
#define si_nop()             __builtin_si_nop()
#define si_sync()            __builtin_si_sync()
#define si_syncc()           __builtin_si_syncc()
#define si_dsync()           __builtin_si_dsync()
#define si_mfspr(imm)        __builtin_si_mfspr(imm)
#define si_mtspr(imm,ra)     __builtin_si_mtspr(imm,ra)
#define si_fscrrd()          __builtin_si_fscrrd()
#define si_fscrwr(ra)        __builtin_si_fscrwr(ra)
#define si_rdch(imm)         __builtin_si_rdch(imm)
#define si_rchcnt(imm)       __builtin_si_rchcnt(imm)
#define si_wrch(imm,ra)      __builtin_si_wrch(imm,ra)

#define si_from_char(scalar)    __builtin_si_from_char(scalar)
#define si_from_uchar(scalar)   __builtin_si_from_uchar(scalar)
#define si_from_short(scalar)   __builtin_si_from_short(scalar)
#define si_from_ushort(scalar)  __builtin_si_from_ushort(scalar)
#define si_from_int(scalar)     __builtin_si_from_int(scalar)
#define si_from_uint(scalar)    __builtin_si_from_uint(scalar)
#define si_from_llong(scalar)   __builtin_si_from_long(scalar)
#define si_from_ullong(scalar)  __builtin_si_from_ulong(scalar)
#define si_from_float(scalar)   __builtin_si_from_float(scalar)
#define si_from_double(scalar)  __builtin_si_from_double(scalar)
#define si_from_ptr(scalar)     __builtin_si_from_ptr(scalar)

#define si_to_char(ra)      __builtin_si_to_char(ra)
#define si_to_uchar(ra)     __builtin_si_to_uchar(ra)
#define si_to_short(ra)     __builtin_si_to_short(ra)
#define si_to_ushort(ra)    __builtin_si_to_ushort(ra)
#define si_to_int(ra)       __builtin_si_to_int(ra)
#define si_to_uint(ra)      __builtin_si_to_uint(ra)
#define si_to_llong(ra)     __builtin_si_to_long(ra)
#define si_to_ullong(ra)    __builtin_si_to_ulong(ra)
#define si_to_float(ra)     __builtin_si_to_float(ra)
#define si_to_double(ra)    __builtin_si_to_double(ra)
#define si_to_ptr(ra)       __builtin_si_to_ptr(ra)

#define __align_hint(ptr,base,offset) __builtin_spu_align_hint(ptr,base,offset)

#ifndef __cplusplus

/* generic spu_* intrinisics */ 

#define spu_splats(scalar)        __builtin_spu_splats(scalar) 
#define spu_convtf(ra,imm)        __builtin_spu_convtf(ra,imm)
#define spu_convts(ra,imm)        __builtin_spu_convts(ra,imm)
#define spu_convtu(ra,imm)        __builtin_spu_convtu(ra,imm) 
#define spu_extend(ra)            __builtin_spu_extend(ra) 
#define spu_roundtf(ra)           __builtin_spu_roundtf(ra) 
#define spu_add(ra,rb)            __builtin_spu_add(ra,rb) 
#define spu_addx(ra,rb,rt)        __builtin_spu_addx(ra,rb,rt) 
#define spu_genc(ra,rb)           __builtin_spu_genc(ra,rb) 
#define spu_gencx(ra,rb,rt)       __builtin_spu_gencx(ra,rb,rt) 
#define spu_madd(ra,rb,rc)        __builtin_spu_madd(ra,rb,rc)
#define spu_nmadd(ra,rb,rc)       __builtin_spu_nmadd(ra,rb,rc)
#define spu_mhhadd(ra,rb,rc)      __builtin_spu_mhhadd(ra,rb,rc)
#define spu_msub(ra,rb,rc)        __builtin_spu_msub(ra,rb,rc) 
#define spu_mul(ra,rb)            __builtin_spu_mul(ra,rb) 
#define spu_mulh(ra,rb)           __builtin_spu_mulh(ra,rb) 
#define spu_mule(ra,rb)           __builtin_spu_mule(ra,rb) 
#define spu_mulo(ra,rb)           __builtin_spu_mulo(ra,rb) 
#define spu_mulsr(ra,rb)          __builtin_spu_mulsr(ra,rb) 
#define spu_nmsub(ra,rb,rc)       __builtin_spu_nmsub(ra,rb,rc) 
#define spu_sub(ra,rb)            __builtin_spu_sub(ra,rb)
#define spu_subx(ra,rb,rt)        __builtin_spu_subx(ra,rb,rt) 
#define spu_genb(ra,rb)           __builtin_spu_genb(ra,rb) 
#define spu_genbx(ra,rb,rt)       __builtin_spu_genbx(ra,rb,rt) 
#define spu_absd(ra,rb)           __builtin_spu_absd(ra,rb) 
#define spu_avg(ra,rb)            __builtin_spu_avg(ra,rb) 
#define spu_sumb(ra,rb)           __builtin_spu_sumb(ra,rb) 
#define spu_bisled(ra)            __builtin_spu_bisled(ra, 0)
#define spu_bisled_d(ra)          __builtin_spu_bisled_d(ra, 0)
#define spu_bisled_e(ra)          __builtin_spu_bisled_e(ra, 0)
#define spu_cmpabseq(ra,rb)       __builtin_spu_cmpabseq(ra,rb) 
#define spu_cmpabsgt(ra,rb)       __builtin_spu_cmpabsgt(ra,rb) 
#define spu_cmpeq(ra,rb)          __builtin_spu_cmpeq(ra,rb) 
#define spu_cmpgt(ra,rb)          __builtin_spu_cmpgt(ra,rb) 
#define spu_hcmpeq(ra,rb)         __builtin_spu_hcmpeq(ra,rb) 
#define spu_hcmpgt(ra,rb)         __builtin_spu_hcmpgt(ra,rb) 
#define spu_cntb(ra)              __builtin_spu_cntb(ra) 
#define spu_cntlz(ra)             __builtin_spu_cntlz(ra) 
#define spu_gather(ra)            __builtin_spu_gather(ra) 
#define spu_maskb(ra)             __builtin_spu_maskb(ra) 
#define spu_maskh(ra)             __builtin_spu_maskh(ra) 
#define spu_maskw(ra)             __builtin_spu_maskw(ra) 
#define spu_sel(ra,rb,rc)         __builtin_spu_sel(ra,rb,rc) 
#define spu_shuffle(ra,rb,rc)     __builtin_spu_shuffle(ra,rb,rc) 
#define spu_and(ra,rb)            __builtin_spu_and(ra,rb) 
#define spu_andc(ra,rb)           __builtin_spu_andc(ra,rb) 
#define spu_eqv(ra,rb)            __builtin_spu_eqv(ra,rb) 
#define spu_nand(ra,rb)           __builtin_spu_nand(ra,rb)
#define spu_nor(ra,rb)            __builtin_spu_nor(ra,rb) 
#define spu_or(ra,rb)             __builtin_spu_or(ra,rb) 
#define spu_orc(ra,rb)            __builtin_spu_orc(ra,rb) 
#define spu_orx(ra)               __builtin_spu_orx(ra)
#define spu_xor(ra,rb)            __builtin_spu_xor(ra,rb) 
#define spu_rl(ra,rb)             __builtin_spu_rl(ra,rb) 
#define spu_rlqw(ra,count)        __builtin_spu_rlqw(ra,count) 
#define spu_rlqwbyte(ra,count)    __builtin_spu_rlqwbyte(ra,count) 
#define spu_rlqwbytebc(ra,count)  __builtin_spu_rlqwbytebc(ra,count) 
#define spu_rlmask(ra,rb)         __builtin_spu_rlmask(ra,rb) 
#define spu_rlmaska(ra,rb)        __builtin_spu_rlmaska(ra,rb) 
#define spu_rlmaskqw(ra,rb)       __builtin_spu_rlmaskqw(ra,rb) 
#define spu_rlmaskqwbyte(ra,rb)   __builtin_spu_rlmaskqwbyte(ra,rb) 
#define spu_rlmaskqwbytebc(ra,rb) __builtin_spu_rlmaskqwbytebc(ra,rb) 
#define spu_sl(ra,rb)             __builtin_spu_sl(ra,rb) 
#define spu_slqw(ra,rb)           __builtin_spu_slqw(ra,rb) 
#define spu_slqwbyte(ra,rb)       __builtin_spu_slqwbyte(ra,rb) 
#define spu_slqwbytebc(ra,rb)     __builtin_spu_slqwbytebc(ra,rb) 
#define spu_extract(ra,pos)       __builtin_spu_extract(ra,pos) 
#define spu_insert(scalar,ra,pos) __builtin_spu_insert(scalar,ra,pos) 
#define spu_promote(scalar,pos)   __builtin_spu_promote(scalar,pos) 

#else /* __cplusplus */

/* A bit of a hack...  Float conversion needs an immediate operand.
 * always_inline doesn't help because the compiler generates an error
 * before inlining happens. */
static inline vec_float4 __hack_spu_convtf (vec_int4, vec_float4, vec_float4) __attribute__((__always_inline__));
static inline vec_float4 __hack_spu_convtf (vec_uint4, vec_float4, vec_float4) __attribute__((__always_inline__));
static inline vec_float4
__hack_spu_convtf (vec_int4 ra, vec_float4 from_signed, vec_float4 from_unsigned)
{
  (void)ra;
  (void)from_unsigned;
  return from_signed;
}
static inline vec_float4
__hack_spu_convtf (vec_uint4 ra, vec_float4 from_signed, vec_float4 from_unsigned)
{
  (void)ra;
  (void)from_signed;
  return from_unsigned;
}
#define spu_convtf(ra,imm) \
  __hack_spu_convtf((ra), \
	            __builtin_spu_convtf_1((vec_int4)(ra), (imm)), \
		    __builtin_spu_convtf_0((vec_uint4)(ra), (imm)))

/* The following defines and functions were created automatically from
 * spu_builtins.def. */
#define spu_convts(a, b)	__builtin_spu_convts (a, b)
#define spu_convtu(a, b)	__builtin_spu_convtu (a, b)
#define spu_roundtf(a)		__builtin_spu_roundtf (a)
#define spu_mulh(a, b)		__builtin_spu_mulh (a, b)
#define spu_mulsr(a, b)		__builtin_spu_mulsr (a, b)
#define spu_frest(a)		__builtin_spu_frest (a)
#define spu_frsqest(a)		__builtin_spu_frsqest (a)
#define spu_nmadd(a, b, c)	__builtin_spu_nmadd (a, b, c)
#define spu_absd(a, b)		__builtin_spu_absd (a, b)
#define spu_avg(a, b)		__builtin_spu_avg (a, b)
#define spu_sumb(a, b)		__builtin_spu_sumb (a, b)
#define spu_bisled(a)		__builtin_spu_bisled (a, 0)
#define spu_bisled_d(a)		__builtin_spu_bisled_d (a, 0)
#define spu_bisled_e(a)		__builtin_spu_bisled_e (a, 0)
#define spu_cmpabseq(a, b)	__builtin_spu_cmpabseq (a, b)
#define spu_cmpabsgt(a, b)	__builtin_spu_cmpabsgt (a, b)

static inline vec_short8 spu_extend (vec_char16 a) __attribute__((__always_inline__));
static inline vec_int4 spu_extend (vec_short8 a) __attribute__((__always_inline__));
static inline vec_llong2 spu_extend (vec_int4 a) __attribute__((__always_inline__));
static inline vec_double2 spu_extend (vec_float4 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_add (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_add (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_add (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_add (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_float4 spu_add (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_add (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_add (vec_ushort8 a, unsigned short b) __attribute__((__always_inline__));
static inline vec_short8 spu_add (vec_short8 a, short b) __attribute__((__always_inline__));
static inline vec_uint4 spu_add (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_int4 spu_add (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_addx (vec_int4 a, vec_int4 b, vec_int4 c) __attribute__((__always_inline__));
static inline vec_uint4 spu_addx (vec_uint4 a, vec_uint4 b, vec_uint4 c) __attribute__((__always_inline__));
static inline vec_int4 spu_genc (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_genc (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_gencx (vec_int4 a, vec_int4 b, vec_int4 c) __attribute__((__always_inline__));
static inline vec_uint4 spu_gencx (vec_uint4 a, vec_uint4 b, vec_uint4 c) __attribute__((__always_inline__));
static inline vec_int4 spu_madd (vec_short8 a, vec_short8 b, vec_int4 c) __attribute__((__always_inline__));
static inline vec_float4 spu_madd (vec_float4 a, vec_float4 b, vec_float4 c) __attribute__((__always_inline__));
static inline vec_double2 spu_madd (vec_double2 a, vec_double2 b, vec_double2 c) __attribute__((__always_inline__));
static inline vec_float4 spu_msub (vec_float4 a, vec_float4 b, vec_float4 c) __attribute__((__always_inline__));
static inline vec_double2 spu_msub (vec_double2 a, vec_double2 b, vec_double2 c) __attribute__((__always_inline__));
static inline vec_uint4 spu_mhhadd (vec_ushort8 a, vec_ushort8 b, vec_uint4 c) __attribute__((__always_inline__));
static inline vec_int4 spu_mhhadd (vec_short8 a, vec_short8 b, vec_int4 c) __attribute__((__always_inline__));
static inline vec_uint4 spu_mule (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_int4 spu_mule (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_float4 spu_mul (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_mul (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_int4 spu_mulo (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_mulo (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_int4 spu_mulo (vec_short8 a, short b) __attribute__((__always_inline__));
static inline vec_uint4 spu_mulo (vec_ushort8 a, unsigned short b) __attribute__((__always_inline__));
static inline vec_float4 spu_nmsub (vec_float4 a, vec_float4 b, vec_float4 c) __attribute__((__always_inline__));
static inline vec_double2 spu_nmsub (vec_double2 a, vec_double2 b, vec_double2 c) __attribute__((__always_inline__));
static inline vec_ushort8 spu_sub (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_sub (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_sub (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_sub (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_float4 spu_sub (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_sub (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_sub (unsigned short a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_sub (short a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_sub (unsigned int a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_sub (int a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_subx (vec_uint4 a, vec_uint4 b, vec_uint4 c) __attribute__((__always_inline__));
static inline vec_int4 spu_subx (vec_int4 a, vec_int4 b, vec_int4 c) __attribute__((__always_inline__));
static inline vec_uint4 spu_genb (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_genb (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_genbx (vec_uint4 a, vec_uint4 b, vec_uint4 c) __attribute__((__always_inline__));
static inline vec_int4 spu_genbx (vec_int4 a, vec_int4 b, vec_int4 c) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cmpeq (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cmpeq (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_cmpeq (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_cmpeq (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpeq (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpeq (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpeq (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cmpeq (vec_uchar16 a, unsigned char b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cmpeq (vec_char16 a, signed char b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_cmpeq (vec_ushort8 a, unsigned short b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_cmpeq (vec_short8 a, short b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpeq (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpeq (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cmpgt (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cmpgt (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_cmpgt (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_cmpgt (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpgt (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpgt (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpgt (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cmpgt (vec_uchar16 a, unsigned char b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cmpgt (vec_char16 a, signed char b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_cmpgt (vec_ushort8 a, unsigned short b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_cmpgt (vec_short8 a, short b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpgt (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_cmpgt (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline void spu_hcmpeq (int a, int b) __attribute__((__always_inline__));
static inline void spu_hcmpeq (unsigned int a, unsigned int b) __attribute__((__always_inline__));
static inline void spu_hcmpgt (int a, int b) __attribute__((__always_inline__));
static inline void spu_hcmpgt (unsigned int a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cntb (vec_char16 a) __attribute__((__always_inline__));
static inline vec_uchar16 spu_cntb (vec_uchar16 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_cntlz (vec_int4 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_cntlz (vec_uint4 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_cntlz (vec_float4 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_gather (vec_int4 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_gather (vec_uint4 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_gather (vec_short8 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_gather (vec_ushort8 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_gather (vec_char16 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_gather (vec_uchar16 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_gather (vec_float4 a) __attribute__((__always_inline__));
static inline vec_uchar16 spu_maskb (unsigned short a) __attribute__((__always_inline__));
static inline vec_uchar16 spu_maskb (short a) __attribute__((__always_inline__));
static inline vec_uchar16 spu_maskb (unsigned int a) __attribute__((__always_inline__));
static inline vec_uchar16 spu_maskb (int a) __attribute__((__always_inline__));
static inline vec_ushort8 spu_maskh (unsigned char a) __attribute__((__always_inline__));
static inline vec_ushort8 spu_maskh (signed char a) __attribute__((__always_inline__));
static inline vec_ushort8 spu_maskh (char a) __attribute__((__always_inline__));
static inline vec_ushort8 spu_maskh (unsigned short a) __attribute__((__always_inline__));
static inline vec_ushort8 spu_maskh (short a) __attribute__((__always_inline__));
static inline vec_ushort8 spu_maskh (unsigned int a) __attribute__((__always_inline__));
static inline vec_ushort8 spu_maskh (int a) __attribute__((__always_inline__));
static inline vec_uint4 spu_maskw (unsigned char a) __attribute__((__always_inline__));
static inline vec_uint4 spu_maskw (signed char a) __attribute__((__always_inline__));
static inline vec_uint4 spu_maskw (char a) __attribute__((__always_inline__));
static inline vec_uint4 spu_maskw (unsigned short a) __attribute__((__always_inline__));
static inline vec_uint4 spu_maskw (short a) __attribute__((__always_inline__));
static inline vec_uint4 spu_maskw (unsigned int a) __attribute__((__always_inline__));
static inline vec_uint4 spu_maskw (int a) __attribute__((__always_inline__));
static inline vec_llong2 spu_sel (vec_llong2 a, vec_llong2 b, vec_ullong2 c) __attribute__((__always_inline__));
static inline vec_ullong2 spu_sel (vec_ullong2 a, vec_ullong2 b, vec_ullong2 c) __attribute__((__always_inline__));
static inline vec_int4 spu_sel (vec_int4 a, vec_int4 b, vec_uint4 c) __attribute__((__always_inline__));
static inline vec_uint4 spu_sel (vec_uint4 a, vec_uint4 b, vec_uint4 c) __attribute__((__always_inline__));
static inline vec_short8 spu_sel (vec_short8 a, vec_short8 b, vec_ushort8 c) __attribute__((__always_inline__));
static inline vec_ushort8 spu_sel (vec_ushort8 a, vec_ushort8 b, vec_ushort8 c) __attribute__((__always_inline__));
static inline vec_char16 spu_sel (vec_char16 a, vec_char16 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_uchar16 spu_sel (vec_uchar16 a, vec_uchar16 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_float4 spu_sel (vec_float4 a, vec_float4 b, vec_uint4 c) __attribute__((__always_inline__));
static inline vec_double2 spu_sel (vec_double2 a, vec_double2 b, vec_ullong2 c) __attribute__((__always_inline__));
static inline vec_llong2 spu_sel (vec_llong2 a, vec_llong2 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_ullong2 spu_sel (vec_ullong2 a, vec_ullong2 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_int4 spu_sel (vec_int4 a, vec_int4 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_uint4 spu_sel (vec_uint4 a, vec_uint4 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_short8 spu_sel (vec_short8 a, vec_short8 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_ushort8 spu_sel (vec_ushort8 a, vec_ushort8 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_float4 spu_sel (vec_float4 a, vec_float4 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_double2 spu_sel (vec_double2 a, vec_double2 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_uchar16 spu_shuffle (vec_uchar16 a, vec_uchar16 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_char16 spu_shuffle (vec_char16 a, vec_char16 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_ushort8 spu_shuffle (vec_ushort8 a, vec_ushort8 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_short8 spu_shuffle (vec_short8 a, vec_short8 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_uint4 spu_shuffle (vec_uint4 a, vec_uint4 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_int4 spu_shuffle (vec_int4 a, vec_int4 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_ullong2 spu_shuffle (vec_ullong2 a, vec_ullong2 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_llong2 spu_shuffle (vec_llong2 a, vec_llong2 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_float4 spu_shuffle (vec_float4 a, vec_float4 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_double2 spu_shuffle (vec_double2 a, vec_double2 b, vec_uchar16 c) __attribute__((__always_inline__));
static inline vec_uchar16 spu_and (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_char16 spu_and (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_and (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_and (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_and (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_and (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_and (vec_ullong2 a, vec_ullong2 b) __attribute__((__always_inline__));
static inline vec_llong2 spu_and (vec_llong2 a, vec_llong2 b) __attribute__((__always_inline__));
static inline vec_float4 spu_and (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_and (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_and (vec_uchar16 a, unsigned char b) __attribute__((__always_inline__));
static inline vec_char16 spu_and (vec_char16 a, signed char b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_and (vec_ushort8 a, unsigned short b) __attribute__((__always_inline__));
static inline vec_short8 spu_and (vec_short8 a, short b) __attribute__((__always_inline__));
static inline vec_uint4 spu_and (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_int4 spu_and (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_andc (vec_llong2 a, vec_llong2 b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_andc (vec_ullong2 a, vec_ullong2 b) __attribute__((__always_inline__));
static inline vec_int4 spu_andc (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_andc (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_short8 spu_andc (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_andc (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_char16 spu_andc (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_andc (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_float4 spu_andc (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_andc (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_llong2 spu_eqv (vec_llong2 a, vec_llong2 b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_eqv (vec_ullong2 a, vec_ullong2 b) __attribute__((__always_inline__));
static inline vec_int4 spu_eqv (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_eqv (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_short8 spu_eqv (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_eqv (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_char16 spu_eqv (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_eqv (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_float4 spu_eqv (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_eqv (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_llong2 spu_nand (vec_llong2 a, vec_llong2 b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_nand (vec_ullong2 a, vec_ullong2 b) __attribute__((__always_inline__));
static inline vec_int4 spu_nand (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_nand (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_short8 spu_nand (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_nand (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_char16 spu_nand (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_nand (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_float4 spu_nand (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_nand (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_llong2 spu_nor (vec_llong2 a, vec_llong2 b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_nor (vec_ullong2 a, vec_ullong2 b) __attribute__((__always_inline__));
static inline vec_int4 spu_nor (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_nor (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_short8 spu_nor (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_nor (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_char16 spu_nor (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_nor (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_float4 spu_nor (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_nor (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_or (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_char16 spu_or (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_or (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_or (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_or (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_or (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_or (vec_ullong2 a, vec_ullong2 b) __attribute__((__always_inline__));
static inline vec_llong2 spu_or (vec_llong2 a, vec_llong2 b) __attribute__((__always_inline__));
static inline vec_float4 spu_or (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_or (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_or (vec_uchar16 a, unsigned char b) __attribute__((__always_inline__));
static inline vec_char16 spu_or (vec_char16 a, signed char b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_or (vec_ushort8 a, unsigned short b) __attribute__((__always_inline__));
static inline vec_short8 spu_or (vec_short8 a, short b) __attribute__((__always_inline__));
static inline vec_uint4 spu_or (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_int4 spu_or (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_orc (vec_llong2 a, vec_llong2 b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_orc (vec_ullong2 a, vec_ullong2 b) __attribute__((__always_inline__));
static inline vec_int4 spu_orc (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_orc (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_short8 spu_orc (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_orc (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_char16 spu_orc (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_orc (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_float4 spu_orc (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_orc (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_int4 spu_orx (vec_int4 a) __attribute__((__always_inline__));
static inline vec_uint4 spu_orx (vec_uint4 a) __attribute__((__always_inline__));
static inline vec_uchar16 spu_xor (vec_uchar16 a, vec_uchar16 b) __attribute__((__always_inline__));
static inline vec_char16 spu_xor (vec_char16 a, vec_char16 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_xor (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_xor (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_xor (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_xor (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_xor (vec_ullong2 a, vec_ullong2 b) __attribute__((__always_inline__));
static inline vec_llong2 spu_xor (vec_llong2 a, vec_llong2 b) __attribute__((__always_inline__));
static inline vec_float4 spu_xor (vec_float4 a, vec_float4 b) __attribute__((__always_inline__));
static inline vec_double2 spu_xor (vec_double2 a, vec_double2 b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_xor (vec_uchar16 a, unsigned char b) __attribute__((__always_inline__));
static inline vec_char16 spu_xor (vec_char16 a, signed char b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_xor (vec_ushort8 a, unsigned short b) __attribute__((__always_inline__));
static inline vec_short8 spu_xor (vec_short8 a, short b) __attribute__((__always_inline__));
static inline vec_uint4 spu_xor (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_int4 spu_xor (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rl (vec_ushort8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_rl (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rl (vec_uint4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_rl (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rl (vec_ushort8 a, short b) __attribute__((__always_inline__));
static inline vec_short8 spu_rl (vec_short8 a, short b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rl (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_rl (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_rlqw (vec_uchar16 a, int b) __attribute__((__always_inline__));
static inline vec_char16 spu_rlqw (vec_char16 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlqw (vec_ushort8 a, int b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlqw (vec_short8 a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlqw (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlqw (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_rlqw (vec_ullong2 a, int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_rlqw (vec_llong2 a, int b) __attribute__((__always_inline__));
static inline vec_float4 spu_rlqw (vec_float4 a, int b) __attribute__((__always_inline__));
static inline vec_double2 spu_rlqw (vec_double2 a, int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_rlqwbyte (vec_uchar16 a, int b) __attribute__((__always_inline__));
static inline vec_char16 spu_rlqwbyte (vec_char16 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlqwbyte (vec_ushort8 a, int b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlqwbyte (vec_short8 a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlqwbyte (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlqwbyte (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_rlqwbyte (vec_ullong2 a, int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_rlqwbyte (vec_llong2 a, int b) __attribute__((__always_inline__));
static inline vec_float4 spu_rlqwbyte (vec_float4 a, int b) __attribute__((__always_inline__));
static inline vec_double2 spu_rlqwbyte (vec_double2 a, int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_rlqwbytebc (vec_uchar16 a, int b) __attribute__((__always_inline__));
static inline vec_char16 spu_rlqwbytebc (vec_char16 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlqwbytebc (vec_ushort8 a, int b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlqwbytebc (vec_short8 a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlqwbytebc (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlqwbytebc (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_rlqwbytebc (vec_ullong2 a, int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_rlqwbytebc (vec_llong2 a, int b) __attribute__((__always_inline__));
static inline vec_float4 spu_rlqwbytebc (vec_float4 a, int b) __attribute__((__always_inline__));
static inline vec_double2 spu_rlqwbytebc (vec_double2 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlmask (vec_ushort8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlmask (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlmask (vec_uint4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlmask (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlmask (vec_ushort8 a, int b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlmask (vec_short8 a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlmask (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlmask (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlmaska (vec_ushort8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlmaska (vec_short8 a, vec_short8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlmaska (vec_uint4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlmaska (vec_int4 a, vec_int4 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlmaska (vec_ushort8 a, int b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlmaska (vec_short8 a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlmaska (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlmaska (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_rlmaskqw (vec_uchar16 a, int b) __attribute__((__always_inline__));
static inline vec_char16 spu_rlmaskqw (vec_char16 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlmaskqw (vec_ushort8 a, int b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlmaskqw (vec_short8 a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlmaskqw (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlmaskqw (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_rlmaskqw (vec_ullong2 a, int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_rlmaskqw (vec_llong2 a, int b) __attribute__((__always_inline__));
static inline vec_float4 spu_rlmaskqw (vec_float4 a, int b) __attribute__((__always_inline__));
static inline vec_double2 spu_rlmaskqw (vec_double2 a, int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_rlmaskqwbyte (vec_uchar16 a, int b) __attribute__((__always_inline__));
static inline vec_char16 spu_rlmaskqwbyte (vec_char16 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlmaskqwbyte (vec_ushort8 a, int b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlmaskqwbyte (vec_short8 a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlmaskqwbyte (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlmaskqwbyte (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_rlmaskqwbyte (vec_ullong2 a, int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_rlmaskqwbyte (vec_llong2 a, int b) __attribute__((__always_inline__));
static inline vec_float4 spu_rlmaskqwbyte (vec_float4 a, int b) __attribute__((__always_inline__));
static inline vec_double2 spu_rlmaskqwbyte (vec_double2 a, int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_rlmaskqwbytebc (vec_uchar16 a, int b) __attribute__((__always_inline__));
static inline vec_char16 spu_rlmaskqwbytebc (vec_char16 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_rlmaskqwbytebc (vec_ushort8 a, int b) __attribute__((__always_inline__));
static inline vec_short8 spu_rlmaskqwbytebc (vec_short8 a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_rlmaskqwbytebc (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_rlmaskqwbytebc (vec_int4 a, int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_rlmaskqwbytebc (vec_ullong2 a, int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_rlmaskqwbytebc (vec_llong2 a, int b) __attribute__((__always_inline__));
static inline vec_float4 spu_rlmaskqwbytebc (vec_float4 a, int b) __attribute__((__always_inline__));
static inline vec_double2 spu_rlmaskqwbytebc (vec_double2 a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_sl (vec_ushort8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_short8 spu_sl (vec_short8 a, vec_ushort8 b) __attribute__((__always_inline__));
static inline vec_uint4 spu_sl (vec_uint4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_int4 spu_sl (vec_int4 a, vec_uint4 b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_sl (vec_ushort8 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_short8 spu_sl (vec_short8 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_sl (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_int4 spu_sl (vec_int4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_slqw (vec_llong2 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_slqw (vec_ullong2 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_int4 spu_slqw (vec_int4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_slqw (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_short8 spu_slqw (vec_short8 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_slqw (vec_ushort8 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_char16 spu_slqw (vec_char16 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_slqw (vec_uchar16 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_float4 spu_slqw (vec_float4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_double2 spu_slqw (vec_double2 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_slqwbyte (vec_llong2 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_slqwbyte (vec_ullong2 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_int4 spu_slqwbyte (vec_int4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_slqwbyte (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_short8 spu_slqwbyte (vec_short8 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_slqwbyte (vec_ushort8 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_char16 spu_slqwbyte (vec_char16 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_slqwbyte (vec_uchar16 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_float4 spu_slqwbyte (vec_float4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_double2 spu_slqwbyte (vec_double2 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_slqwbytebc (vec_llong2 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_slqwbytebc (vec_ullong2 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_int4 spu_slqwbytebc (vec_int4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_slqwbytebc (vec_uint4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_short8 spu_slqwbytebc (vec_short8 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_slqwbytebc (vec_ushort8 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_char16 spu_slqwbytebc (vec_char16 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_slqwbytebc (vec_uchar16 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_float4 spu_slqwbytebc (vec_float4 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_double2 spu_slqwbytebc (vec_double2 a, unsigned int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_splats (unsigned char a) __attribute__((__always_inline__));
static inline vec_char16 spu_splats (signed char a) __attribute__((__always_inline__));
static inline vec_char16 spu_splats (char a) __attribute__((__always_inline__));
static inline vec_ushort8 spu_splats (unsigned short a) __attribute__((__always_inline__));
static inline vec_short8 spu_splats (short a) __attribute__((__always_inline__));
static inline vec_uint4 spu_splats (unsigned int a) __attribute__((__always_inline__));
static inline vec_int4 spu_splats (int a) __attribute__((__always_inline__));
static inline vec_ullong2 spu_splats (unsigned long long a) __attribute__((__always_inline__));
static inline vec_llong2 spu_splats (long long a) __attribute__((__always_inline__));
static inline vec_float4 spu_splats (float a) __attribute__((__always_inline__));
static inline vec_double2 spu_splats (double a) __attribute__((__always_inline__));
static inline unsigned char spu_extract (vec_uchar16 a, int b) __attribute__((__always_inline__));
static inline signed char spu_extract (vec_char16 a, int b) __attribute__((__always_inline__));
static inline unsigned short spu_extract (vec_ushort8 a, int b) __attribute__((__always_inline__));
static inline short spu_extract (vec_short8 a, int b) __attribute__((__always_inline__));
static inline unsigned int spu_extract (vec_uint4 a, int b) __attribute__((__always_inline__));
static inline int spu_extract (vec_int4 a, int b) __attribute__((__always_inline__));
static inline unsigned long long spu_extract (vec_ullong2 a, int b) __attribute__((__always_inline__));
static inline long long spu_extract (vec_llong2 a, int b) __attribute__((__always_inline__));
static inline float spu_extract (vec_float4 a, int b) __attribute__((__always_inline__));
static inline double spu_extract (vec_double2 a, int b) __attribute__((__always_inline__));
static inline vec_uchar16 spu_insert (unsigned char a, vec_uchar16 b, int c) __attribute__((__always_inline__));
static inline vec_char16 spu_insert (signed char a, vec_char16 b, int c) __attribute__((__always_inline__));
static inline vec_ushort8 spu_insert (unsigned short a, vec_ushort8 b, int c) __attribute__((__always_inline__));
static inline vec_short8 spu_insert (short a, vec_short8 b, int c) __attribute__((__always_inline__));
static inline vec_uint4 spu_insert (unsigned int a, vec_uint4 b, int c) __attribute__((__always_inline__));
static inline vec_int4 spu_insert (int a, vec_int4 b, int c) __attribute__((__always_inline__));
static inline vec_ullong2 spu_insert (unsigned long long a, vec_ullong2 b, int c) __attribute__((__always_inline__));
static inline vec_llong2 spu_insert (long long a, vec_llong2 b, int c) __attribute__((__always_inline__));
static inline vec_float4 spu_insert (float a, vec_float4 b, int c) __attribute__((__always_inline__));
static inline vec_double2 spu_insert (double a, vec_double2 b, int c) __attribute__((__always_inline__));
static inline vec_uchar16 spu_promote (unsigned char a, int b) __attribute__((__always_inline__));
static inline vec_char16 spu_promote (signed char a, int b) __attribute__((__always_inline__));
static inline vec_char16 spu_promote (char a, int b) __attribute__((__always_inline__));
static inline vec_ushort8 spu_promote (unsigned short a, int b) __attribute__((__always_inline__));
static inline vec_short8 spu_promote (short a, int b) __attribute__((__always_inline__));
static inline vec_uint4 spu_promote (unsigned int a, int b) __attribute__((__always_inline__));
static inline vec_int4 spu_promote (int a, int b) __attribute__((__always_inline__));
static inline vec_ullong2 spu_promote (unsigned long long a, int b) __attribute__((__always_inline__));
static inline vec_llong2 spu_promote (long long a, int b) __attribute__((__always_inline__));
static inline vec_float4 spu_promote (float a, int b) __attribute__((__always_inline__));
static inline vec_double2 spu_promote (double a, int b) __attribute__((__always_inline__));

static inline vec_short8
spu_extend (vec_char16 a)
{
  return __builtin_spu_extend_0 (a);
}
static inline vec_int4
spu_extend (vec_short8 a)
{
  return __builtin_spu_extend_1 (a);
}
static inline vec_llong2
spu_extend (vec_int4 a)
{
  return __builtin_spu_extend_2 (a);
}
static inline vec_double2
spu_extend (vec_float4 a)
{
  return __builtin_spu_extend_3 (a);
}
static inline vec_uint4
spu_add (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_add_0 (a, b);
}
static inline vec_int4
spu_add (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_add_1 (a, b);
}
static inline vec_ushort8
spu_add (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_add_2 (a, b);
}
static inline vec_short8
spu_add (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_add_3 (a, b);
}
static inline vec_float4
spu_add (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_add_4 (a, b);
}
static inline vec_double2
spu_add (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_add_5 (a, b);
}
static inline vec_ushort8
spu_add (vec_ushort8 a, unsigned short b)
{
  return __builtin_spu_add_6 (a, b);
}
static inline vec_short8
spu_add (vec_short8 a, short b)
{
  return __builtin_spu_add_7 (a, b);
}
static inline vec_uint4
spu_add (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_add_8 (a, b);
}
static inline vec_int4
spu_add (vec_int4 a, int b)
{
  return __builtin_spu_add_9 (a, b);
}
static inline vec_int4
spu_addx (vec_int4 a, vec_int4 b, vec_int4 c)
{
  return __builtin_spu_addx_0 (a, b, c);
}
static inline vec_uint4
spu_addx (vec_uint4 a, vec_uint4 b, vec_uint4 c)
{
  return __builtin_spu_addx_1 (a, b, c);
}
static inline vec_int4
spu_genc (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_genc_0 (a, b);
}
static inline vec_uint4
spu_genc (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_genc_1 (a, b);
}
static inline vec_int4
spu_gencx (vec_int4 a, vec_int4 b, vec_int4 c)
{
  return __builtin_spu_gencx_0 (a, b, c);
}
static inline vec_uint4
spu_gencx (vec_uint4 a, vec_uint4 b, vec_uint4 c)
{
  return __builtin_spu_gencx_1 (a, b, c);
}
static inline vec_int4
spu_madd (vec_short8 a, vec_short8 b, vec_int4 c)
{
  return __builtin_spu_madd_0 (a, b, c);
}
static inline vec_float4
spu_madd (vec_float4 a, vec_float4 b, vec_float4 c)
{
  return __builtin_spu_madd_1 (a, b, c);
}
static inline vec_double2
spu_madd (vec_double2 a, vec_double2 b, vec_double2 c)
{
  return __builtin_spu_madd_2 (a, b, c);
}
static inline vec_float4
spu_msub (vec_float4 a, vec_float4 b, vec_float4 c)
{
  return __builtin_spu_msub_0 (a, b, c);
}
static inline vec_double2
spu_msub (vec_double2 a, vec_double2 b, vec_double2 c)
{
  return __builtin_spu_msub_1 (a, b, c);
}
static inline vec_uint4
spu_mhhadd (vec_ushort8 a, vec_ushort8 b, vec_uint4 c)
{
  return __builtin_spu_mhhadd_0 (a, b, c);
}
static inline vec_int4
spu_mhhadd (vec_short8 a, vec_short8 b, vec_int4 c)
{
  return __builtin_spu_mhhadd_1 (a, b, c);
}
static inline vec_uint4
spu_mule (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_mule_0 (a, b);
}
static inline vec_int4
spu_mule (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_mule_1 (a, b);
}
static inline vec_float4
spu_mul (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_mul_0 (a, b);
}
static inline vec_double2
spu_mul (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_mul_1 (a, b);
}
static inline vec_int4
spu_mulo (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_mulo_0 (a, b);
}
static inline vec_uint4
spu_mulo (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_mulo_1 (a, b);
}
static inline vec_int4
spu_mulo (vec_short8 a, short b)
{
  return __builtin_spu_mulo_2 (a, b);
}
static inline vec_uint4
spu_mulo (vec_ushort8 a, unsigned short b)
{
  return __builtin_spu_mulo_3 (a, b);
}
static inline vec_float4
spu_nmsub (vec_float4 a, vec_float4 b, vec_float4 c)
{
  return __builtin_spu_nmsub_0 (a, b, c);
}
static inline vec_double2
spu_nmsub (vec_double2 a, vec_double2 b, vec_double2 c)
{
  return __builtin_spu_nmsub_1 (a, b, c);
}
static inline vec_ushort8
spu_sub (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_sub_0 (a, b);
}
static inline vec_short8
spu_sub (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_sub_1 (a, b);
}
static inline vec_uint4
spu_sub (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_sub_2 (a, b);
}
static inline vec_int4
spu_sub (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_sub_3 (a, b);
}
static inline vec_float4
spu_sub (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_sub_4 (a, b);
}
static inline vec_double2
spu_sub (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_sub_5 (a, b);
}
static inline vec_ushort8
spu_sub (unsigned short a, vec_ushort8 b)
{
  return __builtin_spu_sub_6 (a, b);
}
static inline vec_short8
spu_sub (short a, vec_short8 b)
{
  return __builtin_spu_sub_7 (a, b);
}
static inline vec_uint4
spu_sub (unsigned int a, vec_uint4 b)
{
  return __builtin_spu_sub_8 (a, b);
}
static inline vec_int4
spu_sub (int a, vec_int4 b)
{
  return __builtin_spu_sub_9 (a, b);
}
static inline vec_uint4
spu_subx (vec_uint4 a, vec_uint4 b, vec_uint4 c)
{
  return __builtin_spu_subx_0 (a, b, c);
}
static inline vec_int4
spu_subx (vec_int4 a, vec_int4 b, vec_int4 c)
{
  return __builtin_spu_subx_1 (a, b, c);
}
static inline vec_uint4
spu_genb (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_genb_0 (a, b);
}
static inline vec_int4
spu_genb (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_genb_1 (a, b);
}
static inline vec_uint4
spu_genbx (vec_uint4 a, vec_uint4 b, vec_uint4 c)
{
  return __builtin_spu_genbx_0 (a, b, c);
}
static inline vec_int4
spu_genbx (vec_int4 a, vec_int4 b, vec_int4 c)
{
  return __builtin_spu_genbx_1 (a, b, c);
}
static inline vec_uchar16
spu_cmpeq (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_cmpeq_0 (a, b);
}
static inline vec_uchar16
spu_cmpeq (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_cmpeq_1 (a, b);
}
static inline vec_ushort8
spu_cmpeq (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_cmpeq_2 (a, b);
}
static inline vec_ushort8
spu_cmpeq (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_cmpeq_3 (a, b);
}
static inline vec_uint4
spu_cmpeq (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_cmpeq_4 (a, b);
}
static inline vec_uint4
spu_cmpeq (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_cmpeq_5 (a, b);
}
static inline vec_uint4
spu_cmpeq (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_cmpeq_6 (a, b);
}
static inline vec_uchar16
spu_cmpeq (vec_uchar16 a, unsigned char b)
{
  return __builtin_spu_cmpeq_7 (a, b);
}
static inline vec_uchar16
spu_cmpeq (vec_char16 a, signed char b)
{
  return __builtin_spu_cmpeq_8 (a, b);
}
static inline vec_ushort8
spu_cmpeq (vec_ushort8 a, unsigned short b)
{
  return __builtin_spu_cmpeq_9 (a, b);
}
static inline vec_ushort8
spu_cmpeq (vec_short8 a, short b)
{
  return __builtin_spu_cmpeq_10 (a, b);
}
static inline vec_uint4
spu_cmpeq (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_cmpeq_11 (a, b);
}
static inline vec_uint4
spu_cmpeq (vec_int4 a, int b)
{
  return __builtin_spu_cmpeq_12 (a, b);
}
static inline vec_uchar16
spu_cmpgt (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_cmpgt_0 (a, b);
}
static inline vec_uchar16
spu_cmpgt (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_cmpgt_1 (a, b);
}
static inline vec_ushort8
spu_cmpgt (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_cmpgt_2 (a, b);
}
static inline vec_ushort8
spu_cmpgt (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_cmpgt_3 (a, b);
}
static inline vec_uint4
spu_cmpgt (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_cmpgt_4 (a, b);
}
static inline vec_uint4
spu_cmpgt (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_cmpgt_5 (a, b);
}
static inline vec_uint4
spu_cmpgt (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_cmpgt_6 (a, b);
}
static inline vec_uchar16
spu_cmpgt (vec_uchar16 a, unsigned char b)
{
  return __builtin_spu_cmpgt_7 (a, b);
}
static inline vec_uchar16
spu_cmpgt (vec_char16 a, signed char b)
{
  return __builtin_spu_cmpgt_8 (a, b);
}
static inline vec_ushort8
spu_cmpgt (vec_ushort8 a, unsigned short b)
{
  return __builtin_spu_cmpgt_9 (a, b);
}
static inline vec_ushort8
spu_cmpgt (vec_short8 a, short b)
{
  return __builtin_spu_cmpgt_10 (a, b);
}
static inline vec_uint4
spu_cmpgt (vec_int4 a, int b)
{
  return __builtin_spu_cmpgt_11 (a, b);
}
static inline vec_uint4
spu_cmpgt (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_cmpgt_12 (a, b);
}
static inline void
spu_hcmpeq (int a, int b)
{
  return __builtin_spu_hcmpeq_0 (a, b);
}
static inline void
spu_hcmpeq (unsigned int a, unsigned int b)
{
  return __builtin_spu_hcmpeq_1 (a, b);
}
static inline void
spu_hcmpgt (int a, int b)
{
  return __builtin_spu_hcmpgt_0 (a, b);
}
static inline void
spu_hcmpgt (unsigned int a, unsigned int b)
{
  return __builtin_spu_hcmpgt_1 (a, b);
}
static inline vec_uchar16
spu_cntb (vec_char16 a)
{
  return __builtin_spu_cntb_0 (a);
}
static inline vec_uchar16
spu_cntb (vec_uchar16 a)
{
  return __builtin_spu_cntb_1 (a);
}
static inline vec_uint4
spu_cntlz (vec_int4 a)
{
  return __builtin_spu_cntlz_0 (a);
}
static inline vec_uint4
spu_cntlz (vec_uint4 a)
{
  return __builtin_spu_cntlz_1 (a);
}
static inline vec_uint4
spu_cntlz (vec_float4 a)
{
  return __builtin_spu_cntlz_2 (a);
}
static inline vec_uint4
spu_gather (vec_int4 a)
{
  return __builtin_spu_gather_0 (a);
}
static inline vec_uint4
spu_gather (vec_uint4 a)
{
  return __builtin_spu_gather_1 (a);
}
static inline vec_uint4
spu_gather (vec_short8 a)
{
  return __builtin_spu_gather_2 (a);
}
static inline vec_uint4
spu_gather (vec_ushort8 a)
{
  return __builtin_spu_gather_3 (a);
}
static inline vec_uint4
spu_gather (vec_char16 a)
{
  return __builtin_spu_gather_4 (a);
}
static inline vec_uint4
spu_gather (vec_uchar16 a)
{
  return __builtin_spu_gather_5 (a);
}
static inline vec_uint4
spu_gather (vec_float4 a)
{
  return __builtin_spu_gather_6 (a);
}
static inline vec_uchar16
spu_maskb (unsigned short a)
{
  return __builtin_spu_maskb_0 (a);
}
static inline vec_uchar16
spu_maskb (short a)
{
  return __builtin_spu_maskb_1 (a);
}
static inline vec_uchar16
spu_maskb (unsigned int a)
{
  return __builtin_spu_maskb_2 (a);
}
static inline vec_uchar16
spu_maskb (int a)
{
  return __builtin_spu_maskb_3 (a);
}
static inline vec_ushort8
spu_maskh (unsigned char a)
{
  return __builtin_spu_maskh_0 (a);
}
static inline vec_ushort8
spu_maskh (signed char a)
{
  return __builtin_spu_maskh_1 (a);
}
static inline vec_ushort8
spu_maskh (char a)
{
  return __builtin_spu_maskh_1 (a);
}
static inline vec_ushort8
spu_maskh (unsigned short a)
{
  return __builtin_spu_maskh_2 (a);
}
static inline vec_ushort8
spu_maskh (short a)
{
  return __builtin_spu_maskh_3 (a);
}
static inline vec_ushort8
spu_maskh (unsigned int a)
{
  return __builtin_spu_maskh_4 (a);
}
static inline vec_ushort8
spu_maskh (int a)
{
  return __builtin_spu_maskh_5 (a);
}
static inline vec_uint4
spu_maskw (unsigned char a)
{
  return __builtin_spu_maskw_0 (a);
}
static inline vec_uint4
spu_maskw (signed char a)
{
  return __builtin_spu_maskw_1 (a);
}
static inline vec_uint4
spu_maskw (char a)
{
  return __builtin_spu_maskw_1 (a);
}
static inline vec_uint4
spu_maskw (unsigned short a)
{
  return __builtin_spu_maskw_2 (a);
}
static inline vec_uint4
spu_maskw (short a)
{
  return __builtin_spu_maskw_3 (a);
}
static inline vec_uint4
spu_maskw (unsigned int a)
{
  return __builtin_spu_maskw_4 (a);
}
static inline vec_uint4
spu_maskw (int a)
{
  return __builtin_spu_maskw_5 (a);
}
static inline vec_llong2
spu_sel (vec_llong2 a, vec_llong2 b, vec_ullong2 c)
{
  return __builtin_spu_sel_0 (a, b, c);
}
static inline vec_ullong2
spu_sel (vec_ullong2 a, vec_ullong2 b, vec_ullong2 c)
{
  return __builtin_spu_sel_1 (a, b, c);
}
static inline vec_int4
spu_sel (vec_int4 a, vec_int4 b, vec_uint4 c)
{
  return __builtin_spu_sel_2 (a, b, c);
}
static inline vec_uint4
spu_sel (vec_uint4 a, vec_uint4 b, vec_uint4 c)
{
  return __builtin_spu_sel_3 (a, b, c);
}
static inline vec_short8
spu_sel (vec_short8 a, vec_short8 b, vec_ushort8 c)
{
  return __builtin_spu_sel_4 (a, b, c);
}
static inline vec_ushort8
spu_sel (vec_ushort8 a, vec_ushort8 b, vec_ushort8 c)
{
  return __builtin_spu_sel_5 (a, b, c);
}
static inline vec_char16
spu_sel (vec_char16 a, vec_char16 b, vec_uchar16 c)
{
  return __builtin_spu_sel_6 (a, b, c);
}
static inline vec_uchar16
spu_sel (vec_uchar16 a, vec_uchar16 b, vec_uchar16 c)
{
  return __builtin_spu_sel_7 (a, b, c);
}
static inline vec_float4
spu_sel (vec_float4 a, vec_float4 b, vec_uint4 c)
{
  return __builtin_spu_sel_8 (a, b, c);
}
static inline vec_double2
spu_sel (vec_double2 a, vec_double2 b, vec_ullong2 c)
{
  return __builtin_spu_sel_9 (a, b, c);
}
static inline vec_llong2
spu_sel (vec_llong2 a, vec_llong2 b, vec_uchar16 c)
{
  return __builtin_spu_sel_0o (a, b, c);
}
static inline vec_ullong2
spu_sel (vec_ullong2 a, vec_ullong2 b, vec_uchar16 c)
{
  return __builtin_spu_sel_1o (a, b, c);
}
static inline vec_int4
spu_sel (vec_int4 a, vec_int4 b, vec_uchar16 c)
{
  return __builtin_spu_sel_2o (a, b, c);
}
static inline vec_uint4
spu_sel (vec_uint4 a, vec_uint4 b, vec_uchar16 c)
{
  return __builtin_spu_sel_3o (a, b, c);
}
static inline vec_short8
spu_sel (vec_short8 a, vec_short8 b, vec_uchar16 c)
{
  return __builtin_spu_sel_4o (a, b, c);
}
static inline vec_ushort8
spu_sel (vec_ushort8 a, vec_ushort8 b, vec_uchar16 c)
{
  return __builtin_spu_sel_5o (a, b, c);
}
static inline vec_float4
spu_sel (vec_float4 a, vec_float4 b, vec_uchar16 c)
{
  return __builtin_spu_sel_8o (a, b, c);
}
static inline vec_double2
spu_sel (vec_double2 a, vec_double2 b, vec_uchar16 c)
{
  return __builtin_spu_sel_9o (a, b, c);
}
static inline vec_uchar16
spu_shuffle (vec_uchar16 a, vec_uchar16 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_0 (a, b, c);
}
static inline vec_char16
spu_shuffle (vec_char16 a, vec_char16 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_1 (a, b, c);
}
static inline vec_ushort8
spu_shuffle (vec_ushort8 a, vec_ushort8 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_2 (a, b, c);
}
static inline vec_short8
spu_shuffle (vec_short8 a, vec_short8 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_3 (a, b, c);
}
static inline vec_uint4
spu_shuffle (vec_uint4 a, vec_uint4 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_4 (a, b, c);
}
static inline vec_int4
spu_shuffle (vec_int4 a, vec_int4 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_5 (a, b, c);
}
static inline vec_ullong2
spu_shuffle (vec_ullong2 a, vec_ullong2 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_6 (a, b, c);
}
static inline vec_llong2
spu_shuffle (vec_llong2 a, vec_llong2 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_7 (a, b, c);
}
static inline vec_float4
spu_shuffle (vec_float4 a, vec_float4 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_8 (a, b, c);
}
static inline vec_double2
spu_shuffle (vec_double2 a, vec_double2 b, vec_uchar16 c)
{
  return __builtin_spu_shuffle_9 (a, b, c);
}
static inline vec_uchar16
spu_and (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_and_0 (a, b);
}
static inline vec_char16
spu_and (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_and_1 (a, b);
}
static inline vec_ushort8
spu_and (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_and_2 (a, b);
}
static inline vec_short8
spu_and (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_and_3 (a, b);
}
static inline vec_uint4
spu_and (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_and_4 (a, b);
}
static inline vec_int4
spu_and (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_and_5 (a, b);
}
static inline vec_ullong2
spu_and (vec_ullong2 a, vec_ullong2 b)
{
  return __builtin_spu_and_6 (a, b);
}
static inline vec_llong2
spu_and (vec_llong2 a, vec_llong2 b)
{
  return __builtin_spu_and_7 (a, b);
}
static inline vec_float4
spu_and (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_and_8 (a, b);
}
static inline vec_double2
spu_and (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_and_9 (a, b);
}
static inline vec_uchar16
spu_and (vec_uchar16 a, unsigned char b)
{
  return __builtin_spu_and_10 (a, b);
}
static inline vec_char16
spu_and (vec_char16 a, signed char b)
{
  return __builtin_spu_and_11 (a, b);
}
static inline vec_ushort8
spu_and (vec_ushort8 a, unsigned short b)
{
  return __builtin_spu_and_12 (a, b);
}
static inline vec_short8
spu_and (vec_short8 a, short b)
{
  return __builtin_spu_and_13 (a, b);
}
static inline vec_uint4
spu_and (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_and_14 (a, b);
}
static inline vec_int4
spu_and (vec_int4 a, int b)
{
  return __builtin_spu_and_15 (a, b);
}
static inline vec_llong2
spu_andc (vec_llong2 a, vec_llong2 b)
{
  return __builtin_spu_andc_0 (a, b);
}
static inline vec_ullong2
spu_andc (vec_ullong2 a, vec_ullong2 b)
{
  return __builtin_spu_andc_1 (a, b);
}
static inline vec_int4
spu_andc (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_andc_2 (a, b);
}
static inline vec_uint4
spu_andc (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_andc_3 (a, b);
}
static inline vec_short8
spu_andc (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_andc_4 (a, b);
}
static inline vec_ushort8
spu_andc (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_andc_5 (a, b);
}
static inline vec_char16
spu_andc (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_andc_6 (a, b);
}
static inline vec_uchar16
spu_andc (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_andc_7 (a, b);
}
static inline vec_float4
spu_andc (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_andc_8 (a, b);
}
static inline vec_double2
spu_andc (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_andc_9 (a, b);
}
static inline vec_llong2
spu_eqv (vec_llong2 a, vec_llong2 b)
{
  return __builtin_spu_eqv_0 (a, b);
}
static inline vec_ullong2
spu_eqv (vec_ullong2 a, vec_ullong2 b)
{
  return __builtin_spu_eqv_1 (a, b);
}
static inline vec_int4
spu_eqv (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_eqv_2 (a, b);
}
static inline vec_uint4
spu_eqv (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_eqv_3 (a, b);
}
static inline vec_short8
spu_eqv (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_eqv_4 (a, b);
}
static inline vec_ushort8
spu_eqv (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_eqv_5 (a, b);
}
static inline vec_char16
spu_eqv (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_eqv_6 (a, b);
}
static inline vec_uchar16
spu_eqv (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_eqv_7 (a, b);
}
static inline vec_float4
spu_eqv (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_eqv_8 (a, b);
}
static inline vec_double2
spu_eqv (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_eqv_9 (a, b);
}
static inline vec_llong2
spu_nand (vec_llong2 a, vec_llong2 b)
{
  return __builtin_spu_nand_0 (a, b);
}
static inline vec_ullong2
spu_nand (vec_ullong2 a, vec_ullong2 b)
{
  return __builtin_spu_nand_1 (a, b);
}
static inline vec_int4
spu_nand (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_nand_2 (a, b);
}
static inline vec_uint4
spu_nand (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_nand_3 (a, b);
}
static inline vec_short8
spu_nand (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_nand_4 (a, b);
}
static inline vec_ushort8
spu_nand (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_nand_5 (a, b);
}
static inline vec_char16
spu_nand (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_nand_6 (a, b);
}
static inline vec_uchar16
spu_nand (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_nand_7 (a, b);
}
static inline vec_float4
spu_nand (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_nand_8 (a, b);
}
static inline vec_double2
spu_nand (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_nand_9 (a, b);
}
static inline vec_llong2
spu_nor (vec_llong2 a, vec_llong2 b)
{
  return __builtin_spu_nor_0 (a, b);
}
static inline vec_ullong2
spu_nor (vec_ullong2 a, vec_ullong2 b)
{
  return __builtin_spu_nor_1 (a, b);
}
static inline vec_int4
spu_nor (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_nor_2 (a, b);
}
static inline vec_uint4
spu_nor (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_nor_3 (a, b);
}
static inline vec_short8
spu_nor (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_nor_4 (a, b);
}
static inline vec_ushort8
spu_nor (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_nor_5 (a, b);
}
static inline vec_char16
spu_nor (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_nor_6 (a, b);
}
static inline vec_uchar16
spu_nor (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_nor_7 (a, b);
}
static inline vec_float4
spu_nor (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_nor_8 (a, b);
}
static inline vec_double2
spu_nor (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_nor_9 (a, b);
}
static inline vec_uchar16
spu_or (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_or_0 (a, b);
}
static inline vec_char16
spu_or (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_or_1 (a, b);
}
static inline vec_ushort8
spu_or (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_or_2 (a, b);
}
static inline vec_short8
spu_or (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_or_3 (a, b);
}
static inline vec_uint4
spu_or (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_or_4 (a, b);
}
static inline vec_int4
spu_or (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_or_5 (a, b);
}
static inline vec_ullong2
spu_or (vec_ullong2 a, vec_ullong2 b)
{
  return __builtin_spu_or_6 (a, b);
}
static inline vec_llong2
spu_or (vec_llong2 a, vec_llong2 b)
{
  return __builtin_spu_or_7 (a, b);
}
static inline vec_float4
spu_or (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_or_8 (a, b);
}
static inline vec_double2
spu_or (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_or_9 (a, b);
}
static inline vec_uchar16
spu_or (vec_uchar16 a, unsigned char b)
{
  return __builtin_spu_or_10 (a, b);
}
static inline vec_char16
spu_or (vec_char16 a, signed char b)
{
  return __builtin_spu_or_11 (a, b);
}
static inline vec_ushort8
spu_or (vec_ushort8 a, unsigned short b)
{
  return __builtin_spu_or_12 (a, b);
}
static inline vec_short8
spu_or (vec_short8 a, short b)
{
  return __builtin_spu_or_13 (a, b);
}
static inline vec_uint4
spu_or (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_or_14 (a, b);
}
static inline vec_int4
spu_or (vec_int4 a, int b)
{
  return __builtin_spu_or_15 (a, b);
}
static inline vec_llong2
spu_orc (vec_llong2 a, vec_llong2 b)
{
  return __builtin_spu_orc_0 (a, b);
}
static inline vec_ullong2
spu_orc (vec_ullong2 a, vec_ullong2 b)
{
  return __builtin_spu_orc_1 (a, b);
}
static inline vec_int4
spu_orc (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_orc_2 (a, b);
}
static inline vec_uint4
spu_orc (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_orc_3 (a, b);
}
static inline vec_short8
spu_orc (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_orc_4 (a, b);
}
static inline vec_ushort8
spu_orc (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_orc_5 (a, b);
}
static inline vec_char16
spu_orc (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_orc_6 (a, b);
}
static inline vec_uchar16
spu_orc (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_orc_7 (a, b);
}
static inline vec_float4
spu_orc (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_orc_8 (a, b);
}
static inline vec_double2
spu_orc (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_orc_9 (a, b);
}
static inline vec_int4
spu_orx (vec_int4 a)
{
  return __builtin_spu_orx_0 (a);
}
static inline vec_uint4
spu_orx (vec_uint4 a)
{
  return __builtin_spu_orx_1 (a);
}
static inline vec_uchar16
spu_xor (vec_uchar16 a, vec_uchar16 b)
{
  return __builtin_spu_xor_0 (a, b);
}
static inline vec_char16
spu_xor (vec_char16 a, vec_char16 b)
{
  return __builtin_spu_xor_1 (a, b);
}
static inline vec_ushort8
spu_xor (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_xor_2 (a, b);
}
static inline vec_short8
spu_xor (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_xor_3 (a, b);
}
static inline vec_uint4
spu_xor (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_xor_4 (a, b);
}
static inline vec_int4
spu_xor (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_xor_5 (a, b);
}
static inline vec_ullong2
spu_xor (vec_ullong2 a, vec_ullong2 b)
{
  return __builtin_spu_xor_6 (a, b);
}
static inline vec_llong2
spu_xor (vec_llong2 a, vec_llong2 b)
{
  return __builtin_spu_xor_7 (a, b);
}
static inline vec_float4
spu_xor (vec_float4 a, vec_float4 b)
{
  return __builtin_spu_xor_8 (a, b);
}
static inline vec_double2
spu_xor (vec_double2 a, vec_double2 b)
{
  return __builtin_spu_xor_9 (a, b);
}
static inline vec_uchar16
spu_xor (vec_uchar16 a, unsigned char b)
{
  return __builtin_spu_xor_10 (a, b);
}
static inline vec_char16
spu_xor (vec_char16 a, signed char b)
{
  return __builtin_spu_xor_11 (a, b);
}
static inline vec_ushort8
spu_xor (vec_ushort8 a, unsigned short b)
{
  return __builtin_spu_xor_12 (a, b);
}
static inline vec_short8
spu_xor (vec_short8 a, short b)
{
  return __builtin_spu_xor_13 (a, b);
}
static inline vec_uint4
spu_xor (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_xor_14 (a, b);
}
static inline vec_int4
spu_xor (vec_int4 a, int b)
{
  return __builtin_spu_xor_15 (a, b);
}
static inline vec_ushort8
spu_rl (vec_ushort8 a, vec_short8 b)
{
  return __builtin_spu_rl_0 (a, b);
}
static inline vec_short8
spu_rl (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_rl_1 (a, b);
}
static inline vec_uint4
spu_rl (vec_uint4 a, vec_int4 b)
{
  return __builtin_spu_rl_2 (a, b);
}
static inline vec_int4
spu_rl (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_rl_3 (a, b);
}
static inline vec_ushort8
spu_rl (vec_ushort8 a, short b)
{
  return __builtin_spu_rl_4 (a, b);
}
static inline vec_short8
spu_rl (vec_short8 a, short b)
{
  return __builtin_spu_rl_5 (a, b);
}
static inline vec_uint4
spu_rl (vec_uint4 a, int b)
{
  return __builtin_spu_rl_6 (a, b);
}
static inline vec_int4
spu_rl (vec_int4 a, int b)
{
  return __builtin_spu_rl_7 (a, b);
}
static inline vec_uchar16
spu_rlqw (vec_uchar16 a, int b)
{
  return __builtin_spu_rlqw_0 (a, b);
}
static inline vec_char16
spu_rlqw (vec_char16 a, int b)
{
  return __builtin_spu_rlqw_1 (a, b);
}
static inline vec_ushort8
spu_rlqw (vec_ushort8 a, int b)
{
  return __builtin_spu_rlqw_2 (a, b);
}
static inline vec_short8
spu_rlqw (vec_short8 a, int b)
{
  return __builtin_spu_rlqw_3 (a, b);
}
static inline vec_uint4
spu_rlqw (vec_uint4 a, int b)
{
  return __builtin_spu_rlqw_4 (a, b);
}
static inline vec_int4
spu_rlqw (vec_int4 a, int b)
{
  return __builtin_spu_rlqw_5 (a, b);
}
static inline vec_ullong2
spu_rlqw (vec_ullong2 a, int b)
{
  return __builtin_spu_rlqw_6 (a, b);
}
static inline vec_llong2
spu_rlqw (vec_llong2 a, int b)
{
  return __builtin_spu_rlqw_7 (a, b);
}
static inline vec_float4
spu_rlqw (vec_float4 a, int b)
{
  return __builtin_spu_rlqw_8 (a, b);
}
static inline vec_double2
spu_rlqw (vec_double2 a, int b)
{
  return __builtin_spu_rlqw_9 (a, b);
}
static inline vec_uchar16
spu_rlqwbyte (vec_uchar16 a, int b)
{
  return __builtin_spu_rlqwbyte_0 (a, b);
}
static inline vec_char16
spu_rlqwbyte (vec_char16 a, int b)
{
  return __builtin_spu_rlqwbyte_1 (a, b);
}
static inline vec_ushort8
spu_rlqwbyte (vec_ushort8 a, int b)
{
  return __builtin_spu_rlqwbyte_2 (a, b);
}
static inline vec_short8
spu_rlqwbyte (vec_short8 a, int b)
{
  return __builtin_spu_rlqwbyte_3 (a, b);
}
static inline vec_uint4
spu_rlqwbyte (vec_uint4 a, int b)
{
  return __builtin_spu_rlqwbyte_4 (a, b);
}
static inline vec_int4
spu_rlqwbyte (vec_int4 a, int b)
{
  return __builtin_spu_rlqwbyte_5 (a, b);
}
static inline vec_ullong2
spu_rlqwbyte (vec_ullong2 a, int b)
{
  return __builtin_spu_rlqwbyte_6 (a, b);
}
static inline vec_llong2
spu_rlqwbyte (vec_llong2 a, int b)
{
  return __builtin_spu_rlqwbyte_7 (a, b);
}
static inline vec_float4
spu_rlqwbyte (vec_float4 a, int b)
{
  return __builtin_spu_rlqwbyte_8 (a, b);
}
static inline vec_double2
spu_rlqwbyte (vec_double2 a, int b)
{
  return __builtin_spu_rlqwbyte_9 (a, b);
}
static inline vec_uchar16
spu_rlqwbytebc (vec_uchar16 a, int b)
{
  return __builtin_spu_rlqwbytebc_0 (a, b);
}
static inline vec_char16
spu_rlqwbytebc (vec_char16 a, int b)
{
  return __builtin_spu_rlqwbytebc_1 (a, b);
}
static inline vec_ushort8
spu_rlqwbytebc (vec_ushort8 a, int b)
{
  return __builtin_spu_rlqwbytebc_2 (a, b);
}
static inline vec_short8
spu_rlqwbytebc (vec_short8 a, int b)
{
  return __builtin_spu_rlqwbytebc_3 (a, b);
}
static inline vec_uint4
spu_rlqwbytebc (vec_uint4 a, int b)
{
  return __builtin_spu_rlqwbytebc_4 (a, b);
}
static inline vec_int4
spu_rlqwbytebc (vec_int4 a, int b)
{
  return __builtin_spu_rlqwbytebc_5 (a, b);
}
static inline vec_ullong2
spu_rlqwbytebc (vec_ullong2 a, int b)
{
  return __builtin_spu_rlqwbytebc_6 (a, b);
}
static inline vec_llong2
spu_rlqwbytebc (vec_llong2 a, int b)
{
  return __builtin_spu_rlqwbytebc_7 (a, b);
}
static inline vec_float4
spu_rlqwbytebc (vec_float4 a, int b)
{
  return __builtin_spu_rlqwbytebc_8 (a, b);
}
static inline vec_double2
spu_rlqwbytebc (vec_double2 a, int b)
{
  return __builtin_spu_rlqwbytebc_9 (a, b);
}
static inline vec_ushort8
spu_rlmask (vec_ushort8 a, vec_short8 b)
{
  return __builtin_spu_rlmask_0 (a, b);
}
static inline vec_short8
spu_rlmask (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_rlmask_1 (a, b);
}
static inline vec_uint4
spu_rlmask (vec_uint4 a, vec_int4 b)
{
  return __builtin_spu_rlmask_2 (a, b);
}
static inline vec_int4
spu_rlmask (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_rlmask_3 (a, b);
}
static inline vec_ushort8
spu_rlmask (vec_ushort8 a, int b)
{
  return __builtin_spu_rlmask_4 (a, b);
}
static inline vec_short8
spu_rlmask (vec_short8 a, int b)
{
  return __builtin_spu_rlmask_5 (a, b);
}
static inline vec_uint4
spu_rlmask (vec_uint4 a, int b)
{
  return __builtin_spu_rlmask_6 (a, b);
}
static inline vec_int4
spu_rlmask (vec_int4 a, int b)
{
  return __builtin_spu_rlmask_7 (a, b);
}
static inline vec_ushort8
spu_rlmaska (vec_ushort8 a, vec_short8 b)
{
  return __builtin_spu_rlmaska_0 (a, b);
}
static inline vec_short8
spu_rlmaska (vec_short8 a, vec_short8 b)
{
  return __builtin_spu_rlmaska_1 (a, b);
}
static inline vec_uint4
spu_rlmaska (vec_uint4 a, vec_int4 b)
{
  return __builtin_spu_rlmaska_2 (a, b);
}
static inline vec_int4
spu_rlmaska (vec_int4 a, vec_int4 b)
{
  return __builtin_spu_rlmaska_3 (a, b);
}
static inline vec_ushort8
spu_rlmaska (vec_ushort8 a, int b)
{
  return __builtin_spu_rlmaska_4 (a, b);
}
static inline vec_short8
spu_rlmaska (vec_short8 a, int b)
{
  return __builtin_spu_rlmaska_5 (a, b);
}
static inline vec_uint4
spu_rlmaska (vec_uint4 a, int b)
{
  return __builtin_spu_rlmaska_6 (a, b);
}
static inline vec_int4
spu_rlmaska (vec_int4 a, int b)
{
  return __builtin_spu_rlmaska_7 (a, b);
}
static inline vec_uchar16
spu_rlmaskqw (vec_uchar16 a, int b)
{
  return __builtin_spu_rlmaskqw_0 (a, b);
}
static inline vec_char16
spu_rlmaskqw (vec_char16 a, int b)
{
  return __builtin_spu_rlmaskqw_1 (a, b);
}
static inline vec_ushort8
spu_rlmaskqw (vec_ushort8 a, int b)
{
  return __builtin_spu_rlmaskqw_2 (a, b);
}
static inline vec_short8
spu_rlmaskqw (vec_short8 a, int b)
{
  return __builtin_spu_rlmaskqw_3 (a, b);
}
static inline vec_uint4
spu_rlmaskqw (vec_uint4 a, int b)
{
  return __builtin_spu_rlmaskqw_4 (a, b);
}
static inline vec_int4
spu_rlmaskqw (vec_int4 a, int b)
{
  return __builtin_spu_rlmaskqw_5 (a, b);
}
static inline vec_ullong2
spu_rlmaskqw (vec_ullong2 a, int b)
{
  return __builtin_spu_rlmaskqw_6 (a, b);
}
static inline vec_llong2
spu_rlmaskqw (vec_llong2 a, int b)
{
  return __builtin_spu_rlmaskqw_7 (a, b);
}
static inline vec_float4
spu_rlmaskqw (vec_float4 a, int b)
{
  return __builtin_spu_rlmaskqw_8 (a, b);
}
static inline vec_double2
spu_rlmaskqw (vec_double2 a, int b)
{
  return __builtin_spu_rlmaskqw_9 (a, b);
}
static inline vec_uchar16
spu_rlmaskqwbyte (vec_uchar16 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_0 (a, b);
}
static inline vec_char16
spu_rlmaskqwbyte (vec_char16 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_1 (a, b);
}
static inline vec_ushort8
spu_rlmaskqwbyte (vec_ushort8 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_2 (a, b);
}
static inline vec_short8
spu_rlmaskqwbyte (vec_short8 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_3 (a, b);
}
static inline vec_uint4
spu_rlmaskqwbyte (vec_uint4 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_4 (a, b);
}
static inline vec_int4
spu_rlmaskqwbyte (vec_int4 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_5 (a, b);
}
static inline vec_ullong2
spu_rlmaskqwbyte (vec_ullong2 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_6 (a, b);
}
static inline vec_llong2
spu_rlmaskqwbyte (vec_llong2 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_7 (a, b);
}
static inline vec_float4
spu_rlmaskqwbyte (vec_float4 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_8 (a, b);
}
static inline vec_double2
spu_rlmaskqwbyte (vec_double2 a, int b)
{
  return __builtin_spu_rlmaskqwbyte_9 (a, b);
}
static inline vec_uchar16
spu_rlmaskqwbytebc (vec_uchar16 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_0 (a, b);
}
static inline vec_char16
spu_rlmaskqwbytebc (vec_char16 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_1 (a, b);
}
static inline vec_ushort8
spu_rlmaskqwbytebc (vec_ushort8 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_2 (a, b);
}
static inline vec_short8
spu_rlmaskqwbytebc (vec_short8 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_3 (a, b);
}
static inline vec_uint4
spu_rlmaskqwbytebc (vec_uint4 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_4 (a, b);
}
static inline vec_int4
spu_rlmaskqwbytebc (vec_int4 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_5 (a, b);
}
static inline vec_ullong2
spu_rlmaskqwbytebc (vec_ullong2 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_6 (a, b);
}
static inline vec_llong2
spu_rlmaskqwbytebc (vec_llong2 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_7 (a, b);
}
static inline vec_float4
spu_rlmaskqwbytebc (vec_float4 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_8 (a, b);
}
static inline vec_double2
spu_rlmaskqwbytebc (vec_double2 a, int b)
{
  return __builtin_spu_rlmaskqwbytebc_9 (a, b);
}
static inline vec_ushort8
spu_sl (vec_ushort8 a, vec_ushort8 b)
{
  return __builtin_spu_sl_0 (a, b);
}
static inline vec_short8
spu_sl (vec_short8 a, vec_ushort8 b)
{
  return __builtin_spu_sl_1 (a, b);
}
static inline vec_uint4
spu_sl (vec_uint4 a, vec_uint4 b)
{
  return __builtin_spu_sl_2 (a, b);
}
static inline vec_int4
spu_sl (vec_int4 a, vec_uint4 b)
{
  return __builtin_spu_sl_3 (a, b);
}
static inline vec_ushort8
spu_sl (vec_ushort8 a, unsigned int b)
{
  return __builtin_spu_sl_4 (a, b);
}
static inline vec_short8
spu_sl (vec_short8 a, unsigned int b)
{
  return __builtin_spu_sl_5 (a, b);
}
static inline vec_uint4
spu_sl (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_sl_6 (a, b);
}
static inline vec_int4
spu_sl (vec_int4 a, unsigned int b)
{
  return __builtin_spu_sl_7 (a, b);
}
static inline vec_llong2
spu_slqw (vec_llong2 a, unsigned int b)
{
  return __builtin_spu_slqw_0 (a, b);
}
static inline vec_ullong2
spu_slqw (vec_ullong2 a, unsigned int b)
{
  return __builtin_spu_slqw_1 (a, b);
}
static inline vec_int4
spu_slqw (vec_int4 a, unsigned int b)
{
  return __builtin_spu_slqw_2 (a, b);
}
static inline vec_uint4
spu_slqw (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_slqw_3 (a, b);
}
static inline vec_short8
spu_slqw (vec_short8 a, unsigned int b)
{
  return __builtin_spu_slqw_4 (a, b);
}
static inline vec_ushort8
spu_slqw (vec_ushort8 a, unsigned int b)
{
  return __builtin_spu_slqw_5 (a, b);
}
static inline vec_char16
spu_slqw (vec_char16 a, unsigned int b)
{
  return __builtin_spu_slqw_6 (a, b);
}
static inline vec_uchar16
spu_slqw (vec_uchar16 a, unsigned int b)
{
  return __builtin_spu_slqw_7 (a, b);
}
static inline vec_float4
spu_slqw (vec_float4 a, unsigned int b)
{
  return __builtin_spu_slqw_8 (a, b);
}
static inline vec_double2
spu_slqw (vec_double2 a, unsigned int b)
{
  return __builtin_spu_slqw_9 (a, b);
}
static inline vec_llong2
spu_slqwbyte (vec_llong2 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_0 (a, b);
}
static inline vec_ullong2
spu_slqwbyte (vec_ullong2 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_1 (a, b);
}
static inline vec_int4
spu_slqwbyte (vec_int4 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_2 (a, b);
}
static inline vec_uint4
spu_slqwbyte (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_3 (a, b);
}
static inline vec_short8
spu_slqwbyte (vec_short8 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_4 (a, b);
}
static inline vec_ushort8
spu_slqwbyte (vec_ushort8 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_5 (a, b);
}
static inline vec_char16
spu_slqwbyte (vec_char16 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_6 (a, b);
}
static inline vec_uchar16
spu_slqwbyte (vec_uchar16 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_7 (a, b);
}
static inline vec_float4
spu_slqwbyte (vec_float4 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_8 (a, b);
}
static inline vec_double2
spu_slqwbyte (vec_double2 a, unsigned int b)
{
  return __builtin_spu_slqwbyte_9 (a, b);
}
static inline vec_llong2
spu_slqwbytebc (vec_llong2 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_0 (a, b);
}
static inline vec_ullong2
spu_slqwbytebc (vec_ullong2 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_1 (a, b);
}
static inline vec_int4
spu_slqwbytebc (vec_int4 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_2 (a, b);
}
static inline vec_uint4
spu_slqwbytebc (vec_uint4 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_3 (a, b);
}
static inline vec_short8
spu_slqwbytebc (vec_short8 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_4 (a, b);
}
static inline vec_ushort8
spu_slqwbytebc (vec_ushort8 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_5 (a, b);
}
static inline vec_char16
spu_slqwbytebc (vec_char16 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_6 (a, b);
}
static inline vec_uchar16
spu_slqwbytebc (vec_uchar16 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_7 (a, b);
}
static inline vec_float4
spu_slqwbytebc (vec_float4 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_8 (a, b);
}
static inline vec_double2
spu_slqwbytebc (vec_double2 a, unsigned int b)
{
  return __builtin_spu_slqwbytebc_9 (a, b);
}
static inline vec_uchar16
spu_splats (unsigned char a)
{
  return __builtin_spu_splats_0 (a);
}
static inline vec_char16
spu_splats (signed char a)
{
  return __builtin_spu_splats_1 (a);
}
static inline vec_char16
spu_splats (char a)
{
  return __builtin_spu_splats_1 (a);
}
static inline vec_ushort8
spu_splats (unsigned short a)
{
  return __builtin_spu_splats_2 (a);
}
static inline vec_short8
spu_splats (short a)
{
  return __builtin_spu_splats_3 (a);
}
static inline vec_uint4
spu_splats (unsigned int a)
{
  return __builtin_spu_splats_4 (a);
}
static inline vec_int4
spu_splats (int a)
{
  return __builtin_spu_splats_5 (a);
}
static inline vec_ullong2
spu_splats (unsigned long long a)
{
  return __builtin_spu_splats_6 (a);
}
static inline vec_llong2
spu_splats (long long a)
{
  return __builtin_spu_splats_7 (a);
}
static inline vec_float4
spu_splats (float a)
{
  return __builtin_spu_splats_8 (a);
}
static inline vec_double2
spu_splats (double a)
{
  return __builtin_spu_splats_9 (a);
}
static inline unsigned char
spu_extract (vec_uchar16 a, int b)
{
  return __builtin_spu_extract_0 (a, b);
}
static inline signed char
spu_extract (vec_char16 a, int b)
{
  return __builtin_spu_extract_1 (a, b);
}
static inline unsigned short
spu_extract (vec_ushort8 a, int b)
{
  return __builtin_spu_extract_2 (a, b);
}
static inline short
spu_extract (vec_short8 a, int b)
{
  return __builtin_spu_extract_3 (a, b);
}
static inline unsigned int
spu_extract (vec_uint4 a, int b)
{
  return __builtin_spu_extract_4 (a, b);
}
static inline int
spu_extract (vec_int4 a, int b)
{
  return __builtin_spu_extract_5 (a, b);
}
static inline unsigned long long
spu_extract (vec_ullong2 a, int b)
{
  return __builtin_spu_extract_6 (a, b);
}
static inline long long
spu_extract (vec_llong2 a, int b)
{
  return __builtin_spu_extract_7 (a, b);
}
static inline float
spu_extract (vec_float4 a, int b)
{
  return __builtin_spu_extract_8 (a, b);
}
static inline double
spu_extract (vec_double2 a, int b)
{
  return __builtin_spu_extract_9 (a, b);
}
static inline vec_uchar16
spu_insert (unsigned char a, vec_uchar16 b, int c)
{
  return __builtin_spu_insert_0 (a, b, c);
}
static inline vec_char16
spu_insert (signed char a, vec_char16 b, int c)
{
  return __builtin_spu_insert_1 (a, b, c);
}
static inline vec_ushort8
spu_insert (unsigned short a, vec_ushort8 b, int c)
{
  return __builtin_spu_insert_2 (a, b, c);
}
static inline vec_short8
spu_insert (short a, vec_short8 b, int c)
{
  return __builtin_spu_insert_3 (a, b, c);
}
static inline vec_uint4
spu_insert (unsigned int a, vec_uint4 b, int c)
{
  return __builtin_spu_insert_4 (a, b, c);
}
static inline vec_int4
spu_insert (int a, vec_int4 b, int c)
{
  return __builtin_spu_insert_5 (a, b, c);
}
static inline vec_ullong2
spu_insert (unsigned long long a, vec_ullong2 b, int c)
{
  return __builtin_spu_insert_6 (a, b, c);
}
static inline vec_llong2
spu_insert (long long a, vec_llong2 b, int c)
{
  return __builtin_spu_insert_7 (a, b, c);
}
static inline vec_float4
spu_insert (float a, vec_float4 b, int c)
{
  return __builtin_spu_insert_8 (a, b, c);
}
static inline vec_double2
spu_insert (double a, vec_double2 b, int c)
{
  return __builtin_spu_insert_9 (a, b, c);
}
static inline vec_uchar16
spu_promote (unsigned char a, int b)
{
  return __builtin_spu_promote_0 (a, b);
}
static inline vec_char16
spu_promote (signed char a, int b)
{
  return __builtin_spu_promote_1 (a, b);
}
static inline vec_char16
spu_promote (char a, int b)
{
  return __builtin_spu_promote_1 (a, b);
}
static inline vec_ushort8
spu_promote (unsigned short a, int b)
{
  return __builtin_spu_promote_2 (a, b);
}
static inline vec_short8
spu_promote (short a, int b)
{
  return __builtin_spu_promote_3 (a, b);
}
static inline vec_uint4
spu_promote (unsigned int a, int b)
{
  return __builtin_spu_promote_4 (a, b);
}
static inline vec_int4
spu_promote (int a, int b)
{
  return __builtin_spu_promote_5 (a, b);
}
static inline vec_ullong2
spu_promote (unsigned long long a, int b)
{
  return __builtin_spu_promote_6 (a, b);
}
static inline vec_llong2
spu_promote (long long a, int b)
{
  return __builtin_spu_promote_7 (a, b);
}
static inline vec_float4
spu_promote (float a, int b)
{
  return __builtin_spu_promote_8 (a, b);
}
static inline vec_double2
spu_promote (double a, int b)
{
  return __builtin_spu_promote_9 (a, b);
}
#endif  /* __cplusplus */

#ifdef __cplusplus
extern "C" {
#endif

/* The type checking for some of these won't be accurate but they need
 * to be defines because of the immediate values. */
#define spu_idisable()          __builtin_spu_idisable()
#define spu_ienable()           __builtin_spu_ienable()
#define spu_mfspr(imm)          si_to_uint(si_mfspr((imm)))
#define spu_mtspr(imm, ra)      si_mtspr((imm),si_from_uint (ra))
#define spu_mffpscr()           ((vec_uint4)si_fscrrd())
#define spu_mtfpscr(a)          si_fscrwr((qword)a)
#define spu_dsync()             si_dsync() 
#define spu_stop(imm)           si_stop(imm)
#define spu_sync()              si_sync()
#define spu_sync_c()            si_syncc()
#define spu_readch(imm)         si_to_uint(si_rdch((imm)))
#define spu_readchqw(imm)       ((vec_uint4)si_rdch((imm)))
#define spu_readchcnt(imm)      si_to_uint(si_rchcnt((imm)))
#define spu_writech(imm, ra)    si_wrch((imm), si_from_uint(ra))
#define spu_writechqw(imm, ra)  si_wrch((imm), (qword)(ra))

/* The following functions are static and always_inline to make sure
 * they don't show up in object files which they aren't used in.  */

static __inline__ vec_float4 spu_re (vec_float4 ra) __attribute__((__always_inline__));
static __inline__ vec_float4 spu_rsqrte (vec_float4 ra) __attribute__((__always_inline__));

static __inline__ vec_float4
spu_re (vec_float4 ra)
{
  return (vec_float4) si_fi ((qword) (ra), si_frest ((qword) (ra)));
}
static __inline__ vec_float4
spu_rsqrte (vec_float4 ra)
{
  return (vec_float4) si_fi ((qword) (ra), si_frsqest ((qword) (ra)));
}

/* composite intrinsics */
static __inline__ void spu_mfcdma32(volatile void *ls, unsigned int ea, unsigned int size, unsigned int tagid, unsigned int cmd) __attribute__((__always_inline__));
static __inline__ void spu_mfcdma64(volatile void *ls, unsigned int eahi, unsigned int ealow, unsigned int size, unsigned int tagid, unsigned int cmd) __attribute__((__always_inline__));
static __inline__ unsigned int spu_mfcstat(unsigned int type) __attribute__((__always_inline__));

static __inline__ void
spu_mfcdma32(volatile void *ls, unsigned int ea, unsigned int size, unsigned int tagid, unsigned int cmd)
{
      si_wrch(MFC_LSA,si_from_ptr(ls));
      si_wrch(MFC_EAL,si_from_uint(ea));
      si_wrch(MFC_Size,si_from_uint(size));
      si_wrch(MFC_TagID,si_from_uint(tagid));
      si_wrch(MFC_Cmd,si_from_uint(cmd));
}
static __inline__ void
spu_mfcdma64(volatile void *ls, unsigned int eahi, unsigned int ealow, unsigned int size, unsigned int tagid, unsigned int cmd)
{
      si_wrch(MFC_LSA,si_from_ptr(ls));
      si_wrch(MFC_EAH,si_from_uint(eahi));
      si_wrch(MFC_EAL,si_from_uint(ealow));
      si_wrch(MFC_Size,si_from_uint(size));
      si_wrch(MFC_TagID,si_from_uint(tagid));
      si_wrch(MFC_Cmd,si_from_uint(cmd));
}
static __inline__ unsigned int
spu_mfcstat(unsigned int type)
{
      si_wrch(MFC_WrTagUpdate,si_from_uint(type));
      return si_to_uint(si_rdch(MFC_RdTagStat));
}
#ifdef __cplusplus

}
#endif  /* __cplusplus */

////////////////////////////////////////////////////////////////////////////////
// Provide the backend functions for memset and memcpy 
////////////////////////////////////////////////////////////////////////////////

#define _STRING
#define _SCE_STRING_H_

#if !defined _FUNC_DEF
# include <bits/spec.h>
//#define _FUNC_DEF(retval,name,arg) _INLINE_DEF retval name arg 
#endif

#if !defined(_Const_return)
  #define _Const_return const
#endif

		/* MACROS */
#ifndef NULL
 #define NULL	 	_NULL
#endif /* NULL */

_C_STD_BEGIN

_C_LIB_DECL

// Loading from this table takes one instruction, generating the shuffle
// pattern would take three and still require a load.  If you call
// memcpy (or other functions that share this table) more than a few
// times, there will be a savings in memory size.
extern const vec_uchar16 __Shuffles[];

int strcoll(const char *, const char *);
char *strerror(int);
char *strtok(char *_Restrict, const char *_Restrict);
char *strdup(const char *);
size_t strxfrm(char *_Restrict, const char *_Restrict, size_t);
int strcasecmp(const char *, const char *);
int strncasecmp(const char *, const char *, size_t);

#if !defined __CRYCG_BACKEND__
__attribute__ ((crycg_attr
      (driver, "invalidate[MM], return[MX](M), return[LX](L)")))
#endif
void *memcpy(void *, const void *, size_t);

#if !defined __CRYCG_BACKEND__
__attribute__ ((crycg_attr
      (driver, "invalidate[M], return[M](M), return[L](L)")))
#endif
void *memset (void *, int, size_t);

#if !defined __CRYCG_BACKEND__
__attribute__ ((crycg_attr (driver, "missing[M]")))
#endif
int printf(const char *, ...);

_END_C_LIB_DECL

#if defined __CRYCG_BACKEND__
 void *memcpy__VMM(void *, const void *, size_t);
 void *memcpy__VML(void *, const void *, size_t);
 void *memcpy__VLM(void *, const void *, size_t);
 void *memcpy__VLL(void *, const void *, size_t);
 void *memset__VM (void *, int, size_t);
 void *memset__VL (void *, int, size_t);
#endif

#ifndef _NO_INLINE_DEFINITIONS
#include <bits/spec.h>
#include <bits/memchr.h>
#include <bits/memcmp.h>
#include <bits/memmove.h>
#include <bits/strcat.h>
#include <bits/strchr.h>
//#include <bits/strcmp.h>
#include <bits/strcpy.h>
#include <bits/strcspn.h>
#include <bits/strlen.h>
#include <bits/strncat.h>
#include <bits/strncmp.h>
#include <bits/strpbrk.h>
#include <bits/strrchr.h>
#include <bits/strspn.h>
#include <bits/strstr.h>
#include <bits/strncpy.h>

inline int strcmp( const char *p1, const char *p2 )
{
	while( *p1 != '\0' && *p2 != '\0' )
	{	
		if( *p1 < *p2 ) return -1;
		if( *p1 > *p2 ) return 1;
		
		++p1;
		++p2;
	}
	
	if( *p2 == '\0' ) return -1;
	if( *p1 == '\0' ) return 1;
	
	return 0;
}

#endif

_C_STD_END

#if defined(_STD_USING)
using _CSTD __Shuffles;
#endif

using _CSTD memcpy;
using _CSTD memset;

#if !defined __CRYCG_BACKEND__
__attribute__ ((crycg_attr (driver, "missing[M]")))
#endif
int printf(const char *, ...);


////////////////////////////////////////////////////////////////////////////////
// Required typedefs/macros and other magic for vmx2spu_gcc.h
////////////////////////////////////////////////////////////////////////////////

// Prevent the frontend compiler from actually including anything from
// the system header file (which will generate a ton of error
// messages) by tricking the include guard that the file has already
// been parsed by the preprocessor
#define _VMX2SPU_GCC_H_	

#ifdef __cplusplus

#ifdef __SPU__

/************************************************************************
 *                        INTRINSICS 
 ************************************************************************/

/* vec_abs (vector absolute value)
 * =======
 */
static inline vec_char16 vec_abs(vec_char16 a)
{
  vec_char16 minus_a;

  minus_a = (vec_char16)(spu_add((vec_ushort8)(spu_and(spu_xor(a, 0xFF), 0x7F)), 0x101));
  return (spu_sel(minus_a, a, spu_cmpgt(a, -1)));
}

static inline vec_short8 vec_abs(vec_short8 a)
{
  return (spu_sel(spu_sub(0, a), a, spu_cmpgt(a, -1)));
}

static inline vec_int4 vec_abs(vec_int4 a)
{
  return (spu_sel(spu_sub(0, a), a, spu_cmpgt(a, -1)));
}

static inline vec_float4 vec_abs(vec_float4 a)
{
  return ((vec_float4)(spu_rlmask(spu_sl((vec_uint4)(a), 1), -1)));
}

/* vec_abss (vector absolute value saturate)
 * ========
 */
static inline vec_char16 vec_abss(vec_char16 a)
{
  vec_char16 minus_a;

  minus_a = (vec_char16)spu_add((vec_short8)(spu_xor(a, -1)), 
				(vec_short8)(spu_and(spu_cmpgt((vec_uchar16)(a), 0x80), 1)));
  return (spu_sel(minus_a, a, spu_cmpgt(a, -1)));
}

static inline vec_short8 vec_abss(vec_short8 a)
{
  vec_short8 minus_a;

  minus_a = spu_add(spu_sub(0, a), (vec_short8)(spu_cmpeq(a, (vec_short8){0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000})));
  return (spu_sel(minus_a, a, spu_cmpgt(a, -1)));
}

static inline vec_int4 vec_abss(vec_int4 a)
{
  vec_int4 minus_a;

  minus_a = spu_add(spu_sub(0, a), (vec_int4)(spu_cmpeq(a, (vec_int4){0x80000000,0x80000000,0x80000000,0x80000000})));
  return (spu_sel(minus_a, a, spu_cmpgt(a, -1)));
}


/* vec_add (vector add)
 * =======
 */
static inline vec_uchar16 vec_add(vec_uchar16 a, vec_uchar16 b)
{
  return ((vec_uchar16)(spu_sel(spu_add((vec_ushort8)(a), (vec_ushort8)(b)),
				spu_add(spu_and((vec_ushort8)(a), 0xFF00), spu_and((vec_ushort8)(b), 0xFF00)),
				spu_splats((unsigned short)(0xFF00)))));
}

static inline vec_char16 vec_add(vec_char16 a, vec_char16 b)
{
  return ((vec_char16)vec_add((vec_uchar16)(a), (vec_uchar16)(b)));
}

static inline vec_char16 vec_add(vec_bchar16 a, vec_char16 b)
{
  return ((vec_char16)vec_add((vec_uchar16)(a), (vec_uchar16)(b)));
}

static inline vec_char16 vec_add(vec_char16 a, vec_bchar16 b)
{
  return ((vec_char16)vec_add((vec_uchar16)(a), (vec_uchar16)(b)));
}

static inline vec_ushort8 vec_add(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_add(a, b));
}

static inline vec_short8 vec_add(vec_short8 a, vec_short8 b)
{
  return (spu_add(a, b));
}

static inline vec_short8 vec_add(vec_bshort8 a, vec_short8 b)
{
  return (spu_add((vec_short8)(a), b));
}

static inline vec_short8 vec_add(vec_short8 a, vec_bshort8 b)
{
  return (spu_add(a, (vec_short8)(b)));
}

static inline vec_uint4 vec_add(vec_uint4 a, vec_uint4 b)
{
  return (spu_add(a, b));
}

static inline vec_int4 vec_add(vec_int4 a, vec_int4 b)
{
  return (spu_add(a, b));
}

static inline vec_int4 vec_add(vec_bint4 a, vec_int4 b)
{
  return (spu_add((vec_int4)(a), b));
}

static inline vec_int4 vec_add(vec_int4 a, vec_bint4 b)
{
  return (spu_add(a, (vec_int4)(b)));
}

static inline vec_float4 vec_add(vec_float4 a, vec_float4 b)
{
  return (spu_add(a, b));
}

/* vec_addc (vector add carryout unsigned word)
 * ========
 */
#define vec_addc(_a, _b)	spu_genc(_a, _b)

/* vec_adds (vector add saturated)
 * ========
 */
static inline vec_uchar16 vec_adds(vec_uchar16 a, vec_uchar16 b)
{
  vec_uchar16 s1, s2, s, d;

  s1 = (vec_uchar16)(spu_add(spu_rlmask((vec_ushort8)(a), -8), spu_rlmask((vec_ushort8)(b), -8)));
  s2 = (vec_uchar16)(spu_add(spu_and((vec_ushort8)(a), 0xFF), spu_and((vec_ushort8)(b), 0xFF)));
  s  = spu_shuffle(s1, s2, ((vec_uchar16){0, 16,  2, 18,  4, 20,  6, 22,
				          8, 24, 10, 26, 12, 28, 14, 30}));
  d  = spu_shuffle(s1, s2, ((vec_uchar16){1, 17,  3, 19,  5, 21,  7, 23,
				          9, 25, 11, 27, 13, 29, 15, 31}));
  return (spu_or(d, spu_cmpeq(s, 1)));
}

static inline vec_char16 vec_adds(vec_char16 a, vec_char16 b)
{
  vec_uchar16 s1, s2, s, d;

  s1 = (vec_uchar16)(spu_add(spu_rlmask((vec_ushort8)(a), -8), spu_rlmask((vec_ushort8)(b), -8)));
  s2 = (vec_uchar16)(spu_add(spu_and((vec_ushort8)(a), 0xFF), spu_and((vec_ushort8)(b), 0xFF)));
  s  = spu_shuffle(s1, s2, ((vec_uchar16){1, 17,  3, 19,  5, 21,  7, 23,
				          9, 25, 11, 27, 13, 29, 15, 31}));
  d = spu_sel(s, spu_splats((unsigned char)0x7F), spu_cmpgt(spu_and(s, (vec_uchar16)(spu_nor(a, b))), 0x7F));
  d = spu_sel(d, spu_splats((unsigned char)0x80), spu_cmpgt(spu_nor(s, (vec_uchar16)(spu_nand(a, b))), 0x7F));
  return ((vec_char16)(d));
}

static inline vec_char16 vec_adds(vec_bchar16 a, vec_char16 b)
{
  return (vec_adds((vec_char16)(a), b));
}

static inline vec_char16 vec_adds(vec_char16 a, vec_bchar16 b)
{
  return (vec_adds(a, (vec_char16)(b)));
}

static inline vec_ushort8 vec_adds(vec_ushort8 a, vec_ushort8 b)
{
  vec_ushort8 s, d;
  
  s = spu_add(a, b);
  d = spu_or(s, spu_rlmaska(spu_sel(spu_xor(s, -1), a, spu_eqv(a, b)), -15));
  return (d);
}

static inline vec_short8 vec_adds(vec_short8 a, vec_short8 b)
{
  vec_short8 s, d;
  
  s = spu_add(a, b);
  d = spu_sel(s, spu_splats((signed short)0x7FFF), (vec_ushort8)(spu_rlmaska(spu_and(s, spu_nor(a, b)), -15)));
  d = spu_sel(d, spu_splats((signed short)0x8000), (vec_ushort8)(spu_rlmaska(spu_nor(s, spu_nand(a, b)), -15)));
  return (d);
}

static inline vec_short8 vec_adds(vec_bshort8 a, vec_short8 b)
{
  return (vec_adds((vec_short8)(a), b));
}

static inline vec_short8 vec_adds(vec_short8 a, vec_bshort8 b)
{
  return (vec_adds(a, (vec_short8)(b)));
}

static inline vec_uint4 vec_adds(vec_uint4 a, vec_uint4 b)
{
  return (spu_or(spu_add(a, b), spu_rlmaska(spu_sl(spu_genc(a, b), 31), -31)));
}

static inline vec_int4 vec_adds(vec_int4 a, vec_int4 b)
{
  vec_int4 s, d;
  
  s = spu_add(a, b);
  d = spu_sel(s, spu_splats((signed int)0x7FFFFFFF), (vec_uint4)spu_rlmaska(spu_and(s, spu_nor(a, b)), -31));
  d = spu_sel(d, spu_splats((signed int)0x80000000), (vec_uint4)spu_rlmaska(spu_nor(s, spu_nand(a, b)), -31));
  return (d);
}

static inline vec_int4 vec_adds(vec_bint4 a, vec_int4 b)
{
  return (vec_adds((vec_int4)(a), b));
}

static inline vec_int4 vec_adds(vec_int4 a, vec_bint4 b)
{
  return (vec_adds(a, (vec_int4)(b)));
}

/* vec_and (vector logical and)
 * =======
 */
static inline vec_uchar16 vec_and(vec_uchar16 a, vec_uchar16 b)
{
  return (spu_and(a, b));
}

static inline vec_char16 vec_and(vec_char16 a, vec_char16 b)
{
  return (spu_and(a, b));
}

static inline vec_char16 vec_and(vec_bchar16 a, vec_char16 b)
{
  return (spu_and((vec_char16)(a), b));
}

static inline vec_char16 vec_and(vec_char16 a, vec_bchar16 b)
{
  return (spu_and(a, (vec_char16)(b)));
}

static inline vec_ushort8 vec_and(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_and(a, b));
}

static inline vec_short8 vec_and(vec_short8 a, vec_short8 b)
{
  return (spu_and(a, b));
}

static inline vec_short8 vec_and(vec_bshort8 a, vec_short8 b)
{
  return (spu_and((vec_short8)(a), b));
}

static inline vec_short8 vec_and(vec_short8 a, vec_bshort8 b)
{
  return (spu_and(a, (vec_short8)(b)));
}

static inline vec_uint4 vec_and(vec_uint4 a, vec_uint4 b)
{
  return (spu_and(a, b));
}

static inline vec_int4 vec_and(vec_int4 a, vec_int4 b)
{
  return (spu_and(a, b));
}

static inline vec_int4 vec_and(vec_bint4 a, vec_int4 b)
{
  return (spu_and((vec_int4)(a), b));
}

static inline vec_int4 vec_and(vec_int4 a, vec_bint4 b)
{
  return (spu_and(a, (vec_int4)(b)));
}

static inline vec_float4 vec_and(vec_float4 a, vec_float4 b)
{
  return (spu_and(a, b));
}

static inline vec_float4 vec_and(vec_bint4 a, vec_float4 b)
{
  return (spu_and((vec_float4)(a),b));
}

static inline vec_float4 vec_and(vec_float4 a, vec_bint4 b)
{
  return (spu_and(a, (vec_float4)(b)));
}


/* vec_andc (vector logical and with complement) 
 * ========
 */
static inline vec_uchar16 vec_andc(vec_uchar16 a, vec_uchar16 b)
{
  return (spu_andc(a, b));
}

static inline vec_char16 vec_andc(vec_char16 a, vec_char16 b)
{
  return (spu_andc(a, b));
}

static inline vec_char16 vec_andc(vec_bchar16 a, vec_char16 b)
{
  return (spu_andc((vec_char16)(a), b));
}

static inline vec_char16 vec_andc(vec_char16 a, vec_bchar16 b)
{
  return (spu_andc(a, (vec_char16)(b)));
}

static inline vec_ushort8 vec_andc(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_andc(a, b));
}

static inline vec_short8 vec_andc(vec_short8 a, vec_short8 b)
{
  return (spu_andc(a, b));
}

static inline vec_short8 vec_andc(vec_bshort8 a, vec_short8 b)
{
  return (spu_andc((vec_short8)(a), b));
}

static inline vec_short8 vec_andc(vec_short8 a, vec_bshort8 b)
{
  return (spu_andc(a, (vec_short8)(b)));
}

static inline vec_uint4 vec_andc(vec_uint4 a, vec_uint4 b)
{
  return (spu_andc(a, b));
}

static inline vec_int4 vec_andc(vec_int4 a, vec_int4 b)
{
  return (spu_andc(a, b));
}

static inline vec_int4 vec_andc(vec_bint4 a, vec_int4 b)
{
  return (spu_andc((vec_int4)(a), b));
}

static inline vec_int4 vec_andc(vec_int4 a, vec_bint4 b)
{
  return (spu_andc(a, (vec_int4)(b)));
}

static inline vec_float4 vec_andc(vec_float4 a, vec_float4 b)
{
  return (spu_andc(a,b));
}

static inline vec_float4 vec_andc(vec_bint4 a, vec_float4 b)
{
  return (spu_andc((vec_float4)(a),b));
}

static inline vec_float4 vec_andc(vec_float4 a, vec_bint4 b)
{
  return (spu_andc(a, (vec_float4)(b)));
}

/* vec_avg (vector average)
 * =======
 */
static inline vec_uchar16 vec_avg(vec_uchar16 a, vec_uchar16 b)
{
  return (spu_avg(a, b));
}

static inline vec_char16 vec_avg(vec_char16 a, vec_char16 b)
{
  return ((vec_char16)(spu_xor(spu_avg((vec_uchar16)(a), (vec_uchar16)(b)), 
			       (vec_uchar16)(spu_and(spu_xor(a,b), 0x80)))));
}

static inline vec_ushort8 vec_avg(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_add(spu_add(spu_rlmask(a, -1), spu_rlmask(b, -1)), 
		  spu_and(spu_or(a, b), 1)));
}

static inline vec_short8 vec_avg(vec_short8 a, vec_short8 b)
{
  return (spu_add(spu_add(spu_rlmaska(a, -1), spu_rlmaska(b, -1)), 
		  spu_and(spu_or(a, b), 1)));
}

static inline vec_uint4 vec_avg(vec_uint4 a, vec_uint4 b)
{
  return (spu_add(spu_add(spu_rlmask(a, -1), spu_rlmask(b, -1)), 
		  spu_and(spu_or(a, b), 1)));
}

static inline vec_int4 vec_avg(vec_int4 a, vec_int4 b)
{
  return (spu_add(spu_add(spu_rlmaska(a, -1), spu_rlmaska(b, -1)), 
		  spu_and(spu_or(a, b), 1)));
}


/* vec_ceil (vector ceiling)
 * ========
 */
static inline vec_float4 vec_ceil(vec_float4 a)
{
  vec_int4  exp;
  vec_uint4 mask;

  a = spu_add(a, (vec_float4)(spu_and(spu_xor(spu_rlmaska((vec_int4)a, -31), -1), spu_splats((signed int)0x3F7FFFFF))));
  exp = spu_sub(127, (vec_int4)(spu_and(spu_rlmask((vec_uint4)(a), -23), 0xFF)));
  mask = spu_rlmask(spu_splats((unsigned int)0x7FFFFF), exp);
  mask = spu_sel(spu_splats((unsigned int)0), mask, spu_cmpgt(exp, -31));
  mask = spu_or(mask, spu_xor((vec_uint4)(spu_rlmaska(spu_add(exp, -1), -31)), -1));

  return ((vec_float4)(spu_andc((vec_uint4)(a), mask)));
}


/* vec_cmpb (vector compare bounds floating-point)
 * ========
 */
static inline vec_int4 vec_cmpb(vec_float4 a, vec_float4 b)
{
  vec_int4 b0 = (vec_int4)spu_splats(0x80000000);
  vec_int4 b1 = (vec_int4)spu_splats(0x40000000);

  return (spu_or(spu_and((vec_int4)spu_cmpgt(a, b), b0), 
		 spu_and((vec_int4)spu_cmpgt(spu_xor(b, (vec_float4)(b0)), a), b1)));
}

/* vec_cmpeq (vector compare equal)
 * =========
 */
#define vec_cmpeq(_a, _b)	spu_cmpeq(_a, _b)


/* vec_cmpge (vector compare greater than or equal)
 * =========
 */
static inline vec_bint4 vec_cmpge(vec_float4 a, vec_float4 b)
{
  return (spu_xor(spu_cmpgt(b, a), -1));
}


/* vec_cmpgt (vector compare greater than)
 * =========
 */
#define vec_cmpgt(_a, _b)	spu_cmpgt(_a, _b)


/* vec_cmple (vector compare less than or equal)
 * =========
 */
static inline vec_bint4 vec_cmple(vec_float4 a, vec_float4 b)
{
  return (spu_xor(spu_cmpgt(a, b), -1));
}


/* vec_cmplt (vector compare less than)
 * =========
 */
#define vec_cmplt(_a, _b)	spu_cmpgt(_b, _a)


/* vec_ctf (vector convert from fixed-point word)
 * =======
 */
#define vec_ctf(_a, _b)		spu_convtf(_a, _b)


/* vec_cts (vector convert to signed fixed-point word saturate)
 * =======
 */
#define vec_cts(_a, _b)		spu_convts(_a, _b)


/* vec_ctu (vector convert to unsigned fixed-point word saturate)
 * =======
 */
#define vec_ctu(_a, _b)		spu_convtu(_a, _b)


/* vec_dss (vector data stream stop)
 * =======
 */
#define vec_dss(_a)


/* vec_dssall (vector data stream stop all)
 * ==========
 */
#define vec_dssall()


/* vec_dst (vector data stream touch)
 * =======
 */
#define vec_dst(_a, _b, _c)


/* vec_dstst (vector data stream touch for store)
 * =========
 */
#define vec_dstst(_a, _b, _c)


/* vec_dststt (vector data stream touch for store transient)
 * ==========
 */
#define vec_dststt(_a, _b, _c)


/* vec_dstt (vector data stream touch transient)
 * ========
 */
#define vec_dstt(_a, _b, _c)


/* vec_expte (vector is 2 raised tp the exponent estimate floating-point)
 * =========
 */
static inline vec_float4 vec_expte(vec_float4 a)
{
  vec_float4 bias, frac, exp;
  vec_int4 ia;

  bias = (vec_float4)(spu_andc(spu_splats((signed int)0x3F7FFFFF), spu_rlmaska((vec_int4)(a), -31)));
  ia   = spu_convts(spu_add(a, bias), 0);
  frac = spu_sub(spu_convtf(ia, 0), a);
  exp  = (vec_float4)(spu_sl(spu_add(ia, 127), 23));

  return (spu_mul(spu_madd(spu_madd(spu_splats(0.17157287f), frac, spu_splats(-0.67157287f)),
			   frac, spu_splats(1.0f)), exp));
}


/* vec_floor (vector floor)
 * =========
 */
static inline vec_float4 vec_floor(vec_float4 a)
{
  vec_int4  exp;
  vec_uint4 mask;

  a = spu_sub(a, (vec_float4)(spu_and(spu_rlmaska((vec_int4)a, -31), spu_splats((signed int)0x3F7FFFFF))));
  exp = spu_sub(127, (vec_int4)(spu_and(spu_rlmask((vec_uint4)(a), -23), 0xFF)));
  mask = spu_rlmask(spu_splats((unsigned int)0x7FFFFF), exp);
  mask = spu_sel(spu_splats((unsigned int)0), mask, spu_cmpgt(exp, -31));
  mask = spu_or(mask, spu_xor((vec_uint4)(spu_rlmaska(spu_add(exp, -1), -31)), -1));

  return ((vec_float4)(spu_andc((vec_uint4)(a), mask)));
}


/* vec_ld (vector load indexed)
 * ======
 */
static inline vec_uchar16 vec_ld(int a, unsigned char *b)
{
  return (*((vec_uchar16 *)(b+a)));
}

static inline vec_uchar16 vec_ld(int a, vec_uchar16 *b)
{
  return (*((vec_uchar16 *)((unsigned char *)(b)+a)));
}

static inline vec_char16 vec_ld(int a, signed char *b)
{
  return (*((vec_char16 *)(b+a)));
}

static inline vec_char16 vec_ld(int a, vec_char16 *b)
{
  return (*((vec_char16 *)((signed char *)(b)+a)));
}

static inline vec_ushort8 vec_ld(int a, unsigned short *b)
{
  return (*((vec_ushort8 *)((unsigned char *)(b)+a)));
}

static inline vec_ushort8 vec_ld(int a, vec_ushort8 *b)
{
  return (*((vec_ushort8 *)((unsigned char *)(b)+a)));
}

static inline vec_short8 vec_ld(int a, signed short *b)
{
  return (*((vec_short8 *)((unsigned char *)(b)+a)));
}

static inline vec_short8 vec_ld(int a, vec_short8 *b)
{
  return (*((vec_short8 *)((signed char *)(b)+a)));
}

static inline vec_uint4 vec_ld(int a, unsigned int *b)
{
  return (*((vec_uint4 *)((unsigned char *)(b)+a)));
}

static inline vec_uint4 vec_ld(int a, vec_uint4 *b)
{
  return (*((vec_uint4 *)((unsigned char *)(b)+a)));
}

static inline vec_int4 vec_ld(int a, signed int *b)
{
  return (*((vec_int4 *)((unsigned char *)(b)+a)));
}

static inline vec_int4 vec_ld(int a, vec_int4 *b)
{
  return (*((vec_int4 *)((signed char *)(b)+a)));
}

static inline vec_float4 vec_ld(int a, float *b)
{
  return (*((vec_float4 *)((unsigned char *)(b)+a)));
}

static inline vec_float4 vec_ld(int a, vec_float4 *b)
{
  return (*((vec_float4 *)((unsigned char *)(b)+a)));
}

/* vec_lde (vector load element indexed)
 * =======
 */
static inline vec_uchar16 vec_lde(int a, unsigned char *b)
{
  return (*((vec_uchar16 *)(b+a)));
}

static inline vec_char16 vec_lde(int a, signed char *b)
{
  return (*((vec_char16 *)(b+a)));
}

static inline vec_ushort8 vec_lde(int a, unsigned short *b)
{
  return (*((vec_ushort8 *)((unsigned char *)(b)+a)));
}

static inline vec_short8 vec_lde(int a, signed short *b)
{
  return (*((vec_short8 *)((unsigned char *)(b)+a)));
}


static inline vec_uint4 vec_lde(int a, unsigned int *b)
{
  return (*((vec_uint4 *)((unsigned char *)(b)+a)));
}

static inline vec_int4 vec_lde(int a, signed int *b)
{
  return (*((vec_int4 *)((unsigned char *)(b)+a)));
}


static inline vec_float4 vec_lde(int a, float *b)
{
  return (*((vec_float4 *)((unsigned char *)(b)+a)));
}

/* vec_ldl (vector load indexed LRU)
 * =======
 */
#define vec_ldl(_a, _b)		vec_ld(_a, _b)


/* vec_loge (vector log2 estimate floating-point)
 * ========
 */
static inline vec_float4 vec_loge(vec_float4 a)
{
  vec_int4 exp;
  vec_float4 frac;

  exp  = spu_add((vec_int4)(spu_and(spu_rlmask((vec_uint4)(a), -23), 0xFF)), -127);
  frac = (vec_float4)(spu_sub((vec_int4)(a), spu_sl(exp, 23)));

  return (spu_madd(spu_madd(spu_splats(-0.33985f), frac, spu_splats(2.01955f)), 
		   frac, spu_sub(spu_convtf(exp, 0), spu_splats(1.6797f))));
}


/* vec_lvsl (vector load for shift left)
 * ========
 */
static inline vec_uchar16 vec_lvsl(int a, unsigned char *b)
{
  return ((vec_uchar16)spu_add((vec_ushort8)(spu_splats((unsigned char)((a + (int)(b)) & 0xF))), 
			       ((vec_ushort8){0x0001, 0x0203, 0x0405, 0x0607,
				              0x0809, 0x0A0B, 0x0C0D, 0x0E0F})));
}

static inline vec_uchar16 vec_lvsl(int a, signed char *b)
{
  return (vec_lvsl(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsl(int a, unsigned short *b)
{
  return (vec_lvsl(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsl(int a, short *b)
{
  return (vec_lvsl(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsl(int a, unsigned int *b)
{
  return (vec_lvsl(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsl(int a, int *b)
{
  return (vec_lvsl(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsl(int a, float *b)
{
  return (vec_lvsl(a, (unsigned char *)b));
}


/* vec_lvsr (vector load for shift right)
 * ========
 */
static  inline vec_uchar16 vec_lvsr(int a, unsigned char *b)
{
  return ((vec_uchar16)(spu_sub(((vec_ushort8){0x1011, 0x1213, 0x1415, 0x1617,
				               0x1819, 0x1A1B, 0x1C1D, 0x1E1F}),
				(vec_ushort8)(spu_splats((unsigned char)((a + (int)(b)) & 0xF))))));
}

static inline vec_uchar16 vec_lvsr(int a, signed char *b)
{
  return (vec_lvsr(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsr(int a, unsigned short *b)
{
  return (vec_lvsr(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsr(int a, short *b)
{
  return (vec_lvsr(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsr(int a, unsigned int *b)
{
  return (vec_lvsr(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsr(int a, int *b)
{
  return (vec_lvsr(a, (unsigned char *)b));
}

static inline vec_uchar16 vec_lvsr(int a, float *b)
{
  return (vec_lvsr(a, (unsigned char *)b));
}

/* vec_madd (vector multiply add)
 * ========
 */
#define vec_madd(_a, _b, _c)	spu_madd(_a, _b, _c)



/* vec_madds (vector multiply add saturate)
 * =========
 */
static inline vec_short8 vec_madds(vec_short8 a, vec_short8 b, vec_short8 c)
{
  return (vec_adds(c, spu_sel((vec_short8)(spu_sl(spu_mule(a, b), 1)),
			      (vec_short8)(spu_rlmask(spu_mulo(a, b), -15)),
			      ((vec_ushort8){0, 0xFFFF, 0, 0xFFFF, 0, 0xFFFF, 0, 0xFFFF}))));
}

/* vec_max (vector maximum)
 * =======
 */
static inline vec_uchar16 vec_max(vec_uchar16 a, vec_uchar16 b)
{
  return (spu_sel(b, a, spu_cmpgt(a, b)));
}

static inline vec_char16 vec_max(vec_char16 a, vec_char16 b)
{
  return (spu_sel(b, a, spu_cmpgt(a, b)));
}

static inline vec_char16 vec_max(vec_bchar16 a, vec_char16 b)
{
  return (spu_sel(b, (vec_char16)(a), spu_cmpgt((vec_char16)(a), b)));
}

static inline vec_char16 vec_max(vec_char16 a, vec_bchar16 b)
{
  return (spu_sel((vec_char16)(b), a, spu_cmpgt(a, (vec_char16)(b))));
}

static inline vec_ushort8 vec_max(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_sel(b, a, spu_cmpgt(a, b)));
}

static inline vec_short8 vec_max(vec_short8 a, vec_short8 b)
{
  return (spu_sel(b, a, spu_cmpgt(a, b)));
}

static inline vec_short8 vec_max(vec_bshort8 a, vec_short8 b)
{
  return (spu_sel(b, (vec_short8)(a), spu_cmpgt((vec_short8)(a), b)));
}

static inline vec_short8 vec_max(vec_short8 a, vec_bshort8 b)
{
  return (spu_sel((vec_short8)(b), a, spu_cmpgt(a, (vec_short8)(b))));
}

static inline vec_uint4 vec_max(vec_uint4 a, vec_uint4 b)
{
  return (spu_sel(b, a, spu_cmpgt(a, b)));
}

static inline vec_int4 vec_max(vec_int4 a, vec_int4 b)
{
  return (spu_sel(b, a, spu_cmpgt(a, b)));
}

static inline vec_int4 vec_max(vec_bint4 a, vec_int4 b)
{
  return (spu_sel(b, (vec_int4)(a), spu_cmpgt((vec_int4)(a), b)));
}

static inline vec_int4 vec_max(vec_int4 a, vec_bint4 b)
{
  return (spu_sel((vec_int4)(b), a, spu_cmpgt(a, (vec_int4)(b))));
}

static inline vec_float4 vec_max(vec_float4 a, vec_float4 b)
{
  return (spu_sel(b, a, spu_cmpgt(a, b)));
}


/* vec_mergeh (vector merge high)
 * ==========
 */
static inline vec_uchar16 vec_mergeh(vec_uchar16 a, vec_uchar16 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){0, 16, 1, 17, 2, 18, 3, 19,
				           4, 20, 5, 21, 6, 22, 7, 23})));
}

static inline vec_char16 vec_mergeh(vec_char16 a, vec_char16 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){0, 16, 1, 17, 2, 18, 3, 19,
				           4, 20, 5, 21, 6, 22, 7, 23})));
}

static inline vec_ushort8 vec_mergeh(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){0, 1, 16, 17, 2, 3, 18, 19, 
				           4, 5, 20, 21, 6, 7, 22, 23})));
}

static inline vec_short8 vec_mergeh(vec_short8 a, vec_short8 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){0, 1, 16, 17, 2, 3, 18, 19, 
				           4, 5, 20, 21, 6, 7, 22, 23})));
}

static inline vec_uint4 vec_mergeh(vec_uint4 a, vec_uint4 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){0, 1, 2, 3, 16, 17, 18, 19, 
				           4, 5, 6, 7, 20, 21, 22, 23})));
}

static inline vec_int4 vec_mergeh(vec_int4 a, vec_int4 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){0, 1, 2, 3, 16, 17, 18, 19, 
				           4, 5, 6, 7, 20, 21, 22, 23})));
}

static inline vec_float4 vec_mergeh(vec_float4 a, vec_float4 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){0, 1, 2, 3, 16, 17, 18, 19, 
				           4, 5, 6, 7, 20, 21, 22, 23})));
}

/* vec_mergel (vector merge low)
 * ==========
 */
static inline vec_uchar16 vec_mergel(vec_uchar16 a, vec_uchar16 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){ 8, 24,  9, 25, 10, 26, 11, 27, 
				           12, 28, 13, 29, 14, 30, 15, 31})));
}

static inline vec_char16 vec_mergel(vec_char16 a, vec_char16 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){ 8, 24,  9, 25, 10, 26, 11, 27, 
				           12, 28, 13, 29, 14, 30, 15, 31})));
}

static inline vec_ushort8 vec_mergel(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){ 8,  9, 24, 25, 10, 11, 26, 27, 
				           12, 13, 28, 29, 14, 15, 30, 31})));
}

static inline vec_short8 vec_mergel(vec_short8 a, vec_short8 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){ 8,  9, 24, 25, 10, 11, 26, 27, 
				           12, 13, 28, 29, 14, 15, 30, 31})));
}

static inline vec_uint4 vec_mergel(vec_uint4 a, vec_uint4 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){ 8,  9, 10, 11, 24, 25, 26, 27, 
				           12, 13, 14, 15, 28, 29, 30, 31})));
}

static inline vec_int4 vec_mergel(vec_int4 a, vec_int4 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){ 8,  9, 10, 11, 24, 25, 26, 27, 
				           12, 13, 14, 15, 28, 29, 30, 31})));
}

static inline vec_float4 vec_mergel(vec_float4 a, vec_float4 b)
{
  return (spu_shuffle(a, b, ((vec_uchar16){ 8,  9, 10, 11, 24, 25, 26, 27, 
				           12, 13, 14, 15, 28, 29, 30, 31})));
}

/* vec_mfvscr (vector move from vector status and control register)
 * ==========
 */
static inline vec_ushort8 vec_mfvscr()
{
  return ((vec_ushort8)spu_splats(0)); 		/* not supported */
}


/* vec_min (vector minimum)
 * =======
 */
static inline vec_uchar16 vec_min(vec_uchar16 a, vec_uchar16 b)
{
  return (spu_sel(a, b, spu_cmpgt(a, b)));
}

static inline vec_char16 vec_min(vec_char16 a, vec_char16 b)
{
  return (spu_sel(a, b, spu_cmpgt(a, b)));
}

static inline vec_char16 vec_min(vec_bchar16 a, vec_char16 b)
{
  return (spu_sel((vec_char16)(a), b, spu_cmpgt((vec_char16)(a), b)));
}

static inline vec_char16 vec_min(vec_char16 a, vec_bchar16 b)
{
  return (spu_sel(a, (vec_char16)(b), spu_cmpgt(a, (vec_char16)(b))));
}

static inline vec_ushort8 vec_min(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_sel(a, b, spu_cmpgt(a, b)));
}

static inline vec_short8 vec_min(vec_short8 a, vec_short8 b)
{
  return (spu_sel(a, b, spu_cmpgt(a, b)));
}

static inline vec_short8 vec_min(vec_bshort8 a, vec_short8 b)
{
  return (spu_sel((vec_short8)(a), b, spu_cmpgt((vec_short8)(a), b)));
}

static inline vec_short8 vec_min(vec_short8 a, vec_bshort8 b)
{
  return (spu_sel(a, (vec_short8)(b), spu_cmpgt(a, (vec_short8)(b))));
}

static inline vec_uint4 vec_min(vec_uint4 a, vec_uint4 b)
{
  return (spu_sel(a, b, spu_cmpgt(a, b)));
}

static inline vec_int4 vec_min(vec_int4 a, vec_int4 b)
{
  return (spu_sel(a, b, spu_cmpgt(a, b)));
}

static inline vec_int4 vec_min(vec_bint4 a, vec_int4 b)
{
  return (spu_sel((vec_int4)(a), b, spu_cmpgt((vec_int4)(a), b)));
}

static inline vec_int4 vec_min(vec_int4 a, vec_bint4 b)
{
  return (spu_sel(a, (vec_int4)(b), spu_cmpgt(a, (vec_int4)(b))));
}

static inline vec_float4 vec_min(vec_float4 a, vec_float4 b)
{
  return (spu_sel(a, b, spu_cmpgt(a, b)));
}

/* vec_mladd (vector multiply low and add unsigned half word)
 * =========
 */
static inline vec_short8 vec_mladd(vec_short8 a, vec_short8 b, vec_short8 c)
{
  return ((vec_short8)(spu_shuffle(spu_madd((vec_short8)(spu_rl((vec_uint4)(a), -16)),
					    (vec_short8)(spu_rl((vec_uint4)(b), -16)),
					    (vec_int4)(spu_rl((vec_uint4)(c), -16))),
				   spu_madd(a, b, spu_extend(c)),
				   ((vec_uchar16){ 2,  3, 18, 19,  6,  7, 22, 23,
					          10, 11, 26, 27, 14, 15, 30, 31}))));
}


static inline vec_ushort8 vec_mladd(vec_ushort8 a, vec_ushort8 b, vec_ushort8 c)
{
  return ((vec_ushort8)(vec_mladd((vec_short8)(a), (vec_short8)(b), (vec_short8)(c))));
}

static inline vec_short8 vec_mladd(vec_ushort8 a, vec_short8 b, vec_short8 c)
{
  return (vec_mladd((vec_short8)(a), b, c));
}

static inline vec_short8 vec_mladd(vec_short8 a, vec_ushort8 b, vec_ushort8 c)
{
  return (vec_mladd(a, (vec_short8)(b), (vec_short8)(c)));
}


/* vec_mradds (vector multiply round and add saturate)
 * ==========
 */
static inline vec_short8 vec_mradds(vec_short8 a, vec_short8 b, vec_short8 c)
{
  vec_int4 round = (vec_int4)spu_splats(0x4000);
  vec_short8 hi, lo;

  hi = (vec_short8)(spu_sl(spu_add(spu_mule(a, b), round), 1));
  lo = (vec_short8)(spu_rlmask(spu_add(spu_mulo(a, b), round), -15));

  return (vec_adds(spu_sel(hi, lo, ((vec_ushort8){0, 0xFFFF, 0, 0xFFFF, 0, 0xFFFF, 0, 0xFFFF})), c));
}


/* vec_msum (vector multiply sum)
 * ========
 */
static inline vec_uint4 vec_msum(vec_uchar16 a, vec_uchar16 b, vec_uint4 c)
{
  vec_ushort8 a1, a2, b1, b2;
  vec_uint4 p1, p2;

  a1 = spu_and((vec_ushort8)(a), 0xFF);
  a2 = spu_rlmask((vec_ushort8)(a), -8);
  b1 = spu_and((vec_ushort8)(b), 0xFF);
  b2 = spu_rlmask((vec_ushort8)(b), -8);

  p1 = spu_add(spu_mulo(a1, b1), spu_mulo(spu_rlqwbyte(a1, -2), spu_rlqwbyte(b1, -2)));
  p2 = spu_add(spu_mulo(a2, b2), spu_mulo(spu_rlqwbyte(a2, -2), spu_rlqwbyte(b2, -2)));
  return (spu_add(p2, spu_add(p1, c)));
}

static inline vec_int4 vec_msum(vec_char16 a, vec_uchar16 b, vec_int4 c)
{
  vec_short8 a1, a2, b1, b2;
  vec_int4 p1, p2;

  a1 = (vec_short8)(spu_extend(a));
  a2 = spu_rlmaska((vec_short8)(a), -8);
  b1 = (vec_short8)(spu_and((vec_ushort8)(b), 0xFF));
  b2 = (vec_short8)spu_rlmask((vec_ushort8)(b), -8);

  p1 = spu_add(spu_mulo(a1, b1), spu_mulo(spu_rlqwbyte(a1, -2), spu_rlqwbyte(b1, -2)));
  p2 = spu_add(spu_mulo(a2, b2), spu_mulo(spu_rlqwbyte(a2, -2), spu_rlqwbyte(b2, -2)));
  return (spu_add(p2, spu_add(p1, c)));
}

static inline vec_uint4 vec_msum(vec_ushort8 a, vec_ushort8 b, vec_uint4 c)
{
  return (spu_add(spu_add(spu_mulo(a, b), spu_mulo(spu_rlqwbyte(a, -2), spu_rlqwbyte(b, -2))), c));
}

static inline vec_int4 vec_msum(vec_short8 a, vec_short8 b, vec_int4 c)
{
  return (spu_add(spu_add(spu_mulo(a, b), spu_mulo(spu_rlqwbyte(a, -2), spu_rlqwbyte(b, -2))), c));
}


/* vec_msums (vector multiply sum saturate)
 * ========
 */
static inline vec_uint4 vec_msums(vec_ushort8 a, vec_ushort8 b, vec_uint4 c)
{
  vec_uint4 p1, p2;

  p1 = spu_mulo(a, b);
  p2 = spu_mulo(spu_rlqwbyte(a, -2), spu_rlqwbyte(b, -2));

  return (vec_adds(p2, vec_adds(p1, c)));
}

static inline vec_int4 vec_msums(vec_short8 a, vec_short8 b, vec_int4 c)
{
  return (vec_adds(spu_add(spu_mulo(a, b), spu_mulo(spu_rlqwbyte(a, -2), spu_rlqwbyte(b, -2))), c));
}

/* vec_mtvscr (vector move to vector status and control register)
 * ==========
 */
#define vec_mtvscr(_a)		/* not supported */


/* vec_mule (vector multiply even)
 * ========
 */
static inline vec_ushort8 vec_mule(vec_uchar16 a, vec_uchar16 b)
{
  vec_ushort8 hi, lo;

  hi = (vec_ushort8)spu_mulo((vec_ushort8)(spu_rlmask((vec_uint4)(a), -24)), 
			     (vec_ushort8)(spu_rlmask((vec_uint4)(b), -24)));
  lo = (vec_ushort8)spu_mulo((vec_ushort8)(spu_rlmask((vec_short8)(a), -8)), 
			     (vec_ushort8)(spu_rlmask((vec_short8)(b), -8)));

  return (spu_shuffle(hi, lo, ((vec_uchar16){ 2,  3, 18, 19,  6,  7, 22, 23,
				             10, 11, 26, 27, 14, 15, 30, 31})));
}

static inline vec_short8 vec_mule(vec_char16 a, vec_char16 b)
{
  vec_short8 hi, lo;

  hi = (vec_short8)spu_mulo((vec_short8)(spu_rlmaska((vec_uint4)(a), -24)), 
			    (vec_short8)(spu_rlmaska((vec_uint4)(b), -24)));
  lo = (vec_short8)spu_mulo((vec_short8)(spu_rlmaska((vec_short8)(a), -8)), 
			    (vec_short8)(spu_rlmaska((vec_short8)(b), -8)));

  return (spu_shuffle(hi, lo, ((vec_uchar16){ 2,  3, 18, 19,  6,  7, 22, 23,
				             10, 11, 26, 27, 14, 15, 30, 31})));
}

static inline vec_uint4 vec_mule(vec_ushort8 a, vec_ushort8 b)
{
 return (spu_mulo((vec_ushort8)spu_rlmask((vec_uint4)(a), -16),
		  (vec_ushort8)spu_rlmask((vec_uint4)(b), -16)));
}


static inline vec_int4 vec_mule(vec_short8 a, vec_short8 b)
{
 return (spu_mulo((vec_short8)spu_rlmaska((vec_int4)(a), -16),
		  (vec_short8)spu_rlmaska((vec_int4)(b), -16)));
}


/* vec_mulo (vector multiply odd)
 * ========
 */
static inline vec_ushort8 vec_mulo(vec_uchar16 a, vec_uchar16 b)
{
  vec_ushort8 hi, lo;

  hi = (vec_ushort8)spu_mulo((vec_ushort8)(spu_and(spu_rlmask((vec_uint4)(a), -16), 0xFF)), 
			     (vec_ushort8)(spu_and(spu_rlmask((vec_uint4)(b), -16), 0xFF)));
  lo = (vec_ushort8)spu_mulo(spu_and((vec_ushort8)(a), 0xFF), spu_and((vec_ushort8)(b), 0xFF));

  return (spu_shuffle(hi, lo, ((vec_uchar16){ 2,  3, 18, 19,  6,  7, 22, 23,
				             10, 11, 26, 27, 14, 15, 30, 31})));
}

static inline vec_short8 vec_mulo(vec_char16 a, vec_char16 b)
{
  vec_short8 aa, bb, hi, lo;

  aa = spu_extend(a);
  bb = spu_extend(b);

  hi = (vec_short8)spu_mulo((vec_short8)(spu_rlmaska((vec_uint4)(aa), -16)), 
		(vec_short8)(spu_rlmaska((vec_uint4)(bb), -16)));
  lo = (vec_short8)spu_mulo(aa, bb);
  return (spu_shuffle(hi, lo, ((vec_uchar16){ 2,  3, 18, 19,  6,  7, 22, 23,
				             10, 11, 26, 27, 14, 15, 30, 31})));
}

static inline vec_uint4 vec_mulo(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_mulo(a, b));
}


static inline vec_int4 vec_mulo(vec_short8 a, vec_short8 b)
{
  return (spu_mulo(a, b));
}


/* vec_nmsub (vector negative multiply subtract)
 * =========
 */
#define vec_nmsub(_a, _b, _c)	spu_nmsub(_a, _b, _c)


/* vec_nor (vector logical nor)
 * =======
 */
#define vec_nor(_a, _b)		spu_nor(_a, _b)


/* vec_or (vector logical or)
 * ======
 */
static inline vec_uchar16 vec_or(vec_uchar16 a, vec_uchar16 b)
{
  return (spu_or(a, b));
}

static inline vec_char16 vec_or(vec_char16 a, vec_char16 b)
{
  return (spu_or(a, b));
}

static inline vec_char16 vec_or(vec_bchar16 a, vec_char16 b)
{
  return (spu_or((vec_char16)(a), b));
}

static inline vec_char16 vec_or(vec_char16 a, vec_bchar16 b)
{
  return (spu_or(a, (vec_char16)(b)));
}

static inline vec_ushort8 vec_or(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_or(a, b));
}

static inline vec_short8 vec_or(vec_short8 a, vec_short8 b)
{
  return (spu_or(a, b));
}

static inline vec_short8 vec_or(vec_bshort8 a, vec_short8 b)
{
  return (spu_or((vec_short8)(a), b));
}

static inline vec_short8 vec_or(vec_short8 a, vec_bshort8 b)
{
  return (spu_or(a, (vec_short8)(b)));
}

static inline vec_uint4 vec_or(vec_uint4 a, vec_uint4 b)
{
  return (spu_or(a, b));
}

static inline vec_int4 vec_or(vec_int4 a, vec_int4 b)
{
  return (spu_or(a, b));
}

static inline vec_int4 vec_or(vec_bint4 a, vec_int4 b)
{
  return (spu_or((vec_int4)(a), b));
}

static inline vec_int4 vec_or(vec_int4 a, vec_bint4 b)
{
  return (spu_or(a, (vec_int4)(b)));
}

static inline vec_float4 vec_or(vec_float4 a, vec_float4 b)
{
  return (spu_or(a, b));
}

static inline vec_float4 vec_or(vec_bint4 a, vec_float4 b)
{
  return (spu_or((vec_float4)(a),b));
}

static inline vec_float4 vec_or(vec_float4 a, vec_bint4 b)
{
  return (spu_or(a, (vec_float4)(b)));
}


/* vec_pack (vector pack)
 * ========
 */
static inline vec_uchar16 vec_pack(vec_ushort8 a, vec_ushort8 b)
{
  return ((vec_uchar16)spu_shuffle(a, b, ((vec_uchar16){ 1,  3,  5,  7,  9, 11, 13, 15,
					                17, 19, 21, 23, 25, 27, 29, 31})));
}

static inline vec_char16 vec_pack(vec_short8 a, vec_short8 b)
{
  return ((vec_char16)spu_shuffle(a, b, ((vec_uchar16){ 1,  3,  5,  7,  9, 11, 13, 15,
					               17, 19, 21, 23, 25, 27, 29, 31})));
}

static inline vec_ushort8 vec_pack(vec_uint4 a, vec_uint4 b)
{
  return ((vec_ushort8)spu_shuffle(a, b, ((vec_uchar16){ 2,  3,  6,  7, 10, 11, 14, 15,
					                18, 19, 22, 23, 26, 27, 30, 31})));
}

static inline vec_short8 vec_pack(vec_int4 a, vec_int4 b)
{
  return ((vec_short8)spu_shuffle(a, b, ((vec_uchar16){ 2,  3,  6,  7, 10, 11, 14, 15,
					               18, 19, 22, 23, 26, 27, 30, 31})));
}


/* vec_packpx (vector pack pixel)
 * ==========
 */
static inline vec_pixel8 vec_packpx(vec_uint4 a, vec_uint4 b)
{
  vec_uint4 x03FF = (vec_uint4)(spu_splats((unsigned short)0x03FF));
  vec_uint4 x001F = (vec_uint4)(spu_splats((unsigned short)0x001F));

  return ((vec_pixel8)(spu_shuffle(spu_sel(spu_sel(spu_sl(a, 7), spu_sl(a, 10), x03FF),
					   spu_sl(a, 13), x001F),
				   spu_sel(spu_sel(spu_sl(b, 7), spu_sl(b, 10), x03FF),
					   spu_sl(b, 13), x001F),
				   ((vec_uchar16){ 0,  1,  4,  5,   8,  9, 12, 13,
					          16, 17, 20, 21, 24, 25, 28, 29}))));
}


/* vec_packs (vector pack saturate)
 * =========
 */
static inline vec_uchar16 vec_packs(vec_ushort8 a, vec_ushort8 b)
{
  vec_ushort8 max = spu_splats((unsigned short)0x00FF);
  
  return ((vec_uchar16)(spu_shuffle(spu_sel(a, max, spu_cmpgt(a, 255)),
				    spu_sel(b, max, spu_cmpgt(b, 255)),
				    ((vec_uchar16){ 1,  3,  5,  7,  9, 11, 13, 15,
					           17, 19, 21, 23, 25, 27, 29, 31}))));
}

static inline vec_char16 vec_packs(vec_short8 a, vec_short8 b)
{
  vec_short8 max = spu_splats((signed short)0x007F);
  vec_short8 min = spu_splats((signed short)0xFF80);
  
  return ((vec_char16)(spu_shuffle(spu_sel(min, spu_sel(a, max, spu_cmpgt(a, 127)), spu_cmpgt(a, -128)),
				    spu_sel(min, spu_sel(b, max, spu_cmpgt(b, 127)), spu_cmpgt(b, -128)),
				   ((vec_uchar16){ 1,  3,  5,  7,  9, 11, 13, 15,
					          17, 19, 21, 23, 25, 27, 29, 31}))));
}

static inline vec_ushort8 vec_packs(vec_uint4 a, vec_uint4 b)
{
  vec_uint4 max = spu_splats((unsigned int)0x0000FFFF);
  
  return ((vec_ushort8)(spu_shuffle(spu_sel(a, max, spu_cmpgt(a, max)), 
				    spu_sel(b, max, spu_cmpgt(b, max)), 
				    ((vec_uchar16){ 2,  3,  6,  7, 10, 11, 14, 15,
					           18, 19, 22, 23, 26, 27, 30, 31}))));
}  

static inline vec_short8 vec_packs(vec_int4 a, vec_int4 b)
{
  vec_int4 max = spu_splats((signed int)0x00007FFF);
  vec_int4 min = spu_splats((signed int)0xFFFF8000);
  
  return ((vec_short8)(spu_shuffle(spu_sel(min, spu_sel(a, max, spu_cmpgt(a, max)), spu_cmpgt(a, min)),
				   spu_sel(min, spu_sel(b, max, spu_cmpgt(b, max)), spu_cmpgt(b, min)),
				   ((vec_uchar16){ 2,  3,  6,  7, 10, 11, 14, 15,
					          18, 19, 22, 23, 26, 27, 30, 31}))));
}  


/* vec_packsu (vector pack saturate unsigned)
 * ==========
 */
static inline vec_uchar16 vec_packsu(vec_ushort8 a, vec_ushort8 b)
{
  return ((vec_uchar16)spu_shuffle(spu_or(a, (vec_ushort8)(spu_cmpgt(a, 255))),
				   spu_or(b, (vec_ushort8)(spu_cmpgt(b, 255))),
				   ((vec_uchar16){ 1,  3,  5,  7,  9, 11, 13, 15,
					          17, 19, 21, 23, 25, 27, 29, 31})));
}

static inline vec_uchar16 vec_packsu(vec_short8 a, vec_short8 b)
{
  vec_short8 max = spu_splats((signed short)0x00FF);
  vec_short8 min = spu_splats((signed short)0x0000);
  
  return ((vec_uchar16)(spu_shuffle(spu_sel(min, spu_sel(a, max, spu_cmpgt(a, 255)), spu_cmpgt(a, 0)),
				    spu_sel(min, spu_sel(b, max, spu_cmpgt(b, 255)), spu_cmpgt(b, 0)),
				    ((vec_uchar16){ 1,  3,  5,  7,  9, 11, 13, 15,
					           17, 19, 21, 23, 25, 27, 29, 31}))));

  return (vec_packsu((vec_ushort8)(a), (vec_ushort8)(b)));
}

static inline vec_ushort8 vec_packsu(vec_uint4 a, vec_uint4 b)
{
  vec_uint4 max = spu_splats((unsigned int)0xFFFF);

  return ((vec_ushort8)spu_shuffle(spu_or(a, (vec_uint4)(spu_cmpgt(a, max))),
				   spu_or(b, (vec_uint4)(spu_cmpgt(b, max))),
				   ((vec_uchar16){ 2,  3,  6,  7, 10, 11, 14, 15,
					          18, 19, 22, 23, 26, 27, 30, 31})));
}

static inline vec_ushort8 vec_packsu(vec_int4 a, vec_int4 b)
{
  vec_int4 max = spu_splats((signed int)0x0000FFFF);
  vec_int4 min = spu_splats((signed int)0x00000000);
  
  return ((vec_ushort8)(spu_shuffle(spu_sel(min, spu_sel(a, max, spu_cmpgt(a, max)), spu_cmpgt(a, min)),
				    spu_sel(min, spu_sel(b, max, spu_cmpgt(b, max)), spu_cmpgt(b, min)),
				    ((vec_uchar16){ 2,  3,  6,  7, 10, 11, 14, 15,
					           18, 19, 22, 23, 26, 27, 30, 31}))));
}


/* vec_perm (vector permute)
 * ========
 */
static inline vec_uchar16 vec_perm(vec_uchar16 a, vec_uchar16 b, vec_uchar16 c)
{
  return (spu_shuffle(a, b, spu_and(c, 0x1F)));
}

static inline vec_char16 vec_perm(vec_char16 a, vec_char16 b, vec_uchar16 c)
{
  return ((vec_char16)(vec_perm((vec_uchar16)(a), (vec_uchar16)(b), c)));
}

static inline vec_ushort8 vec_perm(vec_ushort8 a, vec_ushort8 b, vec_uchar16 c)
{
  return ((vec_ushort8)(vec_perm((vec_uchar16)(a), (vec_uchar16)(b), c)));
}

static inline vec_short8 vec_perm(vec_short8 a, vec_short8 b, vec_uchar16 c)
{
  return ((vec_short8)(vec_perm((vec_uchar16)(a), (vec_uchar16)(b), c)));
}

static inline vec_uint4 vec_perm(vec_uint4 a, vec_uint4 b, vec_uchar16 c)
{
  return ((vec_uint4)(vec_perm((vec_uchar16)(a), (vec_uchar16)(b), c)));
}

static inline vec_int4 vec_perm(vec_int4 a, vec_int4 b, vec_uchar16 c)
{
  return ((vec_int4)(vec_perm((vec_uchar16)(a), (vec_uchar16)(b), c)));
}

static inline vec_float4 vec_perm(vec_float4 a, vec_float4 b, vec_uchar16 c)
{
  return ((vec_float4)(vec_perm((vec_uchar16)(a), (vec_uchar16)(b), c)));
}


/* vec_re (vector reciprocal estimate)
 * ======
 */
#define vec_re(_a)	spu_re(_a)


/* vec_rl (vector rotate left)
 * ======
 */
static inline vec_uchar16 vec_rl(vec_uchar16 a, vec_uchar16 b)
{
  vec_ushort8 r1, r2;

  r1 = spu_rl(spu_and((vec_ushort8)(a), 0xFF), (vec_short8)spu_and((vec_ushort8)(b), 7));
  r2 = spu_rl(spu_and((vec_ushort8)(a), -256), (vec_short8)spu_and(spu_rlmask((vec_ushort8)(b), -8), 7));
  return ((vec_uchar16)(spu_sel(spu_or(r2, spu_sl(r2, 8)), spu_or(r1, spu_rlmask(r1, -8)), spu_splats((unsigned short)0xFF))));
}

static inline vec_char16 vec_rl(vec_char16 a, vec_uchar16 b)
{
  return ((vec_char16)(vec_rl((vec_uchar16)(a), b)));
}

static inline vec_ushort8 vec_rl(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_rl(a, (vec_short8)(b)));
}

static inline vec_short8 vec_rl(vec_short8 a, vec_ushort8 b)
{
  return (spu_rl(a, (vec_short8)(b)));
}

static inline vec_uint4 vec_rl(vec_uint4 a, vec_uint4 b)
{
  return (spu_rl(a, (vec_int4)(b)));
}

static inline vec_int4 vec_rl(vec_int4 a, vec_uint4 b)
{
  return (spu_rl(a, (vec_int4)(b)));
}


/* vec_round (vector round)
 * =========
 */
static inline vec_float4 vec_round(vec_float4 a)
{
  vec_float4 s_half, s_one, d;
  vec_uint4 odd;
  vec_uint4 msb = spu_splats((unsigned int)0x80000000);
  vec_float4 half = spu_splats(0.5f);
  vec_int4 exp;
  vec_uint4 mask;

  s_half = (vec_float4)(spu_sel((vec_uint4)(half), (vec_uint4)(a), msb));
  a = spu_add(a, s_half);
  s_one = spu_add(s_half, s_half);
  exp  = spu_sub(127, (vec_int4)(spu_and(spu_rlmask((vec_uint4)(a), -23), 0xFF)));
  mask = spu_rlmask(spu_splats((unsigned int)0x7FFFFF), exp);
  mask = spu_sel(spu_splats((unsigned int)0), mask, spu_cmpgt(exp, -31));
  mask = spu_or(mask, spu_xor((vec_uint4)(spu_rlmaska(spu_add(exp, -1), -31)), -1));

  odd = spu_and((vec_uint4)(spu_convts(a, 0)), 1);
  s_one = spu_andc(s_one, (vec_float4)spu_cmpeq(mask, 0));
  s_one = spu_and(s_one, spu_and((vec_float4)spu_cmpeq(spu_and((vec_uint4)(a), mask), 0),
				 (vec_float4)spu_cmpeq(odd, 1)));
  d = spu_andc(a, (vec_float4)(mask));
  d = spu_sub(d, s_one);
  return (d);
}

/* vec_rsqrte (vector reciprocal square root estimate)
 * ==========
 */
#define vec_rsqrte(_a)	spu_rsqrte(_a)


/* vec_sel (vector select)
 * =======
 */
#define vec_sel(_a, _b, _c)	spu_sel(_a, _b, _c)


/* vec_sl (vector shift left)
 * ======
 */
static inline vec_uchar16 vec_sl(vec_uchar16 a, vec_uchar16 b)
{
  vec_ushort8 hi, lo;

  lo = spu_and(spu_sl((vec_ushort8)(a), spu_and((vec_ushort8)(b), 7)), 0xFF);
  hi = spu_sl(spu_and((vec_ushort8)(a), -256), spu_and(spu_rlmask((vec_ushort8)(b), -8), 7));

  return ((vec_uchar16)(spu_or(hi, lo)));
}

static inline vec_char16 vec_sl(vec_char16 a, vec_uchar16 b)
{
  return ((vec_char16)(vec_sl((vec_uchar16)(a), b)));
}

static inline vec_ushort8 vec_sl(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_sl(a, spu_and(b, 15)));
}

static inline vec_short8 vec_sl(vec_short8 a, vec_ushort8 b)
{
  return (spu_sl(a, spu_and((vec_ushort8)(b), 15)));
}

static inline vec_uint4 vec_sl(vec_uint4 a, vec_uint4 b)
{
  return (spu_sl(a, spu_and(b, 31)));
}

static inline vec_int4 vec_sl(vec_int4 a, vec_uint4 b)
{
  return (spu_sl(a, spu_and(b, 31)));
}


/* vec_sld (vector shift left double)
 * =======
 */
#define vec_sld(_a, _b, _c)	spu_shuffle(_a, _b, ((vec_uchar16){ 0+(_c),  1+(_c),  2+(_c),  3+(_c),  \
								    4+(_c),  5+(_c),  6+(_c),  7+(_c), 	\
								    8+(_c),  9+(_c), 10+(_c), 11+(_c), 	\
							           12+(_c), 13+(_c), 14+(_c), 15+(_c)}))


/* vec_sll (vector shift left long)
 * =======
 */
#define vec_sll(_a, _b)		spu_slqw(_a, spu_extract((vec_uint4)(_b), 0))


/* vec_slo (vector shift left by octet)
 * =======
 */
#define vec_slo(_a, _b)		spu_slqwbytebc(_a, spu_extract((vec_uint4)(_b), 3) & 0x7F)


/* vec_splat (vector splat)
 * =========
 */
#define vec_splat(_a, _b)	spu_splats(spu_extract(_a, _b))


/* vec_splat_s8 (vector splat signed byte)
 * ============
 */
#define vec_splat_s8(_a)	spu_splats((signed char)(_a))


/* vec_splat_s16 (vector splat signed half-word)
 * =============
 */
#define vec_splat_s16(_a)	spu_splats((signed short)(_a))


/* vec_splat_s32 (vector splat signed word)
 * =============
 */
#define vec_splat_s32(_a)	spu_splats((signed int)(_a))


/* vec_splat_u8 (vector splat unsigned byte)
 * ============
 */
#define vec_splat_u8(_a)	spu_splats((unsigned char)(_a))


/* vec_splat_u16 (vector splat unsigned half-word)
 * =============
 */
#define vec_splat_u16(_a)	spu_splats((unsigned short)(_a))


/* vec_splat_u32 (vector splat unsigned word)
 * =============
 */
#define vec_splat_u32(_a)	spu_splats((unsigned int)(_a))


/* vec_sr (vector shift right)
 * ======
 */
static inline vec_uchar16 vec_sr(vec_uchar16 a, vec_uchar16 b)
{
  vec_ushort8 hi, lo;

  lo = spu_rlmask(spu_and((vec_ushort8)(a), 0xFF), spu_sub(0, (vec_short8)(spu_and((vec_ushort8)(b), 7))));
  hi = spu_and(spu_rlmask((vec_ushort8)(a), spu_sub(0, (vec_short8)(spu_and(spu_rlmask((vec_ushort8)(b), -8), 7)))), -256);

  return ((vec_uchar16)(spu_or(hi, lo)));
}

static inline vec_char16 vec_sr(vec_char16 a, vec_uchar16 b)
{
  return ((vec_char16)(vec_sr((vec_uchar16)(a), b)));
}

static inline vec_ushort8 vec_sr(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_rlmask(a, spu_sub(0, (vec_short8)(spu_and(b, 15)))));
}

static inline vec_short8 vec_sr(vec_short8 a, vec_ushort8 b)
{
  return ((vec_short8)(vec_sr((vec_ushort8)(a), b)));
}

static inline vec_uint4 vec_sr(vec_uint4 a, vec_uint4 b)
{
  return (spu_rlmask(a, spu_sub(0, (vec_int4)(spu_and(b, 31)))));
}

static inline vec_int4 vec_sr(vec_int4 a, vec_uint4 b)
{
  return ((vec_int4)(vec_sr((vec_uint4)(a), b)));
}


/* vec_sra (vector shift right algebraic)
 * =======
 */
static inline vec_char16 vec_sra(vec_char16 a, vec_uchar16 b)
{
  vec_short8 hi, lo;

  lo = spu_and(spu_rlmaska(spu_extend(a), spu_sub(0, (vec_short8)(spu_and((vec_ushort8)(b), 7)))), 0xFF);
  hi = spu_and(spu_rlmaska((vec_short8)(a), spu_sub(0, (vec_short8)(spu_and(spu_rlmask((vec_ushort8)(b), -8), 7)))), -256);

  return ((vec_char16)(spu_or(hi, lo)));
}

static inline vec_uchar16 vec_sra(vec_uchar16 a, vec_uchar16 b)
{
  return ((vec_uchar16)(vec_sra((vec_char16)(a), b)));
}

static inline vec_short8 vec_sra(vec_short8 a, vec_ushort8 b)
{
  return (spu_rlmaska(a, spu_sub(0, (vec_short8)(spu_and(b, 15)))));
}

static inline vec_ushort8 vec_sra(vec_ushort8 a, vec_ushort8 b)
{
  return ((vec_ushort8)(vec_sra((vec_short8)(a), b)));
}

static inline vec_int4 vec_sra(vec_int4 a, vec_uint4 b)
{
  return (spu_rlmaska(a, spu_sub(0, (vec_int4)(spu_and(b, 31)))));
}

static inline vec_uint4 vec_sra(vec_uint4 a, vec_uint4 b)
{
  return ((vec_uint4)(vec_sra((vec_int4)(a), b)));
}


/* vec_srl (vector shift right long)
 * =======
 */
#define vec_srl(_a, _b)		spu_rlmaskqw(_a, 0-spu_extract((vec_int4)(_b), 3))


/* vec_sro (vector shift right by octet)
 * =======
 */
#define vec_sro(_a, _b)		spu_rlmaskqwbyte(_a, 0 - ((spu_extract((vec_int4)(_b), 3) >> 3) & 0xF))

/* vec_st (vector store indexed)
 * ======
 */
static inline void vec_st(vec_uchar16 a, int b, unsigned char *c)
{
  *((vec_uchar16 *)(c+b)) = a;
}

static inline void vec_st(vec_uchar16 a, int b, vec_uchar16 *c)
{
  *((vec_uchar16 *)((unsigned char *)(c)+b)) = a;
}

static inline void vec_st(vec_char16 a, int b, signed char *c)
{
  *((vec_char16 *)(c+b)) = a;
}

static inline void vec_st(vec_char16 a, int b, vec_char16 *c)
{
  *((vec_char16 *)((signed char *)(c)+b)) = a;
}

static inline void vec_st(vec_bchar16 a, int b, signed char *c)
{
  *((vec_bchar16 *)((signed char *)(c)+b)) = a;
}

static inline void vec_st(vec_ushort8 a, int b, unsigned short *c)
{
  *((vec_ushort8 *)((unsigned char *)(c)+b)) = a;
}

static inline void vec_st(vec_ushort8 a, int b, vec_ushort8 *c)
{
  *((vec_ushort8 *)((unsigned char *)(c)+b)) = a;
}

static inline void vec_st(vec_short8 a, int b, signed short *c)
{
  *((vec_short8 *)((unsigned char *)(c)+b)) = a;
}

static inline void vec_st(vec_short8 a, int b, vec_short8 *c)
{
  *((vec_short8 *)((signed char *)(c)+b)) = a;
}

static inline void vec_st(vec_bshort8 a, int b, signed short *c)
{
  *((vec_bshort8 *)((signed char *)(c)+b)) = a;
}

static inline void vec_st(vec_uint4 a, int b, unsigned int *c)
{
  *((vec_uint4 *)((unsigned char *)(c)+b)) = a;
}

static inline void vec_st(vec_uint4 a, int b, vec_uint4 *c)
{
  *((vec_uint4 *)((unsigned char *)(c)+b)) = a;
}

static inline void vec_st(vec_int4 a, int b, signed int *c)
{
  *((vec_int4 *)((unsigned char *)(c)+b)) = a;
}

static inline void vec_st(vec_int4 a, int b, vec_int4 *c)
{
  *((vec_int4 *)((signed char *)(c)+b)) = a;
}

static inline void vec_st(vec_bint4 a, int b, signed int *c)
{
  *((vec_bint4 *)((signed char *)(c)+b)) = a;
}

static inline void vec_st(vec_float4 a, int b, float *c)
{
  *((vec_float4 *)((unsigned char *)(c)+b)) = a;
}

static inline void vec_st(vec_float4 a, int b, vec_float4 *c)
{
  *((vec_float4 *)((unsigned char *)(c)+b)) = a;
}


/* vec_ste (vector store element indexed)
 * =======
 */
static inline void vec_ste(vec_uchar16 a, int b, unsigned char *c)
{
  unsigned char *ptr;

  ptr = c + b;
  *ptr = spu_extract(a, (int)(ptr) & 15);
}

static inline void vec_ste(vec_char16 a, int b, signed char *c)
{
  vec_ste((vec_uchar16)(a), b, (unsigned char *)(c));
}

static inline void vec_ste(vec_bchar16 a, int b, signed char *c)
{
  vec_ste((vec_uchar16)(a), b, (unsigned char *)(c));
}

static inline void vec_ste(vec_ushort8 a, int b, unsigned short *c)
{
  unsigned short *ptr;

  ptr = (unsigned short *)(((unsigned int)(c) + b) & ~1);
  *ptr = spu_extract(a, ((int)(ptr) >> 1) & 7);
}

static inline void vec_ste(vec_short8 a, int b, signed short *c)
{
  vec_ste((vec_ushort8)(a), b, (unsigned short *)(c));
}

static inline void vec_ste(vec_bshort8 a, int b, signed short *c)
{
  vec_ste((vec_ushort8)(a), b, (unsigned short *)(c));
}

static inline void vec_ste(vec_uint4 a, int b, unsigned int *c)
{
  unsigned int *ptr;

  ptr = (unsigned int *)(((unsigned int)(c) + b) & ~3);
  *ptr = spu_extract(a, ((int)(ptr) >> 2) & 3);
}

static inline void vec_ste(vec_int4 a, int b, signed int *c)
{
  vec_ste((vec_uint4)(a), b, (unsigned int *)(c));
}

static inline void vec_ste(vec_bint4 a, int b, signed int *c)
{
  vec_ste((vec_uint4)(a), b, (unsigned int *)(c));
}

static inline void vec_ste(vec_float4 a, int b, float *c)
{
  vec_ste((vec_uint4)(a), b, (unsigned int *)(c));
}


/* vec_stl (vector store indexed LRU)
 * =======
 */
#define vec_stl(_a, _b, _c)		vec_st(_a, _b, _c)


/* vec_sub (vector subtract)
 * =======
 */
static inline vec_uchar16 vec_sub(vec_uchar16 a, vec_uchar16 b)
{
  return ((vec_uchar16)(spu_sel(spu_sub((vec_ushort8)(a), (vec_ushort8)(b)),
				spu_sub(spu_and((vec_ushort8)(a), -256), spu_and((vec_ushort8)(b), -256)),
				spu_splats((unsigned short)0xFF00))));
}

static inline vec_char16 vec_sub(vec_char16 a, vec_char16 b)
{
  return ((vec_char16)(vec_sub((vec_uchar16)(a), (vec_uchar16)(b))));
}

static inline vec_char16 vec_sub(vec_bchar16 a, vec_char16 b)
{
  return ((vec_char16)(vec_sub((vec_uchar16)(a), (vec_uchar16)(b))));
}

static inline vec_char16 vec_sub(vec_char16 a, vec_bchar16 b)
{
  return ((vec_char16)(vec_sub((vec_uchar16)(a), (vec_uchar16)(b))));
}

static inline vec_ushort8 vec_sub(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_sub(a, b));
}

static inline vec_short8 vec_sub(vec_short8 a, vec_short8 b)
{
  return (spu_sub(a, b));
}

static inline vec_short8 vec_sub(vec_bshort8 a, vec_short8 b)
{
  return (spu_sub((vec_short8)(a), b));
}

static inline vec_short8 vec_sub(vec_short8 a, vec_bshort8 b)
{
  return (spu_sub(a, (vec_short8)(b)));
}

static inline vec_uint4 vec_sub(vec_uint4 a, vec_uint4 b)
{
  return (spu_sub(a, b));
}

static inline vec_int4 vec_sub(vec_int4 a, vec_int4 b)
{
  return (spu_sub(a, b));
}

static inline vec_int4 vec_sub(vec_bint4 a, vec_int4 b)
{
  return (spu_sub((vec_int4)(a), b));
}

static inline vec_int4 vec_sub(vec_int4 a, vec_bint4 b)
{
  return (spu_sub(a, (vec_int4)(b)));
}

static inline vec_float4 vec_sub(vec_float4 a, vec_float4 b)
{
  return (spu_sub(a, b));
}


/* vec_subc (vector subtract carryout)
 * ========
 */
#define vec_subc(_a, _b)	spu_genb(_a, _b)


/* vec_subs (vector subtract saturate)
 * ========
 */
static inline vec_uchar16 vec_subs(vec_uchar16 a, vec_uchar16 b)
{
  vec_ushort8 s1, s2;
  vec_uchar16 s, d;

  s1 = spu_sub(spu_rlmask((vec_ushort8)(a), -8), spu_rlmask((vec_ushort8)(b), -8));
  s2 = spu_sub(spu_and((vec_ushort8)(a), 0xFF), spu_and((vec_ushort8)(b), 0xFF));
  s  = (vec_uchar16)(spu_shuffle(s1, s2, ((vec_uchar16){0, 16,  2, 18,  4, 20,  6, 22,
					                8, 24, 10, 26, 12, 28, 14, 30})));
  d  = (vec_uchar16)(spu_shuffle(s1, s2, ((vec_uchar16){1, 17,  3, 19,  5, 21,  7, 23,
					                9, 25, 11, 27, 13, 29, 15, 31})));
  return (spu_andc(d, s));
}

static inline vec_char16 vec_subs(vec_char16 a, vec_char16 b)
{
  vec_ushort8 s1, s2;
  vec_uchar16 s, d;

  s1 = spu_sub(spu_rlmask((vec_ushort8)(a), -8), spu_rlmask((vec_ushort8)(b), -8));
  s2 = spu_sub(spu_and((vec_ushort8)(a), 0xFF), spu_and((vec_ushort8)(b), 0xFF));
  s  = (vec_uchar16)(spu_shuffle(s1, s2, ((vec_uchar16){1, 17,  3, 19,  5, 21,  7, 23,
					                9, 25, 11, 27, 13, 29, 15, 31})));
  d  = spu_sel(s, spu_splats((unsigned char)0x7F), spu_cmpgt(spu_nor((vec_uchar16)(a), spu_nand(s, (vec_uchar16)(b))), 0x7F));
  d  = spu_sel(d, spu_splats((unsigned char)0x80), spu_cmpgt(spu_and((vec_uchar16)(a), spu_nor(s, (vec_uchar16)(b))), 0x7F));
  
  return ((vec_char16)(d));
}

static inline vec_char16 vec_subs(vec_bchar16 a, vec_char16 b)
{
  return (vec_subs((vec_char16)(a), b));
}

static inline vec_char16 vec_subs(vec_char16 a, vec_bchar16 b)
{
  return (vec_subs(a, (vec_char16)(b)));
}

static inline vec_ushort8 vec_subs(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_andc(spu_sub(a, b), spu_cmpgt(b, a)));
}

static inline vec_short8 vec_subs(vec_short8 a, vec_short8 b)
{
  vec_short8 s;
  vec_short8 d;
  
  s = spu_sub(a, b);
  d = spu_sel(s, spu_splats((signed short)0x7FFF), (vec_ushort8)(spu_rlmaska(spu_nor(a, spu_nand(s, b)), -15)));
  d = spu_sel(d, spu_splats((signed short)0x8000), (vec_ushort8)(spu_rlmaska(spu_and(a, spu_nor(s, b)), -15)));

  return (d);
}

static inline vec_short8 vec_subs(vec_bshort8 a, vec_short8 b)
{
  return ((vec_short8)(vec_subs((vec_short8)(a), b)));
}

static inline vec_short8 vec_subs(vec_short8 a, vec_bshort8 b)
{
  return ((vec_short8)(vec_subs(a, (vec_short8)(b))));
}

static inline vec_uint4 vec_subs(vec_uint4 a, vec_uint4 b)
{
  return (spu_andc(spu_sub(a, b), spu_cmpgt(b, a)));
}

static inline vec_int4 vec_subs(vec_int4 a, vec_int4 b)
{
  vec_int4 s;
  vec_int4 d;
  
  s = spu_sub(a, b);
  d = spu_sel(s, spu_splats((signed int)0x7FFFFFFF), (vec_uint4)(spu_rlmaska(spu_nor(a, spu_nand(s, b)), -31)));
  d = spu_sel(d, spu_splats((signed int)0x80000000), (vec_uint4)(spu_rlmaska(spu_and(a, spu_nor(s, b)), -31)));

  return (d);
}

static inline vec_int4 vec_subs(vec_bint4 a, vec_int4 b)
{
  return ((vec_int4)(vec_subs((vec_int4)(a), b)));
}

static inline vec_int4 vec_subs(vec_int4 a, vec_bint4 b)
{
  return ((vec_int4)(vec_subs(a, (vec_int4)(b))));
}


/* vec_sum4s (vector sum across partial (1/4) staturated)
 * =========
 */
static inline vec_uint4 vec_sum4s(vec_uchar16 a, vec_uint4 b)
{
  vec_uint4 a01_23, a0123;

  a01_23 = (vec_uint4)(spu_add(spu_rlmask((vec_ushort8)(a), -8),
			       spu_and((vec_ushort8)(a), 0xFF)));
  a0123 = spu_add(spu_rlmask(a01_23, -16), spu_and(a01_23, 0x1FF));
  return (vec_adds(a0123, b));
}

static inline vec_int4 vec_sum4s(vec_char16 a, vec_int4 b)
{
  vec_int4 a01_23, a0123;

  a01_23 = (vec_int4)(spu_add(spu_rlmaska((vec_short8)(a), -8),
			      spu_extend(a)));
  a0123 = spu_add(spu_rlmaska(a01_23, -16), spu_extend((vec_short8)(a01_23)));
  return (vec_adds(a0123, b));
}

static inline vec_int4 vec_sum4s(vec_short8 a, vec_int4 b)
{
  vec_int4 a0123;

  a0123 = spu_add(spu_rlmaska((vec_int4)(a), -16), spu_extend(a));
  return (vec_adds(a0123, b));
}


/* vec_sum2s (vector sum across partial (1/2) staturated)
 * =========
 */
static inline vec_int4 vec_sum2s(vec_int4 a, vec_int4 b)
{
  vec_int4 c, d;
  vec_int4 sign1, sign2, sign3;
  vec_int4 carry, sum_l, sum_h, sat, sat_val;

  sign1 = spu_rlmaska(a, -31);
  sign2 = spu_rlmaska(b, -31);

  c = spu_rlqwbyte(a, -4);
  sign3 = spu_rlqwbyte(sign1, -4);
  
  carry = spu_genc(a, b);
  sum_l = spu_add(a, b);
  sum_h = spu_addx(sign1, sign2, carry);

  carry = spu_genc(sum_l, c);
  sum_l = spu_add(sum_l, c);
  sum_h = spu_addx(sum_h, sign3, carry);
  
  sign1 = spu_rlmaska(sum_l, -31);
  sign2 = spu_rlmaska(sum_h, -31);

  sat_val = spu_xor(sign2, spu_splats((signed int)0x7FFFFFFF));

  sat = spu_orc(spu_xor(sign1, sign2), (vec_int4)spu_cmpeq(sum_h, sign2));

  d = spu_and(spu_sel(sum_l, sat_val, (vec_uint4)(sat)), (vec_int4){0, -1, 0, -1});

  return (d);
}


/* vec_sums (vector sum staturated)
 * ========
 */
static inline vec_int4 vec_sums(vec_int4 a, vec_int4 b)
{
  vec_int4 a0, a1, a2, c0, c1, c2, d;
  vec_int4 sign_a, sign_b, sign_l, sign_h;
  vec_int4 sum_l, sum_h, sat, sat_val;

  sign_a = spu_rlmaska(a, -31);
  sign_b = spu_rlmaska(b, -31);

  a0 = spu_rlqwbyte(a, -12);
  a1 = spu_rlqwbyte(a, -8);
  a2 = spu_rlqwbyte(a, -4);

  sum_l = spu_add(a, b);
  sum_h = spu_addx(sign_a, sign_b, spu_genc(a, b));
  
  c2 = spu_genc(sum_l, a2);
  sum_l = spu_add(sum_l, a2);
  sum_h = spu_addx(sum_h, spu_rlqwbyte(sign_a, -4), c2);

  c1 = spu_genc(sum_l, a1);
  sum_l = spu_add(sum_l, a1);
  sum_h = spu_addx(sum_h, spu_rlqwbyte(sign_a, -8), c1);

  c0 = spu_genc(sum_l, a0);
  sum_l = spu_add(sum_l, a0);
  sum_h = spu_addx(sum_h, spu_rlqwbyte(sign_a, -12), c0);

  sign_l = spu_rlmaska(sum_l, -31);
  sign_h = spu_rlmaska(sum_h, -31);

  sat_val = spu_xor(sign_h, spu_splats((signed int)0x7FFFFFFF));

  sat = spu_orc(spu_xor(sign_l, sign_h), (vec_int4)spu_cmpeq(sum_h, sign_h));

  d = spu_and(spu_sel(sum_l, sat_val, (vec_uint4)(sat)), ((vec_int4){0, 0, 0, -1}));

  return (d);
}


/* vec_trunc (vector truncate) 
 * =========
 */
static inline vec_float4 vec_trunc(vec_float4 a)
{
  vec_int4 exp;
  vec_uint4 mask;

  exp  = spu_sub(127, (vec_int4)(spu_and(spu_rlmask((vec_uint4)(a), -23), 0xFF)));
  mask = spu_rlmask(spu_splats((unsigned int)0x7FFFFF), exp);
  mask = spu_sel(spu_splats((unsigned int)0), mask, spu_cmpgt(exp, -31));
  mask = spu_or(mask, spu_xor((vec_uint4)(spu_rlmaska(spu_add(exp, -1), -31)), -1));
  return (spu_andc(a, (vec_float4)(mask)));
}

/* vec_unpackh (vector unpack high element) 
 * ===========
 */
static inline vec_short8 vec_unpackh(vec_char16 a)
{
  return (spu_extend(spu_shuffle(a, a, ((vec_uchar16){0, 0, 1, 1, 2, 2, 3, 3, 
					              4, 4, 5, 5, 6, 6, 7, 7}))));
}

static inline vec_bshort8 vec_unpackh(vec_bchar16 a)
{
  return ((vec_bshort8)(vec_unpackh((vec_char16)(a))));
}

static inline vec_int4 vec_unpackh(vec_short8 a)
{
  return (spu_extend(spu_shuffle(a, a, ((vec_uchar16){0, 0, 0, 1, 0, 0, 2, 3, 
					              0, 0, 4, 5, 0, 0, 6, 7}))));
}

#ifdef SUPPORT_UNPACK_PIXEL
/* Due to type conflicts, unpacking of pixel types and boolean shorts
 * can not simultaneously be supported. By default, the boolean short is
 * supported.
 */
static inline vec_uint4 vec_unpackh(vec_pixel8 a)
{
  vec_ushort8 p1, p2;

  p1 = spu_shuffle((vec_ushort8)(spu_rlmaska((vec_short8)(a.p), -7)),
		   spu_and((vec_ushort8)(a.p), 0x1F),
		   ((vec_uchar16){ 0, 128, 128, 17,  2, 128, 128, 19,
			           4, 128, 128, 21,  6, 128, 128, 23}));
  p2 = spu_shuffle(spu_and(spu_rlmask((vec_ushort8)(a.p), -5), 0x1F),
		   spu_and(spu_rlmask((vec_ushort8)(a.p), -10), 0x1F),
		   ((vec_uchar16){ 128,  17, 1, 128, 128,  19, 3, 128,
			           128,  21, 5, 128, 128,  23, 7, 128}));
  return ((vec_uint4)(spu_or(p1, p2)));
}

#else

static inline vec_bint4 vec_unpackh(vec_bshort8 a)
{
  return ((vec_bint4)(vec_unpackh((vec_short8)(a))));
}
#endif





/* vec_unpackl (vector unpack low element) 
 * ===========
 */
static inline vec_short8 vec_unpackl(vec_char16 a)
{
  return (spu_extend(spu_shuffle(a, a, ((vec_uchar16){8, 8, 9, 9, 10, 10, 11, 11,
					              12, 12, 13, 13, 14, 14, 15, 15}))));
}

static inline vec_bshort8 vec_unpackl(vec_bchar16 a)
{
  return ((vec_bshort8)(vec_unpackl((vec_char16)(a))));
}


static inline vec_int4 vec_unpackl(vec_short8 a)
{
  return (spu_extend(spu_shuffle(a, a, ((vec_uchar16){0, 0, 8, 9, 0, 0, 10, 11, 
					              0, 0,12,13, 0, 0, 14, 15}))));
}


#ifdef SUPPORT_UNPACK_PIXEL
/* Due to type conflicts, unpacking of pixel types and boolean shorts
 * can not simultaneously be supported. By default, the boolean short is
 * supported.
 */
static inline vec_uint4 vec_unpackl(vec_pixel8 a)
{
  vec_ushort8 p1, p2;

  p1 = spu_shuffle((vec_ushort8)(spu_rlmaska((vec_short8)(a), -7)),
		   spu_and((vec_ushort8)(a), 0x1F),
		   ((vec_uchar16){ 8, 128, 128, 25,  10, 128, 128, 27,
			          12, 128, 128, 29,  14, 128, 128, 31}));
  p2 = spu_shuffle(spu_and(spu_rlmask((vec_ushort8)(a), -5), 0x1F),
		   spu_and(spu_rlmask((vec_ushort8)(a), -10), 0x1F),
		   ((vec_uchar16){ 128, 25,  9, 128, 128, 27, 11, 128,
			           128, 29, 13, 128, 128, 31, 15, 128}));
  return ((vec_uint4)(spu_or(p1, p2)));
}

#else

static inline vec_bint4 vec_unpackl(vec_bshort8 a)
{
  return ((vec_bint4)(vec_unpackl((vec_short8)(a))));

}
#endif



/* vec_xor (vector logical xor)
 * ======
 */
static inline vec_uchar16 vec_xor(vec_uchar16 a, vec_uchar16 b)
{
  return (spu_xor(a, b));
}

static inline vec_char16 vec_xor(vec_char16 a, vec_char16 b)
{
  return (spu_xor(a, b));
}

static inline vec_char16 vec_xor(vec_bchar16 a, vec_char16 b)
{
  return (spu_xor((vec_char16)(a), b));
}

static inline vec_char16 vec_xor(vec_char16 a, vec_bchar16 b)
{
  return (spu_xor(a, (vec_char16)(b)));
}

static inline vec_ushort8 vec_xor(vec_ushort8 a, vec_ushort8 b)
{
  return (spu_xor(a, b));
}

static inline vec_short8 vec_xor(vec_short8 a, vec_short8 b)
{
  return (spu_xor(a, b));
}

static inline vec_short8 vec_xor(vec_bshort8 a, vec_short8 b)
{
  return (spu_xor((vec_short8)(a), b));
}

static inline vec_short8 vec_xor(vec_short8 a, vec_bshort8 b)
{
  return (spu_xor(a, (vec_short8)(b)));
}

static inline vec_uint4 vec_xor(vec_uint4 a, vec_uint4 b)
{
  return (spu_xor(a, b));
}

static inline vec_int4 vec_xor(vec_int4 a, vec_int4 b)
{
  return (spu_xor(a, b));
}

static inline vec_int4 vec_xor(vec_bint4 a, vec_int4 b)
{
  return (spu_xor((vec_int4)(a), b));
}

static inline vec_int4 vec_xor(vec_int4 a, vec_bint4 b)
{
  return (spu_xor(a, (vec_int4)(b)));
}

static inline vec_float4 vec_xor(vec_float4 a, vec_float4 b)
{
  return (spu_xor(a, b));
}

static inline vec_float4 vec_xor(vec_bint4 a, vec_float4 b)
{
  return (spu_xor((vec_float4)(a),b));
}

static inline vec_float4 vec_xor(vec_float4 a, vec_bint4 b)
{
  return (spu_xor(a, (vec_float4)(b)));
}

/************************************************************************
 *                        PREDICATES
 ************************************************************************/

/* vec_all_eq (all elements equal)
 * ==========
 */
static inline int vec_all_eq(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0xFFFF));
}

static inline int vec_all_eq(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0xFFFF));
}

static inline int vec_all_eq(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_char16)(a), b)), 0) == 0xFFFF));
}

static inline int vec_all_eq(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_char16)(b))), 0) == 0xFFFF));
}

static inline int vec_all_eq(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0xFF));
}

static inline int vec_all_eq(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0xFF));
}

static inline int vec_all_eq(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_short8)(a), b)), 0) == 0xFF));
}

static inline int vec_all_eq(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_short8)(b))), 0) == 0xFF));
}

static inline int vec_all_eq(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0xF));
}

static inline int vec_all_eq(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0xF));
}

static inline int vec_all_eq(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_int4)(a), b)), 0) == 0xF));
}

static inline int vec_all_eq(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_int4)(b))), 0) == 0xF));
}

static inline int vec_all_eq(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0xF));
}


/* vec_all_ge (all elements greater than or equal)
 * ==========
 */
static inline int vec_all_ge(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0));
}

static inline int vec_all_ge(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0));
}

static inline  int vec_all_ge(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_char16)(a))), 0) == 0));
}

static inline int vec_all_ge(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_char16)(b), a)), 0) == 0));
}

static inline int vec_all_ge(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0));
}

static inline int vec_all_ge(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0));
}

static inline int vec_all_ge(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_short8)(a))), 0) == 0));
}

static inline int vec_all_ge(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_short8)(b), a)), 0) == 0));
}

static inline int vec_all_ge(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0));
}

static inline int vec_all_ge(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0));
}

static inline int vec_all_ge(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_int4)(a))), 0) == 0));
}

static inline int vec_all_ge(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_int4)(b), a)), 0) == 0));
}

static inline int vec_all_ge(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0));
}


/* vec_all_gt (all elements greater than)
 * ==========
 */
static inline int vec_all_gt(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0xFFFF));
}

static inline int vec_all_gt(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0xFFFF));
}

static inline int vec_all_gt(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_char16)(a), b)), 0) == 0xFFFF));
}

static inline int vec_all_gt(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_char16)(b))), 0) == 0xFFFF));
}

static inline int vec_all_gt(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0xFF));
}

static inline int vec_all_gt(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0xFF));
}

static inline int vec_all_gt(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_short8)(a), b)), 0) == 0xFF));
}

static inline int vec_all_gt(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_short8)(b))), 0) == 0xFF));
}

static inline int vec_all_gt(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0xF));
}

static inline int vec_all_gt(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0xF));
}

static inline int vec_all_gt(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_int4)(a), b)), 0) == 0xF));
}

static inline int vec_all_gt(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_int4)(b))), 0) == 0xF));
}

static inline int vec_all_gt(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0xF));
}


/* vec_all_in (all elements in bounds)
 * ==========
 */
static inline int vec_all_in(vec_float4 a, vec_float4 b)
{
  return (spu_extract(spu_gather(spu_nor(spu_cmpabsgt(a, b), (vec_uint4)(spu_rlmaska((vec_int4)(b), -31)))), 0) == 0xF);
}


/* vec_all_le (all elements less than or equal)
 * ==========
 */
static inline int vec_all_le(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0));
}

static inline int vec_all_le(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0));
}

static inline int vec_all_le(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_char16)(a), b)), 0) == 0));
}

static inline int vec_all_le(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_char16)(b))), 0) == 0));
}

static inline int vec_all_le(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0));
}

static inline int vec_all_le(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0));
}

static inline int vec_all_le(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_short8)(a), b)), 0) == 0));
}

static inline int vec_all_le(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_short8)(b))), 0) == 0));
}

static inline int vec_all_le(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0));
}

static inline int vec_all_le(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0));
}

static inline int vec_all_le(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_int4)(a), b)), 0) == 0));
}

static inline int vec_all_le(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_int4)(b))), 0) == 0));
}

static inline int vec_all_le(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0));
}


/* vec_all_lt (all elements less than)
 * ==========
 */
static inline int vec_all_lt(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0xFFFF));
}

static inline int vec_all_lt(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0xFFFF));
}

static inline int vec_all_lt(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_char16)(a))), 0) == 0xFFFF));
}

static inline int vec_all_lt(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_char16)(b), a)), 0) == 0xFFFF));
}

static inline int vec_all_lt(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0xFF));
}

static inline int vec_all_lt(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0xFF));
}

static inline int vec_all_lt(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_short8)(a))), 0) == 0xFF));
}

static inline int vec_all_lt(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_short8)(b), a)), 0) == 0xFF));
}

static inline int vec_all_lt(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0xF));
}

static inline int vec_all_lt(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0xF));
}

static inline int vec_all_lt(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_int4)(a))), 0) == 0xF));
}

static inline int vec_all_lt(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_int4)(b), a)), 0) == 0xF));
}

static inline int vec_all_lt(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0xF));
}


/* vec_all_nan (all elements not a number)
 * ===========
 */
static inline int vec_all_nan(vec_float4 a)
{
  vec_uint4 exp, man;
  vec_uint4 exp_mask = spu_splats((unsigned int)0x7F800000);

  exp = spu_and((vec_uint4)(a), exp_mask);
  man = spu_and((vec_uint4)(a), spu_splats((unsigned int)0x007FFFFF));
  return ((int)(spu_extract(spu_gather(spu_andc(spu_cmpeq(exp, exp_mask), 
						spu_cmpeq(man, 0))), 0) == 0xF));
}

#define vec_all_nan(_a)		(0)


/* vec_all_ne (all elements not equal)
 * ==========
 */
static inline int vec_all_ne(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0));
}

static inline int vec_all_ne(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0));
}

static inline int vec_all_ne(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_char16)(a), b)), 0) == 0));
}

static inline int vec_all_ne(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_char16)(b))), 0) == 0));
}

static inline int vec_all_ne(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0));
}

static inline int vec_all_ne(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0));
}

static inline int vec_all_ne(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_short8)(a), b)), 0) == 0));
}

static inline int vec_all_ne(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_short8)(b))), 0) == 0));
}

static inline int vec_all_ne(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0));
}

static inline int vec_all_ne(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0));
}

static inline int vec_all_ne(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_int4)(a), b)), 0) == 0));
}

static inline int vec_all_ne(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_int4)(b))), 0) == 0));
}

static inline int vec_all_ne(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) == 0));
}


/* vec_all_nge (all elements not greater than or eqaul)
 * ===========
 */
static inline int vec_all_nge(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0xF));
}


/* vec_all_ngt (all elements not greater than)
 * ===========
 */
static inline int vec_all_ngt(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0));
}


/* vec_all_nle (all elements not less than or equal)
 * ===========
 */
static inline int vec_all_nle(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) == 0xF));
}


/* vec_all_nlt (all elements not less than)
 * ===========
 */
static inline int vec_all_nlt(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) == 0));
}


/* vec_all_numeric (all elements numeric)
 * ===========
 */
static inline int vec_all_numeric(vec_float4 a)
{
  vec_uint4 exp;

  exp = spu_and(spu_rlmask((vec_uint4)(a), -23), 0xFF);
  return ((int)(spu_extract(spu_gather(spu_cmpeq(exp, 255)), 0) == 0));
}



/* vec_any_eq (any elements equal)
 * ==========
 */
static inline int vec_any_eq(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0));
}

static inline int vec_any_eq(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0));
}

static inline int vec_any_eq(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_char16)(a), b)), 0) != 0));
}

static inline int vec_any_eq(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_char16)(b))), 0) != 0));
}

static inline int vec_any_eq(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0));
}

static inline int vec_any_eq(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0));
}

static inline int vec_any_eq(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_short8)(a), b)), 0) != 0));
}

static inline int vec_any_eq(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_short8)(b))), 0) != 0));
}

static inline int vec_any_eq(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpeq(a, b), -31)), 0)));
}

static inline int vec_any_eq(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpeq(a, b), -31)), 0)));
}

static inline int vec_any_eq(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpeq((vec_int4)(a), b), -31)), 0)));
}

static inline int vec_any_eq(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpeq(a, (vec_int4)(b)), -31)), 0)));
}

static inline int vec_any_eq(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpeq(a, b), -31)), 0)));
}

/* vec_any_ge (any elements greater than or equal)
 * ==========
 */
static inline int vec_any_ge(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0xFFFF));
}

static inline int vec_any_ge(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0xFFFF));
}

static inline int vec_any_ge(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_char16)(a))), 0) != 0xFFFF));
}

static inline int vec_any_ge(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_char16)(b), a)), 0) != 0xFFFF));
}

static inline int vec_any_ge(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0xFF));
}

static inline int vec_any_ge(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0xFF));
}

static inline int vec_any_ge(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_short8)(a))), 0) != 0xFF));
}

static inline int vec_any_ge(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_short8)(b), a)), 0) != 0xFF));
}

static inline int vec_any_ge(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0xF));
}

static inline int vec_any_ge(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0xF));
}

static inline int vec_any_ge(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_int4)(a))), 0) != 0xF));
}

static inline int vec_any_ge(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_int4)(b), a)), 0) != 0xF));
}

static inline int vec_any_ge(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0xF));
}


/* vec_any_gt (any elements greater than)
 * ==========
 */
static inline int vec_any_gt(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0));
}

static inline int vec_any_gt(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0));
}

static inline int vec_any_gt(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_char16)(a), b)), 0) != 0));
}

static inline int vec_any_gt(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_char16)(b))), 0) != 0));
}

static inline int vec_any_gt(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0));
}

static inline int vec_any_gt(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0));
}

static inline int vec_any_gt(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_short8)(a), b)), 0) != 0));
}

static inline int vec_any_gt(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_short8)(b))), 0) != 0));
}


static inline int vec_any_gt(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt(a, b), -31)), 0)));
}

static inline int vec_any_gt(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt(a, b), -31)), 0)));
}

static inline int vec_any_gt(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt((vec_int4)(a), b), -31)), 0)));
}

static inline int vec_any_gt(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt(a, (vec_int4)(b)), -31)), 0)));
}

static inline int vec_any_gt(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt(a, b), -31)), 0)));
}

/* vec_any_le (any elements less than or equal)
 * ==========
 */
static inline int vec_any_le(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0xFFFF));
}

static inline int vec_any_le(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0xFFFF));
}

static inline int vec_any_le(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_char16)(a), b)), 0) != 0xFFFF));
}

static inline int vec_any_le(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_char16)(b))), 0) != 0xFFFF));
}

static inline int vec_any_le(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0xFF));
}

static inline int vec_any_le(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0xFF));
}

static inline int vec_any_le(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_short8)(a), b)), 0) != 0xFF));
}

static inline int vec_any_le(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_short8)(b))), 0) != 0xFF));
}

static inline int vec_any_le(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0xF));
}

static inline int vec_any_le(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0xF));
}

static inline int vec_any_le(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_int4)(a), b)), 0) != 0xF));
}

static inline int vec_any_le(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, (vec_int4)(b))), 0) != 0xF));
}

static inline int vec_any_le(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0xF));
}


/* vec_any_lt (any elements less than)
 * ==========
 */
static inline int vec_any_lt(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0));
}

static inline int vec_any_lt(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0));
}

static inline int vec_any_lt(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_char16)(a))), 0) != 0));
}

static inline int vec_any_lt(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_char16)(b), a)), 0) != 0));
}

static inline int vec_any_lt(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0));
}

static inline int vec_any_lt(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0));
}

static inline int vec_any_lt(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, (vec_short8)(a))), 0) != 0));
}

static inline int vec_any_lt(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt((vec_short8)(b), a)), 0) != 0));
}

static inline int vec_any_lt(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt(b, a), -31)), 0)));
}

static inline int vec_any_lt(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt(b, a), -31)), 0)));
}

static inline int vec_any_lt(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt(b, (vec_int4)(a)), -31)), 0)));
}

static inline int vec_any_lt(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt((vec_int4)(b), a), -31)), 0)));
}

static inline int vec_any_lt(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt(b, a), -31)), 0)));
}

/* vec_any_nan (any elements not a number)
 * ===========
 */
static inline int vec_any_nan(vec_float4 a)
{
  vec_uint4 exp, man;
  vec_uint4 exp_mask = spu_splats((unsigned int)0x7F800000);

  exp = spu_and((vec_uint4)(a), exp_mask);
  man = spu_and((vec_uint4)(a), spu_splats((unsigned int)0x007FFFFF));
  return ((int)(spu_extract(spu_gather(spu_andc(spu_cmpeq(exp, exp_mask), 
						spu_cmpeq(man, 0))), 0) != 0));
}


/* vec_any_ne (any elements not equal)
 * ==========
 */
static inline int vec_any_ne(vec_uchar16 a, vec_uchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0xFFFF));
}

static inline int vec_any_ne(vec_char16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0xFFFF));
}

static inline int vec_any_ne(vec_bchar16 a, vec_char16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_char16)(a), b)), 0) != 0xFFFF));
}

static inline int vec_any_ne(vec_char16 a, vec_bchar16 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_char16)(b))), 0) != 0xFFFF));
}

static inline int vec_any_ne(vec_ushort8 a, vec_ushort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0xFF));
}

static inline int vec_any_ne(vec_short8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0xFF));
}

static inline int vec_any_ne(vec_bshort8 a, vec_short8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_short8)(a), b)), 0) != 0xFF));
}

static inline int vec_any_ne(vec_short8 a, vec_bshort8 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_short8)(b))), 0) != 0xFF));
}

static inline int vec_any_ne(vec_uint4 a, vec_uint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0xF));
}

static inline int vec_any_ne(vec_int4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0xF));
}

static inline int vec_any_ne(vec_bint4 a, vec_int4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq((vec_int4)(a), b)), 0) != 0xF));
}

static inline int vec_any_ne(vec_int4 a, vec_bint4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, (vec_int4)(b))), 0) != 0xF));
}

static inline int vec_any_ne(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpeq(a, b)), 0) != 0xF));
}


/* vec_any_nge (any elements not greater than or eqaul)
 * ===========
 */
static inline int vec_any_nge(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_orx(spu_rlmask(spu_cmpgt(b, a), -31)), 0)));
}

/* vec_any_ngt (any elements not greater than)
 * ===========
 */
static inline int vec_any_ngt(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0xF));
}


/* vec_any_nle (any elements not less than or equal)
 * ===========
 */
static inline int vec_any_nle(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(a, b)), 0) != 0));
}


/* vec_any_nlt (any elements not less than)
 * ===========
 */
static inline int vec_any_nlt(vec_float4 a, vec_float4 b)
{
  return ((int)(spu_extract(spu_gather(spu_cmpgt(b, a)), 0) != 0xF));
}


/* vec_any_numeric (any elements numeric)
 * ===============
 */
static inline int vec_any_numeric(vec_float4 a)
{
  vec_uint4 exp;

  exp = spu_and(spu_rlmask((vec_uint4)(a), -23), 0xFF);
  return ((int)(spu_extract(spu_gather(spu_cmpeq(exp, 255)), 0) != 0xF));
}


/* vec_any_out (any elements out of bounds)
 * ===========
 */
static inline int vec_any_out(vec_float4 a, vec_float4 b)
{
  return (spu_extract(spu_gather(spu_nor(spu_cmpabsgt(a, b), (vec_uint4)(spu_rlmaska((vec_int4)(b), -31)))), 0) != 0xF);
}


/* CBE Language Extension Intrinsics
 */

/* vec_extract (extract element from vector)
 * ===========
 */
#define vec_extract(_a, _element)	spu_extract(_a, _element)


/* vec_insert (insert scalar into specified vector element)
 * ==========
 */
#define vec_insert(_a, _b, _element)	spu_insert(_a, _b, _element)

/* vec_lvlx (load vector left indexed)
 * ========
 */
static inline vec_uchar16 vec_lvlx(int a, unsigned char *b)
{
  vec_uchar16 *p = (vec_uchar16 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_uchar16 vec_lvlx(int a, vec_uchar16 *b)
{
  vec_uchar16 *p = (vec_uchar16 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_char16 vec_lvlx(int a, signed char *b)
{
  vec_char16 *p = (vec_char16 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_char16 vec_lvlx(int a, vec_char16 *b)
{
  vec_char16 *p = (vec_char16 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_ushort8 vec_lvlx(int a, unsigned short *b)
{
  vec_ushort8 *p = (vec_ushort8 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_ushort8 vec_lvlx(int a, vec_ushort8 *b)
{
  vec_ushort8 *p = (vec_ushort8 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_short8 vec_lvlx(int a, signed short *b)
{
  vec_short8 *p = (vec_short8 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_short8 vec_lvlx(int a, vec_short8 *b)
{
  vec_short8 *p = (vec_short8 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_uint4 vec_lvlx(int a, unsigned int *b)
{
  vec_uint4 *p = (vec_uint4 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_uint4 vec_lvlx(int a, vec_uint4 *b)
{
  vec_uint4 *p = (vec_uint4 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_int4 vec_lvlx(int a, signed int *b)
{
  vec_int4 *p = (vec_int4 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_int4 vec_lvlx(int a, vec_int4 *b)
{
  vec_int4 *p = (vec_int4 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_float4 vec_lvlx(int a, float *b)
{
  vec_float4 *p = (vec_float4 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}

static inline vec_float4 vec_lvlx(int a, vec_float4 *b)
{
  vec_float4 *p = (vec_float4 *)((unsigned char *)(b) + a);
  return(spu_slqwbyte(*p, (unsigned int)p & 0xF));
}


/* vec_lvlxl (load vector left indexed last)
 * =========
 */
#define vec_lvlxl(_a, _b)	vec_lvlx(_a, _b)


/* vec_lvrx (load vector right indexed)
 * ========
 */
static inline vec_uchar16 vec_lvrx(int a, unsigned char *b)
{
  vec_uchar16 *p = (vec_uchar16 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_uchar16 vec_lvrx(int a, vec_uchar16 *b)
{
  vec_uchar16 *p = (vec_uchar16 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_char16 vec_lvrx(int a, signed char *b)
{
  vec_char16 *p = (vec_char16 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_char16 vec_lvrx(int a, vec_char16 *b)
{
  vec_char16 *p = (vec_char16 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_ushort8 vec_lvrx(int a, unsigned short *b)
{
  vec_ushort8 *p = (vec_ushort8 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_ushort8 vec_lvrx(int a, vec_ushort8 *b)
{
  vec_ushort8 *p = (vec_ushort8 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_short8 vec_lvrx(int a, signed short *b)
{
  vec_short8 *p = (vec_short8 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_short8 vec_lvrx(int a, vec_short8 *b)
{
  vec_short8 *p = (vec_short8 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_uint4 vec_lvrx(int a, unsigned int *b)
{
  vec_uint4 *p = (vec_uint4 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_uint4 vec_lvrx(int a, vec_uint4 *b)
{
  vec_uint4 *p = (vec_uint4 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_int4 vec_lvrx(int a, signed int *b)
{
  vec_int4 *p = (vec_int4 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_int4 vec_lvrx(int a, vec_int4 *b)
{
  vec_int4 *p = (vec_int4 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_float4 vec_lvrx(int a, float *b)
{
  vec_float4 *p = (vec_float4 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}

static inline vec_float4 vec_lvrx(int a, vec_float4 *b)
{
  vec_float4 *p = (vec_float4 *)((unsigned char *)(b) + a);
  return(spu_rlmaskqwbyte(*p, ((int)p & 0xF)-16));
}



/* vec_lvrxl (load vector right indexed last)
 * =========
 */
#define vec_lvrxl(_a, _b)	vec_lvrx(_a, _b)


/* vec_promote (promote scalar to a vector)
 * ===========
 */
#define vec_promote(_a, _element)	spu_promote(_a, _element)


/* vec_splats (splat scalar to a vector)
 * ==========
 */
#define vec_splats(_a)	spu_splats(_a)


/* vec_stvlx (store vector left indexed)
 * =========
 */
static inline void vec_stvlx(vec_uchar16 a, int b, unsigned char *c)
{
  int shift;
  vec_uchar16 *p = (vec_uchar16 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned char)0xFF), shift));
}

static inline void vec_stvlx(vec_uchar16 a, int b, vec_uchar16 *c)
{
  int shift;
  vec_uchar16 *p = (vec_uchar16 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned char)0xFF), shift));
}

static inline void vec_stvlx(vec_char16 a, int b, signed char *c)
{
  int shift;
  vec_char16 *p = (vec_char16 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned char)0xFF), shift));
}

static inline void vec_stvlx(vec_char16 a, int b, vec_char16 *c)
{
  int shift;
  vec_char16 *p = (vec_char16 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned char)0xFF), shift));
}

static inline void vec_stvlx(vec_ushort8 a, int b, unsigned short *c)
{
  int shift;
  vec_ushort8 *p = (vec_ushort8 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned short)0xFFFF), shift));
}

static inline void vec_stvlx(vec_ushort8 a, int b, vec_ushort8 *c)
{
  int shift;
  vec_ushort8 *p = (vec_ushort8 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned short)0xFFFF), shift));
}

static inline void vec_stvlx(vec_short8 a, int b, signed short *c)
{
  int shift;
  vec_short8 *p = (vec_short8 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned short)0xFFFF), shift));
}

static inline void vec_stvlx(vec_short8 a, int b, vec_short8 *c)
{
  int shift;
  vec_short8 *p = (vec_short8 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned short)0xFFFF), shift));
}

static inline void vec_stvlx(vec_uint4 a, int b, unsigned int *c)
{
  int shift;
  vec_uint4 *p = (vec_uint4 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvlx(vec_uint4 a, int b, vec_uint4 *c)
{
  int shift;
  vec_uint4 *p = (vec_uint4 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvlx(vec_int4 a, int b, signed int *c)
{
  int shift;
  vec_int4 *p = (vec_int4 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvlx(vec_int4 a, int b, vec_int4 *c)
{
  int shift;
  vec_int4 *p = (vec_int4 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvlx(vec_float4 a, int b, float *c)
{
  int shift;
  vec_float4 *p = (vec_float4 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvlx(vec_float4 a, int b, vec_float4 *c)
{
  int shift;
  vec_float4 *p = (vec_float4 *)((unsigned char *)(c) + b);

  shift = -((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_rlmaskqwbyte(a, shift),
	       spu_rlmaskqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

/* vec_stvlxl (store vector left indexed last)
 * ==========
 */
#define vec_stvlxl(_a, _b, _c)	vec_stvlx(_a, _b, _c)


/* vec_stvrx (store vector right indexed)
 * =========
 */
static inline void vec_stvrx(vec_uchar16 a, int b, unsigned char *c)
{
  int shift;
  vec_uchar16 *p = (vec_uchar16 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned char)0xFF), shift));
}

static inline void vec_stvrx(vec_uchar16 a, int b, vec_uchar16 *c)
{
  int shift;
  vec_uchar16 *p = (vec_uchar16 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned char)0xFF), shift));
}

static inline void vec_stvrx(vec_char16 a, int b, signed char *c)
{
  int shift;
  vec_char16 *p = (vec_char16 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned char)0xFF), shift));
}

static inline void vec_stvrx(vec_char16 a, int b, vec_char16 *c)
{
  int shift;
  vec_char16 *p = (vec_char16 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned char)0xFF), shift));
}

static inline void vec_stvrx(vec_ushort8 a, int b, unsigned short *c)
{
  int shift;
  vec_ushort8 *p = (vec_ushort8 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned short)0xFFFF), shift));
}

static inline void vec_stvrx(vec_ushort8 a, int b, vec_ushort8 *c)
{
  int shift;
  vec_ushort8 *p = (vec_ushort8 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned short)0xFFFF), shift));
}

static inline void vec_stvrx(vec_short8 a, int b, signed short *c)
{
  int shift;
  vec_short8 *p = (vec_short8 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned short)0xFFFF), shift));
}

static inline void vec_stvrx(vec_short8 a, int b, vec_short8 *c)
{
  int shift;
  vec_short8 *p = (vec_short8 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned short)0xFFFF), shift));
}

static inline void vec_stvrx(vec_uint4 a, int b, unsigned int *c)
{
  int shift;
  vec_uint4 *p = (vec_uint4 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvrx(vec_uint4 a, int b, vec_uint4 *c)
{
  int shift;
  vec_uint4 *p = (vec_uint4 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvrx(vec_int4 a, int b, signed int *c)
{
  int shift;
  vec_int4 *p = (vec_int4 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvrx(vec_int4 a, int b, vec_int4 *c)
{
  int shift;
  vec_int4 *p = (vec_int4 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvrx(vec_float4 a, int b, float *c)
{
  int shift;
  vec_float4 *p = (vec_float4 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

static inline void vec_stvrx(vec_float4 a, int b, vec_float4 *c)
{
  int shift;
  vec_float4 *p = (vec_float4 *)((unsigned char *)(c) + b);

  shift = 16-((int)p & 0xF);
  *p = spu_sel(*p,
	       spu_slqwbyte(a, shift),
	       spu_slqwbyte(spu_splats((unsigned int)0xFFFFFFFF), shift));
}

/* vec_stvrxl (store vector right indexed last)
 * ==========
 */
#define vec_stvrxl(_a, _b, _c)	vec_stvrx(_a, _b, _c)


#endif /* __SPU__ */
#endif /* __cplusplus */

////////////////////////////////////////////////////////////////////////////////
// CryCG relevant types and macros 
////////////////////////////////////////////////////////////////////////////////

#if !defined(__CRYCG_NOINLINE__)
# define __CRYCG_NOINLINE__ __attribute__ ((crycg_attr ("noinline")))
#endif
#if !defined(__CRYCG_PRESERVE__)
# if !defined(CRYCG_CM)
#  define __CRYCG_PRESERVE__ __attribute__ ((crycg_attr ("preserve")))
# else
#  define __CRYCG_PRESERVE__
# endif
#endif

#if defined __cplusplus
#if !defined SPU_MAIN_PTR
template <typename T>
__CRYCG_NOINLINE__ T *__spu_main_ptr(T *ptr) { return ptr; }
#define SPU_MAIN_PTR(PTR) __spu_main_ptr((PTR))
#endif
#if !defined SPU_MAIN_REF
template <typename T>
__CRYCG_NOINLINE__ T &__spu_main_ref(T &ref) { return ref; }
#define SPU_MAIN_REF(REF) __spu_main_ref((REF))
#endif
#if !defined SPU_LOCAL_PTR
template <typename T>
__CRYCG_NOINLINE__ T *__spu_local_ptr(T *ptr) { return ptr; }
#define SPU_LOCAL_PTR(PTR) __spu_local_ptr((PTR))
#endif
#if !defined SPU_LOCAL_REF
template <typename T>
__CRYCG_NOINLINE__ T &__spu_local_ref(T &ref) { return ref; }
#define SPU_LOCAL_REF(REF) __spu_local_ref((REF))
#endif
#if !defined SPU_LINK_PTR
template <typename T, typename L>
__CRYCG_NOINLINE__ T *__spu_link_ptr(T *ptr, L *) { return ptr; }
template <typename T, typename L>
__CRYCG_NOINLINE__ T *__spu_link_ptr(T *ptr, L &) { return ptr; }
#define SPU_LINK_PTR(PTR, LINK) __spu_link_ptr((PTR), (LINK))
#endif
#if !defined SPU_LINK_REF
template <typename T, typename L>
__CRYCG_NOINLINE__ T &__spu_link_ref(T &ref, L *) { return ref; }
template <typename T, typename L>
__CRYCG_NOINLINE__ T &__spu_link_ref(T &ref, L &) { return ref; }
#define SPU_LINK_REF(REF, LINK) __spu_link_ref((PTR), (LINK))
#endif
#endif /* __cplusplus */

#if !defined SPU_DOMAIN_MAIN
#define SPU_DOMAIN_MAIN __attribute__ ((crycg_domain ("MAIN")))
#endif
#if !defined SPU_DOMAIN_LOCAL
#define SPU_DOMAIN_LOCAL __attribute__ ((crycg_domain ("LOCAL")))
#endif
#if !defined SPU_DOMAIN_LINK
#define SPU_DOMAIN_LINK(ID) __attribute__ ((crycg_domain (ID)))
#endif

template<typename T, const size_t Size> 
struct crycg_copy 
{
  static void copy(
    T* __restrict__ dst, const T*  __restrict__ src) 
  {
    *dst=*src; 
    crycg_copy<T,Size-1>::copy(dst+1,src+1);
  }
};

template<typename T> 
struct crycg_copy<T,1>
{
  static __attribute__((crycg_attr("inline"))) 
    void copy(T* __restrict__ dst, const T*  __restrict__ src) 
  {
    *dst=*src; 
  }
};

template struct crycg_copy<vec_uint4,16>;
typedef crycg_copy<vec_uint4, 16> __CRYCG_PRESERVE__ crycg_vec_copy_16;
template struct crycg_copy<vec_uint4, 15>;
typedef crycg_copy<vec_uint4, 15> __CRYCG_PRESERVE__ crycg_vec_copy_15;
template struct crycg_copy<vec_uint4, 14>;
typedef crycg_copy<vec_uint4, 14> __CRYCG_PRESERVE__ crycg_vec_copy_14;
template struct crycg_copy<vec_uint4, 13>;
typedef crycg_copy<vec_uint4, 13> __CRYCG_PRESERVE__ crycg_vec_copy_13;
template struct crycg_copy<vec_uint4, 12>;
typedef crycg_copy<vec_uint4, 12> __CRYCG_PRESERVE__ crycg_vec_copy_12;
template struct crycg_copy<vec_uint4, 11>;
typedef crycg_copy<vec_uint4, 11> __CRYCG_PRESERVE__ crycg_vec_copy_11;
template struct crycg_copy<vec_uint4, 10>;
typedef crycg_copy<vec_uint4, 10> __CRYCG_PRESERVE__ crycg_vec_copy_10;
template struct crycg_copy<vec_uint4, 9>;
typedef crycg_copy<vec_uint4, 9>  __CRYCG_PRESERVE__ crycg_vec_copy_9;
template struct crycg_copy<vec_uint4, 8>;
typedef crycg_copy<vec_uint4, 8>  __CRYCG_PRESERVE__ crycg_vec_copy_8;
template struct crycg_copy<vec_uint4, 7>;
typedef crycg_copy<vec_uint4, 7>  __CRYCG_PRESERVE__ crycg_vec_copy_7;
template struct crycg_copy<vec_uint4, 6>;
typedef crycg_copy<vec_uint4, 6>  __CRYCG_PRESERVE__ crycg_vec_copy_6;
template struct crycg_copy<vec_uint4, 5>;
typedef crycg_copy<vec_uint4, 5>  __CRYCG_PRESERVE__ crycg_vec_copy_5;
template struct crycg_copy<vec_uint4, 4>;
typedef crycg_copy<vec_uint4, 4>  __CRYCG_PRESERVE__ crycg_vec_copy_4;
template struct crycg_copy<vec_uint4, 3>;
typedef crycg_copy<vec_uint4, 3>  __CRYCG_PRESERVE__ crycg_vec_copy_3;
template struct crycg_copy<vec_uint4, 2>;
typedef crycg_copy<vec_uint4, 2>  __CRYCG_PRESERVE__ crycg_vec_copy_2;
template struct crycg_copy<vec_uint4, 1>;
typedef crycg_copy<vec_uint4, 1>  __CRYCG_PRESERVE__ crycg_vec_copy_1;

template struct crycg_copy<unsigned long long, 16>;
typedef crycg_copy<unsigned long long, 16> __CRYCG_PRESERVE__ crycg_lint_copy_16;
template struct crycg_copy<unsigned long long, 15>;
typedef crycg_copy<unsigned long long, 15> __CRYCG_PRESERVE__ crycg_lint_copy_15;
template struct crycg_copy<unsigned long long, 14>;
typedef crycg_copy<unsigned long long, 14> __CRYCG_PRESERVE__ crycg_lint_copy_14;
template struct crycg_copy<unsigned long long, 13>;
typedef crycg_copy<unsigned long long, 13> __CRYCG_PRESERVE__ crycg_lint_copy_13;
template struct crycg_copy<unsigned long long, 12>;
typedef crycg_copy<unsigned long long, 12> __CRYCG_PRESERVE__ crycg_lint_copy_12;
template struct crycg_copy<unsigned long long, 11>;
typedef crycg_copy<unsigned long long, 11> __CRYCG_PRESERVE__ crycg_lint_copy_11;
template struct crycg_copy<unsigned long long, 10>;
typedef crycg_copy<unsigned long long, 10> __CRYCG_PRESERVE__ crycg_lint_copy_10;
template struct crycg_copy<unsigned long long, 9>;
typedef crycg_copy<unsigned long long, 9>  __CRYCG_PRESERVE__ crycg_lint_copy_9;
template struct crycg_copy<unsigned long long, 8>;
typedef crycg_copy<unsigned long long, 8>  __CRYCG_PRESERVE__ crycg_lint_copy_8;
template struct crycg_copy<unsigned long long, 7>;
typedef crycg_copy<unsigned long long, 7>  __CRYCG_PRESERVE__ crycg_lint_copy_7;
template struct crycg_copy<unsigned long long, 6>;
typedef crycg_copy<unsigned long long, 6>  __CRYCG_PRESERVE__ crycg_lint_copy_6;
template struct crycg_copy<unsigned long long, 5>;
typedef crycg_copy<unsigned long long, 5>  __CRYCG_PRESERVE__ crycg_lint_copy_5;
template struct crycg_copy<unsigned long long, 4>;
typedef crycg_copy<unsigned long long, 4>  __CRYCG_PRESERVE__ crycg_lint_copy_4;
template struct crycg_copy<unsigned long long, 3>;
typedef crycg_copy<unsigned long long, 3>  __CRYCG_PRESERVE__ crycg_lint_copy_3;
template struct crycg_copy<unsigned long long, 2>;
typedef crycg_copy<unsigned long long, 2>  __CRYCG_PRESERVE__ crycg_lint_copy_2;
template struct crycg_copy<unsigned long long, 1>;
typedef crycg_copy<unsigned long long, 1>  __CRYCG_PRESERVE__ crycg_lint_copy_1;

template struct crycg_copy<unsigned int, 16>;
typedef crycg_copy<unsigned int, 16> __CRYCG_PRESERVE__ crycg_int_copy_16;
template struct crycg_copy<unsigned int, 15>;
typedef crycg_copy<unsigned int, 15> __CRYCG_PRESERVE__ crycg_int_copy_15;
template struct crycg_copy<unsigned int, 14>;
typedef crycg_copy<unsigned int, 14> __CRYCG_PRESERVE__ crycg_int_copy_14;
template struct crycg_copy<unsigned int, 13>;
typedef crycg_copy<unsigned int, 13> __CRYCG_PRESERVE__ crycg_int_copy_13;
template struct crycg_copy<unsigned int, 12>;
typedef crycg_copy<unsigned int, 12> __CRYCG_PRESERVE__ crycg_int_copy_12;
template struct crycg_copy<unsigned int, 11>;
typedef crycg_copy<unsigned int, 11> __CRYCG_PRESERVE__ crycg_int_copy_11;
template struct crycg_copy<unsigned int, 10>;
typedef crycg_copy<unsigned int, 10> __CRYCG_PRESERVE__ crycg_int_copy_10;
template struct crycg_copy<unsigned int, 9>;
typedef crycg_copy<unsigned int, 9>  __CRYCG_PRESERVE__ crycg_int_copy_9;
template struct crycg_copy<unsigned int, 8>;
typedef crycg_copy<unsigned int, 8>  __CRYCG_PRESERVE__ crycg_int_copy_8;
template struct crycg_copy<unsigned int, 7>;
typedef crycg_copy<unsigned int, 7>  __CRYCG_PRESERVE__ crycg_int_copy_7;
template struct crycg_copy<unsigned int, 6>;
typedef crycg_copy<unsigned int, 6>  __CRYCG_PRESERVE__ crycg_int_copy_6;
template struct crycg_copy<unsigned int, 5>;
typedef crycg_copy<unsigned int, 5>  __CRYCG_PRESERVE__ crycg_int_copy_5;
template struct crycg_copy<unsigned int, 4>;
typedef crycg_copy<unsigned int, 4>  __CRYCG_PRESERVE__ crycg_int_copy_4;
template struct crycg_copy<unsigned int, 3>;
typedef crycg_copy<unsigned int, 3>  __CRYCG_PRESERVE__ crycg_int_copy_3;
template struct crycg_copy<unsigned int, 2>;
typedef crycg_copy<unsigned int, 2>  __CRYCG_PRESERVE__ crycg_int_copy_2;
template struct crycg_copy<unsigned int, 1>;
typedef crycg_copy<unsigned int, 1>  __CRYCG_PRESERVE__ crycg_int_copy_1;

#endif

