#!/usr/bin/perl
#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Echo the command arguments, applying a path normalization.
# The build target may be specified through the -t option.  If a build target
# is specified and a '..' is removed from the path, then the target name is
# appended to the line (in angle brackets).

use warnings;
use strict;

use Getopt::Std;
getopts('at:p:b:cH:lh');
our($opt_a, $opt_t, $opt_p, $opt_b, $opt_c, $opt_l, $opt_h, $opt_H);

my $EXT_LDFILES = 'files';

if ($opt_h)
{
  print <<EOF;
echo.pl: Echo with path normalization.
Synopsis:
  \$PERL echo.pl (Options) -- (Arguments)
Options:
-c
  Cygwin mode.  Convert file names of the form '/(PREFIX)/(DRIVE)/...' to
  '(DRIVE):/...'.  The pattern is recognized for stand alone options _and_ for
  paths follwing a -I option.
-H HOST_SYSTEM
  One of 'Linux', 'Windows', or 'Cygwin'.
-b BASEDIR
  Used in Cygwin mode only.  The base directory in Windows notation
  (drive:path).  If this option is specified, then the path prefix '/base' is
  converted to the specified base directory.
-p PREFIX
  Prefix to be stripped from all specified arguments.  The prefix is matched
  in case-insensitive mode.
-t TARGET
  The target name.  If a "/../" sequence is removed from an argument and a
  target is specified using the -t option, then the specified target name is
  appended to the output in brackets.  This option is ignored in line mode.
-l
  Line mode.  Output every argument in a separate line.  This option is useful
  for generating file lists.  This flag also disables the -t flag.
-a
  Link all mode.  This is a special mode expanding file lists.  If an argument
  matches the pattern *.o and a corresponding *.files file exists in the same
  directory, then the contents of the *.files file are echoed instead of the
  *.o file.
-h
  Display this help screen and exit.
EOF
  exit 0;
}

my $space = '';
my $stripped = 0;

if (defined($opt_H) and ($opt_H eq 'Cygwin')) { $opt_c = 1; }

foreach my $arg (@ARGV)
{
  while ($arg =~ s/\/\.\//\//) { }
  while ($arg =~ s/[^\/]+\/\.\.\///) { $stripped = 1; }
  if ($opt_p) { $arg =~ s/^${opt_p}//i; }
  if ($opt_c)
  {
    if ($opt_b)
    {
      if ($arg =~ /^(-[IL]|)\/base\/(.*$)/i)
      {
        $arg = "$1$opt_b/$2";
        $arg =~ s/\\/\//g;
        $arg =~ s/\/\/*/\//g;
      }
    }
    if ($arg =~ /^(-[IL]|)\/cygdrive\/([a-z])\/(.*$)/i)
    {
      $arg = "$1$2:/$3";
    }
    elsif ($arg =~ /^(-[IL]|)\/([a-z])\/(.*$)/i)
    {
      $arg = "$1$2:/$3";
    }
  }
  if ($opt_a and $arg =~ /^.*\.o$/)
  {
    my $listFile = "$arg.$EXT_LDFILES";
    if (-f "$listFile")
    {
      local *IN;
      open (IN, $listFile) or die "Can't open list file '$listFile': $!";
      while (<IN>)
      {
        next if /^\s*$/;
        s/^\s+|\s+$//g;
        if ($opt_l)
        {
          print "$_\n";
        }
        else
        {
          print "$space$_";
          $space = ' ';
        }
      }
      close IN;
      next;
    }
  }
  if ($opt_l)
  {
    print "$arg\n";
  }
  else
  {
    print "$space$arg";
    $space = ' ';
  }
}
if (not $opt_l)
{
  if ($opt_t and $stripped) { print " [$opt_t]"; }
  print "\n";
}
exit 0;

# vim:ts=2:sw=2:expandtab

