#!/usr/bin/perl
#############################################################################
## Crytek Source File
## Copyright (C) 2007, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Apr 10, 2007
## Description: GNU-make based build system
#############################################################################

# Fix the GCC generated dependency files for Cygwin make.

# This script generates the C++ files for an SPU job.
use warnings;
use strict;
use Getopt::Long qw(:config no_auto_abbrev bundling);

my $opt_help = 0; 
my $opt_base; 
my $opt_host;
GetOptions(
    'h|help' => \$opt_help,
    'b|basedir=s' => \$opt_base,    
    'host-system=s' => \$opt_host
    ) or exit 1;
if ($opt_help)
{
	print <<EOF
fixdeps.pl: Script for fixing compiler generated dependency files.
This script is part of the VisualStudio integration layer.
Synopsis:
  \$PERL fixdeps.pl -b BASEDIR <DEPS.orig >DEPS.fixed
Options:
-b BASEDIR
	The base directory in Windows notation (drive:path).  If this option is
	specified, then the base directory is translated to '/base/' in the fixed
	output file.
--host-system HOST 
	Specify the host system to either be 'MingW', 'Windows' or 'Cygwin'
EOF
  ;
  exit 0;
}
if (defined $opt_host and $opt_host eq 'MingW')
{
    while (<STDIN>) 
    { 
	my $line = $_;
	my $old_line = $line; 
	if ($line =~ m/\s*([a-z]:[^\s]*)\s+.*/i)
	{
	    my $path = $1; 
	    $path =~ s/\\/\//g; 
	    $path =~ s/\/\//\//g; 
	    $path =~ s/\/\.\//\//g; 
	    if ($line =~ m/\s+\\\s+/) {  $line = " $path \\\n"; } 
	    else { $line = " $path \n"; }
	}
	print $line; 
    }
    exit 0;
}
elsif (defined $opt_host and $opt_host eq 'Cygwin')
{ 
# Note: NOT configurable via command line - the Cygwin drive prefix (including
# trailing /).  Cygwin default is '/cygdrive/' - changed to '/' for MinGW
# compatibility.
#my $optCygwinDrivePrefix = '/cygdrive/';
    my $optCygwinDrivePrefix = '/';

    my $basedir;
    if (defined $opt_base)
    {
	$basedir = $opt_base;
	$basedir =~ s#\\#/#g;
	$basedir =~ s#//+#/#g;
    }

    our @lines = ( );
    while (<STDIN>) { push @lines, $_; }
    my $line;
    foreach $line (@lines)
    {
	$line =~ s#\\(\S)#/$1#g;
	$line =~ s#//+#/#g;
	if (defined $basedir)
	{
	    # Replace references to the basedir.
	    my $index = index lc $line, lc $basedir;
	    if ($index >= 0)
	    {
		# Make sure the base dir is a prefix of a filename.
		if ($index > 0 and (substr $line, $index - 1, 1) ne ' ') { $index = -1; }
	    }
	    if ($index >= 0)
	    {
		my $prefix = substr $line, 0, $index;
		my $suffix = substr $line, $index + length $basedir, -1;
		$line = $prefix . '/base/' . $suffix;
		$line =~ s#//+#/#g;
	    }
	}
	if ($line =~ /^(\s+)([a-z]):\/(.*$)/i)
	{
	    my $driveLetter = lc $2;
	    $line = "$1$optCygwinDrivePrefix$driveLetter/$3\n";
	}
	elsif ($line =~ /^(\S+:\s+)([a-z]):\/(.*$)/i)
	{
	    my $driveLetter = lc $2;
	    $line = "$1$optCygwinDrivePrefix$driveLetter/$3\n";
	}
	if ($line =~ /^([a-z]):(.*$)/i)
	{
	    my $driveLetter = lc $1;
	    $line = "$optCygwinDrivePrefix$driveLetter$2\n";
	}
	$line =~ s/\s+$//;
	print "$line\r\n";
    }
    exit 0;
}

print STDERR "$0: unsupported host system\n";
exit 1;

# vim:ts=2:sw=2

