#!/bin/perl
use File::Basename;
use Fcntl qw(:flock SEEK_END);

if ($#ARGV > 3)
{
	my $incrediFile = splice @ARGV,0,1;
	my $group = splice @ARGV,0,1;	
	my $ccline = join(" ", @ARGV);
	#replace % by %%
	my $repl = '%%';
	my $replAppend = '>>';	
	$ccline =~ s/\%/$repl/ge;
#	$ccline =~ s/__redirect_append__/$replAppend/ge;
	my $command = basename(@ARGV[0]);
	my $lv2 = '-lv2-';
	my $spulv2 = 'spu-lv2-g';	
	my $pagedist = 'pagedist';
	my $perlcmd = 'perl';
	my $capt = $command;
	my $cppString = '.cpp';
	my $tmpOString = '_tmp.o';
	my $emptyString = '';
#	my $forceLocal = "";
	my $cmd;
	my $xgwaitcmd = 'xgWait';
	my $codepagegenMode = 0;
	my $genPageDescCmd = 'genpagedesc.pl';
	if($command  =~ /$xgwaitcmd/)
	{
		$cmd = "\@$ccline";
	}
	else
	{
		if($command  =~ /$spulv2/)
		{
			my $baseName = basename(@ARGV[@ARGV - 1]);
			$capt = basename(substr($command,0,index($command, ".exe"))) . ":" . substr($baseName,0,index($baseName,".o")) . ".cpp";
		}
		elsif($command  =~ /$lv2/)
		{
			$capt = basename(substr($command,0,index($command, ".exe"))) . ":" . basename(@ARGV[@ARGV - 3]);
		}
		elsif($command  =~ /$pagedist/)
		{
			$capt = basename(@ARGV[@ARGV - 4]);
			$capt = "pagedist:" . substr($capt,0,index($capt, ".pageinfo"));
		}
		elsif($command =~ /$perlcmd/)
		{
		    foreach $args(@ARGV)
		    {
			if($codepagegenMode eq 0 && index($args,$genPageDescCmd) ge 0)
			{
			    $codepagegenMode = 1;
			    next;
			}
			if (index($args,$cppString) ge 0)
			{
			    $capt = basename($args);
			    last;
			}
			else
			{
			    if (index($args,$tmpOString) ge 0)
			    {
				$capt = basename($args);
				$capt =~ s/$tmpOString/$emptyString/ge;					
				$capt = "codepagegen:" . $capt;
				last;
			    }
			}
		    }
		    if($codepagegenMode eq 0)
		    {
			if(@ARGV[@ARGV - 2] eq '-p' || index(@ARGV[@ARGV - 1],".pageinfo" > 0))
			{
			    $capt = "genspu(pages):" . $capt;
			}
			else
			{
			    $capt = "genspu(job):" . $capt;
			}
		    }
		}
		if($codepagegenMode eq 1)
		{
			#insert string markers as this got stripped
			my $replString = '--pagegen-tool=\'';
			$ccline =~ s/--pagegen-tool=/$replString/ge;
			$ccline = $ccline . '\'';
		}
		$cmd = "\@xgSubmit /group=$group /caption=$capt /command $ccline";
	}
	open(incredifile, "+>>$incrediFile") || die("Cannot Open Incredibuild-batchfile: $incrediFile");
	flock (incredifile, LOCK_EX) || die "flock: $!";
	print incredifile "$cmd\n";
	flock(incredifile, LOCK_UN);
	close(incredifile);
}
