@ECHO OFF

REM #########################################################################
REM ## Crytek Source File
REM ## Copyright (C) 2007, Crytek Studios
REM ##
REM ## Creator: Sascha Demetrio
REM ## Date: Apr 11, 2007
REM ## Description: GNU-make based build system
REM #########################################################################

REM # Common batch file performing the VS integration operations.

REM # Arguments:
REM # %1 The base directory.
REM # %2 The project source directory.
REM # %3 The project name.
REM # %4 The name of the build configuration (make system).
REM # %5 The name of the build configuration (VS solution).
REM # %6 The name of the solution makefile (defaults to CryEngine.mk if empty)

SET BASE_DIR=%1
SET PROJECT_DIR=%2
SET PROJECT_NAME=%3
SET CONFIG=%4
SET VS_CONFIG=%5
SET SOLUTION_NAME=%6

IF DEFINED CELL_SDK (SET CELL_SDK_OVERRIDE=1)
IF NOT DEFINED CELL_SDK (SET CELL_SDK=%BASE_DIR%/Code/SDKs/PS3/cell)

if exist %CELL_SDK%/*.*	goto HAS_CELL_SDK
echo %CELL_SDK% not found
echo Map via perforce: "//depot/3rdParty/PS3/... //<your client>/mastercd/Code/SDKs/PS3/..."
exit -1

:HAS_CELL_SDK

SET CYGWIN_DIR=%BASE_DIR%/Code/Tools/Make/Tools/host-win32/cygwin
SET MINGW_DIR=%BASE_DIR%/Code/Tools/Make/Tools/host-win32/mingw
SET MSYS_DIR=%BASE_DIR%/Code/Tools/Make/Tools/host-win32/msys/1.0
SET CELL_HOSTDIR=%CELL_SDK%/host-win32
PATH %CELL_HOSTDIR%/bin;%CELL_HOSTDIR%/ppu/bin;%CELL_HOSTDIR%/spu/bin;%PATH%
PATH %MSYS_DIR%\bin\;%MSYS_DIR%\local\bin\;%MINGW_DIR%\;%CYGWIN_DIR%/bin;%PATH%

rem %CYGWIN_DIR%/bin/mount.exe -f -u -b -c /
rem %CYGWIN_DIR%/bin/mount.exe -f -u %CYGWIN_DIR% /
rem %CYGWIN_DIR%/bin/mount.exe -f -u %CYGWIN_DIR%/bin /usr/bin
rem %CYGWIN_DIR%/bin/mount.exe -f -u %CYGWIN_DIR%/lib /usr/lib
rem %CYGWIN_DIR%/bin/mount.exe -f -u %BASE_DIR% /base

%MINGW_DIR%/mkdir.exe -p %BASE_DIR%/Code/Tools/Make/Tools/host-win32/msys/1.0/tmp
%CYGWIN_DIR%/bin/mount.exe -f -u %BASE_DIR%/Code/Tools/Make/Tools/host-win32/msys/1.0/tmp /tmp


SET HOST_SYSTEM=Windows
SET OPTION_CRYCG_SYSTEM_INCLUDEDIRS=$(MAKE_ROOT)/Tools/crycg/ppu/include,$(CELL_SDK)/target/common/include,$(CELL_SDK)/target/spu/include

SET DEFAULT_MK=Code/Tools/Make/Default.mk

REM SET DISTCC_HOSTS=192.168.250.1/8 192.168.14.132/8 192.168.14.133/8 192.168.0.240/8 192.168.222.221/8 localhost/1
SET DISTCC_HOSTS=192.168.250.1/8 192.168.14.131/8 192.168.14.132/8 192.168.14.133/8 192.168.0.240/8 192.168.222.221/8 localhost/1

REM Below is Nottingham's distcc3.1 host list (Based on NOT_DISTCC).
REM Note: --randomize is only available in distcc3.1
IF DEFINED NOT_DISTCC (
	SET DISTCC_HOSTS=--randomize 10.16.0.18/16,lzo 10.16.4.2/8,lzo 10.16.4.13/8,lzo 10.16.4.3/8,lzo 10.16.4.4/8,lzo 10.16.4.5/8,lzo 10.16.4.7/4,lzo 
	SET DISTCC=distcc3.1 )
SET DISTCC_FALLBACK=1
SET DISTCC_RETRY_WAIT=0

REM SET DISTCC_VERBOSE=1

REM For verbose output, add MKOPTION_VERBOSE=1 MKOPTION_COMPACT=0
REM SET MKOPTION_DISTCC=1 
REM SET MKOPTION_MAKEFLAGS=-k
REM SET PERL5SHELL=E:/projects/main/Code/Tools/Make/Tools/host-win32/cygwin/bin/sh.exe -c
REM SET PERL5SHELL=E:/projects/main/Code/Tools/Make/Tools/host-win32/msys/1.0/bin/sh.exe -c
REM SET PERL5SHELL=E:\projects\main\Code\Tools\Make\Tools\host-win32\msys\1.0\bin\sh.exe -c

SET INCREDIBAT=%BASE_DIR%\Incredibuild.bat
SET INCREDIBAT_SPU=%BASE_DIR%\Incredibuild_spu.bat
SET INCREDIBAT_LOG=%BASE_DIR%\Incredibuild.log
SET INCREDIBAT_SPU_LOG=%BASE_DIR%\Incredibuild_spu.log

IF EXIST %BASE_DIR%/Config.bat CALL %BASE_DIR%/Config.bat
SET MAKE_OPTIONS=%MAKE_OPTIONS% CONFIG=%CONFIG% HOST_SYSTEM=Windows
SET MAKE_OPTIONS=%MAKE_OPTIONS% VS_CONFIG=%VS_CONFIG%
REM SET MAKE_OPTIONS=%MAKE_OPTIONS% MKOPTION_PS3_MIXED_BUILD=1
SET MAKE_OPTIONS=%MAKE_OPTIONS% TARGET=%PROJECT_NAME% -r -f %DEFAULT_MK% SOLUTION=%SOLUTION_NAME% INCREDIBAT=%INCREDIBAT%

rm -f %INCREDIBAT%
rm -f %INCREDIBAT_SPU%
rm -f %INCREDIBAT_LOG%
touch %INCREDIBAT_LOG%
rm -f %INCREDIBAT_SPU_LOG%
touch %INCREDIBAT_SPU_LOG%

REM If you want to use cygwin-make set the MAKE_SYSTEM variable to: Cygwin
SET MAKE_SYSTEM=MinGW
IF %MAKE_SYSTEM%==MinGW ( SET MAKE_PROG=mingw32-make.exe
) ELSE ( SET MAKE_PROG=make.exe )

CD /D %BASE_DIR%

