#ifndef __GEOMETRYEXTENDEDEXPORTSOURCE_H__
#define __GEOMETRYEXTENDEDEXPORTSOURCE_H__

#include "Export/IExportSource.h"

#define clamp clamp_foo		// I had to do this to prevent a name collision between Cry_Math.h and 3ds Max's texutil.h
#include "Cry_Math.h"
#undef clamp

class ISceneNode
{
public:
	virtual ~ISceneNode()
	{
	}

	virtual void setParent(ISceneNode* const pNode) = 0;
	virtual void addChild(ISceneNode* const pNode) = 0;

	virtual ISceneNode* getParent() const = 0;
	virtual int getChildCount() const = 0;
	virtual ISceneNode* getChild(int index) const = 0;

	virtual void* getNativeSceneNode() const = 0;
	virtual Matrix34 getWorldTransform() const = 0;
};


struct Scene
{
public:
	std::vector<ISceneNode*> m_nodes;
};


class GeometryExtendedExportSource : public IExportSource
{
public:
	GeometryExtendedExportSource(const std::string& parameters, const std::vector<INode*>& nodes);
	virtual ~GeometryExtendedExportSource();

	// IExportSource
	virtual void GetMetaData(SExportMetaData& metaData) const;
	virtual std::string GetDCCFileName() const;
	virtual std::string GetExportDirectory() const;
	virtual void ReadGeometryFiles(IExportContext* context, IGeometryFileData* geometryFileData);
	virtual bool ReadMaterials(IExportContext* context, const IGeometryFileData* geometryFileData, IMaterialData* materialData);
	virtual void ReadModels(const IGeometryFileData* geometryFileData, int geometryFileIndex, IModelData* modelData);
	virtual void ReadSkinning(IExportContext* context, ISkinningData* skinningData, const IModelData* modelData, int modelIndex, ISkeletonData* skeletonData);
	virtual bool ReadSkeleton(const IGeometryFileData* geometryFileData, int geometryFileIndex, const IModelData* modelData, int modelIndex, const IMaterialData* materialData, ISkeletonData* skeletonData);
	virtual int GetAnimationCount() const;
	virtual std::string GetAnimationName(const IGeometryFileData* geometryFileData, int geometryFileIndex, int animationIndex) const;
	virtual void GetAnimationTimeSpan(float& start, float& stop, int animationIndex) const;
	virtual void ReadAnimationFlags(IExportContext* context, IAnimationData* animationData, const IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex) const;
	virtual IAnimationData * ReadAnimation(IExportContext* context, const IGeometryFileData* geometryFileData, const IModelData* modelData, int modelIndex, const ISkeletonData* skeletonData, int animationIndex, float fps) const;
	virtual bool ReadGeometry(IExportContext* context, IGeometryData* geometry, const IModelData* modelData, const IMaterialData* materialData, int modelIndex);
	virtual bool ReadGeometryMaterialData(IExportContext* context, IGeometryMaterialData* geometryMaterialData, const IModelData* modelData, const IMaterialData* materialData, int modelIndex) const;
	virtual bool ReadBoneGeometry(IExportContext* context, IGeometryData* geometry, ISkeletonData* skeletonData, int boneIndex, const IMaterialData* materialData);
	virtual bool ReadBoneGeometryMaterialData(IExportContext* context, IGeometryMaterialData* geometryMaterialData, ISkeletonData* skeletonData, int boneIndex, const IMaterialData* materialData) const;
	virtual void ReadMorphs(IExportContext* context, IMorphData* morphData, const IModelData* modelData, int modelIndex);
	virtual bool ReadMorphGeometry(IExportContext* context, IGeometryData* geometry, const IModelData* modelData, int modelIndex, const IMorphData* morphData, int morphIndex, const IMaterialData* materialData);
	virtual bool HasValidPosController(const IModelData* modelData, int modelIndex) const;
	virtual bool HasValidRotController(const IModelData* modelData, int modelIndex) const;
	virtual bool HasValidSclController(const IModelData* modelData, int modelIndex) const;

private:
	bool m_bExportFilePerNode;
	bool m_bMergeAllNodes;
	std::vector<ISceneNode*> m_scenesRootNode;
};

#endif //__GEOMETRYEXTENDEDEXPORTSOURCE_H__
