#include "StdAfx.h"
#include "max.h"
#include "ExportFunctions.h"

#define CRYEXPORTLIBRARY_INTERFACE Interface_ID(0x664e63e4, 0x4f040bed)

enum 
{
	FN_TEST,
	FN_EXPORT,
	FN_EXPORT_ANIM,
	FN_EXTENDED_EXPORT
};

class IExportLibrary : public FPStaticInterface
{
public:
	virtual void Test() = 0;
	virtual void Export() = 0;
	virtual void ExportAnim(const char* path, Tab<INode*> roots) = 0;
	virtual void ExtendedExport(const char* parameters, Tab<INode*> nodes) = 0;
};

class ExportLibrary : public IExportLibrary
{
public:
	virtual void Test() 
	{
		MessageBeep(MB_ICONASTERISK);
	}
	virtual void Export() 
	{
		ExportFunctions::Export();
	}
	virtual void ExportAnim(const char* path, Tab<INode*> roots)
	{
		std::set<INode*> rootSet(roots.Count() ? std::set<INode*>(&roots[0], &roots[0] + roots.Count()) : std::set<INode*>());
		ExportFunctions::ExportAnim(path, rootSet);
	}
	virtual void ExtendedExport(const char* parameters, Tab<INode*> nodes)
	{
		std::vector<INode*> nodeVector(nodes.Count() ? std::vector<INode*>(&nodes[0], &nodes[0] + nodes.Count()) : std::vector<INode*>());
		ExportFunctions::ExtendedExport(parameters, nodeVector);
	}
	DECLARE_DESCRIPTOR(ExportLibrary)
 
	// dispatch map
	BEGIN_FUNCTION_MAP
		VFN_0(FN_TEST, Test);
		VFN_0(FN_EXPORT, Export);
		VFN_2(FN_EXPORT_ANIM, ExportAnim, TYPE_STRING, TYPE_INODE_TAB_BV);
		VFN_2(FN_EXTENDED_EXPORT, ExtendedExport, TYPE_STRING, TYPE_INODE_TAB_BV);
	END_FUNCTION_MAP
};

ExportLibrary* exportLibrary = 0;

extern "C" __declspec(dllexport) void Initialize(ClassDesc* parentClass)
{
	if (!exportLibrary)
	{
		exportLibrary = new ExportLibrary(
			CRYEXPORTLIBRARY_INTERFACE, "export", -1, parentClass, 0,
				FN_TEST, "test", -1, TYPE_VOID, 0, 0,
				FN_EXPORT, "export", -1, TYPE_VOID, 0, 0,
				FN_EXPORT_ANIM, "export_anim", -1, TYPE_VOID, 0, 2,
					"path", -1, TYPE_STRING,
					"roots", -1, TYPE_INODE_TAB_BV,
				FN_EXTENDED_EXPORT, "extended_export", -1, TYPE_VOID, 0, 2,
					"parameters", -1, TYPE_STRING,
					"roots", -1, TYPE_INODE_TAB_BV,
			end);
	}
}

extern "C" __declspec(dllexport) void Finalize()
{
	if (exportLibrary)
	{
		delete exportLibrary;
		exportLibrary = 0;
	}
}

extern "C" __declspec(dllexport) void ExtendedExport(const char* parameters, INode** nodes, DWORD nodeCount)
{
	if (!exportLibrary)
	{
		return;
	}

	if ((parameters == 0) || (parameters[0] == 0))
	{
		return;
	}

	if ((nodes == 0) || (nodeCount <= 0))
	{
		return;
	}

	Tab<INode*> tabNodes;
	tabNodes.Append(nodeCount, nodes);

	exportLibrary->ExtendedExport(parameters, tabNodes);
}
