#ifndef __MESHHELPERS_H__
#define __MESHHELPERS_H__

namespace MeshHelpers
{
	struct Triangle
	{
		struct Vertex
		{
			Vertex()
				: p(-1)
				, n(-1)
				, t(-1)
				, c(-1) 
			{
			}

			Vertex(int a_p, int a_n, int a_t, int a_c)
				: p(a_p)
				, n(a_n)
				, t(a_t)
				, c(a_c) 
			{
			}

			int p, n, t, c;		// indices of: position, normal, texture coordinates, color
		};

		Triangle() 
		{
		}

		Triangle(int a_mtlID, const Vertex& a_v0, const Vertex& a_v1, const Vertex& a_v2) 
			: mtlID(a_mtlID)
		{
			v[0] = a_v0; 
			v[1] = a_v1; 
			v[2] = a_v2;
		}

		int mtlID;
		Vertex v[3];
	};

	struct Vector3
	{
		Vector3()
			: x(0.0f)
			, y(0.0f)
			, z(0.0f) 
		{
		}

		Vector3(float a_x, float a_y, float a_z)
			: x(a_x)
			, y(a_y)
			, z(a_z) 
		{
		}

		float x, y, z;
	};

	struct TextureCoordinate
	{
		TextureCoordinate()
			: u(0.0f)
			, v(0.0f) 
		{
		}

		TextureCoordinate(float a_u, float a_v)
			: u(a_u)
			, v(a_v) 
		{
		}

		float u, v;
	};

	struct VertexColour
	{
		VertexColour()
			: r(0.0f)
			, g(0.0f)
			, b(0.0f)
			, a(0.0f) 
		{
		}

		VertexColour(float a_r, float a_g, float a_b, float a_a)
			: r(a_r)
			, g(a_g)
			, b(a_b)
			, a(a_a) 
		{
		}

		float r, g, b, a;
	};

	struct MapChannel
	{
		MapChannel()
		{
			set(0,0,0);
		}

		void set(int a_vertexCount, const Point3* a_vertices, const TVFace* a_faces)
		{
			vertexCount = a_vertexCount;
			vertices = a_vertices;
			faces = a_faces;

			if ((vertexCount <= 0) || (vertices == 0) || (faces == 0))
			{
				vertexCount = 0;
				vertices = 0;
				faces = 0;
			}
		}

		int vertexCount;
		const Point3* vertices;
		const TVFace* faces;
	};


	struct MeshData
	{
		void clear()
		{
			faceCount = 0;
			positionCount = 0;
			normalCount = 0;
			vertexColorAndAlphaCount = 0;

			textureCoordinates.set(0,0,0);
			color.set(0,0,0);
			alpha.set(0,0,0);

			facelistHeadsForNormals.resize(0);
			facelistChainsForNormals.resize(0);
			colorAndAlphaAreMatching = false;
		}

		int faceCount;
		int positionCount;
		int normalCount;
		int vertexColorAndAlphaCount;

		MapChannel textureCoordinates;
		MapChannel color;
		MapChannel alpha;

		std::vector<int> facelistHeadsForNormals;		
		std::vector<int> facelistChainsForNormals;
		bool colorAndAlphaAreMatching;
	};


	Mesh* GetMesh(INode* node);

	bool AssignTriangleIndices(Mesh* mesh, std::vector<MeshHelpers::Triangle>& triangles, MeshData& res);

	void GetObjectOffsetTM(Matrix3& objectOffsetTM, INode* node);

	void CalculatePositions(Mesh* mesh, const MeshHelpers::MeshData& meshData, Matrix3& objectOffsetTM, std::vector<MeshHelpers::Vector3>& positions);
	void CalculateNormals(Mesh* mesh, const MeshHelpers::MeshData& meshData, std::vector<MeshHelpers::Vector3>& normals);
	void CalculateTextureCoordinates(const MeshHelpers::MeshData& meshData, std::vector<MeshHelpers::TextureCoordinate>& textureCoordinates);
	void CalculateVertexColours(const MeshHelpers::MeshData& meshData, std::vector<MeshHelpers::VertexColour>& vertexColours);
}

#endif //__MESHHELPERS_H__
