#include "StdAfx.h"
#include "ModifierHelpers.h"

Modifier* ModifierHelpers::FindModifierSupportingInterface(INode* node, ULONG iid)
{
	Object* object = (node ? node->GetObjectRef() : 0);
	IDerivedObject* derivedObject = (object && object->SuperClassID() == GEN_DERIVOB_CLASS_ID ? static_cast<IDerivedObject*>(object) : 0);

	Modifier* requestedModifier = 0;
	for (int modStackIndex = 0, modStackSize = (derivedObject ? derivedObject->NumModifiers() : 0); modStackIndex < modStackSize; ++modStackIndex)
	{
		// Get current modifier.
		Modifier* modifier = derivedObject->GetModifier(modStackIndex);

		// Check whether this modifier supports the requested interface.
		BaseInterface* iface = static_cast<BaseInterface*>(modifier->GetInterface(iid));
		if (iface)
			requestedModifier = modifier;
	}

	return requestedModifier;
}
