#include "StdAfx.h"
#include "MorpherHelpers.h"

MorphR3* MorpherHelpers::GetMorpher(INode* pNode)
{
	TCHAR* name = pNode->GetName();

	Object* objectRef = pNode->GetObjectRef();

	while (objectRef && objectRef->SuperClassID() == GEN_DERIVOB_CLASS_ID)
	{
		IDerivedObject* derivedObject = static_cast<IDerivedObject*>(objectRef);
		for (int modIndex = 0, modCount = (derivedObject ? derivedObject->NumModifiers() : 0); modIndex < modCount; ++modIndex)
		{
			Modifier* mod = (derivedObject ? derivedObject->GetModifier(modIndex) : 0);
			MorphR3* morpher = (mod && mod->ClassID() == MR3_CLASS_ID ? static_cast<MorphR3*>(mod) : 0);
			if (morpher)
				return morpher;
		}
		objectRef = derivedObject->GetObjRef();
	}

	return 0;
}

void MorpherHelpers::DeformPositions(std::vector<MeshHelpers::Vector3> positions, MorphR3* morpher, int channelIndex)
{
	morphChannel& channel = morpher->chanBank[channelIndex];
	if (channel.mActive)
	{
		for (int i = 0, count = channel.mNumPoints; i < count; ++i)
		{
			if (i < positions.size())
			{
				positions[i].x = channel.mPoints[i].x;
				positions[i].y = channel.mPoints[i].y;
				positions[i].z = channel.mPoints[i].z;
			}
		}
	}
}
