#include "StdAfx.h"
#include "NodeHelpers.h"
#include "StringHelpers.h"

static const char* const excludePrefix = "_";

static const char* const cryexportPrefix = "cryexportnode_";


bool NodeHelpers::IsExcluded(INode* const node)
{
	if (node == 0)
	{
		return true;
	}

	std::string lower = StringHelpers::MakeLowerCase(node->GetName());

	return StringHelpers::StartsWith(lower, excludePrefix);
}


/*
const char* NodeHelpers::GetCryExportNodeNamePrefix()
{
	return cryexportPrefix;
}
*/

std::string NodeHelpers::GetCryExportNodeNameSuffix(const char* const a_name)
{
	if (a_name == 0)
	{
		return std::string();
	}

	std::string name(a_name);
	std::string lower = StringHelpers::MakeLowerCase(name);

	const char* prefix;
	if (StringHelpers::StartsWith(lower, cryexportPrefix))
	{
		prefix = cryexportPrefix;
	}
	else
	{
		return std::string();
	}

	const size_t prefixLength = strlen(prefix);
	return name.substr(prefixLength);
}

bool NodeHelpers::IsFootPrint(INode *node)
{
	if (!node)
		return false;
	Control* pc = node->GetTMController();
	return (pc && (pc->ClassID() == FOOTPRINT_CLASS_ID));
}
