#ifndef __SKINNINGHELPERS_H__
#define __SKINNINGHELPERS_H__

class ISkin;
class ISkinContextData;

namespace SkinningHelpers
{
	class SkinAccessor
	{
	public:
		SkinAccessor(INode* meshNode);
		void FindSkeletonRoots(std::set<INode*>& skeletonRoots);
		void GetBoneInitialPosition(INode* bone, Matrix3& tm);
		int GetVertexCount();
		int GetNumBoneLinksForVertex(int vertexIndex);
		void GetBoneLinkInfoForVertex(int vertexIndex, int linkIndex, INode*& bone, float& weight);
		bool HasSkin() const;

	private:
		ISkin* skin;
		ISkinContextData* skinContext;
		INode* meshNode;
	};
}

#endif //__SKINNINGHELPERS_H__
