#include "StdAfx.h"
#include "UserPropertyHelpers.h"
#include "NodeHelpers.h"
#include "StringHelpers.h"


std::string UserPropertyHelpers::GetNodeProperties(INode* node)
{
	if (node == 0)
	{
		return std::string();
	}

	std::string prop;

	// Get User-Defined-Properties
	{
		TSTR buf;
		node->GetUserPropBuffer(buf);

		const char* data = buf.data();

		if (data && data[0])
		{
			prop += data;
		}
	}

	return prop;
}
