// Declaration of the class that implements CryExportUtil command that is used internally by
// the User Interface scripts shipped with the Exporter plugin
#pragma once

#include "MayaUtils.h"

// Class - utility command used internally for User Interface support.
// UI (and other) MEL scripts from CryTek may use it to make the plugin do some part of the job that 
// scripts otherwise would have to do, for example translation of a set of bones into binded mesh or
// vice versa.
class CCmdExportUtil:
	public MPxCommand
{
public:

	// Does the actual job
	virtual MStatus	doIt ( const MArgList& );

	static void*	creator()
	{
		return new CCmdExportUtil();
	}

	// constructs a syntax object
	static MSyntax newSyntax();

	// parses the common arguments passed to the command (file name)
	virtual MStatus parseArgs (const MArgList& args);

	CCmdExportUtil(void);
	~CCmdExportUtil(void);

protected:
	// This string defines the action to take in this command.
	// this is the first parameter of the -action MEL flag
	MString m_strAction;

	// the list of objects to operate on - selection by default
	MSelectionList m_lstSelection;

	// -toCGF action
	// converts the selection to an array of mesh, dummy etc. objects: converts each bone to the corresponding mesh object
	MStatus prepareForGeometryExport ();

	// -toCAF action
	// converts the selection to an array of bones suitable for animation export; converts mesh to the array of influencing bones
	MStatus prepareForAnimationExport ();

	// reads transform hierarchy and adds it to the result set
	void prepareHierarchyForGeometryExport (const MDagPath& pathHierarchy, int nRecurseLevels = 15);

	// cleans up pure shapes from the list, leaves only transform nodes;
	// this automatically deletes extra nodes like shaders etc.
	void cleanupShapes();

	// adds the flesh connected to the given bone to the result set; returns true if it succeeded;
	// false if there is no flesh connected or it is not a bone
	bool prepareConnectedFleshForGeometryExport (const MDagPath& pathBone);

	// prepares the given bone and all its children for export
	void prepareBoneHierarchyForAnimationExport(const MDagPath& pathJoint);

	// prepares non-bone for export: searches for influencing bones and addds them (hierarchies) to the exported list
	bool prepareNonBoneForAnimationExport (const MDagPath& pathDagNode);

	// appends the given dag path set to the result
	void appendSetToResult (const MDagPathSet& setResult);

	// the result
	MDagPathSet m_setPathResult;

	// full path to return
	bool m_bReturnFullPaths;

	// ignore dummies
	bool m_bIgnoreDummies;
};
