#include "stdafx.h"
#include "MayaCryUtils.h"
#include "CryKeyInterpolation.h"

// converts the time from Maya units to native CryAnimation CAF file units (3DSMAX ticks)
int MayaToCryTime (const MTime& time)
{
	return int (floor (time.as (MTime::kSeconds) * 4800 + 0.5));
}

// converts the time from Maya units to native CryAnimation CAF file units (3DSMAX ticks)
// this is for unitless time
int MayaToCryTime (double fTime)
{
	return int (floor (fTime * 4800 + 0.5));
}

// converts the Cry time to Maya time
MTime CryToMayaTime (int nTick)
{
	return MTime (nTick / 4800.0, MTime::kSeconds);
}

// Converts the translation/rotation into CryBoneKey structure
CryBoneKey ToCryBoneKey (int time, MVector& vmTranslation, MQuaternion& qmRotation)
{
	CryBoneKey key;
	key.relpos.x  = (float)vmTranslation.x;
	key.relpos.y  = (float)vmTranslation.y;
	key.relpos.z  = (float)vmTranslation.z;

	key.abspos = key.relpos;

	key.relquat.w = (float)qmRotation.w;
	key.relquat.v.x = (float)qmRotation.x;
	key.relquat.v.y = (float)qmRotation.y;
	key.relquat.v.z = (float)qmRotation.z;
	key.time   = time;
	return key;
}


// converts rotation order in the format of the transformation matrix class
// into the rotation order in the format of the euler rotation class
MEulerRotation::RotationOrder ToEulOrd (MTransformationMatrix::RotationOrder nRotOrd)
{
	switch (nRotOrd)
	{
	case MTransformationMatrix::kXYZ:
		return MEulerRotation::kXYZ;
	case MTransformationMatrix::kYZX:
		return MEulerRotation::kYZX;
	case MTransformationMatrix::kZXY :
		return MEulerRotation::kZXY ;
	case MTransformationMatrix::kXZY :
		return MEulerRotation::kXZY ;
	case MTransformationMatrix::kYXZ :
		return MEulerRotation::kYXZ ;
	case MTransformationMatrix::kZYX:
		return MEulerRotation::kZYX;
	default:
		return MEulerRotation::kXYZ;
	}
}

unsigned char clamp_to_uchar (float x)
{
	return x <= 0 ? 0 : x >= 255 ? 255 : (unsigned char) x;
}

// converts the color from MColor to CryIRGB
CryIRGB MayaToCryIRGB (const MColor& rgbMayaColor)
{
	CryIRGB rgbResult;
	rgbResult.r = clamp_to_uchar(rgbMayaColor.r * 0xFF);
	rgbResult.g = clamp_to_uchar(rgbMayaColor.g * 0xFF);
	rgbResult.b = clamp_to_uchar(rgbMayaColor.b * 0xFF);
	return rgbResult;
}

Vec3& assign (Vec3& left, MFloatVector& right)
{
	left.x = (float)right.x;
	left.y = (float)right.y;
	left.z = (float)right.z;
	return left;
}

Vec3& assign (Vec3& left, MPoint& right)
{
	left.x = (float)right.x;
	left.y = (float)right.y;
	left.z = (float)right.z;
	return left;
}

Vec3& assign (Vec3& left, MVector& right)
{
	left.x = (float)right.x;
	left.y = (float)right.y;
	left.z = (float)right.z;
	return left;
}


void FixupPath (std::string& strTexPath)
{
	int nStrLen = strTexPath.length ();
	for (int i = 0; i < nStrLen; ++i)
		if (strTexPath[i] == '/')
			strTexPath[i] = '\\';
}

bool GetRelativePath(char* szBuffer, int nBufSize, const char* szFullPath )
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char fext[_MAX_EXT];

	_splitpath( szFullPath,drive,dir,fname,fext );
	char *pos = dir;
	if (pos[0] == '\\')
		pos++;
	pos = strchr(pos,'\\');
	if (pos)
	{
		char temp[_MAX_DIR];
		strcpy( temp,pos+1 );
		strcpy( dir,temp );
	}
	else
	{
		strcpy( dir,"" );
	}
	_makepath( szBuffer,NULL,dir,fname,fext );
	return true;
}
