
#include "stdafx.h"
#include "Mocap.h"

#include "MocapDoc.h"

//////////////////////////////////////////////////////////////////////////
void on_mouse( int event, int x, int y, int flags, void* param )
{

	CMocapDoc *pDoc=(CMocapDoc *)param;
	if ( !pDoc || !pDoc->m_bEditMode )
		return;

	pDoc->EditMarkers(x,y,event);

}

//////////////////////////////////////////////////////////////////////////
bool CMocapDoc::LoadData(CArchive& ar)
{
	m_nMarkerSelected=-1;

	char szFilename[256];
	sprintf(szFilename,"%s",ar.GetFile()->GetFilePath());
	m_input_video = cvCaptureFromAVI(szFilename);
	if (!m_input_video)
	{
		// Either the video didn't exist OR it uses a codec OpenCV
		// doesn't support.					
		MyError("Cannot open file %s \n",szFilename);
		return (false);
	}

	// This is a hack. If we don't call this first then getting capture
	// properties (below) won't work right. This is an OpenCV bug. We
	// ignore the return value here. But it's actually a video frame.	
	cvQueryFrame( m_input_video );

	// Read the video's frame size out of the AVI. 
	CvSize frame_size;
	int w=frame_size.width =(int) cvGetCaptureProperty( m_input_video, CV_CAP_PROP_FRAME_WIDTH );
	int h=frame_size.height =(int) cvGetCaptureProperty( m_input_video, CV_CAP_PROP_FRAME_HEIGHT );	
	int fps=(int) cvGetCaptureProperty( m_input_video, CV_CAP_PROP_FPS );	

	cvReleaseImage(&m_pScreen);
	m_pScreen=cvCreateImage(frame_size,8,3);
	m_pScreenEdit=cvCreateImage(frame_size,8,3);

	// Determine the number of frames in the AVI. 
	long number_of_frames;
	// Go to the end of the AVI (ie: the fraction is "1") 
	cvSetCaptureProperty( m_input_video, CV_CAP_PROP_POS_AVI_RATIO, 1. );
	// Now that we're at the end, read the AVI position in frames 
	number_of_frames = (int) cvGetCaptureProperty( m_input_video, CV_CAP_PROP_POS_FRAMES );
	// Return to the beginning 
	cvSetCaptureProperty( m_input_video, CV_CAP_PROP_POS_FRAMES, 0. );

	cvNamedWindow("MoCap", CV_WINDOW_AUTOSIZE);

	cvSetMouseCallback( "MoCap", on_mouse, this );

	cvInitFont( &m_font1, CV_FONT_HERSHEY_SIMPLEX, 0.35, 0.35);  		

	IplImage *frame = NULL, *frame1 = NULL, *frame2 = NULL,*frame22 = NULL, *frame1_1C = NULL, *frame2_1C = NULL, *eig_image = NULL, *temp_image = NULL, *pyramid1 = NULL, *pyramid2 = NULL;

	frame1_1C=cvCreateImage( frame_size, 8, 1 );	
	frame2_1C=cvCreateImage( frame_size, 8, 1 );	
	//frame11=cvCreateImage( frame_size, 8, 1 );	

	const int nMaxFeatures=2048;

	// allocate storage
	eig_image =cvCreateImage( frame_size, IPL_DEPTH_32F, 1 );
	temp_image=cvCreateImage( frame_size, IPL_DEPTH_32F, 1 );
	frame1=cvCreateImage( frame_size, 8, 3 );	
	frame2=cvCreateImage( frame_size, 8, 3 );	
	// This is some workspace for the algorithm.
	// (The algorithm actually carves the image into pyramids of different resolutions.)		
	pyramid1=cvCreateImage( frame_size, IPL_DEPTH_8U, 1 );
	pyramid2=cvCreateImage( frame_size, IPL_DEPTH_8U, 1 );
	// features found in frame 1
	CvPoint2D32f *frame1_features=new CvPoint2D32f[nMaxFeatures];
	// This array will contain the locations of the points from frame 1 in frame 2. 
	CvPoint2D32f *frame2_features=new CvPoint2D32f[nMaxFeatures];
	//CvPoint2D32f *frame3_features=new CvPoint2D32f[nMaxFeatures];

	// The i-th element of this array will be non-zero if and only if the i-th feature of
	// frame 1 was found in frame 2.
	char *optical_flow_found_feature=new char [nMaxFeatures];
	// The i-th element of this array is the error in the optical flow for the i-th feature
	// of frame1 as found in frame 2.  
	float *optical_flow_feature_error=new float[nMaxFeatures];


	//////////////////////////////////////////////////////////////////////////
	// load .bmp with same filename as video. This is the reference frame	
	ReplaceExtension(szFilename,"bmp");
	MyOutputDebugString("Attempting to load %s\n",szFilename);
	IplImage	*pFrame=cvLoadImage(szFilename);
	
	if (pFrame)
	{		
		uchar *pSrc=(uchar *)pFrame->imageData;
		for (int k=0;k<w*h;k++)
		{
			int r,g,b;
			b=pSrc[k*3+0];
			g=pSrc[k*3+1];
			r=pSrc[k*3+2];

			//if (r==0 && g==255 && b==0)
			if (r==255 && g==0 && b==0)
			{
				int y=k/w;
				int x=k-y*w;

				tFeature *pFeature=new tFeature;
				
				pFeature->v2DPos.x=x;
				pFeature->v2DPos.y=y;
				pFeature->v2DPos.z=1.0;

				m_lstFeatures.push_back(pFeature);
			}
		} //k		
	}
	//////////////////////////////////////////////////////////////////////////
	bool bExportFrames=true;

	char szText[256];
	for (int k=0;k<number_of_frames-1;k++)
	{	
		cvSetCaptureProperty( m_input_video, CV_CAP_PROP_POS_FRAMES, k );

		// first frame	
		IplImage *frame = cvQueryFrame( m_input_video );	
		//cvConvertImage(frame, frame1, 1);			
		cvConvertImage(frame, frame1_1C, 1);	
		cvConvertImage(frame,m_pScreen,1);

		// second frame		
		cvSetCaptureProperty( m_input_video, CV_CAP_PROP_POS_FRAMES, k+1);
		frame = cvQueryFrame( m_input_video );
		//cvConvertImage(frame, frame2, 1);		
		cvConvertImage(frame, frame2_1C, 1);

		int number_of_features=nMaxFeatures;

		cvGoodFeaturesToTrack(frame1_1C, eig_image, temp_image, frame1_features, &number_of_features, .01, .01, NULL);

		for (lstFeatureIt i=m_lstFeatures.begin();i!=m_lstFeatures.end();i++)
		{
			tFeature *pFeature=(*i);
			vector3f vPos=pFeature->v2DPos;
			
			// refine, small radius
			const ftype fRadius=sqr((ftype)(w)/128.0)*2;
			vector3f vRes;
			vRes.Clear();
			int nCount=0;
			for (int i1 = 0; i1 < number_of_features; i1++)
			{			
				ftype fDist=sqr(frame1_features[i1].x-vPos.x)+sqr(frame1_features[i1].y-vPos.y);
				if (fDist>fRadius)
					continue;

				vRes.x+=frame1_features[i1].x;					
				vRes.y+=frame1_features[i1].y;
				nCount++;
			}  //i1

			if (nCount>0)
				pFeature->v2DPos=vRes/(ftype)(nCount);

			CvPoint p;
			p.x = (int) pFeature->v2DPos.x;
			p.y = (int) pFeature->v2DPos.y;
			//cvCircle(m_pScreen,p,(int)(sqrt(fRadius)),CV_RGB(255,0,0),1);
		} //i



		// This is the window size to use to avoid the aperture problem 
		CvSize optical_flow_window = cvSize(5,5);

		// This termination criteria tells the algorithm to stop when it has either done 20 iterations or when
		// epsilon is better than .3.  You can play with these parameters for speed vs. accuracy but these values
		// work pretty well in many situations.
		CvTermCriteria optical_flow_termination_criteria
			//= cvTermCriteria( CV_TERMCRIT_ITER | CV_TERMCRIT_EPS, 20, .3 );
			= cvTermCriteria( CV_TERMCRIT_ITER | CV_TERMCRIT_EPS, 20, .03 );

		cvCalcOpticalFlowPyrLK(frame1_1C, frame2_1C, pyramid1, pyramid2, frame1_features, frame2_features, number_of_features, optical_flow_window, 4, optical_flow_found_feature, optical_flow_feature_error, optical_flow_termination_criteria, 0 );

		for (lstFeatureIt i1=m_lstFeatures.begin();i1!=m_lstFeatures.end();i1++)
		{
			tFeature *pFeature=(*i1);
			vector3f vPos=pFeature->v2DPos;

			// move, bigger radius
			const ftype fRadius=sqr((ftype)(w)/64.0)*2;
			vector3f vRes;
			vRes.Clear();
			int nCount=0;

			for (int i = 0; i < number_of_features; i++)
			{			
				int line_thickness;				line_thickness = 1;			
				CvScalar line_color;			line_color = CV_RGB(255,0,0);

				ftype fDist=sqr(frame1_features[i].x-vPos.x)+sqr(frame1_features[i].y-vPos.y);
				if (fDist>fRadius)
					continue;

				CvPoint p,q;
				p.x = (int) (frame1_features[i].x+0.5);
				p.y = (int) (frame1_features[i].y+0.5);
				cvRectangle(m_pScreen,cvPoint((int)(p.x)-1,(int)(p.y)-1),cvPoint((int)(p.x)+1,(int)(p.y)+1),CV_RGB(0,0,255));
				
				if ( optical_flow_found_feature[i] == 0 )			
					continue;

				vRes.x+=frame2_features[i].x;					
				vRes.y+=frame2_features[i].y;
				nCount++;

				q.x = (int) (frame2_features[i].x+0.5);
				q.y = (int) (frame2_features[i].y+0.5);		

				cvRectangle(m_pScreen,cvPoint((int)(q.x)-1,(int)(q.y)-1),cvPoint((int)(q.x)+1,(int)(q.y)+1),CV_RGB(0,255,0));

				cvDrawLine(m_pScreen,p,q,CV_RGB(255,128,64));
			} //i	

			if (nCount>0)
				pFeature->v2DPos=vRes/(ftype)(nCount);

			CvPoint p;
			p.x = (int) pFeature->v2DPos.x;
			p.y = (int) pFeature->v2DPos.y;
			//cvCircle(m_pScreen,p,(int)(sqrt(fRadius)),CV_RGB(255,0,0),1);
			
			p.x = (int) pFeature->v2DPos.x;
			p.y = (int) pFeature->v2DPos.y;
			cvCircle(m_pScreen,p,3,CV_RGB(255,0,0),-1);
		} //i1

		sprintf(szText,"%d/%d",k,number_of_frames);
		cvPutText(m_pScreen, szText,cvPoint(10,20), &m_font1, cvScalar(255,0,0) );
		if (m_bEditMode)
		{			
			cvPutText( frame1, "EDIT MODE",cvPoint(60,40), &m_font1, cvScalar(255,0,0) );			
		}

		cvShowImage("MoCap",m_pScreen);
		int key_pressed;

		if (m_bEditMode)
			key_pressed =cvWaitKey(0);
		else
			key_pressed =cvWaitKey(1);

		if (key_pressed=='x' || key_pressed=='X')
			break;

		if (key_pressed=='e' || key_pressed=='E')
		{
			// edit mode			
			m_bEditMode=!m_bEditMode;
		}

		if (m_bEditOperation)
		{
			m_bEditOperation=false;
			k--;
			continue;
		}

		if (bExportFrames)
		{		
			char szFilenameTemp[256];
			sprintf(szFilenameTemp,"%sFrame%03d.jpg",GetPath(szFilename),k);			
			cvSaveImage(szFilenameTemp,m_pScreen);
		}

	} //k

	for (lstFeatureIt i=m_lstFeatures.begin();i!=m_lstFeatures.end();i++)
	{
		tFeature *pFeature=(*i);
		delete pFeature;
	} //i

	//////////////////////////////////////////////////////////////////////////
	cvReleaseImage(&frame1_1C);
	cvReleaseImage(&frame2_1C);	
	cvReleaseImage(&eig_image);
	cvReleaseImage(&temp_image);
	cvReleaseImage(&frame1);
	//cvReleaseImage(&firstframe);
	cvReleaseImage(&frame2);
	//cvReleaseImage(&frame22);
	cvReleaseImage(&pyramid1);
	cvReleaseImage(&pyramid2);

	SAFE_DELETE_ARRAY(frame1_features);	
	SAFE_DELETE_ARRAY(frame2_features);
	SAFE_DELETE_ARRAY(optical_flow_found_feature);
	SAFE_DELETE_ARRAY(optical_flow_feature_error);

	cvvDestroyWindow("MoCap");
	cvReleaseCapture(&m_input_video);
	cvReleaseImage(&m_pScreen);m_pScreen=NULL;
	cvReleaseImage(&m_pScreenEdit);m_pScreenEdit=NULL;

	return (false);
}


//////////////////////////////////////////////////////////////////////////
void CMocapDoc::EditMarkers(int x,int y,int event)
{	
	cvConvertImage(m_pScreen, m_pScreenEdit, 0);

	int nBestMarker=m_nMarkerSelected;	

	if (nBestMarker<0)
	{			
		ftype fBestDist=99999;	

		ftype	fX1=x;
		ftype fY1=y;

		int k=0;
		for (lstFeatureIt i=m_lstFeatures.begin();i!=m_lstFeatures.end();i++,k++)
		{
			tFeature *pFeature=(*i);

			ftype fX2=pFeature->v2DPos.x;
			ftype fY2=pFeature->v2DPos.y;	

			ftype fDist=sqr(fX1-fX2)+sqr(fY1-fY2);		

			if (fDist<fBestDist)
			{
				fBestDist=fDist;
				nBestMarker=k;
			}
		} //k

		if (nBestMarker>=0)
		{		
			CvPoint p;
			p.x=(int)(m_lstFeatures[nBestMarker]->v2DPos.x);
			p.y=(int)(m_lstFeatures[nBestMarker]->v2DPos.y);

			cvCircle(m_pScreenEdit,p,7,CV_RGB(0,255,0), 0);
		}
	}
	else
	{
		CvPoint p;
		p.x=(int)(x);
		p.y=(int)(y);

		cvCircle(m_pScreenEdit,p,7,CV_RGB(0,0,0), 0);

	}

	switch( event )
	{
	case CV_EVENT_LBUTTONDOWN:
		{
			if (m_nMarkerSelected<0)
				m_nMarkerSelected=nBestMarker;
			else
			{
				m_lstFeatures[nBestMarker]->v2DPos.x=x;
				m_lstFeatures[nBestMarker]->v2DPos.y=y;
				m_bEditOperation=true;

				m_nMarkerSelected=-1;
			}
		}
		break;

	case CV_EVENT_RBUTTONDOWN:
		{
			// abort
			m_nMarkerSelected=-1;
		}
		break;
	}

	cvShowImage("MoCap", m_pScreenEdit);
	cvWaitKey(1);

}
