using System;

namespace NetworkBandwidthAnalyser
{
	/// <summary>
	/// Summary description for CategorySummation.
	/// </summary>
	public class CategorySummation
	{
		private System.Collections.Hashtable rep;
		public CategorySummation()
		{
			rep = new System.Collections.Hashtable();
		}
		public void Add( String key, double value )
		{
			if (rep.Contains(key))
			{
				System.Collections.ArrayList ary =
					(System.Collections.ArrayList) rep[key];
				ary.Add(value);
			}
			else
			{
				System.Collections.ArrayList ary = new System.Collections.ArrayList();
				ary.Add(value);
				rep.Add( key, ary );
			}
		}
		public System.Collections.Hashtable Totals()
		{
			System.Collections.Hashtable ret = new System.Collections.Hashtable();
			foreach (String key in rep.Keys)
			{
				double sum = 0.0;
				System.Collections.ArrayList ary =
					(System.Collections.ArrayList) rep[key];
				foreach (double x in ary)
					sum += x;
				ret.Add(key,sum);
			}
			return ret;
		}
		public System.Collections.Hashtable Counts()
		{
			System.Collections.Hashtable ret = new System.Collections.Hashtable();
			foreach (String key in rep.Keys)
			{
				System.Collections.ArrayList ary =
					(System.Collections.ArrayList) rep[key];
				ret.Add(key,(double)ary.Count);
			}
			return ret;
		}
		public System.Collections.Hashtable Averages()
		{
			System.Collections.Hashtable ret = new System.Collections.Hashtable();
			foreach (String key in rep.Keys)
			{
				double sum = 0.0;
				System.Collections.ArrayList ary =
					(System.Collections.ArrayList) rep[key];
				foreach (double x in ary)
					sum += x;
				ret.Add(key,sum / ary.Count);
			}
			return ret;
		}
		public System.Collections.Hashtable Maximum()
		{
			System.Collections.Hashtable ret = new System.Collections.Hashtable();
			foreach (String key in rep.Keys)
			{
				double max = 0.0;
				System.Collections.ArrayList ary =
					(System.Collections.ArrayList) rep[key];
				foreach (double x in ary)
					if (x > max)
						max = x;
				ret.Add(key,max);
			}
			return ret;
		}
		public System.Collections.Hashtable Minimum()
		{
			System.Collections.Hashtable ret = new System.Collections.Hashtable();
			foreach (String key in rep.Keys)
			{
				double min = 1e40;
				System.Collections.ArrayList ary =
					(System.Collections.ArrayList) rep[key];
				foreach (double x in ary)
					if (x < min)
						min = x;
				ret.Add(key,min);
			}
			return ret;
		}
	}
}
