using System;

namespace NetworkBandwidthAnalyser
{
	/// <summary>
	/// Summary description for Packet.
	/// </summary>
	public class Packet : IParserSink
	{
		private int totalSize;
		private int time;
		private int id;
		public String ip;
		System.Collections.Hashtable overhead;
		System.Collections.ArrayList messages;

		public Packet( String ip, int time, int id )
		{
			this.ip = ip;
			this.time = time;
			this.id = id;
			overhead = new System.Collections.Hashtable();
			messages = new System.Collections.ArrayList();
		}

		public int MessageCount
		{
			get
			{
				return messages.Count;
			}
		}

		public int TotalSize
		{
			get
			{
				return totalSize;
			}
		}
		public double TotalOverheadSize
		{
			get
			{
				double sum = 0;
				foreach (double x in overhead.Values)
					sum += x;
				return sum;
			}
		}

		public int Time
		{
			get
			{
				return time;
			}
		}

		public int ID
		{
			get
			{
				return id;
			}
		}

		public void AddMessageSizes( System.Collections.ArrayList o, String filterMsg )
		{
			foreach (Message m in messages)
				if (m.name == filterMsg)
					o.Add(m.TotalSize);
		}
		public void AddMessageHeaderSizes( System.Collections.ArrayList o, String filterMsg )
		{
			foreach (Message m in messages)
				if (m.name == filterMsg)
					o.Add(m.HeaderSize);
		}
		public void AddMessageSizes( CategorySummation sum )
		{
			foreach (Message m in messages)
				sum.Add( m.name, m.TotalSize );
		}
		public double OverheadSize( String filter )
		{
			if (overhead.Contains(filter))
				return (double)overhead[filter];
			else
				return 0;
		}
		public void AddMessageTimes( System.Collections.ArrayList o, String filterMsg )
		{
			foreach (Message m in messages)
				if (m.name == filterMsg)
					o.Add((double)time);
		}
		public void AddDataSizes( System.Collections.ArrayList o, String filterData )
		{
			foreach (Message m in messages)
				m.AddDataSizes( o, filterData );
		}
		public void AddDataTimes( System.Collections.ArrayList o, String filterData )
		{
			foreach (Message m in messages)
				m.AddDataTimes( o, filterData, (double)time );
		}
		public void AddMessageNames( System.Collections.Specialized.StringCollection sc )
		{
			foreach (Message m in messages)
				if (!sc.Contains(m.name))
					sc.Add(m.name);
		}
		public void AddOverheadNames( System.Collections.Specialized.StringCollection sc )
		{
			foreach (String k in overhead.Keys)
				if (!sc.Contains(k))
					sc.Add(k);
		}
		public void AddDataNames( System.Collections.Specialized.StringCollection sc )
		{
			foreach (Message m in messages)
				m.AddDataNames( sc );
		}

		#region IParserSink Members

        public double ConvertToDouble(String s)
        {
            System.Globalization.NumberFormatInfo provider = new System.Globalization.NumberFormatInfo();
            provider.NumberDecimalSeparator = ".";
            provider.NumberGroupSeparator = ",";
            return System.Convert.ToDouble(s, provider);
        }

        public void AddLine(Parser parser, String[] tokens)
		{
			if (tokens[0] == "Overhead" || tokens[0] == "Data")
			{
				if (overhead.Contains(tokens[1]))
				{
					double x = (double)overhead[tokens[1]];
					x += ConvertToDouble(tokens[2]);
					overhead[tokens[1]] = x;
				}
				else
				{
					overhead.Add( tokens[1], ConvertToDouble(tokens[2]) );
				}
				return;
			}
			if (tokens[0] == "Message")
			{
				Message msg = new Message(tokens[1], ConvertToDouble(tokens[2]));
				parser.BeginSink(msg);
				messages.Add(msg);
				return;
			}
			if (tokens[0] == "EndPacket")
			{
				totalSize = System.Convert.ToInt32( tokens[1] );
				parser.EndSink();
				return;
			}
			parser.Fail( tokens[0] );
		}

		#endregion
	}
}
