using System;

namespace NetworkBandwidthAnalyser
{
	public class FailedParse : System.Exception
	{
	};

	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	public class Parser
	{
		System.Collections.Stack stack;

		public Parser( IParserSink initialSink )
		{
			stack = new System.Collections.Stack();
			BeginSink(initialSink);
		}

		public void AddLine( String[] tokens )
		{
			((IParserSink)stack.Peek()).AddLine( this, tokens );
		}
		public void BeginSink( IParserSink sink )
		{
			stack.Push(sink);
		}
		public void EndSink()
		{
			stack.Pop();
		}
		public void PassUpLine( String[] tokens )
		{
			EndSink();
			AddLine(tokens);
		}
		public void Fail( String token )
		{
			throw new FailedParse();
		}
	}
}
