/*
ScPl - A plotting library for .NET

IPlotSurface2D.cs
Copyright (C) 2003
Paolo Pierini, Matt Howlett

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
   
2. Redistributions in binary form must reproduce the following text in 
   the documentation and / or other materials provided with the 
   distribution: 
   
   "This product includes software developed as part of 
   the ScPl plotting library project available from: 
   http://www.netcontrols.org/scpl/" 

------------------------------------------------------------------------

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/
using System;

namespace scpl
{
	/// <summary>
	/// The common Interface for all *.PlotSurface2D classes.
	/// </summary>
	public interface IPlotSurface2D
	{
		/// <summary>
		/// Adds an IPlot object to the PlotSurface2D inner collection.
		/// </summary>
		/// <param name="p">An object implementing the IPlot interface.</param>
		void Add(IDrawable p);
		/// <summary>
		/// Adds an IPlot object to the PlotSurface2D inner collection.
		/// </summary>
		/// <param name="p">An object implementing the IPlot interface.</param>
		/// <param name="xax">The position of the abscissa axis.</param>
		/// <param name="yax">The position of the ordinate axis.</param>
		void Add(IDrawable p, scpl.PlotSurface2D.XAxisPosition xax, scpl.PlotSurface2D.YAxisPosition yax);
		/// <summary>
		/// Clears the PlotSurface2D.
		/// </summary>
		void Clear();

		scpl.Legend Legend { get; set; }

		/*
		object DataSource { get; set; }
		object ValueData { get; set; }
		object AbscissaData { get; set; }
		*/

		#region Behavior
		
		/// <summary>
		/// The padding space (in graphics units) for the plot.
		/// </summary>
		int Padding { get; set; }
		
		/// <summary>
		/// The plot background color.
		/// </summary>
		System.Drawing.Color PlotBackColor { get; set; }
		
		/// <summary>
		/// The plot title.
		/// </summary>
		string Title { get; set; }
		
		/// <summary>
		/// The plot title font.
		/// </summary>
		System.Drawing.Font TitleFont { get; set; }
				
		/// <summary>
		/// Smoothing mode to use when drawing plots.
		/// </summary>
		System.Drawing.Drawing2D.SmoothingMode SmoothingMode { get; set; }

		#endregion

		#region AddAxesConstraint
		void AddAxesConstraint( AxesConstraint c );
		#endregion

		#region Axes
		/// <summary>
		/// The bottom abscissa axis.
		/// </summary>
		Axis XAxis1 { get; set; }
		/// <summary>
		/// The top abscissa axis.
		/// </summary>
		Axis XAxis2 { get; set; }
		/// <summary>
		/// The left ordinate axis.
		/// </summary>
		Axis YAxis1 { get; set; }
		/// <summary>
		/// The right ordinate axis.
		/// </summary>
		Axis YAxis2 { get; set; }
		#endregion
	}
}
