/*
ScPl - A plotting library for .NET

PointText.cs
Copyright (C) 2003
Matt Howlett, Paolo Pierini

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
   
2. Redistributions in binary form must reproduce the following text in 
   the documentation and / or other materials provided with the 
   distribution: 
   
   "This product includes software developed as part of 
   the ScPl plotting library project available from: 
   http://www.netcontrols.org/scpl/" 

------------------------------------------------------------------------

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/
using System;

namespace scpl
{
	/// <summary>
	/// PointText class, to store data (X,Y,text string)
	/// </summary>
	public class PointText : PointD
	{
		private string text_;

		/// <summary>
		/// Hide the parameterless constructor.
		/// </summary>
		protected PointText()
		{
		}
		/// <summary>
		/// PointText constructor.
		/// </summary>
		/// <param name="x">The X value</param>
		/// <param name="y">The Y value</param>
		public PointText( double x, double y) : base(x,y)
		{
			text_ = "";
		}

		/// <summary>
		/// PointText constructor.
		/// </summary>
		/// <param name="x">The X value</param>
		/// <param name="y">The Y value</param>
		/// <param name="text">The text string</param>
		public PointText( double x, double y, string text) : base(x,y)
		{
			text_ = text;
		}

		/// <summary>
		/// The text label to display.
		/// </summary>
		public string Text
		{
			get
			{
				return text_;
			}
			set
			{
				text_ = value;
			}
		}
	}
}
