using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PS3BuildHelper
{
	public partial class MainDialog : Form
	{
		public MainDialog(Connect con)
		{
			connect = con;
			InitializeComponent();
		}

		private void PostInitializeComponent()
		{
			if(GetConfigValue("STAGES").Contains("scan") || GetConfigValueInt("OPTION_DEVIRTUALIZE") == 1)
			{
				this.DevirtualizeCheckbox.Checked = true;
				devirtualize = true;
			}
			else
				this.DevirtualizeCheckbox.Checked = false;

			if (GetConfigValueInt("MKOPTION_STRIP_DEAD_CODE") == 1)
			{
				this.DeadCodeCheckBox.Checked = true;
				deadCodeStrip = true;
			}
			else
				this.DeadCodeCheckBox.Checked = false;

			if (GetConfigValueInt("MKOPTION_DISTCC") == 1)
			{
				this.DistCCDistRadio.Checked = true;
				distcc = true;
			}
			else
				this.DistCCDistRadio.Checked = false;

            if (GetConfigValueInt("MKOPTION_CRYCG_CM") == 1)
            {
                this.CMBox.Checked = true;
                cm = true;
            }
            else
                this.CMBox.Checked = false;
            if (GetConfigValueInt("MKOPTION_INCREDIBUILD") == 1)
			{
				this.IncrediBuildDistRadio.Checked = true;
				incredi = true;
			}
			else
			{
				this.IncrediBuildDistRadio.Checked = false;
				this.IBCheckBox.Enabled = false;
			}
			if(!incredi && !distcc)
				this.LocalDistRadio.Checked = true;
			else
				this.LocalDistRadio.Checked = false;

			if (GetConfigValueInt("MKOPTION_OPTIMIZE_SHELL") == 1)
			{
				this.ShellOptCheckbox.Checked = true;
				shell = true;
			}
			else
				this.ShellOptCheckbox.Checked = false;

			if (GetConfigValueInt("MKOPTION_CRYCGPROFILE") == 1)
			{
				this.CryCGProfileCheckbox.Checked = true;
				crycgProfile = true;
			}
			else
				this.CryCGProfileCheckbox.Checked = false;

			if (GetConfigValueInt("OPTION_PS3_MTRACE") == 1)
			{
				this.MTraceCheckBox.Checked = true;
				mtrac = true;
			}
			else
				this.MTraceCheckBox.Checked = false;

			if (GetConfigValueInt("OPTION_LD_MAPFILE") == 1)
			{
				this.MapCheckBox.Checked = true;
				mapFile = true;
			}
			else
				this.MapCheckBox.Checked = false;

			if (GetConfigValueInt("OPTION_WARN_LHS_MICRO") == 1)
			{
				this.LHSCheckBox.Checked = true;
				lhsmicro = true;
			}
			else
				this.LHSCheckBox.Checked = false;

			if (GetConfigValueInt("MKOPTION_TIME_COMMANDS") == 1)
			{
				this.TimeMakeCheckBox.Checked = true;
				timeMakeCommands = true;
			}
			else
				this.TimeMakeCheckBox.Checked = false;

			if (GetConfigValueInt("MKOPTION_COMPACT") == 1)
			{
				this.CompactCheckBox.Checked = true;
				compact = true;
			}
			else
				this.CompactCheckBox.Checked = false;

			if (GetConfigValueInt("OPTION_PS3_DEBUG_FILEHANDLER") == 1)
			{
				this.FileHandleTraceCheckBox.Checked = true;
				fileHandleTrace = true;
			}
			else
				this.FileHandleTraceCheckBox.Checked = false;

			if (GetConfigValueInt("OPTION_PS3_SPU_MEM_CHECK") == 1)
			{
				this.SPUMemCheckBox.Checked = true;
				spuMemCheck = true;
			}
			else
				this.SPUMemCheckBox.Checked = false;

			if (GetConfigValueInt("OPTION_PS3_SPUCACHE_HAZARD_CHECK") == 1)
			{
				this.SPUCacheHazardCheckBox.Checked = true;
				spuHazard = true;
			}
			else
				this.SPUCacheHazardCheckBox.Checked = false;

			if (GetConfigValueInt("OPTION_PS3_USE_STLPORT") == 1)
			{
				this.STLPortCheckBox.Checked = true;
				stl = true;
			}
			else
				this.STLPortCheckBox.Checked = false;

            if (GetConfigValueInt("OPTION_ASSERT") == 1)
			{
				this.AssertCheckBox.Checked = true;
				assert = true;
			}
			else
				this.AssertCheckBox.Checked = false;

			this.OutputDirEdit.Text = GetConfigValue("OPTION_PS3_OUTPUT_DIR");
			outputDir = this.OutputDirEdit.Text;

			if (GetConfigValue("STAGES").Contains("scan") || connect.disableScanStage)
			{
				this.SPUCheckBox.Checked = true;
				spuCode = true;
			}
			else
				this.SPUCheckBox.Checked = false;

			this.ExecNameTextBox.Text = connect.AdaptExecName(GetConfigValue(connect.curSlnName + "_OPTION_PS3_EXEC_NAME"));
			execName = this.ExecNameTextBox.Text;

			if(!this.SPUCheckBox.Checked)
			{
				this.StatsRadioButton.Enabled = false;
				this.ReleaseRadioButton.Enabled = false;
				this.AssertRadioButton.Enabled = false;
                this.CMBox.Enabled = false;
			}
			if (GetConfigValueInt("MKOPTION_VERBOSE") == 1)
			{
				this.VerboseCheckBox.Checked = true;
				verbose = true;
			}
			else
				this.VerboseCheckBox.Checked = false;
			if (DoBuildCommandOutput())
			{
				this.SilentBox.Checked = true;
			}
			else
				this.SilentBox.Checked = false;
			if (GetConfigValueInt("MKOPTION_FASTCLEAN") == 1)
			{
				this.FastCleanCheckBox.Checked = true;
				fastClean = true;
			}
			else
				this.FastCleanCheckBox.Checked = false;
			if (GetConfigValueInt("OPTION_PS3_OPTIMIZED_CODE") == 1)
			{
				this.OptimizedCodeCheckBox.Checked = true;
				optimizedCode = true;
			}
			else
				this.OptimizedCodeCheckBox.Checked = false;
			if (GetConfigValueInt("MKOPTION_NOILINE") == 1)
				this.NoIlineCheckBox.Checked = false;
			else
			{
				this.NoIlineCheckBox.Checked = true;
				iline = true;
			}
            if (GetConfigValueInt("MKOPTION_RELEASE") == 1)
            {
                this.ReleaseCheckbox.Checked = true;
                release = true;
            }
            else
                this.ReleaseCheckbox.Checked = false;
			if (GetConfigValueInt("MKOPTION_INCREDIBUILD_SHOWCONSOLE") == 1)
			{
				this.IBCheckBox.Checked = true;
				ibShowConsole = true;
			}
			else
			{
				this.IBCheckBox.Checked = false;
			}
			if (GetConfigValueInt("MKOPTION_UNITYBUILD") == 1)
			{
				this.UnityBuildCheckBox.Checked = true;
				unityBuild = true;
			}
			else
				this.UnityBuildCheckBox.Checked = false;
			if (GetConfigValueInt("OPTION_NODEBUGSYM") == 1)
				this.NoDebugSymCheckBox.Checked = false;
			else
			{
				this.NoDebugSymCheckBox.Checked = true;
				debugSyms = true;
			}
			if (GetConfigValueInt("OPTION_SUPP_FP_EXCEPTION") == 1)
			{
				this.SupportFPExcCheckBox.Checked = true;
				fpExc = true;
			}
			else
				this.SupportFPExcCheckBox.Checked = false;

			if (connect.SupportF5())
			{
				this.F5CheckBox.Checked = true;
			}
			else
				this.F5CheckBox.Checked = false;
			
			if (GetConfigValueInt("OPTION_PS3_SPU_PROFILE") == 1)
			{
				this.StatsRadioButton.Checked = true;
				spuCodeVer = 1;
			}
			else
			if (GetConfigValueInt("OPTION_PS3_SPU_ASSERT") == 1)
			{
				this.AssertRadioButton.Checked = true;
				spuCodeVer = 2;
			}
			else
				this.ReleaseRadioButton.Checked = true;

			repSize = GetConfigValueInt("OPTION_SPU_REP_SIZE_KB");
			this.SPURepSizeNumeric.Value = repSize;

			mainThreadSize = GetConfigValueInt("OPTION_MAIN_THREAD_STACK_SIZE_KB");
			this.MainThreadSizeNumeric.Value = mainThreadSize;

			mainStackSize = GetConfigValueInt("OPTION_MAIN_STACK_SIZE_KB");
			this.MainStackSizeNumeric.Value = mainStackSize;

			if (false == this.SPUCheckBox.Checked)
			{
				this.DisableScanStageButton.Enabled = false;
				this.SPUMemCheckBox.Enabled = false;
				this.SPUCacheHazardCheckBox.Enabled = false;
				this.ProjectsParallelScanNumeric.Enabled = false;
				this.FilesParallelScanNumeric.Enabled = false;
				this.StatsRadioButton.Enabled = false;
				this.ReleaseRadioButton.Enabled = false;
				this.AssertRadioButton.Enabled = false;
                this.CMBox.Enabled = false;
				this.SPURepSizeNumeric.Enabled = false;
				this.SPUJobEdit.Enabled = false;
				this.ClearSPUJobButton.Enabled = false;
				this.SPUGroupBoxAdvanced.Enabled = false;
			}
			if(connect.disableScanStage)
				this.DisableScanStageButton.Checked = true;
			if(!distcc)
				this.ParallelBuildBox.Enabled = false;
			EnableParallelControls(distcc && connect.ExistsParallelValue(Connect.compileKey) && connect.ExistsParallelValue(Connect.linkKey));

			Connect.ParallelVal scan = connect.GetParallelValue(Connect.scanKey);
			Connect.ParallelVal compile = connect.GetParallelValue(Connect.compileKey);
			Connect.ParallelVal link = connect.GetParallelValue(Connect.linkKey);
			this.ProjectsParallelCompileNumeric.Value = Convert.ToDecimal(compile.procNum);
			this.ProjectsParallelLinkNumeric.Value = Convert.ToDecimal(link.procNum);
			this.ProjectsParallelScanNumeric.Value = Convert.ToDecimal(scan.procNum);
			this.FilesParallelCompileNumeric.Value = Convert.ToDecimal(compile.fileNum);
			this.FilesParallelLinkNumeric.Value = Convert.ToDecimal(link.fileNum);
			this.FilesParallelScanNumeric.Value = Convert.ToDecimal(scan.fileNum);
		}

		private Connect connect;

		private void ApplyButton_Click(object sender, EventArgs e)
		{
			connect.WriteConfigFile(this);
			Close();
		}

		private void CancelButton_Click(object sender, EventArgs e)
		{
			Close();
		}

		private void SPUCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			if (this.SPUCheckBox.Checked)
			{
				this.DevirtualizeCheckbox.Checked = true;
				this.DevirtualizeCheckbox.Enabled = false;
				this.StatsRadioButton.Enabled = true;
				this.ReleaseRadioButton.Enabled = true;
				this.AssertRadioButton.Enabled = true;
                this.CMBox.Enabled = true;
				this.DisableScanStageButton.Enabled = true;
				this.DisableScanStageButton.Checked = false;
				this.SPURepSizeNumeric.Enabled = true;
				this.ProjectsParallelScanNumeric.Enabled = true;
				this.FilesParallelScanNumeric.Enabled = true;
				this.SPUMemCheckBox.Enabled = true;
				this.SPUCacheHazardCheckBox.Enabled = true;
				this.SPURepSizeNumeric.Enabled = true;
				this.SPUJobEdit.Enabled = true;
				this.ClearSPUJobButton.Enabled = true;
				this.SPUGroupBoxAdvanced.Enabled = true;
			}
			else
			{
				this.DevirtualizeCheckbox.Enabled = true;
				this.StatsRadioButton.Enabled = false;
				this.ReleaseRadioButton.Enabled = false;
				this.AssertRadioButton.Enabled = false;
                this.CMBox.Enabled = false;
				this.DisableScanStageButton.Enabled = false;
				this.ProjectsParallelScanNumeric.Enabled = false;
				this.FilesParallelScanNumeric.Enabled = false;
				this.SPUMemCheckBox.Enabled = false;
				this.SPUCacheHazardCheckBox.Enabled = false;
				this.SPURepSizeNumeric.Enabled = false;
				this.SPUJobEdit.Enabled = false;
				this.ClearSPUJobButton.Enabled = false;
				this.SPUGroupBoxAdvanced.Enabled = false;
			}
		}

		private string GetConfigValue(string key)
		{
			return connect.GetConfigValue(key);
		}

		public int GetConfigValueInt(string key)
		{
			return connect.GetConfigValueInt(key);
		}

		public bool DoBuildCommandOutput()
		{
			return connect.DoBuildCommandOutput();
		}

		private void SetConfigValue(string key, string val)
		{
			connect.SetConfigValue(key, val);
		}

		private void FileBrowsClick(object sender, MouseEventArgs e)
		{
			OutputDirDialog = new FolderBrowserDialog();
			string folder = GetConfigValue("OPTION_PS3_OUTPUT_DIR");
			OutputDirDialog.SelectedPath = folder;
			if (OutputDirDialog.ShowDialog() == DialogResult.OK)
			{
				folder = OutputDirDialog.SelectedPath;
				if (folder.Contains(" "))
					MessageBox.Show("Output directory must not contain spaces!");
				else
				{
					folder = connect.ReplaceBackSlashes(folder);
					folder = folder.Substring(0, 1).ToLower() + folder.Substring(1);
					SetConfigValue("OPTION_PS3_OUTPUT_DIR", folder);
					this.OutputDirEdit.Text = folder;
				}
			}
		}

		public bool devirtualize = false;
		public bool deadCodeStrip = false;
		public bool distcc = false;
        public bool cm = false;
		public bool incredi = false;
		public bool mtrac = false;
		public bool shell = false;
		public bool crycgProfile = false;
		public bool mapFile = false;
		public bool spuMemCheck = false;
		public bool timeMakeCommands = false;
		public bool compact = false;
		public bool fileHandleTrace = false;
		public bool spuHazard = false;
		public bool lhsmicro = false;
		public bool stl = false;
		public bool assert = false;
		public string outputDir = "";
		public bool spuCode = false;
		public string execName = "";
		public int spuCodeVer = 0;
		public bool verbose = false;
		public bool fastClean = false;
		public bool optimizedCode = false;
		public bool iline = false;
        public bool release = false;
		public bool ibShowConsole = false;
		public bool unityBuild = false;
		public bool debugSyms = false;
		public bool fpExc = false;
		public int repSize = 0;
		public int mainStackSize = 0;
		public int mainThreadSize = 0;

		private void button1_Click(object sender, EventArgs e)
		{
			//clean compiled ppu code
			connect.DeleteAllObjectFiles(".o");
		}

		private void button2_Click(object sender, EventArgs e)
		{
			//clean compiled spu code
			connect.CleanSPUCode();
		}

		private void CleanDevirtCacheButton_Click(object sender, EventArgs e)
		{
			connect.CleanDevirtCache();
		}

		private void ClearSPUJobButton_Click(object sender, EventArgs e)
		{
			string mask = this.SPUJobEdit.Text;
			if(mask.Length > 0)
				connect.CleanSelSPUJobs(mask);
		}

		private void EnableParallelControls(bool enable)
		{
			if (enable)
			{
				this.ProjectsParallelCompileNumeric.Enabled = true;
				this.ProjectsParallelLinkNumeric.Enabled = true;
				this.FilesParallelCompileNumeric.Enabled = true;
				this.FilesParallelLinkNumeric.Enabled = true;
				this.ParallelUseDefaultCheckbox.Checked = false;
			}
			else
			{
				this.ProjectsParallelCompileNumeric.Enabled = false;
				this.ProjectsParallelLinkNumeric.Enabled = false;
				this.FilesParallelCompileNumeric.Enabled = false;
				this.FilesParallelLinkNumeric.Enabled = false;
				this.ParallelUseDefaultCheckbox.Checked = true;
			}
		}

		private void ParallelUseDefaultButton_CheckedChanged(object sender, EventArgs e)
		{
			EnableParallelControls(false == this.ParallelUseDefaultCheckbox.Checked);
		}

		private void LocalDistRadio_CheckedChanged(object sender, EventArgs e)
		{

		}

		private void DistCCDistRadio_CheckedChanged(object sender, EventArgs e)
		{
			if (this.DistCCDistRadio.Checked)
 				this.ParallelBuildBox.Enabled = true;
 			else
 				this.ParallelBuildBox.Enabled = false;
		}

		private void IncrediBuildDistRadio_CheckedChanged(object sender, EventArgs e)
		{
			if(this.IncrediBuildDistRadio.Checked)
				this.IBCheckBox.Enabled = true;
			else
				this.IBCheckBox.Enabled = false;
		}
	}
}