#special makefile for *_spu.cpp and SPUDriver_spu.cpp in particular

INCLUDE_DIR_SPU		= $(PROJECT_HOME)/Code/Tools/PS3JobManager
JOBMAN_PATH_INC		= -I$(INCLUDE_DIR_SPU)
CRY_COMMON_PATH		= $(PROJECT_HOME)/Code/CryEngine/CryCommon
OBJECT_DIR_SPU		= $(PROJECT_HOME)/../WorkInProgress/michaelg/PS3JobManager/PS3JobManager
JOBPARSER					= $(OUTPUT_DIR)JobParser.exe
BUBBLEGEN					= $(PROJECT_HOME)/Code/Tools/Make/Tools/host-win32/PageGen.exe
SPU_DRIVER_PARSER	= $(OUTPUT_DIR)SPUDriverMemManagerParser
CELL_SDK_VERSION	?= cell
CELL_SDK		?= $(PROJECT_HOME)/Code/SDKs/PS3/$(CELL_SDK_VERSION)
HOST_SYSTEM ?= win32
REPLACE_HBR = perl $(CELL_SDK)/host-$(HOST_SYSTEM)/bin/replace_hbr.pl
PATCH_ALIGNMENT = perl $(OUTPUT_DIR)SPUAsmPatcher.pl 
SPUMODGEN_EX    = perl $(OUTPUT_DIR)spumodgen_ex.pl

SPU_EXT_OPTS = -ffast-math -floop-optimize2 -fgcse-after-reload -fgcse-las -fgcse-sm -fgcse-lm -fsched2-use-superblocks
#SPU_EXT_OPTS =

export OUTPUT_DIR

EXECUTE_SYMBOL	= _Z7ExecutePv
export EXECUTE_SYMBOL

#support sn systems debugging on/off
SN_BUILD_MODE=ON
export SN_BUILD_MODE
SN_MODE=-DSUPP_SN
#SN_MODE=
export SN_MODE

#switch profiling on/off
SPU_PROF = -DDO_SPU_PROFILING
SPU_PROF = 

#enable explicite and all other branch hints on/off
SUPP_BRANCH_HINTS = -DSUPP_BRANCH_HINTS
#SUPP_BRANCH_HINTS = -msafe-hints

#switch asm cache miss handler on/off
SPU_CACHE_MISS_USE_ASM = -DSPU_CACHE_MISS_USE_ASM
#SPU_CACHE_MISS_USE_ASM = 

LIB_FILE_EXT = 
DRIVER_REL_EXT=
#reset asm impl. of cache miss handler for profiling, not implemented there
ifeq "$(SPU_PROF)" "-DDO_SPU_PROFILING"
	SPU_CACHE_MISS_USE_ASM = 
	LIB_FILE_EXT=_profile
	DRIVER_REL_EXT=_profile
endif
export LIB_FILE_EXT

FFIXED_REG= -ffixed-70 -ffixed-71 -ffixed-72 -ffixed-73 -ffixed-74 -ffixed-75 -ffixed-76 -ffixed-77 -ffixed-78

VEC_FLAGS = -DNO_VECIDX

DABR_FLAGS = -DSUPP_DABR
DABR_FLAGS = 

PPU_SPU_COM_FLAGS = $(SN_MODE) $(VEC_FLAGS) $(SPU_PROF) $(DABR_FLAGS) -DDO_SPU_FUNCPROFILING
export PPU_SPU_COM_FLAGS
export SPU_PROF

COMPLETE_BUILD_DEF = -DTEMP_BUBBLE
  
export COMPLETE_BUILD_DEF

DR_I_F = -include $(INCLUDE_DIR_SPU)/SPU/SPUJob.h

#entry points are not required, set 0 instead to avoid a warning

ifeq "$(SN_BUILD_MODE)" "ON"
BUILD_SPU_DEBUG	= COMMAND_LINE='$(CXX_SPU) -g $(CXXFLAGS_DEBUG_SPU_JOBS) -D_SPU_JOB -c $(INCLUDE_FLAGS_COMMON_SPU) $(DR_I_F)'\
						BUBBLE_GEN=$(BUBBLEGEN)\
						BUBBLE_PREPARE=$(OUTPUT_DIR)bubble_prepare_spu\
						BUBBLE_LINK='$(CXX_SPU) $(CXXFLAGS_COMMON_SPU) -g -O0 -T $(INCLUDE_DIR_SPU)/lib/spu_module.ld -Wl,-q $(SPU_JOB_LIBS) -nostartfiles'\
						DRIVER_LIB='-L$(INCLUDE_DIR_SPU)/lib/ -lDriverSPU_debug'\
						PROJECT_OUTPUT_PATH=$(PROJECT_OUTPUT_PATH)\
					  NM='$(NM)'\
					  $(SHELL) $(OUTPUT_DIR)build_spu '$(OUTPUT_DIR)'
BUILD_SPU_RELEASE	= COMMAND_LINE='$(CXX_SPU) -g $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_JOBS) -D_SPU_JOB -c $(INCLUDE_FLAGS_COMMON_SPU) $(DR_I_F)'\
						BUBBLE_GEN=$(BUBBLEGEN)\
						BUBBLE_PREPARE=$(OUTPUT_DIR)bubble_prepare_spu\
						BUBBLE_LINK='$(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_COMMON_SPU) -g -O3 -T $(INCLUDE_DIR_SPU)/lib/spu_module.ld -Wl,-q $(SPU_JOB_LIBS) -nostartfiles'\
						DRIVER_LIB='-L$(INCLUDE_DIR_SPU)/lib/ -lDriverSPU$(LIB_FILE_EXT)'\
						PROJECT_OUTPUT_PATH=$(PROJECT_OUTPUT_PATH)\
					  NM='$(NM)'\
					  $(SHELL) $(OUTPUT_DIR)build_spu '$(OUTPUT_DIR)'
else					  
BUILD_SPU_DEBUG	= COMMAND_LINE='$(CXX_SPU) -g $(CXXFLAGS_DEBUG_SPU_JOBS) -D_SPU_JOB -I$(INCLUDE_DIR_SPU)/SPU $(DR_I_F)'\
						BUBBLE_GEN=$(BUBBLEGEN)\
						BUBBLE_PREPARE=$(OUTPUT_DIR)bubble_prepare_spu\
						BUBBLE_LINK='$(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_JOBS) -nostartfiles'\
						DRIVER_LIB='-L$(INCLUDE_DIR_SPU)/lib/ -lDriverSPU_debug'\
						PROJECT_OUTPUT_PATH=$(PROJECT_OUTPUT_PATH)\
					  NM='$(NM)'\
					  $(SHELL) $(OUTPUT_DIR)build_spu '$(OUTPUT_DIR)'
BUILD_SPU_RELEASE	= COMMAND_LINE='$(CXX_SPU) $(SPU_DEBUG_OPT) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_JOBS) -D_SPU_JOB -I$(INCLUDE_DIR_SPU)/SPU $(DR_I_F)'\
						BUBBLE_GEN=$(BUBBLEGEN)\
						BUBBLE_PREPARE=$(OUTPUT_DIR)bubble_prepare_spu\
						BUBBLE_LINK='$(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_JOBS) -nostartfiles'\
						DRIVER_LIB='-L$(INCLUDE_DIR_SPU)/lib/ -lDriverSPU$(LIB_FILE_EXT)'\
						PROJECT_OUTPUT_PATH=$(PROJECT_OUTPUT_PATH)\
					  NM='$(NM)'\
					  $(SHELL) $(OUTPUT_DIR)build_spu '$(OUTPUT_DIR)'
endif					  

SPU_BIN_DIR				= $(CELL_SDK)/host-$(HOST_SYSTEM)/spu/bin
CXX_SPU_NO_FPIC		= $(SPU_BIN_DIR)/spu-lv2-g++ -mraw $(PPU_SPU_COM_FLAGS) $(FFIXED_REG)
CXX_SPU						= $(CXX_SPU_NO_FPIC) -fPIC -D__LV2_KERNEL__ -fms-extensions -mdouble=fast -fno-function-sections
CCC_SPU						= $(SPU_BIN_DIR)/spu-lv2-gcc -mraw $(FFIXED_REG) -fPIC -D__LV2_KERNEL__ $(PPU_SPU_COM_FLAGS)
CXX_SPU_FILT			= $(SPU_BIN_DIR)/spu-lv2-c++filt
OBJCOPY						= $(CELL_SDK)/host-$(HOST_SYSTEM)/ppu/bin/ppu-lv2-objcopy
NM								= $(SPU_BIN_DIR)/spu-lv2-nm
AR_SPU						= $(SPU_BIN_DIR)/spu-lv2-ar rcs
EMBEDSPU					= $(OBJCOPY) -B powerpc -I binary -O elf64-powerpc-celloslv2 --set-section-align .data=7 --set-section-pad .data=16
WORK_DIR					= e:/Work

SILENT_TAG=@

EXCLUDE_DIR_COMMON	= 

INCLUDE_FLAGS_COMMON_SPU = -I. -I../ -I../../ -I$(CELL_SDK)/target/spu/include \
	  -I$(CELL_SDK)/target/spu/include/vectormath/cpp -I$(CELL_SDK)/target/spu/include/sys
INCLUDE_FLAGS_COMMON_SPU += $(JOBMAN_PATH_INC) -I$(CRY_COMMON_PATH)
													 
CXX_WARNING_FLAGS_SPU = -Wno-invalid-offsetof -Wno-format
													 
CXXFLAGS_COMMON_SPU		= -fno-rtti -fno-exceptions -D_LIB $(INCLUDE_FLAGS_COMMON_SPU) -fpermissive \
	$(INCLUDE_FLAGS) $(CXX_WARNING_FLAGS_SPU) --param max-inline-insns-single=2000

COMMON_LIBS_SPU				= -lm
#-lstdc++

COMMON_DEFINES_SPU		= -D__SPU__ -DPS3
DEBUG_DEFINES_SPU			= $(COMMON_DEFINES_SPU) -D_DEBUG
#-D_DRIVER_DEBUG
RELEASE_DEFINES_SPU		= $(COMMON_DEFINES_SPU) -DNDEBUG

#change only in sync with PS3JobManager lib
SPU_ASSERT_OPTS_RELEASE		= -D_NO_SPU_CACHE_ASSERT -D_NO_SPU_CACHE_HAZ_CHECK -D_NO_SPU_ASSERT
#SPU_ASSERT_OPTS_RELEASE	= -D_NO_SPU_CACHE_ASSERT -D_NO_SPU_CACHE_HAZ_CHECK
#SPU_ASSERT_OPTS_RELEASE	= -D_NO_SPU_CACHE_HAZ_CHECK

SPU_ASSERT_OPTS_DEBUG				= -D_NO_SPU_CACHE_HAZ_CHECK -DCHECK_PAGE_HAZARD


SPU_DEBUG_OPT = -g $(SN_MODE)
#SPU_DEBUG_OPT = $(SN_MODE)
SPU_OPTIMZE_OPTS = -O3 -ffast-math -finline-functions-called-once -fgcse-after-reload -fstrict-aliasing $(SUPP_BRANCH_HINTS)
ifeq "$(SPU_PROF)" "-DDO_SPU_PROFILING"
  SPU_OPTIMZE_OPTS += -Os
endif
SPU_OPTIMZE_OPTS_DEBUG = -Os
#SPU_OPTIMZE_OPTS_DEBUG = -O0 -g -D_DRIVER_DEBUG

ASM_OPT					  = 
ifeq "$(SN_MODE)" "-DSUPP_SN"
	ASM_OPT					= $(SPU_DEBUG_OPT) -O3
endif

CXXFLAGS_RELEASE_SPU_DRIVER = $(CXXFLAGS_COMMON_SPU) $(SPU_OPTIMZE_OPTS)\
	$(RELEASE_DEFINES_SPU) $(SPU_ASSERT_OPTS_RELEASE) -L$(CELL_SDK)/target/spu/lib
CXXFLAGS_DEBUG_SPU_DRIVER		= $(CXXFLAGS_COMMON_SPU) $(DEBUG_DEFINES_SPU) $(SPU_ASSERT_OPTS_DEBUG) -L$(CELL_SDK)/target/spu/lib $(SPU_OPTIMZE_OPTS_DEBUG)

#CXXFLAGS_OPT_FLAGS_DEBUG_SPU_DRIVER = -O0 -finline-functions -fdefault-inline -fif-conversion -fif-conversion2 -funit-at-a-time -fmerge-constants
CXXFLAGS_OPT_FLAGS_DEBUG_SPU_DRIVER = $(SPU_OPTIMZE_OPTS_DEBUG)

#CXXFLAGS_OPT_FLAGS_RELEASE_SPU_JOBS = -O0
CXXFLAGS_OPT_FLAGS_RELEASE_SPU_JOBS = $(SPU_OPTIMZE_OPTS)

ifeq "$(SN_BUILD_MODE)" "ON"
  CXXFLAGS_DEBUG_SPU_DRIVER		+= $(SPU_DEBUG_OPT) $(CXXFLAGS_OPT_FLAGS_DEBUG_SPU_DRIVER)
  CXXFLAGS_RELEASE_SPU_DRIVER	+= $(SPU_DEBUG_OPT)
  
  CXXFLAGS_SPU_JOBS_COMMON		= $(CXXFLAGS_COMMON_SPU) $(SPU_DEBUG_OPT) -c -I$(INCLUDE_DIR_SPU)/SPU -L$(CELL_SDK)/target/spu/lib/pic
  CXXFLAGS_DEBUG_SPU_JOBS		  = $(CXXFLAGS_SPU_JOBS_COMMON) $(SPU_ASSERT_OPTS_DEBUG) $(DEBUG_DEFINES_SPU) -O0
  CXXFLAGS_RELEASE_SPU_JOBS		= $(CXXFLAGS_SPU_JOBS_COMMON) $(SPU_ASSERT_OPTS_RELEASE) $(RELEASE_DEFINES_SPU) $(CXXFLAGS_OPT_FLAGS_RELEASE_SPU_JOBS) 
else
  CXXFLAGS_DEBUG_SPU_DRIVER		+= $(CXXFLAGS_OPT_FLAGS_DEBUG_SPU_DRIVER) 
  CXXFLAGS_RELEASE_SPU_DRIVER	+= -fomit-frame-pointer
  
  CXXFLAGS_DEBUG_SPU_JOBS			= $(CXXFLAGS_COMMON_SPU) $(DEBUG_DEFINES_SPU) -L$(CELL_SDK)/target/spu/lib/pic $(SPU_ASSERT_OPTS_DEBUG)
	CXXFLAGS_RELEASE_SPU_JOBS		= $(CXXFLAGS_COMMON_SPU) $(RELEASE_DEFINES_SPU) -L$(CELL_SDK)/target/spu/lib/pic $(SPU_ASSERT_OPTS_RELEASE) $(CXXFLAGS_OPT_FLAGS_RELEASE_SPU_JOBS)
endif

CXXFLAGS_RELEASE_SPU_DRIVER += $(SPU_EXT_OPTS)

#CXXFLAGS_RELEASE_SPU_DRIVER	+= -D_DRIVER_DEBUG -O0 -fif-conversion -fif-conversion2 -funit-at-a-time -fmerge-constants

DebugPS3/SPU/SPUElf32.x:
	@mkdir -p ./DebugPS3/SPU
	@echo Buidling linker script for SPUDriver_spu
	@$(BUILD) \
	  $(CCC_SPU) $(INCLUDE_DIR_SPU)/SPU $(SN_MODE) $(INCLUDE_FLAGS_COMMON_SPU) \
	  -DSET_STACK_PTR -E -P $(INCLUDE_DIR_SPU)/SPU/SPUElf32.h -o $@

ProfilePS3/SPU/SPUElf32.x:
	@mkdir -p ./ProfilePS3/SPU
	@echo Buidling linker script for SPUDriver_spu
	$(BUILD) \
	  $(CCC_SPU) $(SPU_CACHE_MISS_USE_ASM) $(INCLUDE_DIR_SPU)/SPU $(SN_MODE) $(INCLUDE_FLAGS_COMMON_SPU) \
	  -DSET_STACK_PTR -E -P $(INCLUDE_DIR_SPU)/SPU/SPUElf32.h -o $@

DebugPS3/SPU/MissHandler_spu.x: DebugPS3/SPU/SPUMemManager_spu.o SPU/CodePage/MissHandler_spu.S
	@echo MissHandler_spu.S
	@$(CCC_SPU) $(SPU_ASSERT_OPTS_DEBUG) $(ASM_OPT) -DPS3 -D__SPU__ -D_DEBUG SPU/CodePage/MissHandler_spu.S -c -o DebugPS3/SPU/MissHandler_spu.x
	@cp DebugPS3/SPU/MissHandler_spu.x DebugPS3/SPU/MissHandler_spu.o

ProfilePS3/SPU/MissHandler_spu.x: ProfilePS3/SPU/SPUMemManager_spu.o SPU/CodePage/MissHandler_spu.S
	@echo MissHandler_spu.S
	@$(CCC_SPU) $(SPU_CACHE_MISS_USE_ASM) $(SPU_ASSERT_OPTS_RELEASE) $(ASM_OPT) -DPS3 -D__SPU__ SPU/CodePage/MissHandler_spu.S -c -o ProfilePS3/SPU/MissHandler_spu.x
	@cp ProfilePS3/SPU/MissHandler_spu.x ProfilePS3/SPU/MissHandler_spu.o

DebugPS3/SPU/HistTableLookup_spu.x: DebugPS3/SPU/SPUMemManager_spu.o SPU/FuncHistTable/HistTableLookup_spu.S
	@echo HistTableLookup_spu.S
	@$(CCC_SPU) $(SPU_ASSERT_OPTS_DEBUG) $(ASM_OPT) -DPS3 -D__SPU__ -D_DEBUG SPU/FuncHistTable/HistTableLookup_spu.S -c -o DebugPS3/SPU/HistTableLookup_spu.x
	@cp DebugPS3/SPU/HistTableLookup_spu.x DebugPS3/SPU/HistTableLookup_spu.o

ProfilePS3/SPU/HistTableLookup_spu.x: ProfilePS3/SPU/SPUMemManager_spu.o SPU/FuncHistTable/HistTableLookup_spu.S
	@echo HistTableLookup_spu.S
	@$(CCC_SPU) $(SPU_CACHE_MISS_USE_ASM) $(SPU_ASSERT_OPTS_RELEASE) $(ASM_OPT) -DPS3 -D__SPU__ SPU/FuncHistTable/HistTableLookup_spu.S -c -o ProfilePS3/SPU/HistTableLookup_spu.x
	@cp ProfilePS3/SPU/HistTableLookup_spu.x ProfilePS3/SPU/HistTableLookup_spu.o

DebugPS3/SPU/DoCacheLookup_spu.x: DebugPS3/SPU/SPUMemManager_spu.o SPU/Cache/DoCacheLookup_spu.S
	@echo DoCacheLookup_spu.S
	@$(CCC_SPU) $(SPU_ASSERT_OPTS_DEBUG) $(ASM_OPT) -DPS3 -D__SPU__ -D_DEBUG SPU/Cache/DoCacheLookup_spu.S -c -o DebugPS3/SPU/DoCacheLookup_spu.x
	@cp DebugPS3/SPU/DoCacheLookup_spu.x DebugPS3/SPU/DoCacheLookup_spu.o
	
ProfilePS3/SPU/DoCacheLookup_spu.x: ProfilePS3/SPU/SPUMemManager_spu.o SPU/Cache/DoCacheLookup_spu.S
	@echo DoCacheLookup_spu.S
	@$(CCC_SPU) $(SPU_CACHE_MISS_USE_ASM) $(SPU_ASSERT_OPTS_RELEASE) $(ASM_OPT) -DPS3 -D__SPU__ SPU/Cache/DoCacheLookup_spu.S -c -o ProfilePS3/SPU/DoCacheLookup_spu.x
	@cp ProfilePS3/SPU/DoCacheLookup_spu.x ProfilePS3/SPU/DoCacheLookup_spu.o

FILELIST_LIBDMA	= $(wildcard SPU/libDriverDMA/*.cpp)
FILELIST_LIBDMA += SPU/libDriverDMA/SoftFloat_spu.h

#copy always over the other one since the driver address needs to be the correct one
#invalidate both libraries to force relinking too
DebugPS3/SPU/SPUDriver_spu.o: SPUDriver_spu.cpp DebugPS3/SPU/SPUElf32.x \
	DebugPS3/SPU/MissHandler_spu.x DebugPS3/SPU/HistTableLookup_spu.x DebugPS3/SPU/SPUMemManager_spu.o DebugPS3/SPU/SPUDriverSmall_spu.o DebugPS3/SPU/DoCacheLookup_spu.x\
	$(FILELIST_LIBDMA)
	@$(BUILD) --echo $(notdir $<) \
		$(CXX_SPU_NO_FPIC) $(CXXFLAGS_DEBUG_SPU_DRIVER) $(DR_I_F) $< -c -o DebugPS3/SPU/SPUDriver_spu.obj
	@$(BUILD) \
	  $(CXX_SPU_NO_FPIC) $(SPU_ASSERT_OPTS_DEBUG) $(DR_I_F) -Wl,-nostdlib -nostartfiles -Wl,-T,DebugPS3/SPU/SPUElf32.x -Wl,-entry=main DebugPS3/SPU/SPUDriver_spu.obj -o DebugPS3/SPU/SPUDriver_debug.elf \
	  DebugPS3/SPU/SPUMemManager_spu.o DebugPS3/SPU/SPUDriverSmall_spu.o DebugPS3/SPU/DoCacheLookup_spu.o DebugPS3/SPU/MissHandler_spu.o DebugPS3/SPU/HistTableLookup_spu.o -L$(CELL_SDK)/target/spu/lib/pic $(COMMON_LIBS_SPU)
	$(SPU_DRIVER_PARSER) "DebugPS3/SPU/SPUDriver_debug.elf" "$(INCLUDE_DIR_SPU)/SPU/SPUJob.h" "DEBUG"
ifeq "$(SN_BUILD_MODE)" "ON"
	spumodgen DebugPS3/SPU/SPUDriver_debug.elf DebugPS3/SPU/SPUDriver_debug.bin
	$(SPUMODGEN_EX) DebugPS3/SPU/SPUDriver_debug.bin `$(NM) -n -td DebugPS3/SPU/SPUDriver_debug.elf | grep "_end" | cut -c1-16`
	$(SILENT_TAG)$(EMBEDSPU) --redefine-sym _binary_$(subst -,_,$(subst /,_,DebugPS3/SPU/SPUDriver_debug))_bin_start=SPUDriver DebugPS3/SPU/SPUDriver_debug.bin DebugPS3/SPU/SPUDriver_spu.o
	-@rm -f $(WORK_DIR)/SPUDriver_debug.elf
	-@cp DebugPS3/SPU/SPUDriver_debug.elf $(WORK_DIR)
	@cp DebugPS3/SPU/SPUDriver_debug.elf lib/SPUDriver_debug.elf
else
	$(SILENT_TAG)$(EMBEDSPU) --redefine-sym _binary_$(subst -,_,$(subst /,_,DebugPS3/SPU/SPUDriver_debug))_elf_start=SPUDriver DebugPS3/SPU/SPUDriver_debug.elf DebugPS3/SPU/SPUDriver_spu.o
endif	
	@$(NM) -n -td DebugPS3/SPU/SPUDriver_debug.elf > $(OUTPUT_DIR)NM.txt
	#do not change order, must be kept in sync with JobGen	
	cat $(OUTPUT_DIR)NM.txt | grep "CodePagingCallMissHandler" | cut -c1-16 > lib/SPUDriverAddr_debug.txt
	cat $(OUTPUT_DIR)NM.txt | grep "CodePagingReturnMissHandler" | cut -c1-16 >> lib/SPUDriverAddr_debug.txt
	cat $(OUTPUT_DIR)NM.txt | grep "SetActivePages" | cut -c1-16 >> lib/SPUDriverAddr_debug.txt
	cat $(OUTPUT_DIR)NM.txt | grep "_end" | cut -c1-16 >> lib/SPUDriverAddr_debug.txt
	@rm -f $(OUTPUT_DIR)NM.txt
	@echo libDriverSPU_debug.a
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/JobAPI_spu.cpp\
		-c -o DebugPS3/SPU/JobAPI_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/FlushCacheRange_spu.cpp\
		-c -o DebugPS3/SPU/FlushCacheRange_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/Memcpy__VLM_spu.cpp\
		-c -o DebugPS3/SPU/Memcpy__VLM_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/Memcpy__VML_spu.cpp\
		-c -o DebugPS3/SPU/Memcpy__VML_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/Memcpy__VMM_spu.cpp\
		-c -o DebugPS3/SPU/Memcpy__VMM_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/Memset__VM_spu.cpp\
		-c -o DebugPS3/SPU/Memset__VM_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/MemsetLarge__VM_spu.cpp\
		-c -o DebugPS3/SPU/MemsetLarge__VM_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/LibGCM_spu.cpp\
		-c -o DebugPS3/SPU/LibGCM_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/VolatileSemantics_spu.cpp\
		-c -o DebugPS3/SPU/VolatileSemantics_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/Misc_spu.cpp\
		-c -o DebugPS3/SPU/Misc_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/Allocation_spu.cpp\
		-c -o DebugPS3/SPU/Allocation_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/adddf3_spu.cpp	-c -o DebugPS3/SPU/adddf3_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/subdf3_spu.cpp	-c -o DebugPS3/SPU/subdf3_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/muldf3_spu.cpp	-c -o DebugPS3/SPU/muldf3_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/divdf3_spu.cpp	-c -o DebugPS3/SPU/divdf3_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/floatdisf_spu.cpp	-c -o DebugPS3/SPU/floatdisf_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/floatdidf_spu.cpp	-c -o DebugPS3/SPU/floatdidf_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/fixdfsi_spu.cpp	-c -o DebugPS3/SPU/fixdfsi_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/fixsfdi_spu.cpp	-c -o DebugPS3/SPU/fixsfdi_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/fixdfdi_spu.cpp	-c -o DebugPS3/SPU/fixdfdi_spu.o
	@$(BUILD) $(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_DRIVER) -D_SPU_JOB -D_LIB_DRIVER\
		$(DR_I_F) SPU/libDriverDMA/eqdf2_spu.cpp	-c -o DebugPS3/SPU/eqdf2_spu.o
	@$(AR_SPU) lib/libDriverSPU_debug.a DebugPS3/SPU/FlushCacheRange_spu.o DebugPS3/SPU/Memcpy__VLM_spu.o\
		DebugPS3/SPU/Memcpy__VML_spu.o DebugPS3/SPU/Memcpy__VMM_spu.o DebugPS3/SPU/Memset__VM_spu.o\
		DebugPS3/SPU/MemsetLarge__VM_spu.o DebugPS3/SPU/JobAPI_spu.o DebugPS3/SPU/LibGCM_spu.o DebugPS3/SPU/VolatileSemantics_spu.o\
		DebugPS3/SPU/Misc_spu.o DebugPS3/SPU/Allocation_spu.o DebugPS3/SPU/adddf3_spu.o DebugPS3/SPU/subdf3_spu.o\
		DebugPS3/SPU/muldf3_spu.o DebugPS3/SPU/divdf3_spu.o DebugPS3/SPU/floatdisf_spu.o\
		DebugPS3/SPU/floatdidf_spu.o DebugPS3/SPU/fixdfsi_spu.o DebugPS3/SPU/fixsfdi_spu.o\
		DebugPS3/SPU/fixdfdi_spu.o DebugPS3/SPU/eqdf2_spu.o

ProfilePS3/SPU/SPUDriver_spu.o: SPUDriver_spu.cpp ProfilePS3/SPU/SPUElf32.x \
	ProfilePS3/SPU/SPUMemManager_spu.o ProfilePS3/SPU/SPUDriverSmall_spu.o ProfilePS3/SPU/DoCacheLookup_spu.x ProfilePS3/SPU/MissHandler_spu.x ProfilePS3/SPU/HistTableLookup_spu.x\
	$(FILELIST_LIBDMA)
	@$(BUILD) --echo $(notdir $<) \
	  $(CXX_SPU_NO_FPIC) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) $(SPU_ASSERT_OPTS_RELEASE) $(DR_I_F) -save-temps -dA $< -c -o ProfilePS3/SPU/SPUDriver_spu.obj
	@rm -f ./SPUDriver_spu.ii
	@cat ./SPUDriver_spu.s | $(CXX_SPU_FILT) > ProfilePS3/SPU/SPUDriver_spu.asm
	@rm -f ./SPUDriver_spu.s	
	@$(BUILD) \
		$(CXX_SPU_NO_FPIC) $(SPU_CACHE_MISS_USE_ASM) $(SPU_ASSERT_OPTS_RELEASE) $(DR_I_F) -Wl,-nostdlib -nostartfiles -Wl,-T,ProfilePS3/SPU/SPUElf32.x -Wl,-entry=main \
		ProfilePS3/SPU/SPUDriver_spu.obj -o ProfilePS3/SPU/SPUDriver.elf \
	  ProfilePS3/SPU/SPUMemManager_spu.o ProfilePS3/SPU/SPUDriverSmall_spu.o  ProfilePS3/SPU/DoCacheLookup_spu.o ProfilePS3/SPU/MissHandler_spu.o ProfilePS3/SPU/HistTableLookup_spu.o -L$(CELL_SDK)/target/spu/lib/pic $(COMMON_LIBS_SPU)
ifeq "$(SPU_PROF)" "-DDO_SPU_PROFILING"
	$(SPU_DRIVER_PARSER) "ProfilePS3/SPU/SPUDriver.elf" "$(INCLUDE_DIR_SPU)/SPU/SPUJob.h" "PROFILE"
else
	$(SPU_DRIVER_PARSER) "ProfilePS3/SPU/SPUDriver.elf" "$(INCLUDE_DIR_SPU)/SPU/SPUJob.h" "RELEASE"
endif
ifeq "$(SN_BUILD_MODE)" "ON"
	spumodgen ProfilePS3/SPU/SPUDriver.elf ProfilePS3/SPU/SPUDriver.bin
	$(SPUMODGEN_EX) ProfilePS3/SPU/SPUDriver.bin `$(NM) -n -td ProfilePS3/SPU/SPUDriver.elf | grep "_end" | cut -c1-16`
	$(SILENT_TAG)$(EMBEDSPU) --redefine-sym _binary_$(subst -,_,$(subst /,_,ProfilePS3/SPU/SPUDriver))_bin_start=SPUDriver ProfilePS3/SPU/SPUDriver.bin ProfilePS3/SPU/SPUDriver_spu.o
	-@rm -f $(WORK_DIR)/SPUDriver$(DRIVER_REL_EXT).elf
	-@cp ProfilePS3/SPU/SPUDriver.elf $(WORK_DIR)/SPUDriver$(DRIVER_REL_EXT).elf
	@cp ProfilePS3/SPU/SPUDriver.elf lib/SPUDriver$(DRIVER_REL_EXT).elf
else
	$(SILENT_TAG)$(EMBEDSPU) --redefine-sym _binary_$(subst -,_,$(subst /,_,ProfilePS3/SPU/SPUDriver))_elf_start=SPUDriver ProfilePS3/SPU/SPUDriver.elf $@
endif	
	@$(NM) -n --demangle ProfilePS3/SPU/SPUDriver_spu.obj | grep -v -e '\( A \| U \|__static_initialization_and_destruction_0\|global constructors\)' > ProfilePS3/SPU/SPUDriver_spu.s
	@cat ProfilePS3/SPU/SPUDriver_spu.asm >> ProfilePS3/SPU/SPUDriver_spu.s
	@rm -f ProfilePS3/SPU/SPUDriver_spu.asm
	@$(NM) -n -td ProfilePS3/SPU/SPUDriver.elf > $(OUTPUT_DIR)NM.txt	
	#do not change order, must be kept in sync with JobGen
	cat $(OUTPUT_DIR)NM.txt | grep "CodePagingCallMissHandler" | cut -c1-16 > lib/SPUDriverAddr$(LIB_FILE_EXT).txt
	cat $(OUTPUT_DIR)NM.txt | grep "CodePagingReturnMissHandler" | cut -c1-16 >> lib/SPUDriverAddr$(LIB_FILE_EXT).txt
	cat $(OUTPUT_DIR)NM.txt | grep "SetActivePages" | cut -c1-16 >> lib/SPUDriverAddr$(LIB_FILE_EXT).txt	
	cat $(OUTPUT_DIR)NM.txt | grep "_end" | cut -c1-16 >> lib/SPUDriverAddr$(LIB_FILE_EXT).txt	
	@rm -f $(OUTPUT_DIR)/NM.txt
	@echo libDriverSPU$(LIB_FILE_EXT).a
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/JobAPI_spu.cpp\
		-Os -c -o ProfilePS3/SPU/JobAPI_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/FlushCacheRange_spu.cpp\
		-c -o ProfilePS3/SPU/FlushCacheRange_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/Memcpy__VLM_spu.cpp\
		-c -o ProfilePS3/SPU/Memcpy__VLM_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/Memcpy__VML_spu.cpp\
		-c -o ProfilePS3/SPU/Memcpy__VML_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/Memcpy__VMM_spu.cpp\
		-Os -c -o ProfilePS3/SPU/Memcpy__VMM_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/Memset__VM_spu.cpp\
		-c -o ProfilePS3/SPU/Memset__VM_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/MemsetLarge__VM_spu.cpp\
		-c -o ProfilePS3/SPU/MemsetLarge__VM_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/LibGCM_spu.cpp\
		-O3 -c -o ProfilePS3/SPU/LibGCM_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/VolatileSemantics_spu.cpp\
		-Os -c -o ProfilePS3/SPU/VolatileSemantics_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/Misc_spu.cpp\
		-Os -c -o ProfilePS3/SPU/Misc_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/Allocation_spu.cpp\
		-Os -c -o ProfilePS3/SPU/Allocation_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/adddf3_spu.cpp -O3 -c -o ProfilePS3/SPU/adddf3_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/subdf3_spu.cpp -O3 -c -o ProfilePS3/SPU/subdf3_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/muldf3_spu.cpp -O3 -c -o ProfilePS3/SPU/muldf3_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/divdf3_spu.cpp -O3 -c -o ProfilePS3/SPU/divdf3_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/floatdisf_spu.cpp -O3 -c -o ProfilePS3/SPU/floatdisf_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/floatdidf_spu.cpp -O3 -c -o ProfilePS3/SPU/floatdidf_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/fixdfsi_spu.cpp -O3 -c -o ProfilePS3/SPU/fixdfsi_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/fixsfdi_spu.cpp -O3 -c -o ProfilePS3/SPU/fixsfdi_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/fixdfdi_spu.cpp -O3 -c -o ProfilePS3/SPU/fixdfdi_spu.o
	@$(BUILD) $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) -save-temps -D_SPU_JOB -D_LIB_DRIVER $(SPU_ASSERT_OPTS_RELEASE)\
		$(DR_I_F) SPU/libDriverDMA/eqdf2_spu.cpp -O3 -c -o ProfilePS3/SPU/eqdf2_spu.o
	@rm -f ./*.ii
	@mv -f ./*.s ProfilePS3/SPU
	@$(AR_SPU) lib/libDriverSPU$(LIB_FILE_EXT).a ProfilePS3/SPU/FlushCacheRange_spu.o ProfilePS3/SPU/Memcpy__VLM_spu.o ProfilePS3/SPU/Memcpy__VML_spu.o\
		ProfilePS3/SPU/Memcpy__VMM_spu.o ProfilePS3/SPU/Memset__VM_spu.o ProfilePS3/SPU/JobAPI_spu.o\
		ProfilePS3/SPU/MemsetLarge__VM_spu.o ProfilePS3/SPU/LibGCM_spu.o ProfilePS3/SPU/VolatileSemantics_spu.o\
		ProfilePS3/SPU/Misc_spu.o ProfilePS3/SPU/Allocation_spu.o ProfilePS3/SPU/adddf3_spu.o  ProfilePS3/SPU/subdf3_spu.o\
		ProfilePS3/SPU/muldf3_spu.o ProfilePS3/SPU/divdf3_spu.o ProfilePS3/SPU/floatdisf_spu.o\
		ProfilePS3/SPU/floatdidf_spu.o ProfilePS3/SPU/fixdfsi_spu.o ProfilePS3/SPU/fixsfdi_spu.o\
		ProfilePS3/SPU/fixdfdi_spu.o ProfilePS3/SPU/eqdf2_spu.o

DebugPS3/SPU/SPUMemManager_spu.o: SPUMemManager_spu.cpp
	@mkdir -p ./DebugPS3/SPU
	@$(BUILD) --echo $(notdir $<) \
	  $(CXX_SPU_NO_FPIC) $(CXXFLAGS_DEBUG_SPU_DRIVER) $(DR_I_F) -save-temps $< -c -o DebugPS3/SPU/SPUMemManager_spu.o
	@rm -f ./SPUMemManager_spu.ii
	@cat ./SPUMemManager_spu.s > DebugPS3/SPU/SPUMemManager_spu.asm
	@rm -f ./SPUMemManager_spu.s
	@$(NM) -n --demangle DebugPS3/SPU/SPUMemManager_spu.o | grep -v -e '\( A \| U \|__static_initialization_and_destruction_0\|global constructors\)' > DebugPS3/SPU/SPUMemManager_spu.s
	@cat DebugPS3/SPU/SPUMemManager_spu.asm >> DebugPS3/SPU/SPUMemManager_spu.s
	@rm -f DebugPS3/SPU/SPUMemManager_spu.asm

ProfilePS3/SPU/SPUMemManager_spu.o: SPUMemManager_spu.cpp
	@mkdir -p ./ProfilePS3/SPU
	@$(BUILD) --echo $(notdir $<) \
	  $(CXX_SPU_NO_FPIC) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) $(SPU_ASSERT_OPTS_RELEASE) $(DR_I_F) -save-temps $< -c -o ProfilePS3/SPU/SPUMemManager_spu.o
	@rm -f ./SPUMemManager_spu.ii
	@cat ./SPUMemManager_spu.s > ProfilePS3/SPU/SPUMemManager_spu.asm
	@rm -f ./SPUMemManager_spu.s
	@$(NM) -n --demangle ProfilePS3/SPU/SPUMemManager_spu.o | grep -v -e '\( A \| U \|__static_initialization_and_destruction_0\|global constructors\)' > ProfilePS3/SPU/SPUMemManager_spu.s
	@cat ProfilePS3/SPU/SPUMemManager_spu.asm >> ProfilePS3/SPU/SPUMemManager_spu.s
	@rm -f ProfilePS3/SPU/SPUMemManager_spu.asm

DebugPS3/SPU/SPUDriverSmall_spu.o: SPUDriverSmall_spu.cpp
	@mkdir -p ./DebugPS3/SPU
	@$(BUILD) --echo $(notdir $<) \
	  $(CXX_SPU_NO_FPIC) $(CXXFLAGS_DEBUG_SPU_DRIVER) $(DR_I_F) -save-temps $< -c -o DebugPS3/SPU/SPUDriverSmall_spu.o
	@rm -f ./SPUDriverSmall_spu.ii
	@cat ./SPUDriverSmall_spu.s > DebugPS3/SPU/SPUDriverSmall_spu.asm
	@rm -f ./SPUDriverSmall_spu.s
	@$(NM) -n --demangle DebugPS3/SPU/SPUDriverSmall_spu.o | grep -v -e '\( A \| U \|__static_initialization_and_destruction_0\|global constructors\)' > DebugPS3/SPU/SPUDriverSmall_spu.s
	@cat DebugPS3/SPU/SPUDriverSmall_spu.asm >> DebugPS3/SPU/SPUDriverSmall_spu.s
	@rm -f DebugPS3/SPU/SPUDriverSmall_spu.asm

ProfilePS3/SPU/SPUDriverSmall_spu.o: SPUDriverSmall_spu.cpp
	@mkdir -p ./ProfilePS3/SPU
	@$(BUILD) --echo $(notdir $<) \
	  $(CXX_SPU_NO_FPIC) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_DRIVER) $(SPU_ASSERT_OPTS_RELEASE) $(DR_I_F) -save-temps -Os $< -c -o ProfilePS3/SPU/SPUDriverSmall_spu.o
	@rm -f ./SPUDriverSmall_spu.ii
	@cat ./SPUDriverSmall_spu.s > ProfilePS3/SPU/SPUDriverSmall_spu.asm
	@rm -f ./SPUDriverSmall_spu.s
	@$(NM) -n --demangle ProfilePS3/SPU/SPUDriverSmall_spu.o | grep -v -e '\( A \| U \|__static_initialization_and_destruction_0\|global constructors\)' > ProfilePS3/SPU/SPUDriverSmall_spu.s
	@cat ProfilePS3/SPU/SPUDriverSmall_spu.asm >> ProfilePS3/SPU/SPUDriverSmall_spu.s
	@rm -f ProfilePS3/SPU/SPUDriverSmall_spu.asm

DEPENDENCY_FILE = Makefile.depend
FILELIST_BODY	= $(subst .dirs,.files_, $(wildcard *dirs))

#entry point for usual ps3 jobs must be Execute (generated automatically)
#external symbol is filename without _spu.cpp, elf data are renamed to $(OUTPUT)_(base filename)
#make dependent on SPUDriver since this compilation sets entry point of memory manager
#compile order:
#		- compile job file just to get compile errors (use -shared to not output warning about missing entry point)
#		- invoke Jobparser to create PPU include file and SPU execution file
#		- compile SPU execution file (with target original _spu.o - name), define EXECUTE_SYMBOL as entry point and copy obj to object file
SPU_JOB_LIBS = -L$(CELL_SDK)/target/spu/lib/pic/ $(COMMON_LIBS_SPU) $(CELL_SDK)/target/spu/lib/pic/libc.a $(CELL_SDK)/target/spu/lib/pic/libstdc++.a \
	-L$(INCLUDE_DIR_SPU)/lib/

DebugPS3/SPU/%_spu.o: %_spu.cpp $(INCLUDE_DIR_SPU)/SPU/SPUJob.h
	@mkdir -p ./DebugPS3/SPU
	$(SILENT_TAG) $(JOBPARSER) $< $(OUTPUT) $(DEPENDENCY_FILE) $(FILELIST_BODY) DebugPS3/SPU/
ifeq "$(SN_BUILD_MODE)" "ON"
	@$(BUILD) --echo $(notdir $<) \
	$(CXX_SPU) $(CXXFLAGS_DEBUG_SPU_JOBS) -D_SPU_JOB -save-temps -I$(INCLUDE_DIR_SPU)/SPU\
	 $(COMPLETE_BUILD_DEF) $(INCLUDE_FLAGS_COMMON_SPU) $(DR_I_F)\
	 -o $(basename $<)_helper.o $(basename $<)_helper.cpp
	$(BUILD_SPU_DEBUG) DebugPS3 $(subst _spu.cpp,, $(notdir $<))\
	  $(CXX_SPU) -T $(INCLUDE_DIR_SPU)/lib/spu_module.ld -Wl,-q $(SPU_JOB_LIBS) -nostartfiles\
	    $(basename $<)_helper.o -o DebugPS3/SPU/$(basename $(notdir $<))_inc_debug.elf
else	
  @echo $(notdir $<)
	$(BUILD_SPU_DEBUG) DebugPS3 $(subst _spu.cpp,, $(notdir $<))\
		$(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_DEBUG_SPU_JOBS) -O0 -save-temps -D_SPU_JOB -I$(INCLUDE_DIR_SPU)/SPU\
			$(DR_I_F) -nostartfiles $(COMPLETE_BUILD_DEF)\
			-o DebugPS3/SPU/$(basename $(notdir $<))_inc_debug.elf $(basename $<)_helper.cpp -L$(INCLUDE_DIR_SPU)/lib/\
		-lDriverSPU_debug
		@mv -f $(subst _spu,_spu_helper.cpp, $(basename $<)) DebugPS3/SPU		  		
endif
	@mv -f $(subst _spu,_spu_helper.o, $(basename $<)) DebugPS3/SPU
	@rm -f ./$(basename $(notdir $<))_helper.ii		
	@mv -f ./$(basename $(notdir $<))_helper.s DebugPS3/SPU/$(basename $(notdir $<))_helper.S
ifeq "$(SN_BUILD_MODE)" "ON"	
	@mv -f $(subst _spu.cpp,,$(notdir $<))_job.elf $(WORK_DIR)
endif	
	@rm -f $(OUTPUT_DIR)$(PROJECT_OUTPUT_PATH)/Debug/Bubbles/$(subst _spu,,$(basename $(notdir $<)).elf)	
ifeq "$(SN_BUILD_MODE)" "ON"
	@rm -f $(WORK_DIR)/$(basename $(notdir $<))_inc_debug.elf
	@cp DebugPS3/SPU/$(basename $(notdir $<))_inc_debug.elf $(WORK_DIR)
	rm -f $(OUTPUT_DIR)$(PROJECT_OUTPUT_PATH)/Debug/Bubbles/$(subst _spu,,$(basename $(notdir $<)).bin)
	@mv -f DebugPS3/SPU/$(basename $(notdir $<))_inc_debug.bin $(OUTPUT_DIR)$(PROJECT_OUTPUT_PATH)/Debug/Bubbles/$(subst _spu,,$(basename $(notdir $<)).bin)
endif
	@mv -f DebugPS3/SPU/$(basename $(notdir $<))_inc_debug.elf $(OUTPUT_DIR)$(PROJECT_OUTPUT_PATH)/Debug/Bubbles/$(subst _spu,,$(basename $(notdir $<)).elf)

ProfilePS3/SPU/%_spu.o: %_spu.cpp $(INCLUDE_DIR_SPU)/SPU/SPUJob.h
	@mkdir -p ./ProfilePS3/SPU
	@echo $(notdir $<)
	$(SILENT_TAG) $(JOBPARSER) $< $(OUTPUT) $(DEPENDENCY_FILE) $(FILELIST_BODY) ProfilePS3/SPU/
ifeq "$(SN_BUILD_MODE)" "ON"
	$(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_JOBS) -D_SPU_JOB -save-temps -I$(INCLUDE_DIR_SPU)/SPU\
	 $(COMPLETE_BUILD_DEF) $(INCLUDE_FLAGS_COMMON_SPU) $(DR_I_F)\
	 -o $(basename $<)_helper.o $(basename $<)_helper.cpp
	$(BUILD_SPU_RELEASE) ProfilePS3 $(subst _spu.cpp,, $(notdir $<))\
	  $(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) -T $(INCLUDE_DIR_SPU)/lib/spu_module.ld -Wl,-q $(SPU_JOB_LIBS) -nostartfiles\
	    $(basename $<)_helper.o -o ProfilePS3/SPU/$(basename $(notdir $<))_inc_release.elf
else	
	$(BUILD_SPU_RELEASE) ProfilePS3 $(subst _spu.cpp,, $(notdir $<))\
		$(CXX_SPU) $(SPU_CACHE_MISS_USE_ASM) $(CXXFLAGS_RELEASE_SPU_JOBS) -save-temps -D_SPU_JOB -I$(INCLUDE_DIR_SPU)/SPU\
			$(DR_I_F) -nostartfiles $(COMPLETE_BUILD_DEF)\
			-o ProfilePS3/SPU/$(basename $(notdir $<))_inc_release.elf $(basename $<)_helper.cpp -L$(INCLUDE_DIR_SPU)/lib/\
		-lDriverSPU$(LIB_FILE_EXT)
	@mv -f $(subst _spu,_spu_helper.cpp, $(basename $<)) ProfilePS3/SPU		  		
endif
	@mv -f $(subst _spu,_spu_helper.o, $(basename $<)) ProfilePS3/SPU
	@rm -f ./$(basename $(notdir $<))_helper.ii		
	@mv -f ./$(basename $(notdir $<))_helper.s ProfilePS3/SPU/$(basename $(notdir $<))_helper.S
ifeq "$(SN_BUILD_MODE)" "ON"	
	@mv -f $(subst _spu.cpp,,$(notdir $<))_job.elf $(WORK_DIR)
endif	
	@rm -f $(OUTPUT_DIR)$(PROJECT_OUTPUT_PATH)/Release/Bubbles/$(subst _spu,,$(basename $(notdir $<)).elf)	
ifeq "$(SN_BUILD_MODE)" "ON"
	@rm -f $(WORK_DIR)/$(basename $(notdir $<))_inc_release.elf
	@cp ProfilePS3/SPU/$(basename $(notdir $<))_inc_release.elf $(WORK_DIR)
	rm -f $(OUTPUT_DIR)$(PROJECT_OUTPUT_PATH)/Release/Bubbles/$(subst _spu,,$(basename $(notdir $<)).bin)
	@mv -f ProfilePS3/SPU/$(basename $(notdir $<))_inc_release.bin $(OUTPUT_DIR)$(PROJECT_OUTPUT_PATH)/Release/Bubbles/$(subst _spu,,$(basename $(notdir $<)).bin)
endif
	@mv -f ProfilePS3/SPU/$(basename $(notdir $<))_inc_release.elf $(OUTPUT_DIR)$(PROJECT_OUTPUT_PATH)/Release/Bubbles/$(subst _spu,,$(basename $(notdir $<)).elf)
