#if defined(PS3)

#define NOP nop $127
#define STOPD stop 254
#define STACK_INCR 304

//function pointer history table lookup
//behind each instruction: pipeline (0/1) / latency(cycles)

//Function pointer history table lookup
//		SFuncHistoryTable* const __restrict pHistTable: register $70
//		const unsigned int cEA: register $71
//		const TRetrieveFuncPtrID cRetrFunc: register $72

//		up to 10 parameters are supported to be passed to code page miss handler ($3..$12)
//		pay attention to not trash $70 via g_ProfID in EA-retrieval func
//		Codepaghing miss handler is directly called whilst the 8 parameters remain preserved

/*	C++ version:
	vec_ushort8 HistTableFuncLookup(SFuncHistoryTable* const __restrict pHistTable, const unsigned int cEA, const TRetrieveFuncPtrID cRetrFunc)
	{
		//perform 4 way lookup
		const vec_uint4 ppuEA			= pHistTable->ppuEA;
		const vec_uint4 lru				= pHistTable->lru;
		const vec_uint4 cEA4			= spu_splats(cEA);
		const vec_uint4 cCmpRes		= spu_cmpeq(ppuEA, cEA4);
		const vec_uint4 cGathRes	= spu_gather(cCmpRes);
		const vec_uint4 cCntRes		= spu_cntlz(cGathRes);
		const int cIndex					= 3-spu_extract(spu_sub((unsigned int)31, cCntRes), 0);
#if defined(DO_SPU_PROFILING)
		++NSPU::NDriver::g_PerfStats.funcPtrHits;
#endif
		IF(cIndex >= 0, true)
		{
			pHistTable->lru = spu_insert(spu_extract(g_LRUCounter, 0), lru, cIndex);
			return pHistTable->funcData[cIndex].vecData;
		}
		else
		{
#if defined(DO_SPU_PROFILING)
			++NSPU::NDriver::g_PerfStats.funcPtrMisses;
#endif
			const uint32 cReplIndex		= GetReplIndex(lru);
			const int cFuncID = cRetrFunc(cEA);
			const unsigned int cFuncTableBaseAddr = spu_extract(g_SetMaskSL4, 3);
#if !defined(_NO_SPU_ASSERT)			
			FuncPtrAssertFunc(cEA, cFuncID);
#endif			
			//obtain dest.page ID and its function offset, put into the expectd short-slots
			const unsigned int cFuncEntry = ((unsigned int*)cFuncTableBaseAddr)[cFuncID];
			vec_ushort8& rVecData		= pHistTable->funcData[cReplIndex].vecData;
			rVecData = spu_insert((unsigned short)(cFuncEntry & 0x0000FFFF), rVecData, 4);//set destPageID
			rVecData = spu_insert((unsigned short)((cFuncEntry & 0xFFFF0000) >> 16), rVecData, 3);//set destOffset, stored in multiple of 4
			pHistTable->lru		= spu_insert(spu_extract(g_LRUCounter, 0), lru, cReplIndex);
			pHistTable->ppuEA = spu_insert(cEA, ppuEA, cReplIndex);
			//handle weak flag if current page id and destination page id are equal
			//code rotates current page id (pHistTable->funcData[0].vecData) into upper 16 bits of vec elem 0
			//  haldword compares against cFuncEntry and if euqal, ors scWeak
			return rVecData;
		}
	}
*/
	.file	"HistTableLookup_spu.S"
.text
	.align 6
	.global	HistTableFuncLookup
	.type	HistTableFuncLookup, @function
HistTableFuncLookup:
#if defined(SUPP_SN) && !defined(_NO_SPU_ASSERT)
	ilhu $20,0x07FF				//0/2	  load upper mask for EA (to unmask variant)
	iohl $20,0xFFFC				//0/2	  load lower mask for EA (to unmask variant)
	and $22,$71,$20				//0/2   unmask variant from cEA
	lnop									//1/0
	rotmi	$22,$22,-10			//0/4		cEA / 1024
	clgti $22,$22,256			//0/2		(cEA > 256*1024)?
	brnz	$22,.HTTestPassed//1/4 if(cEA > 256*1024) continue processing
	NOP										//0/0	
	stop 255							//1/4		custom snPause()
.HTTestPassed:	
#endif
	ila	$22,66051					//0/2		load mask for shuffling ints into all 4 slots
	lqd $20, 0($70)				//1/6		const vec_uint4 ppuEA	= pHistTable->ppuEA
	lqa $28, .OFFSET			//1/6		const vec_uint4 cOffConst = (vec_uint4){32,48,64,80}
	shufb	$23,$71,$71,$22	//1/4		const vec_uint4 cEA4	= spu_splats(cEA)	
#if defined(DO_SPU_PROFILING)	
	lqa	$39,_ZN4NSPU7NDriver11g_PerfStatsE+96	//1/6		load NSPU::NDriver::g_PerfStats.funcPtrHits
	cwd	$41,0($sp)				//1/4		generate control word for insertion into NSPU::NDriver::g_PerfStats.funcPtrHits
	ai	$42,$39,1					//0/2		++NSPU::NDriver::g_PerfStats.funcPtrHits	
	shufb	$42,$42,$39,$41	//1/4		shuffle into slot
	NOP										//0/0
	stqa	$42,_ZN4NSPU7NDriver11g_PerfStatsE+96	//1/5		store NSPU::NDriver::g_PerfStats.funcPtrHits
#endif
	il	$48,3							//0/2		load 3 for GetReplIndex
	hbra	.HistHitRet,CodePagingCallMissHandler		//1/10	branch hint for instructions past function call for non miss case	
	il	$47,2							//0/2		load 2 for GetReplIndex
	lqd $21,16($70)				//1/6		const vec_uint4 lru			= pHistTable->lru
	NOP										//0/0	
	lqa	$72,_ZN4NSPU19g_SPUJobResolveFuncE	//1/6		load g_SPUJobResolveFunc
	ceq	$24,$23,$20				//0/2		const vec_uint4 cCmpRes	= spu_cmpeq(ppuEA, cEA4)
	stqa $lr,261616				//1/6		store link register to branch back in case of fn_resolve-failure
//	NOP									//0/0	
//	lnop								//1/0			
	and $29, $28, $24			//0/2		const vec_uint4 cOffset	= spu_and(cCmpRes, cOffConst)
	gb $25, $24						//1/4		const vec_uint4 cGathRes= spu_gather(cCmpRes)
//	NOP										//0/0	
//	lnop									//1/0			
	selb $30,$21,$75,$24	//0/2		update lru with ppu match mask
	orx	$29, $29					//1/4		retrieve final offset into funcData (cIndex * 16 + 2 * sizeof(vec_uint4))
	NOP										//0/0	
	rotqbyi	$40,$21,4			//1/4		const vec_uint4 cVal1			= spu_rlqwbyte(lru, 4) (for GetReplIndex)
//	NOP										//0/0	
	brz $25, .HistMiss		//1/4		IF(cIndex < 0, false) branch
//	NOP										//0/0	
	stqd $30,16($70)			//1/6		store pHistTable->lru
//	NOP
	lqx	$71, $29, $70			//1/6		load return value for hit (pHistTable->funcData[cIndex].vecData) directly into g_CrossPageData
//	NOP										//0/0	
.HistHitRet:
	br	CodePagingCallMissHandler	//1/4		call code page miss handler
.HistMiss:	
#if defined(DO_SPU_PROFILING)
	cwd	$41,4($sp)				//1/4		generate control word for insertion into NSPU::NDriver::g_PerfStats.funcPtrMisses
	ai $42, $39, 1				//0/2		++NSPU::NDriver::g_PerfStats.funcPtrMisses	
	shufb	$42,$42,$39,$41 //1/4		shuffle into slot
	NOP										//0/0
	stqa	$42,_ZN4NSPU7NDriver11g_PerfStatsE+96	//1/5		store NSPU::NDriver::g_PerfStats.funcPtrMisses
#endif
	clgt	$43,$21,$40			//0/2		spu_cmpgt(cVal0, cVal1) (for GetReplIndex)	
	hbr	.FuncIDRetrieval,$72	//1/10	branch hint for function id retrieval
	NOP										//0/0	
	rotqbyi	$41,$21,8			//1/4		const vec_uint4 cVal2 = spu_rlqwbyte(lru, 8) (for GetReplIndex)
	selb	$45,$21,$40,$43	//0/2		const vec_uint4 cCmpSelRes01 = spu_sel(cVal0, cVal1, cCmpVec01)	(for GetReplIndex)	
	rotqbyi	$42,$21,12		//1/4		const vec_uint4 cVal3 = spu_rlqwbyte(lru, 12) (for GetReplIndex)	
	NOP										//0/0	
	stqd	$81,-48($sp)		//1/6		save register 81 as required by ABI
	andi	$49, $43, 1			//0/2		const vec_uint4 cCmpIndexRes01 = spu_sel((vec_uint4)0, (vec_uint4)1, cCmpVec01) (for GetReplIndex)
	stqd	$80,-16($sp)		//1/6		save register 80 as required by ABI
	ori		$81, $3, 0			//0/2		save parameter 1
	stqd	$82,-32($sp)		//1/6		save register 82 as required by ABI
	clgt	$44, $41,$42		//0/2		const vec_uint4 cCmpVec23	= spu_cmpgt(cVal2, cVal3) (for GetReplIndex) 
	rotqbyi $82, $lr, 0		//1/4		save $lr
	ori		$80, $23,0			//0/2		save cEA4
	stqd	$84,-80($sp)		//1/6		save register 84 as required by ABI
	selb	$46,$41,$42,$44	//0/2		const vec_uint4 cCmpSelRes23 = spu_sel(cVal2, cVal3, cCmpVec23) (for GetReplIndex)
	stqd	$83,-64($sp)		//1/6		save register 83 as required by ABI
	ori		$3, $71, 0			//0/2		move cEA into parameter slot
	lqr		$84,.WEAK				//1/6		load scWeak
	selb	$51,$47,$48,$44	//0/2		const vec_uint4 cCmpIndexRes23 = spu_sel((vec_uint4)2, (vec_uint4)3, cCmpVec23) (for GetReplIndex)
	stqd	$85,-96($sp)		//1/6		save register as required by ABI
	clgt	$50, $45,$46		//0/2		const vec_uint4 cCmpVec0123 = spu_cmpgt(cCmpSelRes01, cCmpSelRes23) (for GetReplIndex)
	stqd	$sp,-STACK_INCR($sp)		//1/6		store stack pointer for cRetrFunc
	ori		$85, $4, 0			//0/2		save parameter 2	
	stqd	$86,-112($sp)		//1/6		save register as required by ABI
	selb	$83,$49,$51,$50	//0/2		const vec_uint4 cCmpSelRes0123 = spu_sel(cCmpIndexRes01, cCmpIndexRes23, cCmpVec0123) (for GetReplIndex)
	stqd	$87,-128($sp)		//1/6		save register as required by ABI
	ori		$86, $5,0				//0/2		save parameter 3
	stqd	$88,-144($sp)		//1/6		save register as required by ABI
	ori		$87, $6, 0			//0/2		save parameter 4	
	stqd	$89,-160($sp)		//1/6		save register as required by ABI
	ori		$88, $7, 0			//0/2		save parameter 5	
	stqd	$90,-176($sp)			//1/6		save register as required by ABI
	ori		$89, $8, 0			//0/2		save parameter 6	
	stqd	$91,-192($sp)			//1/6		save register as required by ABI
	ori		$90, $9, 0			//0/2		save parameter 7	
	stqd	$92,-208($sp)			//1/6		save register as required by ABI
	ori		$91, $10, 0			//0/2		save parameter 8	
	stqd	$93,-224($sp)			//1/6		save register as required by ABI
	ori		$92, $11, 0			//0/2		save parameter 9
//	lnop									//1/0	
	ori		$93, $12, 0			//0/2		save parameter 10
//	lnop									//1/0
	ai		$sp,$sp,-STACK_INCR		//0/2		decrement stack for cRetrFunc	
.FuncIDRetrieval:	
	bisl	$lr,$72					//1/4		const int cFuncID = cRetrFunc(cEA)
#if !defined(_NO_SPU_ASSERT)
	ori		$4,	$80,0				//0/2		put cEA into expected parameter slot
	brsl	$lr,	_Z17FuncPtrAssertFuncjj//1/4	call FuncPtrAssertFunc(cFuncID, cEA)
#endif	
	shli	$58,$3,2				//0/4		sizeof(int) * cFuncID
	rotqbyi	$59,$78,12		//1/4		spu_extract(g_SetMaskSL4, 3)
	shli	$60,$83,4				//0/4		sizeof(vec_ushort8) * cArrayIndex
	hbra	.HistMissRet,CodePagingCallMissHandler//1/10	branch hint for return
	ai		$57, $70, 32		//0/2		&pHistTable->funcData
	lqd		$21,16($70)			//1/6		const vec_uint4 lru	= pHistTable->lru (reload)
	ori		$3, $81, 0			//0/2		restore parameter 1
	lqd		$19, 0($70)			//1/6		const vec_uint4 ppuEA	= pHistTable->ppuEA (reload)
	shli	$17,$83,2				//0/4		sizeof(int) * cArrayIndex
	lqx		$13,$58,$59			//1/6		load ((unsigned int*)cFuncTableBaseAddr)[cFuncID]
	a			$14,$58,$59			//0/2		&((unsigned int*)cFuncTableBaseAddr)[cFuncID]
	chd		$54,8($sp)			//1/4		generate controls for destPageID
	ori		$lr,$82,0				//0/2		restore $lr
	chd		$24,6($sp)			//1/4		generate controls for destOffset
	NOP										//0/0
	lqx		$56, $60, $57		//1/6		pHistTable->funcData[cArrayIndex].vecData
	NOP										//0/0
	cwx		$16,$sp,$17			//1/4		gen insertion mask for spu_insert
	ila   $25, 0x0000FFFF	//0/2		load and mask for destOffset
	lqd		$81,(-48+STACK_INCR)($sp)		//1/6		restore register 81 as required by ABI
	NOP										//0/0	
	rotqby $15,$13,$14		//1/4		const unsigned int cFuncEntry = ((unsigned int*)cFuncTableBaseAddr)[cFuncID]
//	NOP										//0/0	
	lqd		$82,(-32+STACK_INCR)($sp)		//1/6		restore register 82 as required by ABI
//	NOP										//0/0	
	shufb	$18,$80,$19,$16	//1/4		pHistTable->ppuEA = spu_insert(cEA, ppuEA, cReplIndex)
	ai		$sp,$sp,STACK_INCR	//0/2		restore stack pointer
	shufb	$22,$75,$21,$16	//1/4		pHistTable->lru		= spu_insert(spu_extract(g_LRUCounter, 0), lru, cReplIndex)
	andc	$26,$15,$25			//0/2		(cFuncEntry & 0xFFFF0000)
	shufb	$71,$15,$56,$54	//1/4		rVecData = spu_insert((unsigned short)(cFuncEntry & 0x0000FFFF), rVecData, 4)
	ceqh  $55, $56, $15		//0/2		compare current page id with dest.page id
	lqd		$80,-16($sp)		//1/6		restore register 80 as required by ABI
	rotmi	$26,$26,-16			//0/4		(cFuncEntry & 0xFFFF0000) >> 16)
	stqd	$18,0($70)			//1/6		save pHistTable->ppuEA
	and		$55, $55, $84		//0/2		if current page id == dest.page id, scWeak flag is selected
	stqd	$22,16($70)			//1/6		save pHistTable->lru
	ori	$4, $85,0					//0/2		restore parameter 2
	lqd		$83,-64($sp)		//1/6		restore register 83 as required by ABI
	ori	$5, $86,0					//0/2		restore parameter 3
	rotqbyi $55,$55,10		//1/4		rotate scWeak into dest.page id-slot
	ori	$6, $87,0					//0/2		restore parameter 4
	shufb	$71,$26,$71,$24	//1/4		rVecData = spu_insert((unsigned short)(cFuncEntry & 0x0000FFFF), rVecData, 4)	
	ori	$7, $88,0					//0/2		restore parameter 5
	lqd	$84,-80($sp)			//1/6		restore register as required by ABI
	ori	$8, $89,0					//0/2		restore parameter 6
	lqd	$85,-96($sp)			//1/6		restore register as required by ABI
	ori	$5, $86,0					//0/2		restore parameter 3
	lqd	$86,-112($sp)			//1/6		restore register as required by ABI
	or	  $71, $71, $55		//0/2		insert scWeak flag
	lqd	$87,-128($sp)			//1/6		restore register as required by ABI
	ori	$9, $90,0					//0/2		restore parameter 7
	lqd	$88,-144($sp)			//1/6		restore register as required by ABI
	ori	$10, $91,0				//0/2		restore parameter 8
	stqx	$71,$60,$57			//1/6		store pHistTable->funcData[cArrayIndex].vecData
	ori	$11, $92,0				//0/2		restore parameter 9
	lqd	$89,-160($sp)			//1/6		restore register as required by ABI	
	ori	$12, $93,0				//0/2		restore parameter 10
	lqd	$90,-176($sp)			//1/6		restore register as required by ABI	
//	NOP										//0/0					
	lqd	$91,-192($sp)			//1/6		restore register as required by ABI		
//	NOP										//0/0					
	lqd	$92,-208($sp)			//1/6		restore register as required by ABI		
//	NOP										//0/0					
	lqd	$93,-224($sp)			//1/6		restore register as required by ABI		
//	NOP										//0/0					
.HistMissRet:	
	br	CodePagingCallMissHandler	//1/4		call code page miss handler
	.size	HistTableFuncLookup, .-HistTableFuncLookup

//--------------------------------------------------------------------------------------------------

//local version where all possible branch targets are within the same page
.text
	.align 6
	.global	LocalHistTabFuncLookup
	.type	LocalHistTabFuncLookup, @function
LocalHistTabFuncLookup:
#if defined(SUPP_SN) && !defined(_NO_SPU_ASSERT)
	ilhu $20,0x07FF				//0/2	  load upper mask for EA (to unmask variant)
	iohl $20,0xFFFC				//0/2	  load lower mask for EA (to unmask variant)
	and $22,$71,$20				//0/2   unmask variant from cEA
	lnop									//1/0
	rotmi	$22,$22,-10			//0/4		cEA / 1024
	clgti $22,$22,256			//0/2		(cEA > 256*1024)?
	brnz	$22,.HTLTestPassed//1/4 if(cEA > 256*1024) continue processing
	NOP										//0/0	
	stop 255							//1/4		custom snPause()
.HTLTestPassed:	
#endif
	ila	$22,66051					//0/2		load mask for shuffling ints into all 4 slots
	lqd $20, 0($70)				//1/6		const vec_uint4 ppuEA	= pHistTable->ppuEA
	lqd $28, 32($70)			//1/6		load funcData
	shufb	$23,$71,$71,$22	//1/4		const vec_uint4 cEA4	= spu_splats(cEA)	
#if defined(DO_SPU_PROFILING)	
	lqa	$39,_ZN4NSPU7NDriver11g_PerfStatsE+96	//1/6		load NSPU::NDriver::g_PerfStats.funcPtrHits
	cwd	$41,0($sp)				//1/4		generate control word for insertion into NSPU::NDriver::g_PerfStats.funcPtrHits
	ai	$42,$39,1					//0/2		++NSPU::NDriver::g_PerfStats.funcPtrHits	
	shufb	$42,$42,$39,$41	//1/4		shuffle into slot
	NOP										//0/0
	stqa	$42,_ZN4NSPU7NDriver11g_PerfStatsE+96	//1/5		store NSPU::NDriver::g_PerfStats.funcPtrHits
#endif
	il	$48,3							//0/2		load 3 for GetReplIndex
	stqa $lr,261616				//1/6		store link register to branch back in case of fn_resolve-failure
	il	$47,2							//0/2		load 2 for GetReplIndex
	lqd $21,16($70)				//1/6		const vec_uint4 lru			= pHistTable->lru
	NOP										//0/0	
	lqa	$72,_ZN4NSPU19g_SPUJobResolveFuncE	//1/6		load g_SPUJobResolveFunc
	ceq	$24,$23,$20				//0/2		const vec_uint4 cCmpRes	= spu_cmpeq(ppuEA, cEA4)
	lnop									//1/0			
//	NOP										//0/0	
//	lnop									//1/0			
	and $29, $28, $24			//0/2		mask matching data for funcData
	gb $25, $24						//1/4		const vec_uint4 cGathRes= spu_gather(cCmpRes)
//	NOP										//0/0	
//	lnop									//1/0			
	selb $30,$21,$75,$24	//0/2		update lru with ppu match mask
	orx	$29, $29					//1/4		move matching data into expected slot
	NOP										//0/0	
	rotqbyi	$40,$21,4			//1/4		const vec_uint4 cVal1			= spu_rlqwbyte(lru, 4) (for GetReplIndex)
//	NOP										//0/0	
	brz $25, .LocalHistMiss	//1/4		IF(cIndex < 0, false) branch
//	NOP										//0/0	
	stqd $30,16($70)			//1/6		store pHistTable->lru
	NOP
	bi	$29								//1/4		call function (no hint possible)
.LocalHistMiss:	
#if defined(DO_SPU_PROFILING)
	cwd	$41,4($sp)				//1/4		generate control word for insertion into NSPU::NDriver::g_PerfStats.funcPtrMisses
	rotqbyi	$42,$39,4			//1/4		rotate NSPU::NDriver::g_PerfStats.funcPtrMisses into pref.slot
	ai $42, $42, 1				//0/2		++NSPU::NDriver::g_PerfStats.funcPtrMisses
	shufb	$42,$42,$39,$41 //1/4		shuffle into slot
	NOP										//0/0
	stqa	$42,_ZN4NSPU7NDriver11g_PerfStatsE+96	//1/5		store NSPU::NDriver::g_PerfStats.funcPtrMisses
#endif
	clgt	$43,$21,$40			//0/2		spu_cmpgt(cVal0, cVal1) (for GetReplIndex)	
	hbr	.LocalFuncIDRetrieval,$72	//1/10	branch hint for function id retrieval
	NOP										//0/0	
	rotqbyi	$41,$21,8			//1/4		const vec_uint4 cVal2 = spu_rlqwbyte(lru, 8) (for GetReplIndex)
	selb	$45,$21,$40,$43	//0/2		const vec_uint4 cCmpSelRes01 = spu_sel(cVal0, cVal1, cCmpVec01)	(for GetReplIndex)	
	rotqbyi	$42,$21,12		//1/4		const vec_uint4 cVal3 = spu_rlqwbyte(lru, 12) (for GetReplIndex)	
	NOP										//0/0	
	stqd	$81,-48($sp)		//1/6		save register 81 as required by ABI
	andi	$49, $43, 1			//0/2		const vec_uint4 cCmpIndexRes01 = spu_sel((vec_uint4)0, (vec_uint4)1, cCmpVec01) (for GetReplIndex)
	stqd	$80,-16($sp)		//1/6		save register 80 as required by ABI
	ori		$81, $3, 0			//0/2		save parameter 1
	stqd	$82,-32($sp)		//1/6		save register 82 as required by ABI
	clgt	$44, $41,$42		//0/2		const vec_uint4 cCmpVec23	= spu_cmpgt(cVal2, cVal3) (for GetReplIndex) 
	rotqbyi $82, $lr, 0		//1/4		save $lr
	ori		$80, $23,0			//0/2		save cEA4
	stqd	$84,-80($sp)		//1/6		save register 84 as required by ABI
	selb	$46,$41,$42,$44	//0/2		const vec_uint4 cCmpSelRes23 = spu_sel(cVal2, cVal3, cCmpVec23) (for GetReplIndex)
	stqd	$83,-64($sp)		//1/6		save register 83 as required by ABI
	ori		$3, $71, 0			//0/2		move cEA into parameter slot
	lnop									//1/0
	selb	$51,$47,$48,$44	//0/2		const vec_uint4 cCmpIndexRes23 = spu_sel((vec_uint4)2, (vec_uint4)3, cCmpVec23) (for GetReplIndex)
	stqd	$85,-96($sp)		//1/6		save register as required by ABI
	clgt	$50, $45,$46		//0/2		const vec_uint4 cCmpVec0123 = spu_cmpgt(cCmpSelRes01, cCmpSelRes23) (for GetReplIndex)
	stqd	$sp,-STACK_INCR($sp)		//1/6		store stack pointer for cRetrFunc
	ori		$85, $4, 0			//0/2		save parameter 2	
	stqd	$86,-112($sp)		//1/6		save register as required by ABI
	selb	$83,$49,$51,$50	//0/2		const vec_uint4 cCmpSelRes0123 = spu_sel(cCmpIndexRes01, cCmpIndexRes23, cCmpVec0123) (for GetReplIndex)
	stqd	$87,-128($sp)		//1/6		save register as required by ABI
	ori		$86, $5,0				//0/2		save parameter 3
	stqd	$88,-144($sp)		//1/6		save register as required by ABI
	ori		$87, $6, 0			//0/2		save parameter 4	
	stqd	$89,-160($sp)		//1/6		save register as required by ABI
	ori		$88, $7, 0			//0/2		save parameter 5	
	stqd	$90,-176($sp)			//1/6		save register as required by ABI
	ori		$89, $8, 0			//0/2		save parameter 6	
	stqd	$91,-192($sp)			//1/6		save register as required by ABI
	ori		$90, $9, 0			//0/2		save parameter 7	
	stqd	$92,-208($sp)			//1/6		save register as required by ABI
	ori		$91, $10, 0			//0/2		save parameter 8	
	stqd	$93,-224($sp)			//1/6		save register as required by ABI
	ori		$92, $11, 0			//0/2		save parameter 9
	ori		$93, $12, 0			//0/2		save parameter 10
	ai		$sp,$sp,-STACK_INCR		//0/2		decrement stack for cRetrFunc	
.LocalFuncIDRetrieval:
	bisl	$lr,$72					//1/4		const int cFuncID = cRetrFunc(cEA)
#if !defined(_NO_SPU_ASSERT)
	ori		$4,	$80,0				//0/2		put cEA into expected parameter slot
	brsl	$lr,	_Z17FuncPtrAssertFuncjj//1/4	call FuncPtrAssertFunc(cFuncID, cEA)
#endif	
	shli	$58,$3,2				//0/4		sizeof(int) * cFuncID
	rotqbyi	$65,$78,12		//1/4		spu_extract(g_SetMaskSL4, 3)
	ila		$22,66051				//0/2		load mask for shuffling ints into all 4 slots
	lqa		$64, _ZN4NSPU14g_PageMemLowerE			//1/6		load g_PageMemLower
	NOP										//0/0			
	lqd		$21,16($70)			//1/6		const vec_uint4 lru	= pHistTable->lru (reload)
	ori		$3, $81, 0			//0/2		restore parameter 1
	lqa		$63, _ZN4NSPU14g_PageMemUpperE			//1/6		load g_PageMemUpper
	shli	$17,$83,2				//0/4		sizeof(int) * cArrayIndex
	lqx		$13,$58,$65			//1/6		load ((unsigned int*)cFuncTableBaseAddr)[cFuncID]
	a			$14,$58,$65			//0/2		&((unsigned int*)cFuncTableBaseAddr)[cFuncID]
	shufb	$59, $82,$82,$22//1/4	const vec_uint4 cLR4 = spu_splats(spu_extract(curLR, 0))
	ori		$lr,$82,0				//0/2		restore $lr
	lqd		$19, 0($70)			//1/6		const vec_uint4 ppuEA	= pHistTable->ppuEA (reload)
	ila   $25, 0x0000FFFF	//0/2		load and mask for destOffset
	cwx		$16,$sp,$17			//1/4		gen insertion mask for spu_insert
//	NOP										//0/0	
//	lnop									//1/0
	clgt	$48, $59, $64		//0/2		const vec_uint4 cLowerAddrCmpRes = spu_cmpgt(cLR4, g_PageMemLower)	
	lqd		$81,(-48+STACK_INCR)($sp)		//1/6		restore register 81 as required by ABI
	NOP										//0/0
	rotqby $15,$13,$14		//1/4		const unsigned int cFuncEntry = ((unsigned int*)cFuncTableBaseAddr)[cFuncID]
	clgt	$47, $63, $59		//0/2		const vec_uint4 cUpperAddrCmpRes = spu_cmpgt(g_PageMemUpper, cLR4)
	lqd		$82,(-32+STACK_INCR)($sp)		//1/6		restore register 82 as required by ABI
	ai		$sp,$sp,STACK_INCR	//0/2		restore stack pointer
	shufb	$18,$80,$19,$16	//1/4		pHistTable->ppuEA = spu_insert(cEA, ppuEA, cReplIndex)
	and		$46, $47, $48		//0/2		const vec_uint4 cCurPageMask	= spu_and(cLowerAddrCmpRes, cUpperAddrCmpRes)	
	shufb	$22,$75,$21,$16	//1/4		pHistTable->lru		= spu_insert(spu_extract(g_LRUCounter, 0), lru, cReplIndex)
	andc	$26,$15,$25			//0/2		(cFuncEntry & 0xFFFF0000)
	lqd		$57, 32($70)		//1/6		load funcData
	and		$45, $46,$64		//0/2		spu_and(cCurPageMask, g_PageMemLower)
	lqd		$80,-16($sp)		//1/6		restore register 80 as required by ABI
	rotmi	$26,$26,-14			//0/4		(cFuncEntry & 0xFFFF0000) >> (16-2)), stored as multiple of 4
	stqd	$18,0($70)			//1/6		save pHistTable->ppuEA
	NOP										//0/0
	orx		$45, $45				//1/4		const uint32 cCurPageEA = spu_extract(spu_orx(spu_and(cCurPageMask, g_SPUPageIndexMask0)), 0)
	ori		$4, $85,0				//0/2		restore parameter 2
	lqd		$83,-64($sp)		//1/6		restore register 83 as required by ABI
	ori		$5, $86,0				//0/2		restore parameter 3
	stqd	$22,16($70)			//1/6		save pHistTable->lru
	ori		$6, $87,0				//0/2		restore parameter 4
	lqd		$85,-96($sp)		//1/6		restore register as required by ABI
	a			$26,$45,$26			//0/2		add current page ea to jump offset
	lqd		$84,-80($sp)		//1/6		restore register as required by ABI
	ori		$5, $86,0				//0/2		restore parameter 3
	lqd		$86,-112($sp)		//1/6		restore register as required by ABI
	ori		$8, $89,0				//0/2		restore parameter 6
	shufb	$57,$26,$57,$16	//1/4		pHistTable->funcData = spu_insert(destOff, pHistTable->funcData, cReplIndex)
	ori		$7, $88,0				//0/2		restore parameter 5
	lqd		$87,-128($sp)		//1/6		restore register as required by ABI
	ori		$9, $90,0				//0/2		restore parameter 7
	lqd		$88,-144($sp)		//1/6		restore register as required by ABI
	ori		$10, $91,0			//0/2		restore parameter 8
	lqd		$89,-160($sp)		//1/6		restore register as required by ABI	
	ori		$11, $92,0			//0/2		restore parameter 9
	stqd	$57, 32($70)		//1/6		save updated funcData
	ori		$12, $93,0			//0/2		restore parameter 10
	lqd		$90,-176($sp)		//1/6		restore register as required by ABI	
//	NOP									//0/0					
	lqd		$91,-192($sp)		//1/6		restore register as required by ABI		
//	NOP									//0/0					
	lqd		$92,-208($sp)		//1/6		restore register as required by ABI		
//	NOP									//0/0					
	lqd		$93,-224($sp)		//1/6		restore register as required by ABI		
//	NOP									//0/0					
	bi		$26							//1/4		call function
	.size	LocalHistTabFuncLookup, .-LocalHistTabFuncLookup


.align	4
.OFFSET:
	.long	32
	.long	48
	.long	64
	.long	80

.align	4
.WEAK:
	.short 0
	.short 0x8000
	.short 0
	.short 0
	.short 0
	.short 0
	.short 0
	.short 0
	
#endif //PS3

