/* 
	implementation of functions to be optimized for size
*/ 

#if defined(PS3)
#if defined(__SPU__)

#define eCryModule eCryM_Launcher
#include <CryModuleDefs.h>
#include <platform.h>
#include <stdio.h>
#include <spu_intrinsics.h>
#include <sys/spu_thread.h>
#include "SPU.h"
#include <IJobManSPU.h>
#include "../PPU/PPU.h"
#include "Memory.h"
#include "SPUMemManager_spu.h"
//include header files for dependency generation (to force recompilation of all jobs)
#include <SPUJobBase.h>
#include "SPUUtilities.h"
#include "./Cache/CacheDefs_spu.h"
#include "CodePage/SPUPages.h"
#include "CodePage/SPUPageLayout.h"
#include "../PPU/ProdConsQueue.h"

namespace NSPU
{
	namespace NDriver
	{
#if defined(DO_SPU_PROFILING)
		extern SJobPerfStats g_PerfStats;
#endif
#ifdef DO_SPU_FUNCPROFILING
		extern NSPU::SFuncProfSPUTiming g_FuncProfData;
#endif
	}

	extern SPageDirInfo g_PageInfo _ALIGN(16);
#ifdef DO_SPU_FUNCPROFILING
	void TransferFuncProfStats()
	{
//		IF((NSPU::g_PageInfo.profilingEnabled == 2),0)
		{
			//first obtain lock
			const uint32 cLockEA = NSPU::NDriver::g_FuncProfData.funcProfTimingAreaEA;
			uint32 lockBuffer[128/sizeof(uint32)] _ALIGN(128);
			mfc_prep(lockBuffer, cLockEA);
			int status = 1;
			do
			{
				mfc_getllar_again();
				mfc_read_atomic_status();
				IF(lockBuffer[0] == 0, true)
				{
					lockBuffer[0] = 1;
					mfc_putllc_again();
					status = mfc_read_atomic_status();
				}
				else
				{
					status = 1;
					for(uint32 i=0; i<64; ++i)
					{
						asm volatile("nop");
						asm volatile("nop");
						asm volatile("nop");
						asm volatile("nop");
					}
				}
			}
			while(status != 0);
			//transfer exist. values here
			const uint32 cFuncProfileCnt = NSPU::NDriver::g_FuncProfData.funcProfileCount;
			const uint32 cTransferSize = NSPU::AlignSize128(cFuncProfileCnt*4*2);
			uint32 localStorage[cTransferSize/sizeof(uint32)] _ALIGN(128);
			const uint32 cJobTimingEA = cLockEA + NSPU::NDriver::g_FuncProfData.jobTimingAreaOffset;
			MemcpyLS(localStorage, cJobTimingEA, cTransferSize, g_scMemCpyTag);
			SyncMemory(g_scMemCpyTag);
			//now accumulate existing values, convert to usec
			uint32 *__restrict pCurTimingSPU = (uint32*)NSPU::NDriver::g_FuncProfData.funcProfSPUTimingAreaBss;
			uint32 *__restrict pCurTimingPPU = localStorage;
			const float cInvTB = 1000.f / 79800.f;//inverse ticks per usec
			for(uint32 i=0;i<cFuncProfileCnt;++i)
			{
				const uint32 cCurValue = *pCurTimingSPU;
				*pCurTimingSPU = 0;
				++pCurTimingSPU;
				*pCurTimingPPU += (uint32)((float)cCurValue * cInvTB);//usec
				++pCurTimingPPU;
				*pCurTimingPPU += *pCurTimingSPU;//count
				*pCurTimingSPU = 0;
				++pCurTimingSPU;
				++pCurTimingPPU;
			}
			//transfer back
			MemcpyMainFenced(cJobTimingEA, localStorage, cTransferSize, g_scMemCpyTag);
			//release lock
			lockBuffer[0] = 0;
			MemcpyMainFenced(cLockEA, lockBuffer, 128, g_scMemCpyTag);
			SyncMemory(g_scMemCpyTag);
		}
	}
#endif
}

//---------------------------------------------ppu calls------------------------------------------------

/*
void LogMessageV(const char* szFormat, va_list args)
{
#if defined(SUPP_PRINTF)
	char buffer[4096];
	vsprintf_spu(buffer, szFormat, args);
	printf(buffer);
#else
	printf(szFormat);
#endif
}
*/

//---------------------------------------------function pointers----------------------------------------

const uint32 FuncPtrAssertFunc(const uint32 cFuncID, const uint32 cEA)
{
	#define CMP_MASK (0xF8000003)	//7 bits used for variant encoding
#if !defined(_NO_SPU_ASSERT)
	if(cFuncID == 0xFFFFFFFF)
	{
#endif
		printf("fn_resolve:addr.mismatch(0x%08x | 0x%08x)\n",cEA & ~CMP_MASK,cEA & CMP_MASK);
#if defined(SUPP_SN)
		__asm volatile ("stop 254");
#endif
#if !defined(_NO_SPU_ASSERT)
		return cFuncID;
	}
	const unsigned int cFuncTableBaseAddr = spu_extract(g_SetMaskSL4, 3);
	/*
	if(cFuncTableBaseAddr == 0)
	{
	printf("Func.table not found\n");
	#if defined(SUPP_SN)
	__asm volatile ("stop 255");
	#endif
	}
	*/
	const unsigned int cFuncEntry = ((unsigned int*)cFuncTableBaseAddr)[cFuncID];
	if(cFuncEntry == 0xFFFFFFFF)
	{
		printf("Func.ptr entry invalid for cEA=0x%08x   FuncID=%d\n",cEA, cFuncID);
#if defined(SUPP_SN)
		__asm volatile ("stop 254");
#endif
	}
	const unsigned int cDebugFuncTableBaseAddr = spu_extract(g_SetMaskSL4, 2);
	if(cDebugFuncTableBaseAddr)
	{
		const uint32 cDebugEA = ((unsigned int*)cDebugFuncTableBaseAddr)[cFuncID];
		const uint32 cUnMaskedDebugEA = cDebugEA & ~CMP_MASK;
		const uint32 cUnMaskedEA = cEA & ~CMP_MASK;
		//printf("func ptr: index=%d   spu addr=%d(0x%08x)  ppu=0x%08x\n",cFuncID,cFuncEntry,cFuncEntry,cUnMaskedDebugEA);
		if(cDebugEA != 0 && cUnMaskedDebugEA != cUnMaskedEA)
		{
			printf("Func.ptr entry mismatch: ea=0x%08x (exp.ea=0x%08x, FuncID=%d)\n",cUnMaskedDebugEA, cUnMaskedEA, cFuncID);
#if defined(SUPP_SN)
			__asm volatile ("stop 254");
#endif
		}
	}
#endif//_NO_SPU_ASSERT
	#undef CMP_MASK
	return cFuncID;//this way $3 can be maintained in asm
}

//---------------------------------------------custom callback----------------------------------------

#endif //__SPU__
#endif //PS3
