/* 
	SPU memory structure
*/

#ifndef __SPU_LOADER_DEFS_H
#define __SPU_LOADER_DEFS_H
#pragma once

#if defined(PS3)

#include "Cache/CacheDefs_spu.h"

namespace NSPU
{
	static const unsigned int scLSSize							= 0x40000;		//size of local storage

	static const unsigned int scLoaderProgSize			= 384;				//total spu loader program(text+data) size
	static const unsigned int scLoaderParamsStart		= 0x3FF90;		//parameter start address of SPU loader
	static const unsigned int scLoaderProgramStart	= 0x3FE10;		//spu loader start address
	static const unsigned int scLoaderTextSizeBytes = 0x0000C0;		//size of loader instruction dump
	static const unsigned int scLoaderTextStart			= 0x0003FE10;	//address where instruction will start in spu local space
	static const unsigned int scLoaderDataSizeBytes = 0x000080;		//number of bytes data section of spu loader has
	static const unsigned int scLoaderDataStart			= 0x0003FF10;	//start address of spu loader data
	static const unsigned int scMemoryStackBase			= 0x3FE00;
	static const unsigned int scMemoryStackSize			= 16 * 1024;	//16 KB stack
	static const unsigned int scHeapTopAddress			= scMemoryStackBase - scMemoryStackSize;	//top heap address

	// per-binary parameters that are passed to the initial SPU loader program
	struct SLoaderBinParams 
	{
		unsigned int imageSize;         //image size, in bytes
		unsigned int imageEAhi;         //hi-order 32-bits of image addr
		unsigned int imageEAlow;        //lo-order 32-bits of image addr
		unsigned int destLS;            //local store destination
		unsigned int entry;             //entry point for application
		unsigned int lsLimit;           //local store limit setting
		unsigned int elfEAhi;						//hi-order 32-bits of SPU-ELF
		unsigned int elfEAlow;					//lo-order 32-bits of SPU-ELF
	};

	//per-thread parameters that are passed to the initial spu loader program 
	struct SLoaderThreadParams 
	{
		unsigned int gpr3[4];           //initial setting for $3
		unsigned int gpr4[4];           //initial setting for $4
		unsigned int gpr5[4];           //initial setting for $5
		unsigned int gpr6[4];           //initial setting for $6
	};

	//per loader parameters that are passed	to the initial SPU loader program
	//it allows relocation of the program branched to by the initial spu program
	struct SLoaderSoParams
	{
		unsigned int loaderEAhi;
		unsigned int loaderEAlow;
		unsigned int loaderSize;
		unsigned int loaderFlags;
	};

	//loader information which is passed to the initial spu loader program by operating system environment
	//structure is placed at location scLoaderParamsStart
	struct SLoaderParams 
	{
		struct SLoaderBinParams			bin;   //per-binary ldr parameters
		struct SLoaderThreadParams	thr;   //per-thread ldr parameters
		struct SLoaderSoParams			ldr;   //per-loader parameters
	};
}//NSPU

#endif //PS3
#endif //__SPU_LOADER_DEFS_H
