#if defined(PS3)

/*
	Dump of initial SPU loader (generated from spu_ldr.S sample)
	DO NOT EDIT
	
	Each SPU-ELF binary file may designate an application-specific loader 
	program, refered to here as "spu_ld.so".  The spu_ld.so is a special 
	program whose job is to "pull" the binary from system memory and put
	its image into SPU local store, then initialize the run-time environment 
	per the ABI.
	
	In the interest of supporting generic spu_ld.so programs, conventions 
	are defined with regard to the size and location the loader program.  
	Specifically, the application's spu_ld.so and parameters are downloaded 
	to fixed locations in local store by the OS, and the spu_ld.so size is 
	limited to a maximum of 384 bytes.
	
	The steps performed by this program are:
	
		1. Read image size & ea values from parameter area.
		2. Construct a 16-element DMA list.
		3. Start an MFC_GETL_CMD.
		4. Wait for MFC_GETL_CMD to complete.
		5. Pre-initialize values of gpr[3..6] with thread data.
		6. Branch to application entry point (bi 0)
	
	Notes: The maximum size for an spu_ld.so program is 384 bytes.
				 The text section for this program is 256 bytes; the remaining 
				 128 bytes used for DMA list storage.
*/

///* spu_ldr.S
//*
//* This file contains a sample implementation of an SPU loader program 
//* for the BE-Linux environment.
//*
//* Each SPU-ELF binary file may designate an application-specific loader 
//* program, refered to here as "spu_ld.so".  The spu_ld.so is a special 
//* program whose job is to "pull" the binary from system memory and put
//* its image into SPU local store, then initialize the run-time environment 
//* per the ABI.
//*
//* In the interest of supporting generic spu_ld.so programs, conventions 
//* are defined with regard to the size and location the loader program.  
//* Specifically, the application's spu_ld.so and parameters are downloaded 
//* to fixed locations in local store by the OS, and the spu_ld.so size is 
//* limitted to a maximum of 384 bytes.
//*
//* The spu_ld.so parameters are defined in <spu_ldr.h>; byte offsets into
//* the parameter data structures are computed by the ../include/mk_ldr_defs 
//* utility.
//*
//* The steps performed by this program are:
//*
//*   1. Read image size & ea values from parameter area.
//*   2. Construct a 16-element DMA list.
//*   3. Start an MFC_GETL_CMD.
//*   5. Wait for MFC_GETL_CMD to complete.
//*   6. Pre-initialize values of gpr[3..6] with thread data.
//*   8. Branch to application entry point.
//*
//* Notes: The maximum size for an spu_ld.so program is 384 bytes.
//* The text section for this program is 256 bytes; the remaining 
//* 128 bytes used for DMA list storage.
//*/
//
//#define LS_SIZE                  	0x40000
//#define _MFC_MAX_DMA_SIZE         	0x4000
//#define _MFC_TAG_UPDATE_ALL       	2
//#define MFC_GETL_CMD             	0x44
//
///* total program(text+data) size */
//#define SPU_LDR_PROG_size               384
///* data section: dma list size */
//#define DMA_LIST_sizeof                 128
///* text size */
///* #define SPU_LDR_PROG_text_size (SPU_LDR_PROG_size-MA_LIST_sizeof) */
//#define SPU_LDR_PROG_text_size          256
///* parameter size */
//#define SPU_LDR_PARAMS_sizeof           112
//
//
///* memory layout for ldr */
///* param section */
///* param start =   (LS_SIZE-SPU_LDR_PARAMS_sizeof) */
//#define SPU_LDR_PARAMS_start            0x3FF90
///* data section for dma_list */
//#define SPU_LDR_PROG_data_start         0x3FF10
///* ldr starts addr */
//#define SPU_LDR_PROG_start		0x3FE10
///* define stack start addr */
//#define PC_SPU_MEMORY_MAP_STACK_BASE    0x3FE00
//
///* ---- SCEI SECTION END ---- */
//
//#define SPU_NOP_INSTR            	0x40200000
//#define TAGID                    	0
//#define TAGMASK                  	1
//
///* Byte offsets for per-binary parameters. */
//#define SPU_LDR_PARAMS_img_size   	0
//#define SPU_LDR_PARAMS_img_ea_hi  	4
//#define SPU_LDR_PARAMS_img_ea_low 	8
//#define SPU_LDR_PARAMS_dst_ls     	12
//#define SPU_LDR_PARAMS_entry      	16
//#define SPU_LDR_PARAMS_lslr       	20
//#define SPU_LDR_PARAMS_elf_ea_hi  	24
//#define SPU_LDR_PARAMS_elf_ea_low 	28
//
///* Byte offsets for per-thread parameters. */
//#define SPU_LDR_PARAMS_gpr3      	32
//#define SPU_LDR_PARAMS_gpr4      	48
//#define SPU_LDR_PARAMS_gpr5      	64
//#define SPU_LDR_PARAMS_gpr6      	80
//
///* Byte offsets for per-loader parameters. */
//#define SPU_LDR_PARAMS_ldr_ea_hi 	96
//#define SPU_LDR_PARAMS_ldr_ea_low	100
//#define SPU_LDR_PARAMS_ldr_size  	104
//#define SPU_LDR_PARAMS_ldr_flags 	108
//
///* Byte offsets for DMA lists. */	
//#define SPU_DMA_LIST_ELEM_ea_low  	4
//#define SPU_DMA_LIST_ELEM_sizeof  	8
//#define SPU_DMA_LIST_ELEM_size    	0
//#define NUM_ELEMENTS             	16
//#define NUM_ELEMENTS_x2          	8
//#define E0_size                  	0
//#define E0_ea_low                	4
//#define E1_size                  	8
//#define E1_ea_low                	12
//
//
//.data
//.align 3
//dma_list:
//.space  DMA_LIST_sizeof 
//.size   dma_list, DMA_LIST_sizeof
//
//.text
//.align 2
//.globl _start
//.text
//_start:
//
///* 1. Initialize parameters for build_dma_list.  The loader 
//*    parameters are stored at location SPU_LDR_PARAMS_start.  
//*    Register usage at this point is not strict, as we will
//*    clean these up later.
//*
//* output registers:
//*  $3	transfer size, in bytes
//*  $4	lower 32-bits of starting EA
//*/
//
///* clear $0 and $7 */
//
///* --------------------------------------------------
//* PLEASE DO NOT MODIFY THIS SECTION
//Cell Evaluation System 040.007                      
//* Copyright(C) 2005 Sony Computer Entertainment Inc.
//* --------------------------------------------------
//*/
//ila	$0,0
//ila	$7,0
///* --- SCEI SECTION END ------------------------------ */
//
//lqa	$3, SPU_LDR_PARAMS_start
//rotqbyi $4, $3, SPU_LDR_PARAMS_img_ea_low
//
///* 2. build_dma_list - Construct a 16 element DMA list, given the 
//*    image size [in bytes] and starting EA.  Each resulting element 
//*    size is in the range [0.._MFC_MAX_DMA_SIZE].  If the total size 
//*    is less than _MFC_MAX_DMA_SIZE * 16, then unused elements in the 
//*    list will have a size of 0.
//*
//* input registers:
//*  $0      contains 0
//*	$3	transfer size, in bytes
//*	$4	lower 32-bits of starting EA
//*  $7      contains 0
//*/
//build_dma_list:
///* 2.1 Initialize constants. */
//il      $8, _MFC_MAX_DMA_SIZE
//
///* 2.2 Generate shuffle patterns so that we can build
//*     two DMA list elements at a time.
//*/
//cwd     $5,  E0_ea_low($0)
//cwd     $15, E1_size($0)
//cwd     $6,  E1_ea_low($0)
//ila     $18, dma_list
//build_dma_list_loop:
///* 2.3 Put first two element sizes into respective slots. */
//lr      $12, $3
///* a       $3, $3, $17 */
//sf      $3, $8, $3
//shufb   $12, $3, $12, $15
///* a       $3, $3, $17 */
//sf      $3, $8, $3
//
///* 2.4 If either are greater than maximum, clamp. */
//cgt     $14, $12, $8
//selb    $12, $12, $8, $14
//
///* 2.5 If either are less than zero, clamp. */
//cgt     $13, $12, $0
//selb    $12, $0, $12, $13
//
///* 2.6 Insert the two element EA's into respective slots. */
//shufb   $12, $4, $12, $5
//a       $4, $4, $8
//shufb   $12, $4, $12, $6
//a       $4, $4, $8
//
///* 2.7 Store the element to dma_list. */
//stqx    $12, $7, $18
//
///* 2.8 Increment loop counter and prepare for next iteration. */
//ai      $7, $7, 16
//cgti    $11, $7, 16*(NUM_ELEMENTS_x2 - 1)
//brz     $11, build_dma_list_loop
//
///* 3. initiate_dma - Start an MFC_GETL_CMD, in order to "pull" 
//*    the SPU-ELF binary from system memory into local store.  
//*
//* input registers:
//*   $0  	contains 0, which is the TAGID we're using
//*   $18 	contains the local store start for 'dma_list'
//*/
//initiate_dma:
///* 3.1 Pre-initialize registers with DMA information. */
//lqa	$7, SPU_LDR_PARAMS_start
//rotqbyi $1, $7, SPU_LDR_PARAMS_dst_ls
//rotqbyi $2, $7, SPU_LDR_PARAMS_img_ea_hi
//ila	$4, DMA_LIST_sizeof
//ila	$6, MFC_GETL_CMD
//
///* 3.2 Submit MFC_GETL_CMD. */
//wrch	$MFC_LSA, $1
//wrch	$MFC_EAH, $2
//wrch	$MFC_EAL, $18
//wrch	$MFC_Size, $4
//wrch	$MFC_TagID, $0
//wrch	$MFC_Cmd, $6
//
///* 5. wait_dma - Wait for MFC_GETL_CMD to complete.
//*/
//wait_dma:
//il	$0, TAGMASK
//wrch	$MFC_WrTagMask, $0
//il	$0, _MFC_TAG_UPDATE_ALL
//wrch	$MFC_WrTagUpdate, $0
//rdch	$0, $MFC_RdTagStat
//
///* 6. Pre-initialize values of gpr[3..5] with thread data.
//*/
//initialize_regs:
//lqa	$3, SPU_LDR_PARAMS_start + SPU_LDR_PARAMS_gpr3
//lqa	$4, SPU_LDR_PARAMS_start + SPU_LDR_PARAMS_gpr4
//lqa	$5, SPU_LDR_PARAMS_start + SPU_LDR_PARAMS_gpr5
//lqa	$6, SPU_LDR_PARAMS_start + SPU_LDR_PARAMS_gpr6
//
///* set stack */
//ila     $1, PC_SPU_MEMORY_MAP_STACK_BASE
//
///* 8. Branch to application entry point.
//*/
//
//branch_entry:
//
//lqa	$0, SPU_LDR_PARAMS_start + SPU_LDR_PARAMS_entry
//bi	$0  
//.balignl 16, SPU_NOP_INSTR




#ifndef __SPU_LOADER_DUMP_H
#define __SPU_LOADER_DUMP_H
#pragma once

#define SPU_LDR_TEXT \
{ \
  0x42000000, \
  0x42000007, \
  0x30fff203, \
  0x3f820184, \
  0x40a00008, \
  0x3ec10005, \
  0x3ec2000f, \
  0x3ec30006, \
  0x43ff8812, \
  0x0400018c, \
  0x0800c403, \
  0xb183018f, \
  0x0800c403, \
  0x4802060e, \
  0x8182060e, \
  0x4800060d, \
  0x8183000d, \
  0xb1830205, \
  0x18020204, \
  0xb1830206, \
  0x18020204, \
  0x2884838c, \
  0x1c040387, \
  0x4c1c038b, \
  0x207ff88b, \
  0x30fff207, \
  0x3f830381, \
  0x3f810382, \
  0x42004004, \
  0x42002206, \
  0x21a00801, \
  0x21a00882, \
  0x21a00912, \
  0x21a00984, \
  0x21a00a00, \
  0x21a00a86, \
  0x40800080, \
  0x21a00b00, \
  0x40800100, \
  0x21a00b80, \
  0x01a00c00, \
  0x30fff603, \
  0x30fff804, \
  0x30fffa05, \
  0x30fffc06, \
  0x43ff0001, \
  0x30fff400, \
  0x35000000, \
} 

#endif //PS3
#endif //__SPU_LOADER_DUMP_H
