/* 
	definitions of all used gcm functions with its local SPU gcm-context
*/

#ifndef __GCM_MAPPING_H
#define __GCM_MAPPING_H
#pragma once

#if defined(PS3) 
		
#include <platform.h>
#ifndef __CRYCG__
	#define SPU_DOMAIN_LOCAL
#endif
//libgcm specific stuff to work arround custom sdk changes
typedef struct CellGcmLocalContextData
{
	SPU_DOMAIN_LOCAL uint32_t *__restrict begin;
	SPU_DOMAIN_LOCAL uint32_t *__restrict end;
	SPU_DOMAIN_LOCAL uint32_t *__restrict current;
	SPU_DOMAIN_LOCAL void* callback;
}
CellGcmLocalContextData;

#if !defined(JOB_LIB_COMP)
extern CellGcmLocalContextData *__restrict thisContext 
#ifdef __CRYCG__
	__attribute__ ((crycg_domain ("LOCAL"))) __attribute__ ((crycg_attr (spu_local,"__ALL__")))
#endif	
;

#ifdef __SPU__
  #define _cg_types_h
  typedef int CGbool;
  #define CG_FALSE ((CGbool)0)
  #define CG_TRUE ((CGbool)1)
  typedef struct _CGcontext *CGcontext;
  typedef struct _CGprogram *CGprogram;
  typedef struct _CGparameter *CGparameter;
  #ifndef CG_NO_CGFX_API
  typedef struct _CGeffect *CGeffect;
  typedef struct _CGtechnique *CGtechnique;
  typedef struct _CGpass *CGpass;
  typedef struct _CGstate *CGstate;
  typedef struct _CGstateassignment *CGstateassignment;
  typedef struct _CGannotation *CGannotation;
  #endif /* CG_NO_CGFX_API */
  typedef void *CGhandle;
  enum CGtype
   {
    CG_UNKNOWN_TYPE,
    CG_STRUCT,
    CG_ARRAY,
  
    CG_TYPE_START_ENUM = 1024,
  # define CG_DATATYPE_MACRO(name, compiler_name, enum_name, base_name, ncols, nrows, pc) \
    enum_name ,
  
  #include <Cg/cg_datatypes.h>
  
  # undef CG_DATATYPE_MACRO
  
   };
  #ifndef __cplusplus
  typedef enum CGtype CGtype;
  #endif
  enum CGresource
   {
  # define CG_BINDLOCATION_MACRO(name,enum_name,compiler_name,\
                                 enum_int,addressable,param_type) \
    enum_name = enum_int,
  
  #include <Cg/cg_bindlocations.h>
  
    CG_UNDEFINED = 3256,
  
   };
  #ifndef __cplusplus
  typedef enum CGresource CGresource; 
  #endif
  enum CGprofile
   {
    CG_PROFILE_START = 6144,
    CG_PROFILE_UNKNOWN,
  
  # define CG_PROFILE_MACRO(name, compiler_id, compiler_id_caps, compiler_opt,int_id,vertex_profile) \
     CG_PROFILE_##compiler_id_caps = int_id,
    
  #include <Cg/cg_profiles.h>
  
    CG_PROFILE_MAX = 7100,
   };
  #ifndef __cplusplus
  typedef enum CGprofile CGprofile;
  #endif
  enum CGerror
   {
  # define CG_ERROR_MACRO(code, enum_name, message) \
     enum_name = code,
  # include <Cg/cg_errors.h>
   };
  #ifndef __cplusplus 
  typedef enum CGerror CGerror; 
  #endif
  enum CGenum
   {
  # define CG_ENUM_MACRO(enum_name, enum_val) \
     enum_name = enum_val,
  # include <Cg/cg_enums.h>
   };
  #ifndef __cplusplus
  typedef enum CGenum CGenum;
  #endif
  enum CGparameterclass
   {
    CG_PARAMETERCLASS_UNKNOWN = 0,
    CG_PARAMETERCLASS_SCALAR,
    CG_PARAMETERCLASS_VECTOR,
    CG_PARAMETERCLASS_MATRIX,
    CG_PARAMETERCLASS_STRUCT,
    CG_PARAMETERCLASS_ARRAY,
    CG_PARAMETERCLASS_SAMPLER,
    CG_PARAMETERCLASS_OBJECT
   };
  #ifndef __cplusplus
  typedef enum CGparameterclass CGparameterclass; 
  #endif
  enum CGdomain
  {
      CG_UNKNOWN_DOMAIN = 0,
      CG_FIRST_DOMAIN   = 1,
      CG_VERTEX_DOMAIN  = 1,
      CG_FRAGMENT_DOMAIN,
      CG_GEOMETRY_DOMAIN,
      CG_NUMBER_OF_DOMAINS
  };
  #ifndef __cplusplus
  typedef enum CGdomain CGdomain; 
  #endif
	#include <Cg/cg.h>
  #define CGprogram uint32_t*
	#define __CELL_GCM_SPU_H__
	#ifndef _STDINT
		#include <stdint.h>
	#endif
	#ifndef _STDBOOL
		#include <stdbool.h>
	#endif
	#include <cell/gcm/gcm_error.h>
	#include <cell/gcm/gcm_macros.h>
	#include <cell/gcm/gcm_helper.h>
	#include <cell/gcm/gcm_methods.h>
	#include <cell/gcm/gcm_enum.h>
	#include <cell/gcm/gcm_struct.h>

	#ifndef SPU_DEBUG_BREAK_ALWAYS
 		#define SPU_DEBUG_BREAK_ALWAYS __asm volatile ("stop 255")  
	#endif
	#ifndef CELL_GCM_MEMCPY
		#define CELL_GCM_MEMCPY __builtin_memcpy
	#endif

//#define OVERWRITE_ASSERTS
	#ifndef OVERWRITE_ASSERTS
		#if defined(_NO_SPU_ASSERT)
			#undef CELL_GCM_ASSERT
			#undef CELL_GCM_ASSERTS
			#undef CELL_GCM_RESERVE
			#define CELL_GCM_ASSERT(a)
			#define CELL_GCM_ASSERTS(a, mess)
			#define CELL_GCM_RESERVE(size)
		#else
			#define CELL_GCM_ASSERT_ENABLE
			#if !defined(__CRYCG__)
				#undef CELL_GCM_RESERVE
				#define CELL_GCM_RESERVE(a) assert((unsigned int)a + (unsigned int)GetGcmSPUData()->contextData.current - ((unsigned int)GetGcmSPUData()->contextData.begin + GetGcmSPUData()->localContextOffset) < LOCAL_SPU_CMD_BUF_SIZE)
				#undef CELL_GCM_ASSERT
				#define CELL_GCM_ASSERT(a) assert(a)
				#undef CELL_GCM_ASSERTS
				#define CELL_GCM_ASSERTS(a,mess) assert(a)
			#endif//__CRYCG__
		#endif
	#else
		#undef CELL_GCM_RESERVE
		#define CELL_GCM_RESERVE(a) IF(!((unsigned int)a + (unsigned int)GetGcmSPUData()->contextData.current - ((unsigned int)GetGcmSPUData()->contextData.begin + GetGcmSPUData()->localContextOffset) < LOCAL_SPU_CMD_BUF_SIZE),0)snPause()
		#undef CELL_GCM_ASSERT
		#define CELL_GCM_ASSERT(a) IF(!(a), 0)snPause()
		#undef CELL_GCM_ASSERTS
		#define CELL_GCM_ASSERTS(a,mess) IF(!(a), 0)snPause()
		#define CELL_GCM_ASSERT_ENABLE
	#endif

	#define __CELL_GCM_COMMAND_C_H__
	#define CELL_GCM_THIS (struct CellGcmLocalContextData*)thisContext
	#define CELL_GCM_CURRENT (CELL_GCM_THIS)->current
	#define CELL_GCM_END (CELL_GCM_THIS)->end
	#define CELL_GCM_CALLBACK (CELL_GCM_THIS)->callback
	#define CELL_GCM_CALLEE(a) cellGcm ## a
	#define CELL_GCM_GLOBAL_DECL inline __attribute__((always_inline))
	#define CELL_GCM_NO_ARGS_FUNC()	thisContext
	#define CELL_GCM_ARGS_FUNC(...)	thisContext, __VA_ARGS__
	#define CELL_GCM_FUNC(func)	cellGcm ## func
	#define CELL_GCM_DECL inline __attribute__((always_inline))
	#define CELL_GCM_MEASURE 0
	#define CELL_GCM_INLINE 1
	#define CELL_GCM_UNSAFE 1
	#define	CELL_GCM_FUNCTION_MACROS
	#define CELL_GCM_RESERVE(count) do { } while(false)
	#define CELL_GCM_RESERVE_RET(count, value) do { } while(false)
	#define CELL_GCM_MODE	CELL_GCM_CPP_EXPLICIT_NAMESPACE
	#define __CELL_GCM_COMMAND_CPP_EXPLICIT_H__
	#define CELL_GCM_FUNC_TYPE void
	#define CELL_GCM_FUNC_TYPE_INT32	int32_t
	#define CELL_GCM_FUNC_TYPE_UINT32	uint32_t
	#define CELL_GCM_FUNC_RETURN return
	#define CELL_GCM_FUNC_RETURN_CELL_OK return CELL_OK
	#define	CELL_GCM_ASM_IN()
	#define	CELL_GCM_ASM_OUT()
	#define CELL_GCM_ASM_RESERVE(count, args)	CELL_GCM_RESERVE(count)
	#define CELL_GCM_ASM_RESERVE_IMM(count, args)	CELL_GCM_RESERVE(count)
	#define CELL_GCM_ASM_RESERVE_REG(count, args)	CELL_GCM_RESERVE(count)
	namespace cell{namespace Gcm{namespace UnsafeInline{
		#undef CELL_GCM_NO_ARGS
		#undef CELL_GCM_ARGS
		#define CELL_GCM_NO_ARGS() CellGcmLocalContextData* thisContext
		#define CELL_GCM_ARGS(...)  CellGcmLocalContextData* thisContext, __VA_ARGS__
		#undef __PPU__
		#include <cell/gcm/gcm_prototypes_sub.h>
		#include <cell/gcm/gcm_implementation_sub.h>
		#undef CELL_GCM_UNSAFE
		#undef CELL_GCM_INLINE
	}}}
	#undef CELL_GCM_MODE
	#include <cell/gcm/gcm_cg_extension.h>
#else//__SPU__
	#include <cell/gcm.h>
#endif//__SPU__
#endif//JOB_LIB_COMP

//same settings as in CCryDXPSGCM_CMBMan.hpp and CCryDXPSGCM_SyncMan.hpp
#define GCM_CMD_SIZE	0x100000
#define GCM_CMD_SEGMENTSIZE	(32*1024)
#define GCM_CMD_SEGMENTCOUNT (GCM_CMD_SIZE/GCM_CMD_SEGMENTSIZE)
#define GCM_CMD_SEGMENTMASK (GCM_CMD_SEGMENTCOUNT-1)
#define ECDXPSSL_BUFFERBITS 14
#define ECDXPSSL_BUFFERSIZE (1<<ECDXPSSL_BUFFERBITS)
#define ECDXPSSL_BUFFERSIZEMASK (ECDXPSSL_BUFFERSIZE-1)
#define ECDXPSSL_BUFFERCOUNT (1<<2)
#define ECDXPSSL_BUFFERCOUNTMASK (ECDXPSSL_BUFFERCOUNT-1)

#define LOCAL_SPU_CMD_BUF_SIZE GCM_CMD_SEGMENTSIZE

//keep in sync with definition in crycg
typedef struct CellGcmSPUData
{
	CellGcmLocalContextData contextData;
	uint32_t RSXPutPtrArea[4] __attribute__ ((aligned(16)));
	uint32_t globalPPUContextMem[sizeof(CellGcmLocalContextData) * 2 / sizeof(uint32)] __attribute__ ((aligned(16)));
	uint32_t localContextOffset;
	SPU_DOMAIN_LOCAL CellGcmContextData *pGlobalPPUContext;//will point into g_GlobalPPUContextMem
	SPU_DOMAIN_LOCAL uint8_t *__restrict pLocalCmdBuffer;
	uint32_t rsxPushOffset;	//offset for rsx push
	uint32_t rsxWaitTime;//flush measures time it waited for rsx, used for profiling
	uint32_t perfTime0;	//custom performance counter 0
	uint32_t perfTime1;	//custom performance counter 1
	uint32_t perfTime2;	//custom performance counter 2
	uint32_t perfTime3;	//custom performance counter 3
	uint32_t localPSBufferSize;	//local  pixel shader buffer size
	SPU_DOMAIN_LOCAL uint8_t * __restrict pLocalPSBuffer;//local pixel shader buffer
	uint32_t psBufferTransferInFlight;	//1 if pixel shader transfer in flight
	uint32_t localVSBufferSize;					//local vertex shader buffer size
	SPU_DOMAIN_LOCAL uint8_t * __restrict pLocalVSBuffer;//local vertex shader buffer
	uint32_t lastUsedSegment;	//last used segment for cmd buffer syncing
	uint64_t SegmentHandle[GCM_CMD_SEGMENTCOUNT];//segment buffer
	uint32_t reportAreaLocSet;//1 if report area has been set for 1st draw call
} CellGcmSPUData __attribute__ ((aligned(16)));

enum	ECDXPSSyncLabelReserv
{
	ECDXPSSLR_BEGIN			=	128,
	ECDXPSSLR_VSYNC0,
	ECDXPSSLR_VSYNC1,
	ECDXPSSLR_INJECTSYNC,
	ECDXPSSLR_INJECTREPORT,
	ECDXPSSLR_RESERVED
};

enum	ECDXPS_SLabel
{
	ECDXPSSL_DRAWCALL = 0,
	ECDXPSSL_COUNT
};

ILINE uint32 StampOffset(uint32 Counter)
{
	Counter&=(ECDXPSSL_BUFFERCOUNTMASK<<ECDXPSSL_BUFFERBITS)|ECDXPSSL_BUFFERSIZEMASK;
	return Counter+ECDXPSSLR_RESERVED;
}

#if !defined(__SPU__)
	extern void cellGcmAddRSXWaitTicks(const unsigned long long cStart, const unsigned long long cTicks);
	extern void cellGcmAddRSXStallTicks(const unsigned long long cStart, const unsigned long long cTicks);
	extern void cellGcmGetAndResetRSXWaitTicks();
#endif



#if defined(__SPU__) && !defined(JOB_LIB_COMP)

struct _CGprogram;
struct _CGpaparameter;

#ifndef ILINE
	#define ILINE __attribute__((always_inline)) inline
#endif

#define THIS_CONTEXT (CellGcmLocalContextData*)SPU_LOCAL_PTR(thisContext)

ILINE void cellGcmSetWaitLabel(const uint8_t index, const uint32_t value)
{
	cell::Gcm::UnsafeInline::cellGcmSetWaitLabel(THIS_CONTEXT,index, value);
}

ILINE void cellGcmSetWriteCommandLabel(const uint8_t index, const uint32_t value)
{
	cell::Gcm::UnsafeInline::cellGcmSetWriteCommandLabel(THIS_CONTEXT,index, value);
}

ILINE void cellGcmSetWriteBackEndLabel(const uint8_t index, const uint32_t value)
{
	cell::Gcm::UnsafeInline::cellGcmSetWriteBackEndLabel(THIS_CONTEXT, index, value);
}

ILINE void cellGcmSetTextureControl(const uint8_t index, const uint32_t enable, const uint16_t minLod, const uint16_t maxLod, const uint8_t maxAniso)
{
	cell::Gcm::UnsafeInline::cellGcmSetTextureControl(THIS_CONTEXT, index, enable, minLod, maxLod, maxAniso);
}

ILINE void cellGcmSetTextureFilter(const uint8_t index, const uint16_t bias, const uint8_t min, const uint8_t mag, const uint8_t conv) 
{
	cell::Gcm::UnsafeInline::cellGcmSetTextureFilter(THIS_CONTEXT, index, bias, min, mag, conv);
}

ILINE void cellGcmSetTextureAddress
(
	const uint8_t index, 
	const uint8_t wraps, 
	const uint8_t wrapt,
	const uint8_t wrapr,
	const uint8_t unsignedRemap,
	const uint8_t zfunc,
	const uint8_t gamma
)
{
	cell::Gcm::UnsafeInline::cellGcmSetTextureAddress(THIS_CONTEXT, index, wraps, wrapt, wrapr, unsignedRemap, zfunc,	gamma);
};

ILINE void cellGcmSetBlendEquation(const uint16_t color, const uint16_t alpha)
{
	cell::Gcm::UnsafeInline::cellGcmSetBlendEquation(THIS_CONTEXT, color, alpha);
};

ILINE void cellGcmSetBlendFunc(const uint16_t sfColor, const uint16_t dfColor, const uint16_t sfAlpha, const uint16_t dfAlpha)
{
	cell::Gcm::UnsafeInline::cellGcmSetBlendFunc(THIS_CONTEXT, sfColor, dfColor, sfAlpha, dfAlpha);
};

ILINE void cellGcmSetColorMask(const uint32_t mask)
{
	cell::Gcm::UnsafeInline::cellGcmSetColorMask(THIS_CONTEXT, mask);
};

ILINE void cellGcmSetColorMaskMrt(const uint32_t mask)
{
	cell::Gcm::UnsafeInline::cellGcmSetColorMaskMrt(THIS_CONTEXT, mask);
};

ILINE void cellGcmSetFrontPolygonMode(const uint32_t mode)
{
	cell::Gcm::UnsafeInline::cellGcmSetFrontPolygonMode(THIS_CONTEXT, mode);
};

ILINE void cellGcmSetBackPolygonMode(const uint32_t mode)
{
	cell::Gcm::UnsafeInline::cellGcmSetBackPolygonMode(THIS_CONTEXT, mode);
};

ILINE void cellGcmSetCullFace(const uint32_t ofm)
{
	cell::Gcm::UnsafeInline::cellGcmSetCullFace(THIS_CONTEXT, ofm);
};

ILINE void cellGcmSetCullFaceEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetCullFaceEnable(THIS_CONTEXT, enable);
};

ILINE void cellGcmSetScissor(const uint16_t x, const uint16_t y, const uint16_t width, const uint16_t height)
{
	cell::Gcm::UnsafeInline::cellGcmSetScissor(THIS_CONTEXT, x, y, width, height);
};

ILINE void cellGcmSetDepthTestEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetDepthTestEnable(THIS_CONTEXT, enable);
};

ILINE void cellGcmSetDepthMask(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetDepthMask(THIS_CONTEXT, enable);
};

ILINE void cellGcmSetDepthFunc(const uint32_t zf)
{
	cell::Gcm::UnsafeInline::cellGcmSetDepthFunc(THIS_CONTEXT, zf);
};

ILINE void cellGcmSetStencilTestEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetStencilTestEnable(THIS_CONTEXT, enable);
};

ILINE void cellGcmSetStencilMask(const uint32_t sm)
{
	cell::Gcm::UnsafeInline::cellGcmSetStencilMask(THIS_CONTEXT, sm);
};

ILINE void cellGcmSetStencilOp(const uint32_t fail, const uint32_t depthFail, const uint32_t depthPass)
{
	cell::Gcm::UnsafeInline::cellGcmSetStencilOp(THIS_CONTEXT, fail, depthFail, depthPass);
};

ILINE void cellGcmSetTexture(const uint8_t index, const CellGcmTexture *texture)
{
	cell::Gcm::UnsafeInline::cellGcmSetTexture(THIS_CONTEXT, index, texture);
};

ILINE void cellGcmSetBlendEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetBlendEnable(THIS_CONTEXT, enable);
};

ILINE void cellGcmSetBlendEnableMrt(const uint32_t mrt1, const uint32_t mrt2, const uint32_t mrt3)
{
	cell::Gcm::UnsafeInline::cellGcmSetBlendEnableMrt(THIS_CONTEXT, mrt1, mrt2, mrt3);
};

ILINE void cellGcmSetBlendColor(const uint32_t color, const uint32_t color2)
{
	cell::Gcm::UnsafeInline::cellGcmSetBlendColor(THIS_CONTEXT, color, color2);
};

ILINE void cellGcmSetStencilFunc(const uint32_t func, const uint32_t ref, const uint32_t mask)
{
	cell::Gcm::UnsafeInline::cellGcmSetStencilFunc(THIS_CONTEXT, func, ref, mask);
};

ILINE void cellGcmSetInvalidateVertexCache()
{
	cell::Gcm::UnsafeInline::cellGcmSetInvalidateVertexCache(THIS_CONTEXT);
};

ILINE void cellGcmSetDrawIndexArray(const uint8_t mode, const uint32_t count, const uint8_t type, const uint8_t locatiion, const uint32_t indices)
{
	cell::Gcm::UnsafeInline::cellGcmSetDrawIndexArray(THIS_CONTEXT, mode, count, type, locatiion, indices);
};

ILINE void cellGcmSetDrawArrays(const uint8_t mode, const uint32_t first, const uint32_t count)
{
	cell::Gcm::UnsafeInline::cellGcmSetDrawArrays(THIS_CONTEXT, mode, first, count);
};

ILINE void cellGcmSetSurface(const CellGcmSurface *surface)
{
	cell::Gcm::UnsafeInline::cellGcmSetSurface(THIS_CONTEXT, surface);
};

ILINE void cellGcmSetViewport
(
	const uint16_t x, 
	const uint16_t y, 
	const uint16_t width, 
	const uint16_t height,
	const float min,
	const float max,
	const float scale[4],
	const float offset[4]
)
{
	cell::Gcm::UnsafeInline::cellGcmSetViewport(THIS_CONTEXT, x, y, width, height, min, max, scale, offset);
};

ILINE void cellGcmSetClearColor(const uint32_t color)
{
	cell::Gcm::UnsafeInline::cellGcmSetClearColor(THIS_CONTEXT, color);
};

ILINE void cellGcmSetClearSurface(const uint32_t mask)
{
	cell::Gcm::UnsafeInline::cellGcmSetClearSurface(THIS_CONTEXT, mask);
};

ILINE void cellGcmSetClearDepthStencil(const uint32_t value)
{
	cell::Gcm::UnsafeInline::cellGcmSetClearDepthStencil(THIS_CONTEXT, value);
};

ILINE void cellGcmSetClearReport(const uint32_t type)
{
	cell::Gcm::UnsafeInline::cellGcmSetClearReport(THIS_CONTEXT, type);
};

ILINE void cellGcmSetZcullStatsEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetZcullStatsEnable(THIS_CONTEXT, enable);
};

ILINE void cellGcmSetInvalidateTextureCache(const uint32_t value)
{
	cell::Gcm::UnsafeInline::cellGcmSetInvalidateTextureCache(THIS_CONTEXT, value);
};

ILINE void cellGcmSetFrequencyDividerOperation(const uint16_t operation)
{
	cell::Gcm::UnsafeInline::cellGcmSetFrequencyDividerOperation(THIS_CONTEXT, operation);
};
/*
ILINE void cellGcmSetVertexDataArray
(
	const uint8_t index,
	const uint16_t frequency,
	const uint8_t stride,
	const uint8_t size,
	const uint8_t type,
	const uint8_t location,
	const uint32_t offset
)
{
	cell::Gcm::UnsafeInline::cellGcmSetVertexDataArray(THIS_CONTEXT, index, frequency, stride, size, type, location, offset);
};
*/
ILINE void cellGcmSetVertexProgramConstants(const uint32_t start, const uint32_t count, const float *data)
{
	cell::Gcm::UnsafeInline::cellGcmSetVertexProgramConstants(THIS_CONTEXT, start, count, data);
};

ILINE void cellGcmSetFragmentProgram(const CGprogram prog, const uint32_t offset)
{
	cell::Gcm::UnsafeInline::cellGcmSetFragmentProgram(THIS_CONTEXT, prog, offset);
};

ILINE int cellGcmSetFlip(CellGcmContextData*, const uint8_t cBufID)
{
	return cellGcmSetFlip(cBufID);
};

/*ILINE unsigned long long cellGcmGetTimeStampLocation(CellGcmContextData*, const uint32_t index, const uint32_t)
{
	return cellGcmGetTimeStampLocation(index);
}

ILINE unsigned long long cellGcmGetTimeStampLocation(const uint32_t index, const uint32_t)
{
	return cellGcmGetTimeStampLocation(index);
}
*/
ILINE void cellGcmSetReport(const uint32_t type, const uint32_t index)
{
	cell::Gcm::UnsafeInline::cellGcmSetReport(THIS_CONTEXT, type, index);
};

ILINE void cellGcmSetZcullLimit(const uint16_t moveForwardLimit, const uint16_t pushBackLimit)
{
	cell::Gcm::UnsafeInline::cellGcmSetZcullLimit(THIS_CONTEXT, moveForwardLimit, pushBackLimit);
};

ILINE void cellGcmSetCallCommand(const uint32_t offset)
{
	cell::Gcm::UnsafeInline::cellGcmSetCallCommand(THIS_CONTEXT, offset);
};

ILINE void cellGcmSetDepthBoundsTestEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetDepthBoundsTestEnable(THIS_CONTEXT, enable);
}

ILINE void cellGcmSetDepthBounds(const float zmin, const float zmax)
{
	cell::Gcm::UnsafeInline::cellGcmSetDepthBounds(THIS_CONTEXT, zmin, zmax);
}

ILINE void cellGcmSetTransferScaleMode(const uint8_t mode, const uint8_t surface)
{
	cell::Gcm::UnsafeInline::cellGcmSetTransferScaleMode(THIS_CONTEXT, mode, surface);
}

ILINE void cellGcmSetTransferScaleSurface(const CellGcmTransferScale *scale, const CellGcmTransferSurface *surface)
{
	cell::Gcm::UnsafeInline::cellGcmSetTransferScaleSurface(THIS_CONTEXT, scale, (CellGcmTransferSurface *)surface);
}

ILINE uint32_t cellGcmSetTransferData
(
	const uint8_t mode, 
	const uint32_t dstOffset,
	const uint32_t dstPitch,
	const uint32_t srcOffset,
	const uint32_t srcPitch,
	const uint32_t bytesPerRow,
	const uint32_t rowCount
)
{
	return cell::Gcm::UnsafeInline::cellGcmSetTransferData
	(
		THIS_CONTEXT,
		mode,
		dstOffset,
		dstPitch,
		srcOffset,
		srcPitch,
		bytesPerRow,
		rowCount
	);
}

ILINE uint32_t cellGcmSetTransferImage
(
	const uint8_t mode, 
	const uint32_t dstOffset,
	const uint32_t dstPitch,
	const uint32_t dstX,
	const uint32_t dstY,
	const uint32_t srcOffset,
	const uint32_t srcPitch,
	const uint32_t srcX,
	const uint32_t srcY,
	const uint32_t width,
	const uint32_t height,
	const uint32_t bytesPerPixel
)
{
	return cell::Gcm::UnsafeInline::cellGcmSetTransferImage
	(
		THIS_CONTEXT,
		mode,
		dstOffset,
		dstPitch,
		dstX,
		dstY,
		srcOffset,
		srcPitch,
		srcX,
		srcY,
		width,
		height,
		bytesPerPixel
	);
}

ILINE void cellGcmSetPointSpriteControl(const uint32_t enable, const uint32_t rmode, const uint32_t texcoord)
{
	cell::Gcm::UnsafeInline::cellGcmSetPointSpriteControl(THIS_CONTEXT, enable, rmode, texcoord);
}

ILINE void cellGcmSetClearZcullSurface(const uint32_t depth, const uint32_t stencil)
{
	cell::Gcm::UnsafeInline::cellGcmSetClearZcullSurface(THIS_CONTEXT, depth, stencil);
}

ILINE void cellGcmSetWaitFlip()
{
	cell::Gcm::UnsafeInline::cellGcmSetWaitFlip(THIS_CONTEXT);
}

ILINE void cellGcmSetTimeStamp(const uint32_t index)
{
	cell::Gcm::UnsafeInline::cellGcmSetTimeStamp(THIS_CONTEXT, index);
}

ILINE void cellGcmSetAntiAliasingControl(const uint32_t enable, const uint32_t alphaToCoverage, const uint32_t alphaToOne, const uint32_t sampleMask)
{
	cell::Gcm::UnsafeInline::cellGcmSetAntiAliasingControl(THIS_CONTEXT, enable, alphaToCoverage, alphaToOne, sampleMask);
}

ILINE void cellGcmSetFragmentProgramControl(const CGprogram prog, const uint8_t controlTxp, const uint8_t reserved0, const uint8_t reserved1)
{
	cell::Gcm::UnsafeInline::cellGcmSetFragmentProgramControl(THIS_CONTEXT, prog, controlTxp, reserved0, reserved1);
}

/*ILINE void cellGcmSetVertexProgramParameter(CGparameter param, const float *value)
{
	cell::Gcm::UnsafeInline::cellGcmSetVertexProgramParameter(THIS_CONTEXT, param, value);
};
*/
ILINE void cellGcmSetZpassPixelCountEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetZpassPixelCountEnable(THIS_CONTEXT, enable);
}

ILINE void cellGcmSetTwoSidedStencilTestEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetTwoSidedStencilTestEnable(THIS_CONTEXT, enable);
}

ILINE void cellGcmSetScullControl(const uint8_t sFunc,const uint8_t sRef,const uint8_t sMask)
{
	cell::Gcm::UnsafeInline::cellGcmSetScullControl(THIS_CONTEXT, sFunc, sRef, sMask);
}

ILINE void cellGcmSetFragmentProgramGammaEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetFragmentProgramGammaEnable(THIS_CONTEXT, enable);
}

ILINE void cellGcmSetFragmentProgramOffset(const CGprogram prog, const uint32_t offset, const uint32_t location)
{
	cell::Gcm::UnsafeInline::cellGcmSetFragmentProgramOffset(THIS_CONTEXT, prog, offset, location);
}

/*ILINE void cellGcmSetSurfaceWindow(const CellGcmSurface *surface, const uint32_t origin, const uint32_t pixelCenter)
{
	cell::Gcm::UnsafeInline::cellGcmSetSurfaceWindow(THIS_CONTEXT, surface, origin, pixelCenter);
};
*/
ILINE void cellGcmSetTextureOptimization(const uint8_t index, const uint8_t slope, const uint8_t iso, const uint8_t aniso)
{
	cell::Gcm::UnsafeInline::cellGcmSetTextureOptimization(THIS_CONTEXT, index, slope, iso, aniso );
}
 
ILINE void cellGcmSetAlphaTestEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetAlphaTestEnable(THIS_CONTEXT, enable );
}
  
ILINE void cellGcmSetAlphaFunc(const uint32_t af, const uint32_t ref)
{
	cell::Gcm::UnsafeInline::cellGcmSetAlphaFunc(THIS_CONTEXT, af, ref );
}

ILINE void cellGcmSetUserCommand(const uint32_t cause)
{
	cell::Gcm::UnsafeInline::cellGcmSetUserCommand(THIS_CONTEXT, cause );
}

ILINE void cellGcmSetTextureBorderColor(uint8_t index, uint32_t color)
{
	cell::Gcm::UnsafeInline::cellGcmSetTextureBorderColor(THIS_CONTEXT, index, color);
}

ILINE void cellGcmSetDitherEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetDitherEnable(THIS_CONTEXT, enable );
}

ILINE void cellGcmSetZcullEnable(const uint32_t depth, const uint32_t stencil)
{
	cell::Gcm::UnsafeInline::cellGcmSetZcullEnable(THIS_CONTEXT, depth, stencil );
}

ILINE void cellGcmSetPolygonOffset(const float factor, const float units)
{
	cell::Gcm::UnsafeInline::cellGcmSetPolygonOffset(THIS_CONTEXT, factor, units );
}

ILINE void cellGcmSetPolygonOffsetFillEnable(const uint32_t enable)
{
	cell::Gcm::UnsafeInline::cellGcmSetPolygonOffsetFillEnable(THIS_CONTEXT, enable);
}

//define it as it uses static const
ILINE void cellGcmSetReportLocation(const uint32_t)
{
	CELL_GCM_METHOD_SET_CONTEXT_DMA_REPORT(CELL_GCM_CURRENT, CELL_GCM_CONTEXT_DMA_REPORT_LOCATION_MAIN);
}


ILINE void cellGcmSetInlineTransferPointer(const uint32_t offset, const uint32_t count, void **pointer)
{
	cell::Gcm::UnsafeInline::cellGcmSetInlineTransferPointer(THIS_CONTEXT, offset, count, pointer);
}

#endif//__SPU__
#endif //PS3
#endif //__GCM_MAPPING_H
