/*
	relocatable and on demand linkable version of Memset__VM
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "../Memory.h"
#include "../SPUUtilities.h"
#include "../Cache/Cache_spu.h"

//128 byte aligned and multiple of 128 byte memset bypassing cache
//intended for large memsets
void MemsetLargeNoCache128(void* pDest, unsigned int val, unsigned int size)
{
	IF(size == 0, 0)
		return;
	//16 dma transfers can run in parallel
	//create 16x128 byte of 
	assert(((uint32)pDest & 127) == 0);
	assert((size & 127) == 0);
	assert((uint32)pDest);
	assert((uint32)size);
	const vec_uint4 cSplatVal = spu_splats(val);
	vec_uint4 localStorage[1024] _ALIGN(128);//aligned 16 KB buffer
	for(uint32 i=0; i<1024; i+=16)
	{
		localStorage[i]			= cSplatVal;
		localStorage[i+1]		= cSplatVal;
		localStorage[i+2]		= cSplatVal;
		localStorage[i+3]		= cSplatVal;
		localStorage[i+4]		= cSplatVal;
		localStorage[i+5]		= cSplatVal;
		localStorage[i+6]		= cSplatVal;
		localStorage[i+7]		= cSplatVal;
		localStorage[i+8]		= cSplatVal;
		localStorage[i+9]		= cSplatVal;
		localStorage[i+10]	= cSplatVal;
		localStorage[i+11]	= cSplatVal;
		localStorage[i+12]	= cSplatVal;
		localStorage[i+13]	= cSplatVal;
		localStorage[i+14]	= cSplatVal;
		localStorage[i+15]	= cSplatVal;
	}
	uint32 bytesLeft = size;
	const uint32 cTransferBlockSize = 16*1024;
	uint32 curDest = (uint32)pDest;
	do
	{
		const uint32 cTransferSize = (bytesLeft >= cTransferBlockSize)?cTransferBlockSize : bytesLeft;
		MemcpyMain(curDest, (void*)localStorage, cTransferSize, USER_DMA_TAG_BASE);
		bytesLeft -= cTransferSize;
		curDest += cTransferBlockSize;
	}WHILE(bytesLeft > 0, 1);
	//create mask to sync all transfer-tags
	const uint32 cTagMask = 1 << USER_DMA_TAG_BASE;
	spu_writech(MFC_WrTagMask, cTagMask);
	spu_writech(MFC_WrTagUpdate,MFC_TAG_UPDATE_ALL);
	spu_readch(MFC_RdTagStat);
}

#endif //__SPU__
#endif //PS3
