/*
	implementation of ppu callback
*/ 

#if defined(PS3) && defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include <stdio.h>
#include "../Memory.h"
#include "../JobStructs.h"

void CustomCallbackHandler(void* pFunc, void* pArg)
{
	NPPU::SDMACallbackData callbackData((NPPU::TSPUCallbackFunc)pFunc, pArg);
	MemcpyMain(*(unsigned int*)G_SPU_CUSTOM_CALLBACK_AREA, (NSPU::TAddrLS)(&callbackData), sizeof(NPPU::SDMACallbackData), g_scDMAPPUMemTag);
	__spu_flush_cache();
	spu_writech(SPU_WrOutIntrMbox, (EVENT_CUSTOM_CALLBACK_PORT << EVENT_PORT_SHIFT));
	spu_readch(SPU_RdSigNotify1);//wait til it finished
}

void SPUExecPPUCall(const uint32 cArg, const unsigned int cOpCode)
{
	//encode address, opcode and blocking info
	assert((cArg & 15) == 0);//address required to be 16 byte aligned
	const uint32 cMailBoxVal = 		
		(uint32)EVENT_COND |							//type event
		(cArg >> EVENT_ADRESS_SHIFT) |		//address
		cOpCode;													//op code
	spu_writech(SPU_WrOutIntrMbox, cMailBoxVal);
	//	if(NSPU::scEventBlocking[(int)cOpCode])				//wait if requested(slow, approx. 70 us)
	//		spu_readch(SPU_RdSigNotify1);
}

#endif
