/*
	relocatable and on demand linkable implementation for required software floating point ops
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "SoftFloat_spu.h"

extern "C"
float64 __adddf3( float64 a, float64 b )
{
	flag aSign = extractFloat64Sign( a );
	flag bSign = extractFloat64Sign( b );
	if ( aSign == bSign )
		return addFloat64Sigs( a, b, aSign );
	else
		return subFloat64Sigs( a, b, aSign );
}

#endif //__SPU__
#endif //PS3
