/*
	relocatable and on demand linkable implementation for required software floating point ops
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "SoftFloat_spu.h"

extern "C"
float64 __divdf3( float64 a, float64 b )
{
	flag aSign, bSign, zSign;
	int16 aExp, bExp, zExp;
	bits32 aSig0, aSig1, bSig0, bSig1, zSig0, zSig1, zSig2;
	bits32 rem0, rem1, rem2, rem3, term0, term1, term2, term3;
	float64 z;

	aSig1 = extractFloat64Frac1( a );
	aSig0 = extractFloat64Frac0( a );
	aExp = extractFloat64Exp( a );
	aSign = extractFloat64Sign( a );
	bSig1 = extractFloat64Frac1( b );
	bSig0 = extractFloat64Frac0( b );
	bExp = extractFloat64Exp( b );
	bSign = extractFloat64Sign( b );
	zSign = aSign ^ bSign;
	IF(aExp == 0x7FF,0)
		return packFloat64( zSign, 0x7FF, 0, 0 );
	IF(bExp == 0x7FF,0)
		return packFloat64( zSign, 0, 0, 0 );
	IF(bExp == 0, 0)
		normalizeFloat64Subnormal( bSig0, bSig1, &bExp, &bSig0, &bSig1 );
	if(aExp == 0)
	{
		if((aSig0 | aSig1) == 0 ) 
			return packFloat64( zSign, 0, 0, 0 );
		normalizeFloat64Subnormal( aSig0, aSig1, &aExp, &aSig0, &aSig1 );
	}
	zExp = aExp - bExp + 0x3FD;
	shortShift64Left( aSig0 | 0x00100000, aSig1, 11, &aSig0, &aSig1 );
	shortShift64Left( bSig0 | 0x00100000, bSig1, 11, &bSig0, &bSig1 );
	if(le64(bSig0, bSig1, aSig0, aSig1))
	{
		shift64Right(aSig0, aSig1, 1, &aSig0, &aSig1);
		++zExp;
	}
	zSig0 = estimateDiv64To32(aSig0, aSig1, bSig0);
	mul64By32To96( bSig0, bSig1, zSig0, &term0, &term1, &term2 );
	sub96( aSig0, aSig1, 0, term0, term1, term2, &rem0, &rem1, &rem2 );
	while((sbits32)rem0 < 0)
	{
		--zSig0;
		add96( rem0, rem1, rem2, 0, bSig0, bSig1, &rem0, &rem1, &rem2 );
	}
	zSig1 = estimateDiv64To32( rem1, rem2, bSig0 );
	if((zSig1 & 0x3FF) <= 4)
	{
		mul64By32To96( bSig0, bSig1, zSig1, &term1, &term2, &term3 );
		sub96( rem1, rem2, 0, term1, term2, term3, &rem1, &rem2, &rem3 );
		while((sbits32)rem1 < 0)
		{
			--zSig1;
			add96( rem1, rem2, rem3, 0, bSig0, bSig1, &rem1, &rem2, &rem3 );
		}
		zSig1 |= ( ( rem1 | rem2 | rem3 ) != 0 );
	}
	shift64ExtraRightJamming(zSig0, zSig1, 0, 11, &zSig0, &zSig1, &zSig2);
	return roundAndPackFloat64(zSign, zExp, zSig0, zSig1, zSig2);
}

#endif //__SPU__
#endif //PS3
