/*
	relocatable and on demand linkable implementation for required software floating point ops
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "SoftFloat_spu.h"

extern "C"
flag __eqdf2(float64 a, float64 b)
{
	return (a.low == b.low)	&& ((a.high == b.high) ||((a.low == 0) && ((bits32)((a.high | b.high)<<1) == 0)));
}

extern "C"
flag __ledf2(float64 a, float64 b)
{
	flag aSign = extractFloat64Sign(a);
	flag bSign = extractFloat64Sign(b);
	if( aSign != bSign)
		return aSign || ((((bits32)((a.high | b.high)<<1)) | a.low | b.low)	== 0 );
	return aSign ? le64(b.high, b.low, a.high, a.low)	: le64( a.high, a.low, b.high, b.low );
}

extern "C"
flag __ltdf2(float64 a, float64 b)
{
	flag aSign = extractFloat64Sign(a);
	flag bSign = extractFloat64Sign(b);
	if( aSign != bSign)
		return aSign && ((((bits32)((a.high | b.high)<<1)) | a.low | b.low) != 0 );
	return aSign ? lt64(b.high, b.low, a.high, a.low)	: lt64(a.high, a.low, b.high, b.low);
}

#endif //__SPU__
#endif //PS3
