/*
	relocatable and on demand linkable implementation for required software floating point ops
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "SoftFloat_spu.h"

extern "C"
int64 __fixdfdi(float64 a)
{
	flag aSign;
	int16 aExp, shiftCount;
	bits64 aSig;
	int64 z;
	Conv64 c64;	c64.fl64 = a;
	aSig = extractFloat64Frac(c64.b64);
	aExp = extractFloat64Exp(a);
	aSign = extractFloat64Sign(a);
	if(aExp) 
		aSig |= 0x0010000000000000LL;
	shiftCount = aExp - 0x433;
	if(0 <= shiftCount) 
	{
		if(0x43E <= aExp) 
			return (sbits64)0x8000000000000000LL;
		z = aSig<<shiftCount;
	}
	else 
		z = aSig>>(-shiftCount);
	IF(aSign,0)
		z = - z;
	return z;
}

extern "C"
int64 __fixunsdfsi(float64 a)
{
	return __fixdfdi(a);
}

extern "C"
int64 __fixunsdfdi(float64 a)
{
	return __fixdfdi(a);
}

#endif //__SPU__
#endif //PS3
