/*
	relocatable and on demand linkable implementation for required software floating point ops
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "SoftFloat_spu.h"

extern "C"
int32 __fixdfsi(float64 a)
{
	flag aSign;
	int16 aExp, shiftCount;
	bits64 aSig, savedASig;
	int32 z;
	Conv64 c64;	c64.fl64 = a;
	aSig = extractFloat64Frac(c64.b64);
	aExp = extractFloat64Exp(a);
	aSign = extractFloat64Sign(a);
	aSig |= 0x0010000000000000LL;
	shiftCount = 0x433 - aExp;
	savedASig = aSig;
	aSig >>= shiftCount;
	z = aSig;
	if ( aSign ) z = - z;
	return z;
}

#endif //__SPU__
#endif //PS3
