/*
	relocatable and on demand linkable implementation for required software floating point ops
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "SoftFloat_spu.h"

extern "C"
int64 __fixsfdi(float32 a)
{
	flag aSign;
	int16 aExp, shiftCount;
	bits32 aSig;
	bits64 aSig64;
	int64 z;
	aSig = extractFloat32Frac(a);
	aExp = extractFloat32Exp(a);
	aSign = extractFloat32Sign(a);
	shiftCount = aExp - 0xBE;
	IF(0 <= shiftCount,0)
		return (sbits64)0x8000000000000000LL;
	aSig64 = aSig | 0x00800000;
	aSig64 <<= 40;
	z = aSig64>>( - shiftCount );
	if(aSign) 
		z = - z;
	return z;
}

extern "C"
int64 __fixunssfdi(float32 a)
{
	return __fixsfdi(a);
}

#endif //__SPU__
#endif //PS3
