/*
	relocatable and on demand linkable implementation for required software floating point ops
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "SoftFloat_spu.h"

extern "C"
float64 __floatdidf(int64 a)
{
	IF(a == 0,0)
		return (float64){0,0};
	IF(a == (int64)0x8000000000000000ULL,0)
	{
		Conv64 u64;
		u64.b64 = packFloat64From64(1, 0x43E, 0);
		return u64.fl64;
	}
	flag zSign = (a < 0);
	return normalizeRoundAndPackFloat64(zSign, 0x43C, zSign?-a:a);
}

extern "C"
float64 __float_unsdidf(int64 a)
{
	return __floatdidf(a);
}

#endif //__SPU__
#endif //PS3
