/*
	relocatable and on demand linkable implementation for required software floating point ops
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "SoftFloat_spu.h"

extern "C"
float32 __floatdisf(int64 a)
{
	flag zSign;
	uint64 absA;
	int8 shiftCount;
	bits32 zSig;
	IF(a == 0,0)
		return 0;
	zSign = (a < 0);
	absA = zSign? -a : a;
	shiftCount = countLeadingZeros64(absA) - 40;
	IF(0 <= shiftCount,0)
		return packFloat32( zSign, 0x95 - shiftCount, absA<<shiftCount );
	else 
	{
		shiftCount += 7;
		if ( shiftCount < 0 )
			shift64RightJamming64( absA, - shiftCount, &absA );
		else
			absA <<= shiftCount;
		return roundAndPackFloat32(zSign, 0x9C - shiftCount, absA);
	}
}

#endif //__SPU__
#endif //PS3
