/*
	relocatable and on demand linkable implementation for required software floating point ops
*/ 

#if defined(PS3)
#if defined(__SPU__)

#if !defined(eCryModule)
	#define eCryModule eCryM_Launcher
#endif
#include <CryModuleDefs.h>
#include <platform.h>
#include "SoftFloat_spu.h"

extern "C"
float64 __muldf3( float64 a, float64 b )
{
	flag aSign, bSign, zSign;
	int16 aExp, bExp, zExp;
	bits32 aSig0, aSig1, bSig0, bSig1, zSig0, zSig1, zSig2, zSig3;
	float64 z;

	aSig1 = extractFloat64Frac1( a );
	aSig0 = extractFloat64Frac0( a );
	aExp = extractFloat64Exp( a );
	aSign = extractFloat64Sign( a );
	bSig1 = extractFloat64Frac1( b );
	bSig0 = extractFloat64Frac0( b );
	bExp = extractFloat64Exp( b );
	bSign = extractFloat64Sign( b );
	zSign = aSign ^ bSign;
	IF(aExp == 0x7FF, 0) 
		return packFloat64( zSign, 0x7FF, 0, 0 );
	IF(bExp == 0x7FF, 0) 
		return packFloat64( zSign, 0x7FF, 0, 0 );
	if(aExp == 0)
	{
		if((aSig0 | aSig1) == 0) 
			return packFloat64( zSign, 0, 0, 0 );
		normalizeFloat64Subnormal( aSig0, aSig1, &aExp, &aSig0, &aSig1 );
	}
	if ( bExp == 0 ) 
	{
		if((bSig0 | bSig1) == 0)
			return packFloat64( zSign, 0, 0, 0 );
		normalizeFloat64Subnormal( bSig0, bSig1, &bExp, &bSig0, &bSig1 );
	}
	zExp = aExp + bExp - 0x400;
	aSig0 |= 0x00100000;
	shortShift64Left( bSig0, bSig1, 12, &bSig0, &bSig1 );
	mul64To128( aSig0, aSig1, bSig0, bSig1, &zSig0, &zSig1, &zSig2, &zSig3 );
	add64( zSig0, zSig1, aSig0, aSig1, &zSig0, &zSig1 );
	zSig2 |= ( zSig3 != 0 );
	if ( 0x00200000 <= zSig0 )
	{
		shift64ExtraRightJamming(zSig0, zSig1, zSig2, 1, &zSig0, &zSig1, &zSig2);
		++zExp;
	}
	return roundAndPackFloat64(zSign, zExp, zSig0, zSig1, zSig2);
}

#endif //__SPU__
#endif //PS3
